/* $Id: Base.h,v 1.2 1997/04/08 15:40:00 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(_XARM_BASE_H_)
#define _XARM_BASE_H_

/* ======================================================================= */
/* Include(s): */
#include <Xarm/CObject.h>
#include <Xarm/XarmArg.h>

#if !defined(DELETE_ON_CLOSE)
/*
*  If DELETE_ON_CLOSE is defined to be TRUE then the object will clean up 
*  allocated memory and the object is associated with the widget.  This 
*  assumes that new was used to create the object.
*  Otherwise the programmer must handle the memory management and
*  object association.
*
*  Delete if going out of scope and/or delete operator is used.
*  This should always be true unless you know what you're doing.
*/
#define DELETE_ON_CLOSE TRUE
#endif

/*
*  typedef's for the conversion routines. As you can see I did not like
*  the idea of using XmString.  Hence, I provided a nice utility
*  for doing the conversions to and from XmString. 
*/
typedef char * (*XmStringToStringFunc)(XmString);
typedef XmString (*StringToXmStringFunc)(char *);

/* Define the Window Object type */
class WObjectClass;
typedef WObjectClass *WObject;

/* 
*  This routine returns the WObject only if the widget is associated with one,
*  otherwise NULL is returned.
*/
WObject WidgetToWObject(Widget);

class WObjectClass : public CObject {
 private:
   friend WObject WidgetToWObject(Widget w);
   Widget wid;
   static void destructor(Widget w,XtPointer data,XtPointer cdata);
   int isDelete;
   XmStringToStringFunc cvtXmStringToStringfp;
   StringToXmStringFunc cvtStringToXmStringfp;
 protected:
   /* ATTENTION, default settings for cvt functions... */
   WObjectClass():wid(NULL),isDelete(FALSE),
               cvtXmStringToStringfp((XmStringToStringFunc)XmCvtXmStringToCT),
               cvtStringToXmStringfp((StringToXmStringFunc)XmCvtCTToXmString) {}
   void widget(Widget w);
   virtual WidgetClass classPointer() = 0; /* pure virtual function */
   virtual _XtString className() = 0; /* pure virtual function */
   virtual Widget createWidget(_XtString name, 
                               Widget w_parent, 
                               ArgList arglist = NULL, 
                               Cardinal cnt = 0);
 public:
   /* ATTENTION, default behavior is (TRUE) user defined, TRUE = delete this 
      pointer when widget is destroyed. */
   void deleteOnClose(int option = DELETE_ON_CLOSE); 

   virtual ~WObjectClass();

   operator Widget(); // auto cast self to widget 
   operator Display*(); // auto cast self to Display *

   Display *display() { return XtDisplay(widget()); }
   Widget widget() { return wid; }
   Widget parent() { return XtParent(widget()); }
   XtAppContext appContext();
   Window window() { return XtWindow(widget()); }

   void destroyCallback(XtCallbackProc funcp, XtPointer data = NULL);  
   void addDestructor();
   void removeDestructor();

   void manage() { XtManageChild(*this); }
   void unmanage() { XtUnmanageChild(*this); }

   /* Most functions that denote a parameter of char * use the cvt functions */
   /* Be careful when changing the cvt function! */
   
   /* Portability functions for different locales */
   void cvtXmStringToStringFunc(XmStringToStringFunc fp) { 
      cvtXmStringToStringfp = fp;
   }
   void cvtStringToXmStringFunc(StringToXmStringFunc fp) { 
      cvtStringToXmStringfp = fp;
   }
   /* All functions that use this cvt routine will clean up the allocated 
      memory.  Hence, don't worry about it.  Look at the source. */
   XmString cvtStringToXmString(char *str) {
      return (*cvtStringToXmStringfp)(str);
   }
   /* Clean up allocated memory pointed to by the return value when done. */
   char * cvtXmStringToString(XmString str) {
      return (*cvtXmStringToStringfp)(str);
   }

   /* get pixmap from a file if possible or return XmUNSPECIFIED_PIXMAP */
   Pixmap getPixmap(char *fname);
   /* get pixmap from a data if possible or return XmUNSPECIFIED_PIXMAP */
   Pixmap getPixmapFromData(char **pdata); 
   
   /* the callback routines */
   void addCallback(_XtString type, 
                    XtCallbackProc fp, 
                    XtPointer closure=NULL);
   void removeCallback(_XtString type,
                       XtCallbackProc fp,
                       XtPointer closure=NULL);
   void removeAllCallbacks(_XtString type);

   /* Make member function callback routines from class CObject visible */
   void addCallback(Widget w,
                    _XtString type, 
                    p_msg fp, 
                    XtPointer closure=NULL);
   void removeCallback(Widget w,
                       _XtString type,
                       p_msg fp,
                       XtPointer closure=NULL);
   void removeAllCallbacks(Widget w, _XtString type);

   /* protocol routines */
   Atom addWMProtocol(char *atom_name, Bool add_if_exists=False);
   void addProtocol(Atom property, Atom protocol_to_add);

};

#endif
