/* Include(s) */
#include <string.h>
#include <stdlib.h>
#include <Xarm/AppContext.h>
#include <Xarm/MainW.h>
#include <Xarm/MenuB.h>
#include <Xarm/MessageB.h>
#include <Xarm/PushB.h>
#include <Xarm/Separator.h>
#include <Xarm/DialogS.h>
#include <Xarm/Shell.h>
#include <Xarm/Form.h>
#include <Xarm/Frame.h>
#include <Xarm/Text.h>

/* Declaration(s) */
class Application: public AppContext
{
 private:
   void exit(Widget,XtPointer,XtPointer);
   void onExit(Widget,XtPointer,XtPointer);

 public:
   Application(char *app_class,int &argc_in_out, char **argv_in_out);
};

char *basename(char *name)
{
   char *s;

   if((s=strrchr(name,'/'))!=NULL)
   {
      s++;
   }
   else
   {
      s = name;
   }
   return s;
}

int
main (int argc, char **argv)
{
   // initialize application
   Application app(basename(argv[0]),argc,argv);

   // realize application
   app.realize();

   // start the main loop
   app.mainLoop();

   // exit code just in case we get here.
   exit(EXIT_SUCCESS);
   return EXIT_SUCCESS;  /* SOME compilers like a return statement */
}

Application::Application(char *app_class, int &argc_in_out, char **argv_in_out):
   AppContext(app_class, NULL, 0, argc_in_out, argv_in_out)
{
   XarmArg         args;                      // Arg List for Widgets
   WidgetList      children = NULL;
   int             numchildren = 0;

   // install window manager message handler(s)
   Atom proto = addWMProtocol(XA_WM_DELETE_WINDOW);
   addWMProtocolCallback(widget(),proto,(p_msg)onExit);

   title(app_class);

   // install window(s) into the application window
   MainWindow *win = new MainWindow(*this,(unsigned char)XmAPPLICATION_DEFINED);
   MenuBar *menu= new MenuBar(*win);

   MenuButton *fileB = new MenuButton(*menu, "File", (KeySym) 'F');
   PushButton *quitB = new PushButton(*fileB, "Exit", (KeySym) 'x',
                                     "Alt<Key>X","Alt-X");
   addCallback(*quitB, XmNactivateCallback,(p_msg) onExit);

   MenuButton *helpB = new MenuButton(*menu, "Help", (KeySym) 'H');
   new PushButton(*helpB, "About");

   args(XmNallowShellResize , True)
       (XmNinitialState     , NormalState)
       (XmNmwmDecorations   , (MWM_DECOR_ALL | MWM_DECOR_RESIZEH))
       (XmNmwmFunctions     , (MWM_FUNC_ALL | MWM_FUNC_RESIZE));

   PopupShell *popupshell = new PopupShell(*this,args,"SubWindow");
   MainWindow *subwin = new MainWindow(*popupshell,(unsigned char)XmAPPLICATION_DEFINED);

   args.reset();
   args(XmNmarginHeight     , 0)
       (XmNmarginWidth      , 0)
       (XmNresizePolicy     , XmRESIZE_GROW)
       (XmNheight           , 87)
       (XmNwidth            , 600);

   Form *subwinform = new Form(*subwin,args,"subwinform");

   args.reset();
   args(XmNbottomAttachment , XmATTACH_NONE)
       (XmNrightOffset      , -1)
       (XmNrightAttachment  , XmATTACH_FORM)
       (XmNleftOffset       , -1)
       (XmNleftAttachment   , XmATTACH_FORM)
       (XmNtopOffset        , 0)
       (XmNtopAttachment    , XmATTACH_FORM)
       (XmNshadowType       , XmSHADOW_OUT)
       (XmNx                , 0)
       (XmNy                , 0);

   Frame *textpaneframe = new Frame(*subwinform,args,"textpaneframe");

   args.reset();
   args(XmNbottomAttachment      , XmATTACH_NONE)
       (XmNrightOffset           , -1)
       (XmNrightAttachment       , XmATTACH_FORM)
       (XmNleftOffset            , -1)
       (XmNleftAttachment        , XmATTACH_FORM)
       (XmNtopOffset             , 0)
       (XmNtopAttachment         , XmATTACH_FORM)
       (XmNshadowType            , XmSHADOW_OUT)
       (XmNy                     , 0)
       (XmNx                     , 0)
       (XmNscrollBarDisplayPolicy, XmAUTOMATIC)
       (XmNvisualPolicy          , XmVARIABLE)
       (XmNscrollingPolicy       , XmAPPLICATION_DEFINED)
       (XmNwordWrap              , True)
       (XmNeditMode              , XmMULTI_LINE_EDIT)
       (XmNscrollHorizontal      , False)
       (XmNscrollVertical        , True)
       (XmNcolumns               , 80)
       (XmNrows                  , 5)
       (XmNcursorPositionVisible , False)
       (XmNeditable              , False);

   ScrolledText *textpane = new ScrolledText(*textpaneframe,args,"textpane");
   subwin->setArea(NULL,NULL,NULL,NULL,*subwinform);

   textpane->manage();
   children = textpaneframe->children();
   numchildren = textpaneframe->numChildren();
   XtManageChildren(children, numchildren);
   children = subwinform->children();
   numchildren = subwinform->numChildren();
   XtManageChildren(children, numchildren);
   subwinform->manage();
   children = popupshell->children();
   numchildren = popupshell->numChildren();
   XtManageChildren(children, numchildren);
   popupshell->popup();

   menu->help(helpB->button);
   menu->manage();
   win->setArea(*menu,NULL,NULL,NULL,NULL);
   win->manage();
}

void
Application::exit(Widget, XtPointer, XtPointer )
{
   quit();
}

void
Application::onExit(Widget w, XtPointer, XtPointer )
{

   QuestionDialog *diag = new QuestionDialog(w,"Do you really want to quit?");

   addCallback(diag->widget(), XmNokCallback, (p_msg)exit);
   diag->dialogTitle("Exit Dialog");
   diag->manage();
}
