//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: util.cc,v 1.6 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/_ctype.h>
#include <stdlib.h>
#include <Cvo/util.h++>
#include <limits.h>
#include <memory.h>

#include <X11/Xlib.h>
#if !defined(XlibSpecificationRelease) || (XlibSpecificationRelease < 5) || defined(X11R4)
int __X11R4_was_not_to_build_this_Cvo_library;
#else
int __X11R5_was_not_to_build_this_Cvo_library;
#endif

#if defined(cray) && !defined(_W1)
extern __required_UNICOS_70_special_version_of_mbstowcs_missing;
extern __required_UNICOS_70_special_version_of_mbtowc_missing;
extern __required_UNICOS_70_special_version_of_wcstombs_missing;
extern __required_UNICOS_70_special_version_of_wctomb_missing;

static int z1 = __required_UNICOS_70_special_version_of_mbstowcs_missing;
static int z2 = __required_UNICOS_70_special_version_of_mbtowc_missing;
static int z3 = __required_UNICOS_70_special_version_of_wcstombs_missing;
static int z4 = __required_UNICOS_70_special_version_of_wctomb_missing;
#endif

int
_Cvo_wcstombs(char **mbs, const wchar_t *wcs, int *maximum)
{   CVO_ENTER
    int length;

    while ((length = wcstombs(*mbs, wcs, *maximum)) != -1 &&
	    length >= *maximum - MB_LEN_MAX) {
        delete [] *mbs;
        *mbs = new char[*maximum += 16];
    }
    CVO_RETURN(length)
}

int
_Cvo_wcstombs(char **mbs, int offset, const wchar_t *wcs, int *maximum)
{   CVO_ENTER
    int length;

    while ((length = wcstombs(*mbs + offset, wcs, *maximum))!= -1 &&
	    length  >= *maximum - MB_LEN_MAX) {
        char *nmbs = new char[*maximum += 16];
	memcpy(nmbs, *mbs, offset);
        delete [] *mbs;
	*mbs = nmbs;
    }
    CVO_RETURN(length)
}

int
_Cvo_mbstowcs(wchar_t **wcs, const char *mbs, int *maximum)
{   CVO_ENTER
    int length;

    while ((length = mbstowcs(*wcs, mbs, *maximum)) != -1 &&
	    length >= *maximum - MB_LEN_MAX) {
	delete [] *wcs;
	*wcs = new wchar_t[*maximum += 16];
    }
    CVO_RETURN(length)
}

int
_Cvo_mbstowcs(wchar_t **wcs, int offset, const char *mbs, int *maximum)
{   CVO_ENTER
    int length;

    while ((length = mbstowcs(*wcs + offset, mbs, *maximum))!= -1 &&
	    length  >= *maximum - MB_LEN_MAX) {
        wchar_t *nwcs = new wchar_t[*maximum += 16];
	memcpy(nwcs, *wcs, offset * sizeof(wchar_t));
        delete [] *wcs;
	*wcs = nwcs;
    }
    CVO_RETURN(length)
}
