//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Tree.cc,v 1.9 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Tree.h++>
#include <Cvo/TreeViewPort.h++>
#include <Cvo/Button.h++>
#include <memory.h>

inline int
max(int x, int y)
{   CVO_ENTER
    CVO_RETURN(x > y ? x : y)
}

void
Cvo_TreeNode::ResetPad()
{   CVO_ENTER
    if (!Mapped())
	CVO_VOID_RETURN

    //
    // Only pass the pad on to first children
    //
    if (parent && parent->children) {
	Cvo_TreeNode *fc = parent->children;
    
	while (fc && !fc->Mapped())
	    fc = fc->sibling;
	if (fc == this) {
	    ColumnPtr *Col = col;
	    
	    if (Col->_topNode != this)
		pad = base->Sibling_Sep() + base->Tree_Sep();
	    else
		pad = base->Sibling_Sep();
	} else {
	    pad = base->Sibling_Sep();
	}
    }

    for (Cvo_TreeNode *w = children; w; w=w->sibling) {
	w->ResetPad();
    }
    CVO_VOID_RETURN
}

void
Cvo_TreeNode::IncPad(int inc)
{   CVO_ENTER
    //
    // Only pass the pad on to first children
    //
    if (parent && parent->children) {
	Cvo_TreeNode *fc = parent->children;
    
	while (fc && !fc->Mapped())
	    fc = fc->sibling;
	if (fc != this) {
	    CVO_VOID_RETURN
	}
    }

    //
    // If the first child has no Children mapped store pad
    //
    Cvo_TreeNode *fc = children;
	
    while (fc && !fc->Mapped())
	fc = fc->sibling;

    if (!fc) {
	pad += inc;
    } else {
	fc->IncPad(inc);
    }
    CVO_VOID_RETURN
}

void
Cvo_TreeNode::SetColWidth(int nw, int nh)
{   CVO_ENTER
    ColumnPtr *Col = col;

    int w;
    switch (base->Gravity()) {
    case Cvo_NORTH:
    case Cvo_SOUTH:
	w = max(Col->width, nh);
	break;
    case Cvo_WEST:
    case Cvo_EAST:
	w = max(Col->width, nw);
	break;
    }
    if (w == Col->width) {
    	CVO_VOID_RETURN
    }

    Col->width = w;

    base->ColWidthAdj(Col);
    CVO_VOID_RETURN
}

void
Cvo_Tree::ColWidthAdj(ColumnPtr* Col)
{   CVO_ENTER

    for (ColumnPtr *CPtr = Col; CPtr;) {
	if (Gravity() == Cvo_NORTH ||
	    Gravity() == Cvo_WEST) {
	    if (CPtr->Prev->Next == NULL ||
		(CPtr->Prev->offset == 0 && CPtr->Prev->width == 0)) {
		CPtr->offset = 0;
	    } else {
		CPtr->offset = CPtr->Prev->offset +
		    Child_Sep() +
		    CPtr->Prev->width;
	    }
	    CPtr=CPtr->Next;
	} else {
	    if (CPtr->Next == NULL ||
		(CPtr->Next->offset == 0 && CPtr->Next->width == 0)) {
		CPtr->offset = 0;
	    } else {
		CPtr->offset = CPtr->Next->offset +
		    Child_Sep() +
		    CPtr->Next->width;
	    }
	    if (CPtr->Prev->Next != NULL)
		CPtr=CPtr->Prev;
	    else
		break;
	}
    }
    CVO_VOID_RETURN
}

Cvo_TreeNode::Cvo_TreeNode(Cvo_Window *obj, Cvo_TreeNode *par)
{   CVO_ENTER
    object = obj;
    childreg = 0;
    map_with_par = 1;
    reg = obj->Register(CvoDestroyedEvent, _CvoTreeDeleteHandler, this);
    obj->Register(CvoPreMapRequestEvent, _CvoTreeMapHandler, this);
//  obj->Register(CvoResizeEvent, _CvoTreeResizeHandler, this);
    obj->Register(CvoUnmapRequestEvent, _CvoTreeUnmapHandler, this);

    parent = par;
    base = parent->base;

    pad = base->Sibling_Sep();

    //
    // Set Column Pointer to Parent Column
    // 
    ColumnPtr *Col = parent->col;

    //
    // Search for insertion Point in next column
    // 
    for(Cvo_TreeNode *w = parent; ; w = w->_up) {

	//
	// If Node has Children
	// 
	if (w->children && w->children->elder) {
	    _dn = w->children->elder->_dn;
	    _up = w->children->elder;
	    w->children->elder->_dn = this;
	    if (_dn) {
		_dn->_up = this;
		_dn->ResetPad();
	    } else {
		Col->Next->_topNode->_up = this;
	    }
	    
	    if (w == parent) {
		// 
		// If w is parent then, New Node is not first child
		// and has been inserted under last elder in column
		// 
		parent->children->ResetPad();
		pad = base->Sibling_Sep();

	    } else { 
		// 
		// If w isnot parent then, New Node is first child
		// and has been inserted under children of a neighboring branch
		// 
		pad = base->Sibling_Sep() + base->Tree_Sep();
	    }

	    Col = Col->Next;
	    col=parent->col->Next;
	    break;

	} else if (Col->_topNode == w) {
	    // 
	    // No Nodes above in column with children ?
	    // if w is the top node in the column and it had no children
	    // 

	    // 
	    // First Node to enter this column ?
	    // 
	    if (Col->Next == NULL) {
		Col->Next = new ColumnPtr;
		Col->Next->Next = NULL;
		Col->Next->_topNode = NULL;
		Col->Next->Prev = Col;
		base->Columns()->Prev = Col->Next;
		Col = Col->Next;
		Col->width = 0;
		_up = this;
	    } else {
		Col = Col->Next;
		_up = Col->_topNode->_up;
		Col->_topNode->_up = this;
	    }

	    _dn = Col->_topNode;
	    Col->_topNode = this;

	    //
	    // Set Padding above next node in column
	    //
	    if (_dn != NULL) {
		_dn->ResetPad();
	    }
	    col=parent->col->Next;
	    break;
	}
    }

    parent->ResetPad();

    //
    // Adjust Column width if necessary
    // 
    object->ComputeLayoutSize(Cvo_FORCE_DESIRED);
    int nw = object->Layout()->desired.width;
    int nh = object->Layout()->desired.height;

    nw = nw ? nw : object->Layout()->minimum.width;
    nh = nh ? nh : object->Layout()->minimum.height;
    SetColWidth(nw, nh);

    //
    //  Insert into Tree as Normal
    // 
    if (parent->children) {
	elder = parent->children->elder;
	elder->sibling = this;
    } else
	parent->children = this;

    parent->children->elder = this;

    sibling = 0;
    children = 0;

    x = 0;
    y = 0;

    //
    // Initially build this object off screen
    // Provides about a 2x speedup.
    //
    object->Layout()->x = 50000;
    object->Layout()->y = 50000;

    CVO_VOID_RETURN
}

Cvo_TreeNode::Cvo_TreeNode(char *lbl, Cvo_TreeNode *par)
{   CVO_ENTER
    label = lbl;
    object = 0;
    childreg = 0;
    mapped = False;
    reg = 0;

    map_with_par = True;

    parent = par;
    base = parent->base;

    pad = base->Sibling_Sep();

    //
    // Set Column Pointer to Parent Column
    // 
    ColumnPtr *Col = parent->col;

    //
    // Search for insertion Point in next column
    // 
    for(Cvo_TreeNode *w = parent; ; w = w->_up) {

	//
	// If Node has Children
	// 
	if (w->children && w->children->elder) {
	    _dn = w->children->elder->_dn;
	    _up = w->children->elder;
	    w->children->elder->_dn = this;
	    if (_dn) {
		_dn->_up = this;
		_dn->ResetPad();
	    } else {
		Col->Next->_topNode->_up = this;
	    }
	    
	    if (w == parent) {
		// 
		// If w is parent then, New Node is not first child
		// and has been inserted under last elder in column
		// 
		parent->children->ResetPad();
		pad = base->Sibling_Sep();

	    } else { 
		// 
		// If w isnot parent then, New Node is first child
		// and has been inserted under children of a neighboring branch
		// 
		pad = base->Sibling_Sep() + base->Tree_Sep();
	    }

	    Col = Col->Next;
	    col=parent->col->Next;
	    break;

	} else if (Col->_topNode == w) {
	    // 
	    // No Nodes above in column with children ?
	    // if w is the top node in the column and it had no children
	    // 

	    // 
	    // First Node to enter this column ?
	    // 
	    if (Col->Next == NULL) {
		Col->Next = new ColumnPtr;
		Col->Next->Next = NULL;
		Col->Next->_topNode = NULL;
		Col->Next->Prev = Col;
		base->Columns()->Prev = Col->Next;
		Col = Col->Next;
		Col->width = 0;
		_up = this;
	    } else {
		Col = Col->Next;
		_up = Col->_topNode->_up;
		Col->_topNode->_up = this;
	    }

	    _dn = Col->_topNode;
	    Col->_topNode = this;

	    //
	    // Set Padding above next node in column
	    //
	    if (_dn != NULL) {
		_dn->ResetPad();
	    }
	    col=parent->col->Next;
	    break;
	}
    }

    parent->ResetPad();

    {
	Cvo_Window *wp = base;

	while (wp && wp->Chamfer() == 0 && wp->Parent())
	    wp = wp->Parent()->ToWindow();

	if (wp && wp->Chamfer()) {
	    chamfer = wp->Chamfer();
    	    vpad = chamfer + 2;
    	    hpad = chamfer + 2;
	    bw = 0;
	} else {
	    vpad = 2;
	    hpad = 2;
	    chamfer = 0;
	    bw = 1;
	}
    }

    //
    // Adjust Column width if necessary
    // 
    lwidth = base->TextAttribute()->StringWidth((wchar_t *)label);
    lheight = base->TextAttribute()->MHeight();

    SetColWidth(FullWidth(), FullHeight());

    //
    //  Insert into Tree as Normal
    // 
    if (parent->children) {
	elder = parent->children->elder;
	elder->sibling = this;
    } else
	parent->children = this;

    parent->children->elder = this;

    sibling = 0;
    children = 0;

    x = 0;
    y = 0;

    CVO_VOID_RETURN
}

void
Cvo_TreeNode::Draw(XExposeEvent *ev)
{
    if (!Mapped()) {
	return;
    }
    if (!object && (!ev || (ev->x <= x + FullWidth() &&
    	     		    x <= ev->x + ev->width &&
	     		    ev->y <= y + FullHeight() &&
    	     		    y <= ev->y + ev->height))) {
	base->SetForeground(base->Background());
    	base->FillRectangle(x, y, FullWidth(), FullHeight());
	base->SetForeground(base->Foreground());
    	if (chamfer) {
	    base->DrawRaisedChamfer(int(chamfer),
				    int(x + bw + chamfer),
				    int(y + bw + chamfer),
				    int(lwidth + (hpad - chamfer) * 2),
				    int(lheight + (vpad - chamfer) * 2),
				    base->Background());
    	}
	base->TextAttribute()->Draw(x + hpad + bw,
				    y + vpad + bw,
				    (wchar_t *)label);
    }
    for (Cvo_TreeNode *tn = children; tn; tn = tn->sibling)
    	tn->Draw(ev);
}

void
Cvo_TreeNode::Map()
{
    if (object)
	object->Map();
    else {
    	mapped = True;
	for (Cvo_TreeNode *tn = children; tn; tn = tn->sibling) {
	    if (tn->MapWithParent())
	    	tn->Map();
    	}
    }
}

Cvo_TreeNode::Cvo_TreeNode(Cvo_Window *obj, Cvo_Tree *par)
{   CVO_ENTER
    object = obj;
    childreg = 0;
    map_with_par = 1;
    reg = obj->Register(CvoDestroyedEvent, _CvoTreeDeleteHandler, this);
    obj->Register(CvoPreMapRequestEvent, _CvoTreeMapHandler, this);
//  obj->Register(CvoResizeEvent, _CvoTreeResizeHandler, this);
    obj->Register(CvoUnmapRequestEvent, _CvoTreeUnmapHandler, this);

    base = par;

    if (base == NULL)
	CVO_VOID_RETURN

    if (base->Columns() == NULL) {
	base->SetColumns(new ColumnPtr);
	base->Columns()->Next = NULL;
	base->Columns()->Prev = base->Columns();
	base->Columns()->_topNode = this;
	base->Columns()->width = 0;
	_up = this;
	pad = base->Sibling_Sep();
    } else {
	_up = base->Columns()->_topNode->_up;
	base->Columns()->_topNode->_up->_dn = this;
	base->Columns()->_topNode->_up = this;
	pad = base->Tree_Sep();
    }

    col = base->Columns();
    _dn = NULL;
    sibling = NULL;
    elder = this;
    children = NULL;
    parent = NULL;

    object->ComputeLayoutSize(Cvo_FORCE_DESIRED);
    int nw = object->Layout()->desired.width;
    int nh = object->Layout()->desired.height;

    nw = nw ? nw : object->Layout()->minimum.width;
    nh = nh ? nh : object->Layout()->minimum.height;
    SetColWidth(nw, nh);

    x = 0;
    y = 0;

    //
    // Initially build this object off screen
    // Provides about a 2x speedup.
    //
    object->Layout()->x = 50000;
    object->Layout()->y = 50000;

    CVO_VOID_RETURN
}

Cvo_TreeNode::~Cvo_TreeNode()
{   CVO_ENTER
    BOOL odeleting = base->deleting;
    base->deleting = True;

    if (parent) {
	if (parent->children == this) {
	    if (parent->children = sibling)
		sibling->elder = elder;
	} else {
	    if (elder->sibling = sibling) {
		sibling->elder = elder;
	    } else {
		parent->children->elder = elder;
	    }
	}
	sibling = elder = 0;
    }

    while (children)
	delete children;

    ColumnPtr *Col = col;
    
    if (Col->_topNode == this) {
	if (_up == this) {
	    base->Columns()->Prev = Col->Prev;
	    Col->Prev->Next = Col->Next;
	    delete Col;
	    Col = NULL;
	    if (col == base->Columns()) {
		base->SetColumns(NULL);
	    }
	} else {
	    _dn->_up = _up;
	    _dn->ResetPad();
	    Col->_topNode = _dn;
	}
    } else {
	if (_dn) {
	    _dn->_up = _up;
	    _dn->ResetPad();
	} else {
	    Col->_topNode->_up = _up;
	}
	_up->_dn = _dn;
    }
    
    if (object) {
    	delete reg;
	delete object;
    }

    if ((base->deleting = odeleting) == False) {
	if (base->columns && base->columns->_topNode && base->Object()) {
	    base->columns->_topNode->ConvertTree();
	    base->layoutDirection = Bottom_to_Top;
	}
	base->MakeDirty();
	base->NewLayout(Cvo_FORCE_DESIRED);
    }
    CVO_DONE
}

void
_CvoTreeDeleteHandler(Cvo_Object *, XEvent *, void *v)
{   CVO_ENTER
    Cvo_TreeNode *to = (Cvo_TreeNode *)v;

    to->object = 0;    // Don't allow a recursive delete!
    delete to;
    CVO_VOID_RETURN
}

void
_CvoTreeMapHandler(Cvo_Object *obj, XEvent *, void *v)
{   CVO_ENTER
    Cvo_TreeNode *to = (Cvo_TreeNode *)v;

    BOOL oldstate = to->base->SetMapState();

    Cvo_TreeNode *t = to->children;
    if (!to->childreg) {
	to->childreg = obj->Register(CvoCreatedChildEvent,
				    _CvoTreeChildHandler, to);
	obj->Register(CvoDestroyedChildEvent, _CvoTreeChildHandler, to);
    }

    while (t) {
	if (t->MapWithParent())
	    t->Map();
	t = t->sibling;
    }
    to->base->ReleaseMapState(oldstate, Bottom_to_Top);
    CVO_VOID_RETURN
}

void _CvoTreeChildHandler(Cvo_Object *obj, XEvent *ev, void *v)
{   CVO_ENTER
    Cvo_ResizeEvent *re = (Cvo_ResizeEvent *)ev;

    if (!obj->Mapped())
	CVO_VOID_RETURN

    Cvo_TreeNode *to = (Cvo_TreeNode *)v;

    //
    // XXX - This is sort of bogus, the Tree layout should take care of
    // this.  Anyhow, when one of our nodes ends up with a new child
    // we figure out how big it will want to be and reset our column
    // width to that and then relayout the tree again.
    //
    Cvo_LayoutWindow *lw = obj->ToLayoutWindow();
    lw->ComputeLayoutSize(Cvo_FORCE_DESIRED);
    to->SetColWidth(lw->Layout()->desired.width, lw->Layout()->desired.height);
    to->base->MakeDirty();
    to->base->NewLayout(Cvo_FORCE_DESIRED);
    CVO_VOID_RETURN
}

void
_CvoTreeUnmapHandler(Cvo_Object *, XEvent *, void *v)
{   CVO_ENTER
    Cvo_TreeNode *to = (Cvo_TreeNode *)v;

    BOOL oldstate = to->base->SetMapState();

    Cvo_TreeNode *t = to->children;
    while (t) {
	t->Unmap();
	t = t->sibling;
    }
    to->base->ReleaseMapState(oldstate, Top_to_Bottom);
    CVO_VOID_RETURN
}

void
Cvo_TreeNode::Layout(int force)
{   CVO_ENTER
    //
    // If we are not mapped, don't go any further.
    //
    if (!Mapped()) {
        CVO_VOID_RETURN
    }

    if (object) {
	object->Layout()->x = x;
	object->Layout()->y = y;

	object->LayoutFunction(force|1, 1, width, height);
    }

    int mx = x;
    int my = y;

    if (object)
	object->XOrigin(&mx, &my);
    else
	base->ToXCoord(&mx, &my);

    switch (base->Gravity()) {
    case Cvo_NORTH:
	mx += FullWidth()/2;
	my += FullHeight();
	break;
    case Cvo_SOUTH:
	mx += FullWidth()/2;
	my--;
	break;
    case Cvo_EAST:
	my += FullHeight()/2;
    	mx--;
	break;
    case Cvo_WEST:
	mx += FullWidth();
	my += FullHeight()/2;
	break;
    }

    if (children) {
	if (base->layoutDirection == Bottom_to_Top) {
	    for (Cvo_TreeNode *w = children->elder; ; w=w->elder) {
		if (w->Mapped()) {
		    w->Layout(force);
		    w->DrawLine(mx, my);
		}
		if (w == children) {
		    break;
		}
	    }
	} else {
	    for (Cvo_TreeNode *w = children; w; w=w->sibling) {
		if (w->Mapped()) {
		    w->Layout(force);
		    w->DrawLine(mx, my);
		}
	    }
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_TreeNode::ConvertCol(ColumnPtr* Col)
{   CVO_ENTER
    Col->width = 0;
    Col->offset = 0;
    for(Cvo_TreeNode *w = Col->_topNode; w; w = w->_dn) {
	if (w->Mapped())
            w->SetColWidth(w->DesWidth() +
                           2 * w->HorizontalPad() +
                           w->BorderWidth(),
                           w->DesHeight() +
                           2 * w->VerticalPad() +
                           w->BorderWidth());
    }
}

void
Cvo_TreeNode::ConvertTree()
{   CVO_ENTER

    if (base->Gravity() == Cvo_NORTH ||
	base->Gravity() == Cvo_WEST) {
	ColumnPtr* Col = base->Columns();
	do {
	    ConvertCol(Col);
	} while ((Col=Col->Next) != NULL);
    } else {
	ColumnPtr* Col = base->Columns()->Prev;
	do {
	    ConvertCol(Col);
	} while (Col->Prev->Next && (Col=Col->Prev) != NULL);
    }

    CVO_VOID_RETURN
}

void
Cvo_TreeNode::DrawLine(int mx, int my)
{   CVO_ENTER
    int cx = x;
    int cy = y;

    if (object)
	object->XOrigin(&cx, &cy);
    else
	base->ToXCoord(&cx, &cy);

    switch (base->Gravity()) {
    case Cvo_NORTH:
	cx += FullWidth()/2;
	break;
    case Cvo_SOUTH:
	cx += FullWidth()/2;
	cy += FullHeight() - 1;
	break;
    case Cvo_EAST:
	cy += FullHeight()/2;
	cx += FullWidth();
	break;
    case Cvo_WEST:
	cy += FullHeight()/2;
    	cx -= 1;
	break;
    }

    base->_AddLine(mx, my, cx, cy);
    CVO_VOID_RETURN
}

static Cvo_Default defs[] = {
    "*CvoTree.Sunken: True",
};

CONSTRUCTORS(Cvo_Tree, Cvo_Window, "CvoTree")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Tree)

extern Cvo_Quark _QhorizontalSpace;
extern Cvo_Quark _QverticalSpace;
Cvo_Quark _QsiblingSeparator	= "siblingSeparator";
Cvo_Quark _QtreeSeparator	= "treeSeparator";
Cvo_Quark _QchildSeparator	= "childSeparator";

void
Cvo_Tree::_Init()
{   CVO_ENTER
    hspace = GetResourceInt(_QhorizontalSpace, _QSpace, 10);
    vspace = GetResourceInt(_QverticalSpace, _QSpace, 10);
    sibling_sep = GetResourceInt(_QsiblingSeparator, _QSeparator, 5);
    tree_sep = GetResourceInt(_QtreeSeparator, _QSeparator, 10);
    child_sep = GetResourceInt(_QchildSeparator, _QSeparator, 20);

    char *xrp = GetResource(_Qgravity, _QGravity, "West");
    switch (*xrp) {
    case 'N': case 'n':
	gravity = Cvo_NORTH;
	break;
    case 'S': case 's':
	gravity = Cvo_SOUTH;
	break;
    case 'E': case 'e':
	gravity = Cvo_EAST;
	break;
    default:
    case 'W': case 'w':
	gravity = Cvo_WEST;
	break;
    };

    columns = 0;
    lineColor = Cvo_Color(this, GetResource(_QlineColor, _QColor, "Black"));

    lines = new XSegment[64];
    maxlines = 64;
    nlines = 0;
    Register(Expose, &Cvo_Tree::ExposureHandler);
    dirty = False;
    deleting = False;
    mapstate=False;
    layoutDirection = Bottom_to_Top;
    CVO_VOID_RETURN
}

BOOL
Cvo_Tree::SetMapState(BOOL s)
{   CVO_ENTER
    BOOL om = mapstate;
    mapstate = s ? True : False;
    CVO_RETURN(om)
}

void
Cvo_Tree::ReleaseMapState(BOOL oldstate, Cvo_TreeDirect_enum dir, BOOL rl)
{   CVO_ENTER
    SetMapState(oldstate);
    if (oldstate == False) {
	columns->_topNode->ConvertTree();
	MakeDirty();
        layoutDirection = dir;
	if (rl)
	    NewLayout(Cvo_FORCE_DESIRED);
    }
    CVO_VOID_RETURN
}

void
Cvo_Tree::SetGravity(CARD16 g)
{   CVO_ENTER
    CARD16 ngravity;

    if (g & Cvo_NORTH)
	ngravity = Cvo_NORTH;
    else if (g & Cvo_SOUTH)
	ngravity = Cvo_SOUTH;
    else if (g & Cvo_EAST)
	ngravity = Cvo_EAST;
    else
	ngravity = Cvo_WEST;

    if (ngravity != gravity) {
	gravity = ngravity;
	if (columns && columns->_topNode && Object()) {
	    MakeDirty();
	    columns->_topNode->ConvertTree();
	    layoutDirection = Bottom_to_Top;
	    Cvo_Object *obj = this;

	    while (obj->Parent() && obj->Parent()->ToLayoutWindow() &&
		   obj->Parent()->ToLayoutWindow()->LayoutBackward())
		obj = obj->Parent();
	    obj->ToLayoutWindow()->NewLayout(Cvo_FORCE_DESIRED);
	}
    }
    CVO_VOID_RETURN
}

int
Cvo_Tree::StandardLayoutFunction(int force, int child, int w, int h)
{   CVO_ENTER
    if (MapState() || !dirty) {
  	CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)
    }
    return(Cvo_Window::StandardLayoutFunction(force, child, w, h));
}

void
Cvo_Tree::StandardLayoutChildren(int force, int olay)
{   CVO_ENTER
    if (!Object() || MapState() || !dirty || olay)
	CVO_VOID_RETURN
    dirty = False;

    nlines = 0;

    if (!columns || !columns->_topNode) {
	ClearWindow();
	CVO_VOID_RETURN
    }

    ColWidthAdj(columns);

    if (columns) {
	for (Cvo_TreeNode *TPtr = columns->_topNode; TPtr; TPtr=TPtr->_dn) {
	    TPtr->Layout(force);
	}
    }
    ClearWindow();
    ExposureHandler();
    Cvo_AnyEvent te;
    SendEvent(CvoTreeRedrawEventType, &te);
    CVO_VOID_RETURN
}

void
Cvo_Tree::ResetAll()
{   CVO_ENTER
    if (!Columns())
	CVO_VOID_RETURN
    ColumnPtr *Col = Columns()->Prev;
    do {
	for(Cvo_TreeNode *w = Col->_topNode; w; w = w->_dn) {
	    w->ResetPad();
	}
    } while (Col->_topNode->col != Columns()  && (Col=Col->Prev) != NULL);
    CVO_VOID_RETURN
}

int
Cvo_Tree::StandardComputeLayoutSize(int force)
{   CVO_ENTER
    Cvo_FrameSize mymin, mydes;

    if (MapState() || !dirty)
    	CVO_RETURN(CheckLayout())

    ComputeUserSizes(mymin, mydes);

    layout.minimum.height = 0;
    layout.minimum.width = 0;

    ResetAll();
    ComputeLayout(force);

    int rs = layout.ignoreshadow ? 0 : raise;

    layout.minimum.height += (vspace + borderWidth + verticalPad) * 2 + rs;
    layout.minimum.width += (hspace + borderWidth + horizontalPad) * 2 + rs;

    if (layout.minimum.width < mymin.width)
	layout.minimum.width = mymin.width;

    if (layout.minimum.height < mymin.height)
	layout.minimum.height = mymin.height;

    if (mydes.width > layout.minimum.width)
	layout.desired.width = mydes.width;
    else
	layout.desired.width = layout.minimum.width;

    if (mydes.height > layout.minimum.height)
	layout.desired.height = mydes.height;
    else
	layout.desired.height = layout.minimum.height;

    if (layout.maximum.width && layout.maximum.width < layout.minimum.width)
	layout.maximum.width = layout.minimum.width;
    if (layout.maximum.height && layout.maximum.height < layout.minimum.height)
	layout.maximum.height = layout.minimum.height;

    CVO_RETURN(CheckLayout())
}

void
Cvo_Tree::ComputeLayout(int force)
{   CVO_ENTER
    if (!Columns())
	CVO_VOID_RETURN

    ColumnPtr *Col = Columns()->Prev;
    do {
	for(Cvo_TreeNode *w = Col->_topNode; w; w = w->_dn) {
	    if (!w->Mapped())
		continue;

	    //
	    // Look for nodes trying to map without parent mapped.
	    // un-map this node so that any children it has won't
	    // be fooled.
	    //
	    if (w->parent && !w->parent->Mapped()) {
		w->Unmap();
		continue;
	    } 

	    if (!(w->width = w->DesWidth()))
		w->width = w->MinWidth();

	    if (!(w->height = w->DesHeight()))
		w->height = w->MinWidth();

	    Cvo_TreeNode *fc = w->children;
	    Cvo_TreeNode *lc;

	    while (fc && !fc->Mapped())
		fc = fc->sibling;

	    if (lc = fc) {
		while (lc->sibling)
		    lc = lc->sibling;
		while (!lc->Mapped())
		    lc = lc->elder;
	    }

	    Cvo_TreeNode *mapped_up = w->_up;
	    while (mapped_up->_dn && !mapped_up->Mapped())
		mapped_up = mapped_up->_up;

	    if (mapped_up->_dn == NULL) {  	// No node mapped above
		mapped_up = NULL;
	    }

	    switch (Gravity()) {
	    case Cvo_NORTH:
	    case Cvo_SOUTH:

		if (fc) {
		    int ch_w;
		    if (fc == lc) {
			//
			// Single Child
			// 
			ch_w = fc->width;
		    } else {
			//
			// Multiple Children
			// 
			ch_w = lc->x + lc->width - fc->x;
		    }
		    w->x = fc->x + ch_w/2 - (w->width/2);

		    //
		    // Look for Overlaps
		    // 
		    if ((mapped_up && w->x - (mapped_up->x +
			     mapped_up->width) < w->pad) ||
			     w->x < w->pad) {
			//
			//  Calculate Pad on tree
			//  Propogate out to first child leaf - recurse
			// 
			do {
                            if (mapped_up) {
				fc->IncPad((mapped_up->x +
					mapped_up->width) -
				       (w->x - w->pad));
			    } else {
				fc->IncPad(HSpace() + w->pad - w->x);
			    }
			}  while ((fc = fc->sibling) && fc->elder != lc);

			// 
			// Recompute layout from the begining
			// 
			ComputeLayout(force);
			CVO_VOID_RETURN //  ComputeLayout doesn't return until
					//  a good layout is found
		    }

		} else {
		    // 
		    // No Children
		    // 

		    if (!mapped_up) {
			w->x = HSpace() + w->pad;
		    } else {
			w->x = (mapped_up->x + mapped_up->width) + w->pad;
		    }
		}
		w->y = VSpace() + w->base->Sibling_Sep() + Col->offset;
		break;
	    case Cvo_WEST:
	    case Cvo_EAST:
		if (fc) {
		    int ch_w;
                    int mult_ch=0;
		    if (fc == lc) {
			//
			// Single Child
			// 
			ch_w = fc->height;
		    } else {
			ch_w = lc->y + lc->height - fc->y;
                        mult_ch = 1;
		    }
		    w->y = fc->y +ch_w/2 -(w->height/2);

		    //
		    // Look for Overlaps
		    // 
		    if ((mapped_up && w->y - (mapped_up->y +
                        mapped_up->height) < w->pad) ||
			     w->y < w->pad) {

			//
			//  Calculate Pad on tree
			//  Propogate out to first child leaf - recurse
			// 
			do {
                            if (mapped_up) {
			        fc->IncPad((mapped_up->y +
                                        mapped_up->height) -
					(w->y - w->pad));
			    } else {
				fc->IncPad(VSpace()+w->pad - w->y);
                            }
			}  while ((fc = fc->sibling) && fc->elder != lc);

			// 
			// Recompute layout from the begining
			// 
			ComputeLayout(force);
			CVO_VOID_RETURN //  ComputeLayout doesn't return until
					//  a good layout is found
		    }

		} else {
		    // 
		    // No Children
		    // 

		    if (!mapped_up) {
			//
			// Top of the column
			//
			w->y = VSpace() + w->pad;
		    } else {
			w->y = (mapped_up->y + mapped_up->height)
			+ w->pad;
		    }
		}
		w->x = HSpace() + w->base->Sibling_Sep() + Col->offset;
		break;
	    }
	    layout.minimum.height = max(layout.minimum.height,
					w->y + w->height);
	    layout.minimum.width =  max(layout.minimum.width,
					w->x + w->width);
	}
    } while (Col->_topNode->col != Columns() && (Col=Col->Prev) != NULL);
    CVO_VOID_RETURN
}

void
Cvo_Tree::ChildHandler(XEvent *, void *)
{   CVO_ENTER
    if (!MapState()) {
	MakeDirty();
    }
    CVO_VOID_RETURN
}

void
Cvo_Tree::ExposureHandler(XEvent *ev, void *)
{   CVO_ENTER
    SetForeground(lineColor);
    XDrawSegments(Dpy(), Object(), Gc(), lines, nlines);

    for (ColumnPtr *cp = columns; cp; cp = cp->Next)
	cp->_topNode->Draw((XExposeEvent *)ev);

    CVO_VOID_RETURN
}

void
Cvo_Tree::_AddLine(int x1, int y1, int x2, int y2)
{   CVO_ENTER
    if (nlines == maxlines) {
	maxlines += 64;
	XSegment *nseg = new XSegment[maxlines];
	memcpy(nseg, lines, sizeof(XSegment) * nlines);
	delete [] lines;
	lines = nseg;
    }
    ToXCoord(&x1, &y1);
    ToXCoord(&x2, &y2);
    lines[nlines].x1 = x1;
    lines[nlines].y1 = y1;
    lines[nlines].x2 = x2;
    lines[nlines++].y2 = y2;
    CVO_VOID_RETURN
}

BOOL
Cvo_TreeNode::SetMapWithParent(BOOL s)
{   CVO_ENTER
    BOOL om = map_with_par;
    map_with_par = s ? True : False;
    CVO_RETURN(om)
}

void
Cvo_TreeNode::Layout_Pixmap(Cvo_TreeViewPortPanner* tvpp,
			    int x_scale, int y_scale, int mx, int my)
{ CVO_ENTER
    int Cx, Cy;
    int cx = Cx = x;
    int cy = Cy = y;

    switch (base->Gravity()) {
    case Cvo_NORTH:
	cx += Width()/2;
	cy -= VerticalPad() + BorderWidth();
	Cx += Width()/2;
	Cy += Height() + VerticalPad() + BorderWidth();
	break;
    case Cvo_SOUTH:
	cx += Width()/2;
	cy += Height() + VerticalPad() + BorderWidth();
	Cx += Width()/2;
	Cy -= VerticalPad() + BorderWidth() + 1;
	break;
    case Cvo_EAST:
	cy += Height()/2;
	cx += Width() + HorizontalPad() + BorderWidth();
	Cx -= HorizontalPad() + BorderWidth() + 1;
	Cy += Height()/2;
	break;
    case Cvo_WEST:
	cy += Height()/2;
	cx -= HorizontalPad() + BorderWidth();
	Cx += Width() + HorizontalPad() + BorderWidth();
	Cy += Height()/2;
	break;
    }

    if (mx != -1) {
	tvpp->_AddLine(mx, my, (cx * MAGN)/x_scale, (cy * MAGN)/y_scale);
    }

    // 
    // Draw a box
    // 
    tvpp->Pixmap()->DrawRectangle((x * MAGN)/x_scale, (y * MAGN)/y_scale,
                        (MAGN * Width() + HorizontalPad() +
			 BorderWidth())/x_scale,
			(MAGN * Height() + VerticalPad() +
			 BorderWidth())/y_scale);

    if (children) {
	for (Cvo_TreeNode *w = children; w; w=w->sibling) {
	    if (w->Mapped()) {
		w->Layout_Pixmap(tvpp, x_scale, y_scale,
				 (MAGN * Cx)/x_scale, (MAGN * Cy)/y_scale);
	    }
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_Tree::FillPixmap(Cvo_TreeViewPortPanner* tvpp, int x_scale, int y_scale)
{   CVO_ENTER

    if (MapState()) {
	CVO_VOID_RETURN
    } 

    if (!tvpp->Object()) { 
	CVO_VOID_RETURN
    }

    if (columns) {
	for (Cvo_TreeNode *TPtr = columns->_topNode; TPtr; TPtr=TPtr->_dn) {
	    TPtr->Layout_Pixmap(tvpp, x_scale, y_scale);
	}
    }
    CVO_VOID_RETURN
}
