//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Translation.cc,v 1.6 1994/08/23 13:50:37 prb Exp $"); }
#include <Cvo/BasicButton.h++>
#include <X11/keysym.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#if defined(__NEED_STRINGS__)
#include <strings.h>
#endif

Cvo_Translation *Cvo_Translation::root = 0;

#define GetToBuffer(s,cond) { \
    char *s1 = buffer; \
    while (*s && (cond)) \
	*s1++ = *s++; \
    *s1 = '\0'; \
}

#define LowerBuffer { \
    for (char *st = buffer; *st; st++) \
	if (isupper(*st)) \
	    *st = tolower(*st);\
}

Cvo_ExtHandleFunction::Cvo_ExtHandleFunction(
		char *s, void (*h)(Cvo_Object *, XEvent *, int, char **))
{
    symbol = s;
    handler = h;
}

void
Cvo_ExtHandleFunction::function(Cvo_Object *o, XEvent *e, int c, char **v)
{
    if (handler)
	(*handler)(o, e, c, v); \
}

Cvo_TranRec::Cvo_TranRec(Cvo_TranRec **root)
{   CVO_ENTER
    next = 0;
    if (!*root) {
	prev = this;
	*root = this;
    } else {
	prev = (*root)->prev;
	prev->next = this;
	(*root)->prev = this;
    }

    yes_modifiers = XLATE_MOD_NONE;
    no_modifiers  = XLATE_MOD_NONE;
    actions = NULL;
    count = 0;
    CVO_VOID_RETURN
}

Cvo_TranRec *
Cvo_TranRec::Duplicate()
{   CVO_ENTER
    Cvo_TranRec *r = 0;
    Cvo_TranRec *a = this;
    while (a) {
        Cvo_TranRec *n = new Cvo_TranRec(&r);
        *n = *a;
        a = a->next;
    }
    CVO_RETURN(r)
}

void
Cvo_TranRec::Delete(Cvo_TranRec **root)
{   CVO_ENTER
    if (*root == this) {
	*root = next;
	if (next)
	    next->prev = prev;
    } else if (next) {
	prev->next = next;
	next->prev = prev;
    } else {
	prev->next = 0;
	(*root)->prev = prev;
    }
    while (actions)
	actions->Delete(&actions);
    CVO_VOID_RETURN
}

Cvo_Translation::Cvo_Translation()
{   CVO_ENTER
    if (next = root)
	next->prev = this;
    root = this;

    mode = XLATE_REPLACE;
    xlate_list = NULL;
    base = 0;
    table0 = 0;
    table1 = 0;
    CVO_VOID_RETURN
}

Cvo_Translation::~Cvo_Translation()
{   CVO_ENTER
    if (next)
	next->prev = prev;
    if (prev)
	prev->next = next;
    if (root == this)
	root = next;

    while (xlate_list)
	xlate_list->Delete(&xlate_list);
    CVO_DONE
}

static int
ClassifyEventString(char *s, int *which)
{   CVO_ENTER
    *which = 0;

    if (s == NULL || !*s)		CVO_RETURN(0)

    if (!strcmp(s,"key"))		CVO_RETURN(CvoKeyTextEvent)
    if (!strcmp(s,"keypress"))		CVO_RETURN(KeyPress)
    if (!strcmp(s,"keydown"))		CVO_RETURN(KeyPress)

    if (!strcmp(s,"keyrelease"))	CVO_RETURN(KeyRelease)
    if (!strcmp(s,"keyup"))		CVO_RETURN(KeyRelease)

    if (!strcmp(s,"down"))		CVO_RETURN(CvoButtonDownEvent)
    if (!strcmp(s,"up"))		CVO_RETURN(CvoButtonUpEvent)

    if (!strcmp(s,"btndown"))		CVO_RETURN(ButtonPress)
    if (!strcmp(s,"buttondown"))	CVO_RETURN(ButtonPress)
    if (!strcmp(s,"buttonpress"))	CVO_RETURN(ButtonPress)
    if (!strcmp(s,"btnup"))		CVO_RETURN(ButtonRelease)
    if (!strcmp(s,"buttonup"))		CVO_RETURN(ButtonRelease)
    if (!strcmp(s,"buttonrelease"))	CVO_RETURN(ButtonRelease)
    if (!strcmp(s,"btnmotion"))		CVO_RETURN(MotionNotify)
    if (!strcmp(s,"buttonmotion"))	CVO_RETURN(MotionNotify)
    if (!strcmp(s,"enterwindow"))	CVO_RETURN(EnterNotify)
    if (!strcmp(s,"leavewindow"))	CVO_RETURN(LeaveNotify)
    if (!strcmp(s,"enternotify"))	CVO_RETURN(EnterNotify)
    if (!strcmp(s,"leavenotify"))	CVO_RETURN(LeaveNotify)
    if (!strcmp(s,"enter"))		CVO_RETURN(EnterNotify)
    if (!strcmp(s,"leave"))		CVO_RETURN(LeaveNotify)

    //
    //	Check specific cases for buttons
    //
    if (!strncmp(s,"btn",3)) {
        switch (s[3]) {
        case '1': *which = Button1Press; break;
        case '2': *which = Button2Press; break;
        case '3': *which = Button3Press; break;
        case '4': *which = Button4Press; break;
        case '5': *which = Button5Press; break;
        default: CVO_RETURN(0)
        }

        if (!s[4] || !strcmp(&s[4],"down") || !strcmp(&s[4], "press")) {
	    CVO_RETURN(ButtonPress)
        } else if (!strcmp(&s[4],"up")) {
            CVO_RETURN(ButtonRelease)
        } else if (!strcmp(&s[4],"motion")) {
            CVO_RETURN(MotionNotify)
        } else {
            CVO_RETURN(0)
        }
    }
    if (!strncmp(s,"button",6)) {
        switch (s[6]) {
        case '1': *which = Button1Press; break;
        case '2': *which = Button2Press; break;
        case '3': *which = Button3Press; break;
        case '4': *which = Button4Press; break;
        case '5': *which = Button5Press; break;
        default: CVO_RETURN(0)
        }

        if (!s[7] || !strcmp(&s[7],"down") || !strcmp(&s[7], "press")) {
	    CVO_RETURN(ButtonPress)
        } else if (!strcmp(&s[7],"up")) {
            CVO_RETURN(ButtonRelease)
        } else if (!strcmp(&s[4],"motion")) {
            CVO_RETURN(MotionNotify)
        } else {
            CVO_RETURN(0)
        }
    }
    CVO_RETURN(0)
}

//
// print debugging information
//
void
Cvo_Translation::Interrogate()
{   CVO_ENTER
    Cvo_TranRec *tr = xlate_list;
    int i = 0;
    while (tr) {
#if defined(verbose_mode)
        fprintf(stderr,"===> translation %d (event %d keysym %s)\n",
            i++,
	    tr->event,
            XKeysymToString(tr->keysym));
        if (tr->event == ButtonPress || tr->event == ButtonRelease) {
            fprintf(stderr,"Button %d\n",(tr->which>>24)&0xff);
        }
        //
        // Dump the modifier flags.
        //
        fprintf(stderr,"NO: ");
        if (tr->no_modifiers & XLATE_MOD_SHIFT)
            fprintf(stderr,"SHIFT ");
        if (tr->no_modifiers & XLATE_MOD_CTRL)
            fprintf(stderr,"CTRL ");
        if (tr->no_modifiers & XLATE_MOD_META)
            fprintf(stderr,"META ");
        if (tr->no_modifiers & XLATE_MOD_HYPER)
            fprintf(stderr,"HYPER ");
        if (tr->no_modifiers & XLATE_MOD_LOCK)
            fprintf(stderr,"LOCK ");
        fprintf(stderr,"\n");
        fprintf(stderr,"YES: ");
        if (tr->yes_modifiers & XLATE_MOD_SHIFT)
            fprintf(stderr,"SHIFT ");
        if (tr->yes_modifiers & XLATE_MOD_CTRL)
            fprintf(stderr,"CTRL ");
        if (tr->yes_modifiers & XLATE_MOD_META)
            fprintf(stderr,"META ");
        if (tr->yes_modifiers & XLATE_MOD_HYPER)
            fprintf(stderr,"HYPER ");
        if (tr->yes_modifiers & XLATE_MOD_LOCK)
            fprintf(stderr,"LOCK ");
        fprintf(stderr,"\n");
#else
        if (tr->no_modifiers & XLATE_MOD_SHIFT)
            fprintf(stderr,"~Shift ");
	else if (tr->yes_modifiers & XLATE_MOD_SHIFT)
            fprintf(stderr," Shift ");
	else
            fprintf(stderr,"       ");

        if (tr->no_modifiers & XLATE_MOD_CTRL)
            fprintf(stderr,"~Ctrl ");
	else if (tr->yes_modifiers & XLATE_MOD_CTRL)
            fprintf(stderr," Ctrl ");
	else
            fprintf(stderr,"      ");

        if (tr->no_modifiers & XLATE_MOD_META)
            fprintf(stderr,"~Meta ");
	else if (tr->yes_modifiers & XLATE_MOD_META)
            fprintf(stderr," Meta ");
	else
            fprintf(stderr,"      ");

        if (tr->no_modifiers & XLATE_MOD_LOCK)
            fprintf(stderr,"~Lock ");
	else if (tr->yes_modifiers & XLATE_MOD_LOCK)
            fprintf(stderr," Lock ");
	else
            fprintf(stderr,"      ");

        if (tr->event == ButtonPress || tr->event == ButtonRelease)
            fprintf(stderr,"<Button %d>",(tr->which>>24)&0xff);
	else 
	    fprintf(stderr,"<%d %s>", tr->event, XKeysymToString(tr->keysym));
#endif
        //
        // Dump each of the actions
        //
	Cvo_Action *act = tr->actions;
	if (!act)
	    fprintf(stderr, "\n");
	while(act) {
            act->Interrogate();
	    act = act->next;
	    if (act)
		fprintf(stderr, "\t\t\t\t");
        }
	tr = tr->next;
    }
    CVO_VOID_RETURN
}

#define NO_MOD_FLAG	0
#define MOD_FLAG_NOT	1
#define MOD_FLAG_ONLY	2

int
Cvo_Translation::ParseAction(char *string)
{   CVO_ENTER
    char *s;
    char buffer[2048];		// XXX -- we limit them to 2K??? Fix this!
    char *bp;
    Cvo_TranRec *tr;
    Cvo_Action *action;
    int mod_flag;

    while (isspace(*string))
	string++;	// skip the spaces
    if (!*string)
	CVO_RETURN(False)
    tr = new Cvo_TranRec(&xlate_list);
    s = string;
    //
    // Look for modifiers
    //
    while (*s && *s != '<') {
        mod_flag = NO_MOD_FLAG;
        while (isspace(*s))
		s++;	// skip the spaces
        if (*s == '!') {
            mod_flag = MOD_FLAG_ONLY;
            s++;
        } else if (*s == '~') {
            mod_flag = MOD_FLAG_NOT;
            s++;
        }
        if (isalpha(*s)) {
            GetToBuffer(s,isalpha(*s));
            //
            // Lowercase the buffer
            //
            for (char *st = buffer; *st; st++)
                if (isupper(*st)) 
		    *st = tolower(*st);

	    int result_flag = XLATE_MOD_NONE;
            //
            // Try the most common modifiers.
            //
            if (!strcmp(buffer,"shift"))
                result_flag = XLATE_MOD_SHIFT;
            else if (!strcmp(buffer,"ctrl"))
                result_flag = XLATE_MOD_CTRL;
            else if (!strcmp(buffer,"meta"))
                result_flag = XLATE_MOD_META;
            //
            // Try the short synonyms.
            //
            else if (!strcmp(buffer,"s"))
                result_flag = XLATE_MOD_SHIFT;
            else if (!strcmp(buffer,"c"))
                result_flag = XLATE_MOD_CTRL;
            else if (!strcmp(buffer,"m"))
                result_flag = XLATE_MOD_META;
            //
            // Try less common modifiers.
            //
            else if (!strcmp(buffer,"hyper"))
                result_flag = XLATE_MOD_META;
            else if (!strcmp(buffer,"lock"))
                result_flag = XLATE_MOD_META;
            else {
		Cvo_Failure(CvoE_WARN, CvoE_BAD_MOD,
			    "Unknown modifier %s in translation %s\n",
			    buffer, string);
		tr->Delete(&xlate_list);
		CVO_RETURN(False)
            }
            //
            // Do the flag stuff now
            //
            if (mod_flag == MOD_FLAG_ONLY) {
                tr->yes_modifiers = tr->no_modifiers = XLATE_MOD_NONE;
            }
            if (mod_flag == MOD_FLAG_NOT) {
                tr->yes_modifiers &= ~result_flag;
                tr->no_modifiers  |=  result_flag;
            } else {
                tr->no_modifiers  &= ~result_flag;
                tr->yes_modifiers |= result_flag;
            }
        } else if (*s == '<') {
            break;
        } else {
	    Cvo_Failure(CvoE_WARN, CvoE_BAD_CHAR,
			"Unknown character %c in translation %s\n",
			*s, string);
	    tr->Delete(&xlate_list);
	    CVO_RETURN(False)
        }
    }
    //
    // Look for the Event.
    //
    while (isspace(*s))
        s++;			// skip the spaces
    if (*s != '<') {
	Cvo_Failure(CvoE_WARN, CvoE_MISSOPEN,
		    "Missing '<' in translation %s\n",
		    string);
	tr->Delete(&xlate_list);
	CVO_RETURN(False)
    }
    s++;
    GetToBuffer(s,(*s != '>'));
    LowerBuffer;
    if (!(tr->event = ClassifyEventString(buffer,&(tr->which)))) {
	Cvo_Failure(CvoE_WARN, CvoE_BAD_EVENT,
		    "Unknown event type %s in translation %s\n",
		    buffer, string);
	tr->Delete(&xlate_list);
	CVO_RETURN(False)
    }
    s++;

    //
    // Look for the count object.
    //
    while (isspace(*s))
        s++;			// skip the spaces
    if (*s == '(') {
	++s;
	GetToBuffer(s,(*s != ')'));
	tr->count = atoi(buffer);
	if (tr->count > 0)
	    tr->count--;
	else
	    tr->count = 0;
	s++;
    }

    //
    // Look for the Event object.
    //
    while (isspace(*s))
        s++;			// skip the spaces
    GetToBuffer(s,(*s != ':'));
    if (!*buffer) {
        tr->keysym = XK_VoidSymbol;
    } else if (!strcasecmp("space", buffer)) {
        tr->keysym = ' ';
    } else {
        tr->keysym = XStringToKeysym(buffer);
    }
    s++;

    //
    // Look for Actions
    //
#ifdef notdef
    while (isspace(*s))
        s++;			// skip the spaces
    if (*s != ':')
        CVO_RETURN(False)
#endif

    //
    // Okay, we know we will add this one, so now it is time to
    // create it.
    //

    while (*s) {
        while (isspace(*s))
            s++;		// skip the spaces
        bp = buffer;
        while (*s && *s != ')')
            *bp++ = *s++;
        if (*s == ')')
            *bp++ = *s++;
        *bp = '\0';
        action = new Cvo_Action(&(tr->actions));
        if (!action->Parse(buffer))
	    action->Delete(&(tr->actions));
    }
    if (tr->actions)
	CVO_RETURN(True)
    Cvo_Failure(CvoE_WARN, CvoE_NOACTION,
		"Missing actions in translation %s\n",
		string);
    tr->Delete(&xlate_list);
    CVO_RETURN(False)
}

int
Cvo_Translation::Parse(char *string, int defmode)
{   CVO_ENTER
    int successful = False;
    char buffer[2048];	// XXX - this is probably too small...

    if (base || table0 || table1) {
	Cvo_Failure(CvoE_WARN, CvoE_OVERWITE,
		    "Internal: overwriting translation table\n");
    }
    base = string;
    mode = defmode;

    while (*string && isspace(*string))
	string++;			// skip spaces
    if (*string == '#') {
	char *s = string;

	while (*s && !isspace(*s) && *s != '\n')
		++s;
	char save = *s;
	*s = '\0';

	if (!strcasecmp("#replace", string)) {
	    mode = XLATE_REPLACE;
	} else if (!strcasecmp("#override", string)) {
	    mode = XLATE_OVERRIDE;
	} else if (!strcasecmp("#augment", string)) {
	    mode = XLATE_AUGMENT;
	} else {
	    Cvo_Failure(CvoE_WARN, CvoE_BADDIRECT,
		        "Bad directive %s in translation table\n",
		        string);
	}
	*s = save;
	string = s;
    }
    while (*string) {
        while (isspace(*string))
            string++;			// skip spaces
        char *s1 = buffer;

        while (*string && *string != '\n') {
            *s1++ = *string++;
        }
        *s1 = '\0';
        if (ParseAction(buffer)) {
            successful = True;
        }
	if (*string)
	    string++;
    }
    CVO_RETURN(successful)
}

Cvo_TranRec *
Cvo_Translation::Match(Cvo_TranRec *ot)
{   CVO_ENTER
    Cvo_TranRec *tr = xlate_list;

    while (tr) {
	if (*tr == *ot)
	    CVO_RETURN(tr)
	tr = tr->next;
    }
    CVO_RETURN(0)
}

void
Cvo_Translation::Merge(Cvo_Translation *t0, Cvo_Translation *t1)
{   CVO_ENTER
    if (base || table0 || table1) {
	Cvo_Failure(CvoE_WARN, CvoE_OVERWITE,
		    "Internal: overwriting translation table\n");
    }
    base = 0;
    table0 = t0;
    table1 = t1;
    //
    // It is real easy if the second table replaces the first one.
    // Or if the first table doesn't exist
    // Just point at it and return.
    //
    if ((t1->mode & XLATE_MASK) == XLATE_REPLACE || !t0->xlate_list) {
	mode = t1->mode & XLATE_MASK;
	xlate_list = t1->xlate_list->Duplicate();
	CVO_VOID_RETURN
    }
    //
    // If the second table doesn't exist, just use the first one
    //
    if (!t1->xlate_list) {
	mode = t0->mode & XLATE_MASK;
	xlate_list = t0->xlate_list->Duplicate();
	CVO_VOID_RETURN
    }
    //
    // Okay, both tables are there.
    // The second table is the table being merged in and the first is
    // the orignal table.  If the second table is marked as XLATE_PREPEND
    // then we will use it as the base instead of the original table.
    //
    mode = t1->mode & XLATE_MASK;

    int pp = t1->mode & XLATE_PREPEND;

    xlate_list = (pp ? t0 : t1)->xlate_list->Duplicate();

    //
    // Now look through the second table
    //

    Cvo_TranRec *tr = (pp ? t1 : t0)->xlate_list;
    while (tr) {
	Cvo_TranRec *otr = Match(tr);
	if (!otr) {
	    //
	    // The preivous translation table did not have this
	    // entry, so we just copy it in.
	    //
	    otr = new Cvo_TranRec(&xlate_list);
	    *otr = *tr;
	} else if ((!pp && mode == XLATE_OVERRIDE) ||
		   ( pp && mode == XLATE_AUGMENT)) {
	    *otr = *tr;
	}
	tr = tr->next;
    }
}

Cvo_Translation *
Cvo_LoadTranslation(char *string, int defmode)
{   CVO_ENTER
    Cvo_Translation *r = Cvo_Translation::root;

    while (r) {
	if (r->base == string)
		CVO_RETURN(r)
	r = r->next;
    }
    r = new Cvo_Translation;
    r->Parse(string, defmode);
    CVO_RETURN(r)
}

Cvo_Translation *
Cvo_LoadTranslation(Cvo_Translation *t0, Cvo_Translation *t1)
{   CVO_ENTER
    Cvo_Translation *r = Cvo_Translation::root;

    while (r) {
	if (r->table0 == t0 && r->table1 == t1)
		CVO_RETURN(r)
	r = r->next;
    }
    r = new Cvo_Translation;
    r->Merge(t0, t1);
    CVO_RETURN(r)
}

void
Cvo_Translation::Bind(Cvo_HandleFunction *map)
{   CVO_ENTER
    Cvo_TranRec *tr = xlate_list;

    while (tr) {
	tr->Bind(map);
	tr = tr->next;
    }
    CVO_VOID_RETURN
}

void
Cvo_TranRec::Bind(Cvo_HandleFunction *map)
{   CVO_ENTER
    Cvo_Action *act = actions;

    while (act) {
	act->Bind(map);
	act = act->next;
    }
    CVO_VOID_RETURN
}

void
Cvo_Translation::Verify()
{   CVO_ENTER
    Cvo_TranRec *tr = xlate_list;

    while (tr) {
	tr->Verify();
	tr = tr->next;
    }
    CVO_VOID_RETURN
}

void
Cvo_TranRec::Verify()
{   CVO_ENTER
    Cvo_Action *act = actions;

    while (act) {
	act->Verify();
	act = act->next;
    }
    CVO_VOID_RETURN
}

void
Cvo_Translation::Install(Cvo_Object *win)
{   CVO_ENTER
    Cvo_TranRec *tr = xlate_list;

    while (tr) {
	tr->Install(win);
	tr = tr->next;
    }
    CVO_VOID_RETURN
}

void
Cvo_TranRec::Install(Cvo_Object *win)
{   CVO_ENTER
    CARD32 e = event | yes_modifiers;

    if (which)
        e |= which;
    if (event == ButtonPress || event == ButtonRelease) {
	e |= (count << ButtonCountShift) & ButtonCountMask;
    }

    new Cvo_ActionRegistration(win, e, CARD16(no_modifiers >> 16),
			       keysym, actions);
    CVO_VOID_RETURN
}

Cvo_ActionRegistration::Cvo_ActionRegistration(Cvo_Object *w,
				     CARD32 e,
				     CARD16 m,
				     KeySym k,
				     Cvo_Action *a)
		      : Cvo_Registration(w, e, m, k)
{
    actions = a;
}

void
Cvo_ActionRegistration::function()
{   CVO_ENTER
    Cvo_Action *act = actions;
    BOOL *delp = deletedp;
    while (act) {
	if (act->function != 0) {
	    act->function->function(object, event, act->numparams, act->params);
	}
    	if (delp && *delp)
	    CVO_VOID_RETURN
	act = act->next;
    }
    event->type = 0;
    CVO_VOID_RETURN
}
