//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Toggle.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Toggle.h++>
#include <string.h>

static Cvo_Default defs[] = {
    "*CvoSquareToggleButton.CvoLabel.Chamfer:0",
    "*CvoSquareToggleButton.Chamfer:0",
    "*CvoSquareToggleButton.BorderWidth:0",
    "*CvoToggleButton.FontWeight:Bold",
    "*CvoToggleButton.Pad:2",
    "*CvoSquareToggleButton.Cursor:Top Left Arrow",
    "*CvoToggleButton.Cursor:Top Left Arrow",
};

CONSTRUCTORS(Cvo_Toggle, Cvo_Window, "CvoToggle")
CONSTRUCTORS(Cvo_SquareToggle, Cvo_Toggle, "CvoSquareToggle")
CONSTRUCTORS(Cvo_BasicToggleButton, Cvo_BasicButton, "CvoBasicToggleButton")
CONSTRUCTORS(Cvo_ToggleButton, Cvo_BasicToggleButton, "CvoToggleButton")
CONSTRUCTORS_1ARG(Cvo_ToggleButton, Cvo_BasicToggleButton, "CvoToggleButton", char *)
CONSTRUCTORS(Cvo_SquareToggleButton, Cvo_BasicToggleButton, "CvoSquareToggleButton")
CONSTRUCTORS_1ARG(Cvo_SquareToggleButton, Cvo_BasicToggleButton, "CvoSquareToggleButton", char *)
CONSTRUCTORS_1ARG(Cvo_SquareToggleButton, Cvo_BasicToggleButton, "CvoSquareToggleButton", wchar_t *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_SquareToggle)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_ToggleButton)

void
Cvo_SquareToggle::_Init()
{   CVO_ENTER
    type = CvoT_SquareToggle;
    inset = chamfer;
    chamfer = 0;
    moat = 0;
    moatChamfer = 0;
    moatEdge = 0;
    sunken = 0;
    etched = 0;
//  borderWidth = 0;
    horizontalPad = 0;
    verticalPad = 0;
    Register(Expose, &Cvo_SquareToggle::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_SquareToggle::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (toggle) {
	if (Monochrome()) {
	    SetForeground(foreground);
	    FillRectangle(inset, inset,
			  Width() - 2 * inset, Height() - 2 * inset);
	    DrawRectangle(inset, inset,
			  Width() - 2 * inset, Height() - 2 * inset);
	} else {
	    SetForeground(background->Select());
	    FillRectangle(inset, inset,
			  Width() - 2 * inset, Height() - 2 * inset);
	    DrawLoweredChamfer(inset, inset, inset,
			       Width() - 2 * inset, Height() - 2 * inset);
	}
    } else {
	if (Monochrome()) {
	    SetForeground(background);
	    FillRectangle(inset, inset,
			  Width() - 2 * inset, Height() - 2 * inset);
	    SetForeground(foreground);
	    DrawRectangle(inset, inset,
			  Width() - 2 * inset - 1, Height() - 2 * inset - 1);
	} else {
	    SetForeground(background);
	    FillRectangle(inset, inset,
			  Width() - 2 * inset, Height() - 2 * inset);
	    DrawRaisedChamfer(inset, inset, inset,
			       Width() - 2 * inset, Height() - 2 * inset);
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_BasicToggleButton::Toggle()
{   CVO_ENTER
    Cvo_ButtonEvent bev;
    bev.value = pressed ^= 1;

    SendEvent(pressed ? CvoButtonDownEvent : CvoButtonUpEvent, &bev);
    Update();
    CVO_VOID_RETURN
}

void
Cvo_BasicToggleButton::Update()
{   CVO_ENTER
    if (sunken = pressed) {
	SelectBackground();
    } else {
	NormalBackground();
    }
    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_BasicToggleButton::ForceOn()
{   CVO_ENTER
    if (pressed)
	CVO_VOID_RETURN

    Cvo_ButtonEvent bev;
    bev.value = pressed = 1;

    SendEvent(CvoButtonDownEvent, &bev);
    Update();
    CVO_VOID_RETURN
}

void
Cvo_BasicToggleButton::ForceOff()
{   CVO_ENTER
    if (!pressed)
	CVO_VOID_RETURN

    Cvo_ButtonEvent bev;
    bev.value = pressed = 0;

    SendEvent(CvoButtonUpEvent, &bev);
    Update();
    CVO_VOID_RETURN
}

void
Cvo_ToggleButton::_Init()
{   CVO_ENTER
    type = CvoT_ToggleButton;
    LoadFont();
    label = GetNewResource(_Qlabel, _QLabel, 0);
    Register(Expose, &Cvo_ToggleButton::ExposureHandler);
    CVO_VOID_RETURN
}

void
Cvo_ToggleButton::SetDefaultText(char *s)
{   CVO_ENTER
    if (!label) {
	label = new char[strlen(s)+1];
	strcpy(label, s);
    }
    CVO_VOID_RETURN
}

void
Cvo_ToggleButton::SetText(char *s)
{   CVO_ENTER
    delete [] label;
    label = new char[strlen(s)+1];
    strcpy(label, s);

    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_ToggleButton::Update()
{   CVO_ENTER
    if (sunken = pressed) {
	SelectBackground();
    } else {
	NormalBackground();
    }
    Redraw();
    CVO_VOID_RETURN
}

void
Cvo_ToggleButton::ExposureHandler(XEvent *, void *)
{   CVO_ENTER
    if (!label)
	CVO_VOID_RETURN

    XRectangle ink;
    XRectangle log;

    StringExtents(label, ink, log);

    int x = (width - int(log.width)) / 2;
    int y = (height - int(log.height)) / 2;

    SetGC(CurrentBackground(), CurrentForeground());
    DrawString(x, y, label);
    CVO_VOID_RETURN
}

CARD16
Cvo_ToggleButton::CalculateWidth()
{   CVO_ENTER

    if (!label)
	CVO_RETURN(0);

    XRectangle ink;
    XRectangle log;

    StringExtents(label, ink, log);
    CVO_RETURN(log.width)
}

CARD16
Cvo_ToggleButton::CalculateHeight()
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->MHeight())
}

void
Cvo_SquareToggleButton::_Init()
{   CVO_ENTER
    type = CvoT_SquareToggleButton;
    LoadFont();
    lab = 0;
    tog = new Cvo_SquareToggle("toggle", this);
    tog->AspectRatio(1,1);
    tog->SetGravity(Cvo_WEST);
    CVO_VOID_RETURN
}

void
Cvo_SquareToggleButton::Update()
{   CVO_ENTER
    if (pressed)
	tog->ForceOn();
    else
	tog->ForceOff();
    CVO_VOID_RETURN
}

void
Cvo_SquareToggleButton::SetText(char *s)
{   CVO_ENTER
    if (!lab) {
	lab = new Cvo_Label("label", this, s);
	lab->SetGravity(Cvo_WEST);
	lab->LeftJustify();
	lab->ExpandFrame();
	lab->LayOpposite();
	tog->SetMinPixelSize(lab->TextAttribute()->MHeight(),
			     lab->TextAttribute()->MHeight());
    } else
	lab->SetText(s);
    CVO_VOID_RETURN
}

void
Cvo_SquareToggleButton::SetText(wchar_t *s)
{   CVO_ENTER
    if (!lab) {
	lab = new Cvo_Label("label", this, s);
	lab->SetGravity(Cvo_WEST);
	lab->LeftJustify();
	lab->ExpandFrame();
	lab->LayOpposite();
    } else
	lab->SetText(s);
    CVO_VOID_RETURN
}
