//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: TextViewPort.cc,v 1.9 1994/09/23 16:43:18 prb Exp $"); }
#include <stdio.h>
#include <Cvo/Window.h++>
#include <Cvo/TextViewPort.h++>

static Cvo_Default defs[] = {
    "*CvoTextViewPort.BorderWidth: 0",
};

CONSTRUCTORS_1ARG(Cvo_TextViewPort, Cvo_ViewPort, "CvoTextViewPort", Cvo_Page *)
CONSTRUCTORS(Cvo_TextViewPort, Cvo_ViewPort, "CvoTextViewPort")

void
Cvo_TextViewPort::_Init(Cvo_Page *i)
{   CVO_ENTER
    type = CvoT_TextViewPort;

    hilites = NULL;
    lasthilite = NULL;
    lookAtScreenOnly = False;
    drawingscreen = False;

    text = new Cvo_CRT("text", upper);
    text->ExpandFrame();
    main = text;
    if (GetResourceTruth("verticalScrollBar", "ScrollBar", True)) {
	AddVertical();

	vertical->Register(CvoScrollBarEvent,
		     &Cvo_TextViewPort_ScrollVertical, this);
    }
    if (GetResourceTruth("horizontalScrollBar", "ScrollBar", True)) {
	AddHorizontal();

	horizontal->Register(CvoScrollBarEvent,
		     &Cvo_TextViewPort_ScrollHorizontal, this);
    }

    Register(CvoResizeEvent, &Cvo_TextViewPort_PageChanged, this);

    text->Register(CvoPageChangedEvent,
		 &Cvo_TextViewPort_PageChanged, this);

    text->Register(CvoTextChangedSizeEvent,
		 &Cvo_TextViewPort_TextChangedSize, this);

    Register(CvoMapRequestEvent, &Cvo_TextViewPort_MapRequest);

    if (page = i) {
	page->SetWindow(text);
	if (vertical)
	    vertical->SetMaximum(page->NumberLines());
    }
    firstline = 0;
    lastline = 0;
    lines = 0;
    jumptoend = 1;
    CVO_VOID_RETURN
}

void
Cvo_TextViewPort_MapRequest(Cvo_Object *obj, XEvent *, void *)
{   CVO_ENTER
    ((Cvo_TextViewPort *)obj)->EvaluateWidth();
    CVO_VOID_RETURN
}

void
Cvo_TextViewPort::_Create()
{   CVO_ENTER
    Cvo_ViewPort::_Create();
    Cvo_TextViewPort_PageChanged(0, 0, this);
    CVO_VOID_RETURN
}

void
Cvo_TextViewPort_ScrollHorizontal(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_TextViewPort *tp = (Cvo_TextViewPort *)data;

    tp->text->ChangeOrigin(se->value * tp->text->TextAttribute()->MWidth());
    tp->text->Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_TextViewPort_ScrollVertical(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_ScrollBarEvent *se = (Cvo_ScrollBarEvent *)ev;
    Cvo_TextViewPort *tp = (Cvo_TextViewPort *)data;

    if (tp->firstline == se->value) {
	for (int i = tp->firstline; i < tp->lastline; ++i) {
	    if (tp->page->Modified(i))
		break;
	}
    	if (i > tp->lastline)
	    CVO_VOID_RETURN
    }
    tp->GotoLine(se->value, True);
}

static inline int
positve(int z)
{
    return(z < 0 ? 0 : z);
}

//
// This routine is called when the something changes on the TextPage
//
void
Cvo_TextViewPort_PageChanged(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_TextViewPort *tp = (Cvo_TextViewPort *)data;
    Cvo_PageChangedEvent *pce = (Cvo_PageChangedEvent *)ev;
    Cvo_PageChangedEvent _pce;

    if (!tp->page)
	CVO_VOID_RETURN;

    if (!ev || ev->type != CvoPageChangedEvent) {
	pce = &_pce;
	pce->newlines = True;
	pce->changedlines = True;
	pce->removedlines = True;
    }

#if defined(__zbug)
    printf("Cvo_TextViewPort_PageChanged(%d%s%s%s) SZ = %d x %d CR = %d - %d\n",
	tp->page->NumberLines(),
	pce->newlines ? " NEW" : "",
        pce->changedlines ? " CHG" : "",
        pce->removedlines ? " RMV" : "",
    	tp->text->Rows(),
    	tp->text->Cols(),
    	tp->firstline, tp->lastline);
#endif

    //
    // GotoLine wont do this if lookAtScreenOnly is not set
    //
    if (!tp->lookAtScreenOnly) {
	tp->EvaluateWidth((pce->changedlines ||
			   pce->removedlines) ? 0 : tp->lines);
    }

    if (!tp->vertical) {
	tp->firstline = 0;
    } else if (tp->jumptoend
        || (pce->removedlines
	    && ((tp->page->NumberLines() > tp->text->Rows()) || tp->firstline)
	    && tp->firstline + tp->text->Rows() > tp->page->NumberLines())) {
	if (pce->newlines || pce->removedlines) {
	    //
	    // If the text changed content then we need to redisplay all.
	    //
	    if (pce->changedlines) {
		goto out;
	    } else if (tp->page->NumberLines() <= tp->text->Rows()) {
		goto out;		// Wow, a goto!!!
	    }
	    if (tp->lines == 0 && tp->firstline < 0) {
		tp->lines = tp->page->NumberLines();
		tp->firstline = 0;
		tp->vertical->SetCurrent(0);
	    } else {
		tp->lines = tp->page->NumberLines();
#if defined(__zbug)
		printf("setting sb to (%d - %d, %d, %d)\n",
				0, tp->page->NumberLines(),
				positve(tp->lines - tp->text->Rows()),
				tp->lastline - tp->firstline);
#endif
		tp->vertical->SetValues(0, tp->page->NumberLines(),
					positve(tp->lines - tp->text->Rows()),
					tp->lastline - tp->firstline);
	    }
	    CVO_VOID_RETURN
	}
    }
    out:
#if defined(__zbug)
    printf("On the outs\n");
#endif

    if (tp->firstline < 0)
	tp->firstline = 0;
    int from = tp->firstline;

    if (!pce->changedlines && !pce->removedlines && from < tp->lines)
	from = tp->lines;

    tp->lines = tp->page->NumberLines();

#if defined(__zbug)
    printf("Want to start with line %d (<= %d)\n", from, tp->lastline);
#endif
    Cvo_CharacterBuffer cb;

    if (from <= tp->lastline) {
	while ((from < tp->lastline && !pce->removedlines
				    && !pce->newlines
				    && tp->page->Modified(from) == False)
	     || tp->RedrawLine(from, cb))
	    ++from;
	tp->lastline = from;
    }

    //
    // Now go through and clear out the extra lines at the end of the page
    //
    from -= tp->firstline;
    while (from < tp->text->Rows()) {
	tp->RedrawLine(from, cb);
	    ++from;
    }

    if (tp->vertical) {
#if defined(__zbug)
    	printf("Setting sb to (%d - %d, %d, %d)\n",
				0, tp->page->NumberLines(),
				tp->firstline,
				tp->lastline - tp->firstline);
#endif
	tp->vertical->SetValues(0, tp->page->NumberLines(),
				tp->firstline,
				tp->lastline - tp->firstline);
    }

    tp->text->Flush(2);
    CVO_VOID_RETURN
}

//
// This routine is called with the number of lines/columns on the Screen
// change
void
Cvo_TextViewPort_TextChangedSize(Cvo_Object *, XEvent *ev, void *data)
{   CVO_ENTER
    Cvo_TextViewPort *tp = (Cvo_TextViewPort *)data;
    Cvo_TextChangedSizeEvent *tcse = (Cvo_TextChangedSizeEvent *)ev;

    if (tp->drawingscreen)
	return;

    if (tp->horizontal)
	tp->horizontal->SetVisible(tcse->width);

    Cvo_CharacterBuffer cb;

    int from = tp->lastline;

    while (from > 0 && !tp->RedrawLine(from, cb))
	--from;
    while (tp->RedrawLine(from, cb))
	from++;
    tp->lastline = from;
    if (tp->vertical) {
	if (tp->vertical->GetVisible() != from - tp->firstline)
	    tp->vertical->SetVisible(from - tp->firstline);
    }
    CVO_VOID_RETURN
}

BOOL
Cvo_TextViewPort::RedrawLine(unsigned x, Cvo_CharacterBuffer &cb)
{   CVO_ENTER
    if (!page)
	CVO_RETURN(False)
    void *data = page->GetLine(x, &cb);
    Cvo_TextAttribute *at;
    Cvo_TextAttribute **ats;


#if defined(___zbug)
    printf("Redraw line %d at row %d\n", x, x - firstline);
#endif
    text->FlattenLine(x - firstline);
    text->DeleteAt(x - firstline, 0, -1);
    if (!data)
	CVO_RETURN(False)
    if (!(ats = page->GetAttributes(x)) &&
	!(at = page->GetAttribute(x))) {
	    at = text->TextAttribute();
    }
    if (ats) {
	if (!text->WillFit(x - firstline, ats, cb.wcLength()))
	    CVO_RETURN(False)
	text->AppendTo(x - firstline, cb.wcValue(), ats, cb.wcLength());
    } else {
	if (!text->WillFit(x - firstline, at))
	    CVO_RETURN(False)
	text->SetState(at);
	text->AppendTo(x - firstline, cb.mbValue());
    }

    switch (Special(x)) {
    case CvoTVP_RAISED:
	text->RaiseLine(x - firstline);
	break;
    }
    CVO_RETURN(True)
}

BOOL
Cvo_TextViewPort::WillLineFit(unsigned x, Cvo_CharacterBuffer &cb)
{   CVO_ENTER
    if (!page)
	CVO_RETURN(False)
    void *data = page->GetLine(x, &cb);
    Cvo_TextAttribute *at;
    Cvo_TextAttribute **ats;

    if (!data)
	CVO_RETURN(False)

    if (!(ats = page->GetAttributes(x)) &&
	!(at = page->GetAttribute(x)))
	    at = text->TextAttribute();
    if (ats) {
	if (!text->WillFit(x - firstline, ats, cb.wcLength()))
	    CVO_RETURN(False)
    } else {
	if (!text->WillFit(x - firstline, at))
	    CVO_RETURN(False)
    }

    CVO_RETURN(True)
}

void
Cvo_TextViewPort::EvaluateWidth(int from)
{   CVO_ENTER
    if (!page || !horizontal)
	CVO_VOID_RETURN
    int mwidth = 0;
    int s = 0;
    int e = page ? page->NumberLines() : 0;

    if (lookAtScreenOnly) {
	s = firstline;
	if (lastline < e)
	    e = lastline;
    } else if (s = from)
	mwidth = horizontal->GetMaximum() * text->TextAttribute()->MWidth();

    Cvo_CharacterBuffer cb;

    for (int x = s; x < e; ++x) {
	void *data = page->GetLine(x, &cb);
	wchar_t *s = cb.wcValue();
	int w = text->StringWidth(s);
	//
	// XXX - MAJOR MAJOR KLUDGE
	//
	while (*s)
	    if (*s++ == '\t')
		w += 8 * text->TextAttribute()->MWidth();
	if (w > mwidth)
	    mwidth = w;
    }
    mwidth += text->TextAttribute()->MWidth() - 1;
    mwidth /= text->TextAttribute()->MWidth();
    if (mwidth != horizontal->GetMaximum())
	horizontal->SetMaximum(mwidth);
    CVO_VOID_RETURN
}

int
Cvo_TextViewPort::StringWidth(char *s, int n)
{   CVO_ENTER
    CVO_RETURN(text->StringWidth(s,n))
}

int
Cvo_TextViewPort::StringWidth(wchar_t *s, int n)
{   CVO_ENTER
    CVO_RETURN(text->StringWidth(s,n))
}

void
Cvo_TextViewPort::MoveCursor(int r, int c)
{
    if (r < 0)
	r = 0;

    if (r >= page->NumberLines())
	r = page->NumberLines() - 1;

    if (c < 0)
	c = 0;

    if (r < firstline) {
	GotoLine(r);
    } else if (r >= lastline) {
	GotoLine(firstline + r - lastline);
	while (r >= lastline) {
	    int olf = firstline;
	    GotoLine(firstline + 1);
	    if (olf == firstline)
		break;
	}
    }

    //
    // XXX - This code is not right, it assumes a fixed width font.
    //

    if (horizontal) {
	int off = horizontal->GetCurrent();
	if (off > c)
	    horizontal->SetCurrent(c);
	else if (c - off >= text->Cols())
	    horizontal->SetCurrent(c + 1 - text->Cols());
    }

    text->MoveCursor(r - firstline, c);
}

void
Cvo_TextViewPort::GotoLine(int newfirst, BOOL fromscroll)
{   CVO_ENTER

    if (!page || !vertical)
	CVO_VOID_RETURN

    //
    // XXX - I don't think this is correct, what if one of the lines at the
    // end is bigger...
    //
    if (newfirst > page->NumberLines() - text->Rows())
	newfirst = page->NumberLines() - text->Rows();
    if (newfirst < 0)
	newfirst = 0;

    if (firstline == newfirst)
	return;

    int newlast = newfirst + text->Rows();

    drawingscreen = True;

    Cvo_CharacterBuffer cb;

    if (firstline < 0 || lastline < newfirst || firstline > newlast) {
	if (text->Object())
	    text->ClearWindow();

	firstline = newfirst;

	while (RedrawLine(newfirst, cb))
	    ++newfirst;
	lastline = newfirst;
    } else if (firstline < newfirst) {
	text->DeleteLine(0, newfirst - firstline);

	firstline = newfirst;

	while (RedrawLine(lastline, cb))
	    ++lastline;
    } else {
	text->InsertLine(0, firstline - newfirst);

	int oldfirst = firstline;
	firstline = newfirst;
	newlast = newfirst;

	while (newlast <= oldfirst && RedrawLine(newlast, cb))
	    ++newlast;
	lastline = firstline + text->Rows();

    	while (newlast < lastline) {
	    if (page->Modified(newlast)) {
		RedrawLine(newlast, cb);
    	    }
	    ++newlast;
    	}

	while (lastline > 0 && !WillLineFit(lastline-1, cb))
	    --lastline;
    }

    if (lookAtScreenOnly)
	EvaluateWidth();


    drawingscreen = False;

    if (!fromscroll)
	vertical->SetCurrent(firstline);	// set the scrollbar correctly

    if (vertical->GetVisible() != lastline - firstline)
	vertical->SetVisible(lastline - firstline);

    text->Flush(2);
    CVO_VOID_RETURN
}

int
Cvo_TextViewPort::Special(int)
{   CVO_ENTER
    CVO_RETURN(0)
}
