//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: TextAttribute.cc,v 1.6 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Pixmap.h++>
#include <string.h>

Cvo_TextAttribute::Cvo_TextAttribute(Cvo_TextAttribute **root,
				     Cvo_Window *d,
				     const Cvo_Font &f)
              : Cvo_RootedList((Cvo_RootedList **)root)
{   CVO_ENTER
    font = f;
    drawable = d;
    foreground = d->CurrentForeground();
    background = d->CurrentBackground();
    secondary = False;
    underline = False;
    underlineat = 0;
    enbolden = False;
    iswindow = True;
    gc = 0;

    reverse = new Cvo_TextAttribute(0, this);
    CVO_VOID_RETURN
}

Cvo_TextAttribute::Cvo_TextAttribute(Cvo_TextAttribute **root,
				     Cvo_Pixmap *d,
				     const Cvo_Font &f)
              : Cvo_RootedList((Cvo_RootedList **)root)
{   CVO_ENTER
    font = f;
    drawable = d;
    foreground = d->CurrentForeground();
    background = d->CurrentBackground();
    secondary = False;
    underline = False;
    underlineat = 0;
    enbolden = False;
    iswindow = False;
    gc = 0;

    reverse = new Cvo_TextAttribute(0, this);
    CVO_VOID_RETURN
}

Cvo_TextAttribute::Cvo_TextAttribute(Cvo_TextAttribute **root,
				     Cvo_TextAttribute *old)
              : Cvo_RootedList((Cvo_RootedList **)root)
{   CVO_ENTER
    reverse = old;

    font = reverse->font;
    drawable = reverse->drawable;
    foreground = root ? reverse->foreground : reverse->background;
    background = root ? reverse->background : reverse->foreground;
    secondary = root ? False : True;
    underline = reverse->underline;
    underlineat = reverse->underlineat;
    enbolden = reverse->enbolden;
    iswindow = reverse->iswindow;
    if (root)
	reverse = new Cvo_TextAttribute(0, this);
    gc = 0;
    CVO_VOID_RETURN
}

Cvo_TextAttribute *
Cvo_TextAttribute::Unsensitive()
{   CVO_ENTER
    Cvo_Window *win = drawable->ToWindow();
    Cvo_Pixmap *pix = (Cvo_Pixmap *)drawable;
    Cvo_TextAttribute *ta = win ? win->TextAttribute() : pix->TextAttribute();

    while (ta) {
	Cvo_TextAttribute *a = ta;
	if (secondary)
	    a = a->reverse;
	if (a->foreground == foreground->Grayed() &&
	    a->background == background &&
	    a->enbolden == enbolden &&
	    a->font == font &&
	    a->underline == underline)
		CVO_RETURN(a)
	ta = ta->Next();
    }

    ta = win ? win->NewTextAttribute() : pix->NewTextAttribute();
    ta->SetForeground(foreground->Grayed());
    ta->SetBackground(background);
    ta->SetFont(font);
    ta->Underline(underline);
    ta->Enbolden(enbolden);
    ta->SetUnderlineAt(underlineat);
    CVO_RETURN(ta)
}

Cvo_TextAttribute *
Cvo_TextAttribute::NukeLink()
{
    Cvo_TextAttribute *m = secondary ? reverse : this;
    Cvo_TextAttribute **r;
    if (m && m->drawable) {
	if (m->iswindow) {
	    r = &((Cvo_Window *)(m->drawable))->textAttributes;
	} else {
	    r = &((Cvo_Pixmap *)(m->drawable))->textAttribute;
	}
	m->Unlink((Cvo_RootedList **)r);
    }
    return(m);
}


void
Cvo_TextAttribute::ResetDrawable(Cvo_Window *w)
{   CVO_ENTER
    Cvo_TextAttribute *m = NukeLink();
    drawable = w;
    iswindow = True;
    reverse->drawable = w;
    reverse->iswindow = True;
    m->Insert((Cvo_RootedList **)&((Cvo_Window *)drawable)->textAttributes);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::ResetDrawable(Cvo_Pixmap *w)
{   CVO_ENTER
    Cvo_TextAttribute *m = NukeLink();

    drawable = w;
    iswindow = False;
    reverse->drawable = w;
    reverse->iswindow = False;
    m->Insert((Cvo_RootedList **)&((Cvo_Pixmap *)drawable)->textAttribute);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::_SetGC()
{   CVO_ENTER
    long mask = GCForeground | GCBackground | GCFillStyle | GCFunction;
    XGCValues xgcv;

    xgcv.fill_style = FillSolid;
    xgcv.function = GXcopy;

    Cvo_Color cfg;
    Cvo_Color cbg;

    if (iswindow) {
	cfg = drawable->ToWindow()->CurrentForeground();
	cbg = drawable->ToWindow()->CurrentBackground();
    } else {
	cfg = ((Cvo_Pixmap *)drawable)->CurrentForeground();
	cbg = ((Cvo_Pixmap *)drawable)->CurrentBackground();
    }

    if (foreground.Empty()) {
	if (reverse->background.Full())
	    foreground = reverse->background;
	else if (secondary)
	    foreground = cbg;
	else
	    foreground = cfg;
    }

    if (background.Empty()) {
	if (reverse->foreground.Full())
	    background = reverse->foreground;
	else if (secondary)
	    background = cfg;
	else
	    background = cbg;
    }

    xgcv.foreground = foreground->Pixel();
    xgcv.background = background->Pixel();

    if (foreground->UsePixmap()) {
	xgcv.stipple = foreground->GetPixmap(1);
	xgcv.fill_style = FillOpaqueStippled;
	mask |= GCStipple;
    }

    if (background->UsePixmap() && xgcv.foreground == xgcv.background) {
	//
	// XXX - hack hack hack
	// This is more than likely wrong, but I am not sure what else to
	// do at this point.  I am worried about solid black boxes for
	// letters when using monochrome.  I guess an option would be to
	// manual clear the place we are going to write and then use DrawString
	// instead of DrawImageString...
	//
	if (xgcv.background == drawable->White())
	    xgcv.background = drawable->Black();
	else
	    xgcv.background = drawable->White();
    }

    if (gc)
	XChangeGC(drawable->Dpy(), gc, mask, &xgcv);
    else
	gc = XCreateGC(drawable->Dpy(), drawable->Object(), mask, &xgcv);
    CVO_VOID_RETURN
}

Cvo_TextAttribute::~Cvo_TextAttribute()
{   CVO_ENTER
    NukeLink();
    if (gc)
	XFreeGC(drawable->Dpy(), gc);
    if (reverse) {
	reverse->reverse = 0;
	delete reverse;
	reverse = 0;
    }
    CVO_DONE
}

void
Cvo_TextAttribute::DrawStrings(int mode,
			int x, int y, int width, int height,
			char *str, int len)
{   CVO_ENTER
    char *e = str;
    char *p = str;
    int py, px;

    XRectangle ink;
    XRectangle log;

    e = str + StringsExtents(str, len, log);

    py = y + (height - int(log.height)) / 2;	// This could be negative...

    p = str;

    while (p < e) {
	char *pe = p;
	while (*pe != '\n' && pe < e)
	    ++pe;
	if (p == pe) {
	    py += font->MHeight();
	} else {
	    Extents(p, pe - p, ink, log);
	    switch (mode) {
	    case Cvo_LEFT_JUSTIFY:
		px = x;
		break;
	    case Cvo_RIGHT_JUSTIFY:
		px = x + width - int(log.width);
		break;
	    default:
		px = x + (width - int(log.width)) / 2;
		break;
	    }
	    Draw(px, py, p, pe - p);
	    py += log.height;
	}
	p = pe + 1;
    }
    CVO_VOID_RETURN
}

int
Cvo_TextAttribute::StringsExtents(char *s, int len, XRectangle &log)
{   CVO_ENTER
    char *e;
    char *p = s;

    if (len < 0)
	len = strlen(s);
    e = s + len;
    log.x = 0;
    log.y = 0;
    log.width = 0;
    log.height = 0;

    XRectangle tink;
    XRectangle tlog;

    while (p < e) {
	char *pe = p;
	while (*pe != '\n' && pe < e)
	    ++pe;
	if (p == pe) {
	    log.height += font->MHeight();
	} else {
	    Extents(p, pe - p, tink, tlog);
	    log.height += tlog.height;

	    if (log.x > tlog.x)
		    log.x = tlog.x;
	    if (log.y > tlog.y)
		    log.y = tlog.y;
	    if (log.width < tlog.width)
		log.width = tlog.width;
	}
	p = pe + 1;
    }
    CVO_RETURN(e - s)
}

void
Cvo_TextAttribute::DrawStrings(int mode,
			int x, int y, int width, int height,
			wchar_t *str, int len)
{   CVO_ENTER
    wchar_t *e = str;
    wchar_t *p = str;
    int py, px;

    XRectangle ink;
    XRectangle log;

    e = str + StringsExtents(str, len, log);

    py = y + (height - int(log.height)) / 2;	// This could be negative...

    p = str;

    while (p < e) {
	wchar_t *pe = p;
	while (*pe != '\n' && pe < e)
	    ++pe;
	if (p == pe) {
	    py += font->MHeight();
	} else {
	    Extents(p, pe - p, ink, log);
	    switch (mode) {
	    case Cvo_LEFT_JUSTIFY:
		px = x;
		break;
	    case Cvo_RIGHT_JUSTIFY:
		px = x + width - int(log.width);
		break;
	    default:
		px = x + (width - int(log.width)) / 2;
		break;
	    }
	    Draw(px, py, p, pe - p);
	    py += log.height;
	}
	p = pe + 1;
    }
    CVO_VOID_RETURN
}

int
Cvo_TextAttribute::StringsExtents(wchar_t *s, int len, XRectangle &log)
{   CVO_ENTER
    wchar_t *e;
    wchar_t *p = s;

    if (len < 0) {
	len = 0;
	while (s[len])
	    ++len;
    }
    e = s + len;
    log.x = 0;
    log.y = 0;
    log.width = 0;
    log.height = 0;

    XRectangle tink;
    XRectangle tlog;

    while (p < e) {
	wchar_t *pe = p;
	while (*pe != '\n' && pe < e)
	    ++pe;
	if (p == pe) {
	    log.height += font->MHeight();
	} else {
	    Extents(p, pe - p, tink, tlog);
	    log.height += tlog.height;

	    if (log.x > tlog.x)
		    log.x = tlog.x;
	    if (log.y > tlog.y)
		    log.y = tlog.y;
	    if (log.width < tlog.width)
		log.width = tlog.width;
	}
	p = pe + 1;
    }
    CVO_RETURN(e - s)
}

void
Cvo_TextAttribute::Draw(int x, int y, char *str, int len)
{   CVO_ENTER
    if (!str || !drawable->Object() || !SetGC())
	CVO_VOID_RETURN

    if (iswindow)
	drawable->ToWindow()->ToXCoord(&x, &y);

    if (len == -1)
	    len = strlen(str);
    y += font->Ascent() - 1;
    if (font->font) {
	XSetFont(drawable->Dpy(), gc, font->font->fid);
	XDrawString(drawable->Dpy(), drawable->Object(), gc, x, y, str, len);
	if (enbolden)
	    XDrawString(drawable->Dpy(), drawable->Object(),
			  gc, x+1, y, str, len);
    }
#if !defined(X11R4)
    else {
	XmbDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
		      gc, x, y, str, len);
	if (enbolden)
	    XmbDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
			  gc, x+1, y, str, len);
    }
#endif
    if (underline) {
	int nx = x + StringWidth(str, len);
	y += (underlineat ? underlineat : font->Height()) - 1;
	y -= font->Ascent();
	XDrawLine(drawable->Dpy(), drawable->Object(), gc, x, y, nx, y);
    }
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Image(int x, int y, char *str, int len)
{   CVO_ENTER
    if (!str || !drawable->Object() || !SetGC())
	CVO_VOID_RETURN

    if (iswindow)
	drawable->ToWindow()->ToXCoord(&x, &y);

    if (len == -1)
	    len = strlen(str);
    y += font->Ascent() - 1;
    if (font->font) {
	XSetFont(drawable->Dpy(), gc, font->font->fid);
	XDrawImageString(drawable->Dpy(), drawable->Object(),
			 gc, x, y, str, len);
	if (enbolden)
	    XDrawString(drawable->Dpy(), drawable->Object(),
			gc, x+1, y, str, len);
    }
#if !defined(X11R4)
    else {
    	if (foreground->UsePixmap()) {
	    int w = StringWidth(str, len);
	    GC g;
	    if (iswindow) {
		drawable->ToWindow()->SetForeground(background);
		g = drawable->ToWindow()->Gc();
	    } else {
		drawable->ToPixmap()->SetForeground(background);
		g = drawable->ToPixmap()->Gc();
	    }

	    XFillRectangle(drawable->Dpy(), drawable->Object(), g,
			x, y - font->Height() + 1, w, font->Height());
	    XmbDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
			gc, x, y, str, len);
    	} else
	    XmbDrawImageString(drawable->Dpy(), drawable->Object(),
		font->fontset, gc, x, y, str, len);

	if (enbolden)
	    XmbDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
			  gc, x+1, y, str, len);
    }
#endif
    if (underline) {
	int nx = x + StringWidth(str, len);
	y += (underlineat ? underlineat : font->Height()) - 1;
	y -= font->Ascent();
	XDrawLine(drawable->Dpy(), drawable->Object(), gc, x, y, nx, y);
    }
    CVO_VOID_RETURN
}

int
Cvo_TextAttribute::StringWidth(char *str, int len)
{   CVO_ENTER
    if (!str)
	CVO_RETURN(0)

    if (len == -1)
	len = strlen(str);

    Cvo_Lock lock;
    if (font->font)
	len = XTextWidth(font->font, str, len);
#if !defined(X11R4)
    else
	len = XmbTextEscapement(font->fontset, str, len);
#endif
    CVO_RETURN(len)
}

static Cvo_CharacterBuffer char_buf;	// XXX -- ugh

void
Cvo_TextAttribute::Draw(int x, int y, wchar_t *str, int len)
{   CVO_ENTER
    if (!str || !drawable->Object() || !SetGC())
	CVO_VOID_RETURN

    if (font->font) {
	char_buf.Set(str, len);
	Draw(x, y, char_buf.mbValue(), char_buf.mbLength());
	CVO_VOID_RETURN
    }

#if !defined(X11R4)
    if (iswindow)
	drawable->ToWindow()->ToXCoord(&x, &y);

    if (len == -1)
	for (len = 0; str[len]; ++len)
		;
    y += font->Ascent() - 1;
    XwcDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
		  gc, x, y, str, len);
    if (enbolden)
	XwcDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
		      gc, x+1, y, str, len);
    if (underline) {
	int nx = x + StringWidth(str, len);
	y += (underlineat ? underlineat : font->Height()) - 1;
	y -= font->Ascent();
	XDrawLine(drawable->Dpy(), drawable->Object(), gc, x, y, nx, y);
    }
#endif
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Image(int x, int y, wchar_t *str, int len)
{   CVO_ENTER
    if (!str || !drawable->Object() || !SetGC())
	CVO_VOID_RETURN

    if (font->font) {
	char_buf.Set(str, len);
	Image(x, y, char_buf.mbValue(), char_buf.mbLength());
	CVO_VOID_RETURN
    }

#if !defined(X11R4)
    if (iswindow)
	drawable->ToWindow()->ToXCoord(&x, &y);

    if (len == -1)
	for (len = 0; str[len]; ++len)
		;
    y += font->Ascent() - 1;

    if (foreground->UsePixmap()) {
	int w = StringWidth(str, len);
    	GC g;
    	if (iswindow) {
	    drawable->ToWindow()->SetForeground(background);
	    g = drawable->ToWindow()->Gc();
    	} else {
	    drawable->ToPixmap()->SetForeground(background);
	    g = drawable->ToPixmap()->Gc();
    	}

    	XFillRectangle(drawable->Dpy(), drawable->Object(), g,
		    x, y - font->Height() + 1, w, font->Height());
	XwcDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
		    gc, x, y, str, len);
    } else
	XwcDrawImageString(drawable->Dpy(), drawable->Object(), font->fontset,
		    gc, x, y, str, len);
    if (enbolden)
	XwcDrawString(drawable->Dpy(), drawable->Object(), font->fontset,
		gc, x+1, y, str, len);
    if (underline) {
	int nx = x + StringWidth(str, len);
	y += (underlineat ? underlineat : font->Height()) - 1;
	y -= font->Ascent();
	XDrawLine(drawable->Dpy(), drawable->Object(), gc, x, y, nx, y);
    }
#endif
    CVO_VOID_RETURN
}

int
Cvo_TextAttribute::StringWidth(wchar_t *str, int len)
{   CVO_ENTER
    if (!str)
        CVO_RETURN(0)

    if (font->font) {
	char_buf.Set(str, len);
	CVO_RETURN(StringWidth(char_buf.mbValue(), char_buf.mbLength()))
    }
#if !defined(X11R4)
    if (len == -1)
        for (len = 0; str[len]; ++len)
                ;

    Cvo_Lock lock;
    len = XwcTextEscapement(font->fontset, str, len);
    CVO_RETURN(len)
#else
    return(0);
#endif
}

void
Cvo_TextAttribute::Extents(char *str, XRectangle &ink)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    XRectangle log;
    Extents(str, strlen(str), ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(char *str, XRectangle &ink, XRectangle &log)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    Extents(str, strlen(str), ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(char *str, int len, XRectangle &ink)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    XRectangle log;
    Extents(str, len, ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(char *str, int len, XRectangle &ink, XRectangle &log)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    Cvo_Lock lock;
    if (font->font) {
	int dir, asc, des;
	XCharStruct over;

	XTextExtents(font->font, str, len, &dir, &asc, &des, &over);
	ink.x = -over.lbearing;
	ink.y = -over.ascent;
	ink.width = over.width;
	ink.height = over.ascent + over.descent;
	log = ink;
	log.height = font->font->ascent + font->font->descent;
    }
#if !defined(X11R4)
    else
	XmbTextExtents(font->fontset, str, len, &ink, &log);
#endif
CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(wchar_t *str, XRectangle &ink)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    XRectangle log;
    for (int len = 0; str[len]; ++len)
	;
    Extents(str, len, ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(wchar_t *str, XRectangle &ink, XRectangle &log)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    for (int len = 0; str[len]; ++len)
	;
    Extents(str, len, ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(wchar_t *str, int len, XRectangle &ink)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    XRectangle log;
    Extents(str, len, ink, log);
    CVO_VOID_RETURN
}

void
Cvo_TextAttribute::Extents(wchar_t *str, int len, XRectangle &ink, XRectangle &log)
{   CVO_ENTER
    if (!str)
	CVO_VOID_RETURN
    Cvo_Lock lock;
    if (font->font) {
	char_buf.Set(str, len);
	Extents(char_buf.mbValue(), len, ink, log);
    }
#if !defined(X11R4)
    else
	XwcTextExtents(font->fontset, str, len, &ink, &log);
#endif
    CVO_VOID_RETURN
}

int Cvo_TextAttribute::StringHeight(char *, int)
{   CVO_ENTER
    // XXX -- This functions should look at its arguments...
    CVO_RETURN(font->Height())
}
int Cvo_TextAttribute::StringHeight(wchar_t *, int)
{   CVO_ENTER
    // XXX -- This functions should look at its arguments...
    CVO_RETURN(font->Height())
}

void
Cvo_TextAttribute::ModifyGC(const Cvo_Color &b, const Cvo_Color &f)
{   CVO_ENTER
    foreground = f;
    reverse->background = f;

    background = b;
    reverse->foreground = b;
    if (gc || reverse->gc) {
	_SetGC();
	reverse->_SetGC();
    }
    CVO_VOID_RETURN
}
   
void 
Cvo_TextAttribute::SetClipOrigin(int x, int y)
{
    if (!drawable->Object() || !SetGC())
	CVO_VOID_RETURN
    if (drawable->ToLayoutWindow())
	drawable->ToLayoutWindow()->ToXCoord(&x, &y);
    XSetClipOrigin(drawable->Dpy(), gc, x, y);
}

void
Cvo_TextAttribute::SetClipRectangles(int x, int y, const XRectangle rect[], int n, int o)
{
    if (!drawable->Object() || !SetGC())
	CVO_VOID_RETURN
    if (drawable->ToLayoutWindow())
	drawable->ToLayoutWindow()->ToXCoord(&x, &y);
    XSetClipRectangles(drawable->Dpy(), gc, x, y, (XRectangle *)rect, n, o);
}

void
Cvo_TextAttribute::SetTSOrigin(int x, int y)
{
    if (!drawable->Object() || !SetGC())
	CVO_VOID_RETURN
   if (drawable->ToLayoutWindow())
	drawable->ToLayoutWindow()->ToXCoord(&x, &y);
    XSetTSOrigin(drawable->Dpy(), gc, x, y);
}
