//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: StandardLayout.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>

int
Cvo_LayoutWindow::StandardLayoutFunction(int force, int child, int w, int h)
{   CVO_ENTER
    if (force == -1)
	CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)

    //
    // If we have been called from outside the layout manager, we will
    // have to compute the layout sizes for our children.
    //
    if (!child)
	ComputeLayoutSize(force);

    //
    // First things first, if we are supposed to align up on one of the
    // two axis, move us there.  This feature must be used with caution
    // as it invalidates some of the automatic layout stuff.
    //

    if (layout.matchX) {
	int x = 0; int y = 0;
	layout.matchX->ComputeOriginAtRoot(&x, &y);
	Parent()->ComputeOriginFromRoot(&x, &y);
	layout.x = x;
    }
    if (layout.matchY) {
	int x = 0; int y = 0;
	layout.matchY->ComputeOriginAtRoot(&x, &y);
	Parent()->ComputeOriginFromRoot(&x, &y);
	layout.y = y;
    }
    if (layout.matchX && layout.matchY)
	layout.dontposition = True;

    //
    // Figure out how much space we will use.  Never use more than the maximum
    // amount, but use up to the max if we can.  Note that FillFrame() will
    // (no longer) override the maximum size of the object.
    // Once the space has been determined, use gravity to determine where the
    // window should go.
    //
    int nw = w;
    int nh = h;

    int minW = horizontalPad ? 0 : 1;
    int minH = verticalPad ? 0 : 1;

    if (!layout.dontresize) {
	nw = layout.fillw ? w
			  : layout.maximum.width
			  ? layout.maximum.width
			  : layout.desired.width;

	nh = layout.fillh ? h
			  : layout.maximum.height
			  ? layout.maximum.height
			  : layout.desired.height;

	if (nw < int(layout.minimum.width))
		nw = layout.minimum.width;
	if (nh < int(layout.minimum.height))
		nh = layout.minimum.height;

	if (layout.maximum.width && nw > int(layout.maximum.width))
	    nw = layout.maximum.width;
	if (layout.maximum.height && nh > int(layout.maximum.height))
	    nh = layout.maximum.height;

	if (w && nw > w)
	    nw = w;
	if (h && nh > h)
	    nh = h;

	if (layout.matchWidth)
	    nw = layout.matchWidth->XWidth();
	if (layout.matchHeight)
	    nh = layout.matchHeight->XHeight();

	if (layout.vaspect && layout.haspect) {
	    if (nw * int(layout.vaspect) > nh * int(layout.haspect)) {
		nw = nh * int(layout.haspect) / int(layout.vaspect);
	    } else {
		nh = nw * int(layout.vaspect) / int(layout.haspect);
	    }
	    if (nw < 1)
		nw = 1;
	    if (nh < 1)
		nh = 1;
	}
    }

    if (!layout.dontposition) {
	switch (layout.gravity) {
	default:
	case Cvo_CENTER:
	case Cvo_NORTH|Cvo_SOUTH:
	case Cvo_EAST|Cvo_WEST:
	case Cvo_NORTH|Cvo_SOUTH|Cvo_EAST|Cvo_WEST:
	    if (!layout.matchX)
		layout.x += (w - nw) / 2;
	    if (!layout.matchY)
		layout.y += (h - nh) / 2;
	    break;
	case Cvo_NORTH:
	case Cvo_NORTH|Cvo_EAST|Cvo_WEST:
	    if (!layout.matchX)
		layout.x += (w - nw) / 2;
	    break;
	case Cvo_SOUTH:
	case Cvo_SOUTH|Cvo_EAST|Cvo_WEST:
	    if (!layout.matchX)
		layout.x += (w - nw) / 2;
	    if (!layout.matchY)
		layout.y += (h - nh);
	    break;
	case Cvo_EAST:
	case Cvo_EAST|Cvo_NORTH|Cvo_SOUTH:
	    if (!layout.matchX)
		layout.x += (w - nw);
	    if (!layout.matchY)
		layout.y += (h - nh) / 2;
	    break;
	case Cvo_WEST:
	case Cvo_WEST|Cvo_NORTH|Cvo_SOUTH:
	    if (!layout.matchY)
		layout.y += (h - nh) / 2;
	    break;
	case Cvo_NORTHEAST:
	    if (!layout.matchX)
		layout.x += (w - nw);
	    break;
	case Cvo_NORTHWEST:
	    break;
	case Cvo_SOUTHEAST:
	    if (!layout.matchX)
		layout.x += (w - nw);
	    if (!layout.matchY)
		layout.y += (h - nh);
	    break;
	case Cvo_SOUTHWEST:
	    if (!layout.matchY)
		layout.y += (h - nh);
	    break;
	}
    }

    w = nw;
    h = nh;

    //
    // Strange sort of thing here, if we are not a "child" then we should
    // not be adjusting our x and y as it was done once before.  This is
    // the case when someone just called ReLayout() to fix up its own
    // children.
    //
    if (child && !layout.dontposition) {
	if (!layout.matchX)
	    layout.x += horizontalPad + borderWidth;
	if (!layout.matchY)
	    layout.y += verticalPad + borderWidth;
    }

    int rs = layout.ignoreshadow ? 0 : raise;

    if (!layout.dontresize) {
	w -= 2 * (borderWidth + horizontalPad) + rs;
	h -= 2 * (borderWidth + verticalPad) + rs;

	if (w < minW)
	    w = minW;
	if (h < minH)
	    h = minH;

	if (layout.vaspect && layout.haspect) {
	    if (w * int(layout.vaspect) > h * int(layout.haspect)) {
		w = h * int(layout.haspect) / int(layout.vaspect);
	    } else {
		h = w * int(layout.vaspect) / int(layout.haspect);
	    }
	    if (w < 1)
		w = 1;
	    if (h < 1)
		h = 1;
	}
    }

    if (width != w || height != h || layout.x != position.x
				  || layout.y != position.y) {
	MoveResizeWindow(layout.x, layout.y, w, h, Cvo_LAYOUTTAG);
    }

    // Okay, now we are ready to call the function to layout our children.
    // Our size has been fixed, as it alway must be prior to calling
    // the LayoutChildren method.
    //
    for (int o = 0; o < Cvo_NOVERLAYS; ++o)
	LayoutChildren(force, o);
    CVO_RETURN(CvoL_FOREWARD|CvoL_BACKWARD)
}

void
Cvo_LayoutWindow::StandardLayoutChildren(int force, int olay)
{   CVO_ENTER
    if (!children) {
	CVO_VOID_RETURN
    }

    Cvo_Object *obj = children;

    CARD32 ecnt = 0;

    //
    // First count up how many children and how many will expand
    //
    int havechildren = 0;
    while (obj) {
        Cvo_LayoutWindow *win = obj->ToLayoutWindow();
        if (win && win->layout.overlay == olay) {
            if (win->LayoutForeward()) {
                ++havechildren;
                ecnt += win->layout.expand;
            }
        }
        obj = obj->Sibling();
    }

    if (!havechildren) {
	CVO_VOID_RETURN
    }

    //
    // Now go down and figure out how much space the children want
    //
    Cvo_FrameSize min, des;

    min.width =  2 * layout.horizontalPad;
    min.height = 2 * layout.verticalPad;
    des.width =  2 * layout.horizontalPad;
    des.height = 2 * layout.verticalPad;

    obj = children;

    //
    // Skip to the first child which is a layout object.
    //
    while (obj && obj->ToLayoutWindow() == NULL)
	obj = obj->sibling;

    while (obj) {
        Cvo_LayoutWindow *win = obj->ToLayoutWindow();

	//
	// Okay, we will be using ``win'' now instead of ``obj'', so we
	// can forward obj on up to the next layout object.
	//
        while ((obj = obj->Sibling()) && obj->ToLayoutWindow() == NULL)
            ;

	if (win->layout.overlay != olay || !win->LayoutForeward())
	    continue;
        if (layout.vertical) {
            if (obj) {
                min.height += layout.internalPad;
                des.height += layout.internalPad;
            }
            min.height += win->layout.minimum.height;
            if (min.width < win->layout.minimum.width)
                min.width = win->layout.minimum.width;

            des.height += win->layout.desired.height;
            if (des.width < win->layout.desired.width)
                des.width = win->layout.desired.width;
        } else {
            if (obj) {
                min.width += layout.internalPad;
                des.width += layout.internalPad;
            }
            min.width += win->layout.minimum.width;
            if (min.height < win->layout.minimum.height)
                min.height = win->layout.minimum.height;

            des.width += win->layout.desired.width;
            if (des.height < win->layout.desired.height)
                des.height = win->layout.desired.height;
        }
    }

    int useminh = 0;        // Use minimum instead of desired
    int useminw = 0;        // Use minimum instead of desired

    //
    // Make des be how much space we will use.
    //
    if (height < int(des.height) || (force & Cvo_FORCE_MINIMUM_HEIGHT)) {
        useminh = 1;
        des.height = min.height;
    }
    if (width < int(des.width) || (force & Cvo_FORCE_MINIMUM_WIDTH)) {
        useminw = 1;
        des.width = min.width;
    }


    INT32 extra = 0;

    if (layout.vertical)
        extra = height - des.height;
    else
        extra = width - des.width;

    if (extra < 0)
        extra = 0;

    int cx = layout.horizontalPad;
    int cy = layout.verticalPad;

    int cox;
    int coy;

    if (layout.vertical) {
        cox = cx;
        coy = height - layout.verticalPad;
    } else {
        coy = cy;
        cox = width - layout.horizontalPad;
    }

    obj = children;

    //
    // Skip to the first child which is a layout object.
    //
    while (obj && obj->ToLayoutWindow() == NULL)
        obj = obj->sibling;

    while (obj) {
        Cvo_LayoutWindow *win = obj->ToLayoutWindow();

        //
        // Okay, we will be using ``win'' now instead of ``obj'', so we
        // can forward obj on up to the next layout object.
        //
        while ((obj = obj->Sibling()) && obj->ToLayoutWindow() == NULL)
            ;

        if (win->layout.overlay != olay || !win->LayoutForeward())
            continue;

        int nh = useminh ? win->layout.minimum.height :
                           win->layout.desired.height;
        int nw = useminw ? win->layout.minimum.width :
                           win->layout.desired.width;

        if (win->layout.dontresize) {
            nw = win->Width();
            nh = win->Height();
        }

	if (win->layout.dontposition) {
            win->LayoutFunction(win->layout.dontresize ? force : force|1,
                                1, nw, nh);
	    continue;
	}

        if (win->layout.expand) {
            INT32 tra = INT32((extra * win->layout.expand + ecnt - 1) / ecnt);
	    if (tra > extra)
		tra = extra;

            if (layout.vertical) {
                if (win->layout.matchHeight)
                    tra = 0;
                nh += int(tra);
            } else {
                if (win->layout.matchWidth)
                    tra = 0;
                nw += int(tra);
            }
            ecnt -= win->layout.expand;
            extra -= tra;
        }
        //
        // Always expand the frame in the other direction
        //
        if (layout.vertical)
            nw = width - 2 * layout.horizontalPad;
        else
            nh = height - 2 * layout.verticalPad;

        if (win->layout.opposite) {
            if (layout.vertical)
                coy -= nh;
            else
                cox -= nw;
            win->layout.x = cox;
            win->layout.y = coy;
            win->LayoutFunction(win->layout.dontresize ? force : force|1,
                                1, nw, nh);
            if (layout.vertical)
                coy -= layout.internalPad;
            else
                cox -= layout.internalPad;
        } else {
            win->layout.x = cx;
            win->layout.y = cy;
            win->LayoutFunction(win->layout.dontresize ? force : force|1,
                                1, nw, nh);
            if (layout.vertical)
		cy += nh + layout.internalPad;
            else
		cx += nw + layout.internalPad;
        }
    }
    CVO_VOID_RETURN
}

void
Cvo_LayoutWindow::ComputeUserSizes(Cvo_FrameSize &mymin, Cvo_FrameSize &mydes)
{   CVO_ENTER
    int fh = 1;
    int fw = 1;

    Cvo_Window *win = ToWindow();

    if (win) {
	fh = win->TextAttribute()->MHeight();
	fw = win->TextAttribute()->MWidth();
    }

    mymin.width = fw * minSize.wchars + minSize.wpixel;
    mymin.height = fh * minSize.hchars + minSize.hpixel;

    mydes.width = fw * defSize.wchars + defSize.wpixel;
    mydes.height = fh * defSize.hchars + defSize.hpixel;

    layout.maximum.width = fw * maxSize.wchars + maxSize.wpixel;
    layout.maximum.height = fh * maxSize.hchars + maxSize.hpixel;


    if (!mymin.width)
        mymin.width = CalculateWidth();
    if (!mymin.height)
        mymin.height = CalculateHeight();

    if (!mydes.width)
        mydes.width = mymin.width;
    if (!mydes.height)
        mydes.height = mymin.height;

    CVO_VOID_RETURN
}

int
Cvo_LayoutWindow::StandardComputeLayoutSize(int force)
{   CVO_ENTER
    Cvo_FrameSize mymin, mydes;

    ComputeUserSizes(mymin, mydes);

    if (layout.vaspect && layout.haspect) {
	if (CARD(mymin.width * layout.vaspect)
	  > CARD(mymin.height * layout.haspect)) {
	    mymin.height = CARD16(mymin.width * layout.vaspect
				/ CARD32(layout.haspect));
	} else {
	    mymin.width = CARD16(mymin.height * layout.haspect
				/ CARD32(layout.vaspect));
	}
	if (CARD(mydes.width * layout.vaspect)
	  > CARD(mydes.height * layout.haspect)) {
	    mydes.height = CARD16(mydes.width * layout.vaspect
				/ CARD32(layout.haspect));
	} else {
	    mydes.width = CARD16(mydes.height * layout.haspect
				/ CARD32(layout.vaspect));
	}
	if (CARD(layout.maximum.width * layout.vaspect)
	  > CARD(layout.maximum.height * layout.haspect)) {
	    layout.maximum.width = CARD16(layout.maximum.height * layout.haspect
				/ CARD32(layout.vaspect));
	} else {
	    layout.maximum.height = CARD16(layout.maximum.width * layout.vaspect
				/ CARD32(layout.haspect));
	}
    }

    //
    // min and des keep track of the total sum for our children
    //
    Cvo_FrameSize min, des;

    min.width = 0;
    min.height = 0;
    des.width = 0;
    des.height = 0;

    Cvo_FrameSize omin[Cvo_NOVERLAYS], odes[Cvo_NOVERLAYS];
    BOOL havechildren[Cvo_NOVERLAYS];

    for (int olay = 0; olay < Cvo_NOVERLAYS; ++olay) {
	havechildren[olay] = False;
	omin[olay].width = 0;
	omin[olay].height = 0;
	odes[olay].width = 0;
	odes[olay].height = 0;
    }

    Cvo_Object *obj = children;

    while (obj && obj->ToLayoutWindow() == NULL)
	obj = obj->sibling;

    while (obj) {
	Cvo_LayoutWindow *w = obj->ToLayoutWindow();

	while ((obj = obj->Sibling()) && obj->ToLayoutWindow() == NULL)
	    ;

	if (!w->ComputeLayoutSize(force))
	    continue;

	havechildren[w->layout.overlay] = True;

	if (layout.vertical) {
	    if (obj) {
		omin[w->layout.overlay].height += layout.internalPad;
		odes[w->layout.overlay].height += layout.internalPad;
	    }
	    omin[w->layout.overlay].height += w->layout.minimum.height;
	    if (omin[w->layout.overlay].width < w->layout.minimum.width)
		omin[w->layout.overlay].width = w->layout.minimum.width;

	    odes[w->layout.overlay].height += w->layout.desired.height;
	    if (odes[w->layout.overlay].width < w->layout.desired.width)
		odes[w->layout.overlay].width = w->layout.desired.width;
	} else {
	    if (obj) {
		omin[w->layout.overlay].width += layout.internalPad;
		odes[w->layout.overlay].width += layout.internalPad;
	    }
	    omin[w->layout.overlay].width += w->layout.minimum.width;
	    if (omin[w->layout.overlay].height < w->layout.minimum.height)
		omin[w->layout.overlay].height = w->layout.minimum.height;

	    odes[w->layout.overlay].width += w->layout.desired.width;
	    if (odes[w->layout.overlay].height < w->layout.desired.height)
		odes[w->layout.overlay].height = w->layout.desired.height;
	}
    }

    //
    // If our children do not have a minimum size or
    // we are not to be resized, use our minimum and desired sizes
    //
    if (layout.dontresize && Width() && Height()) {
	min.width = Width();
	min.height = Height();
	des.width = Width();
	des.height = Height();
	layout.maximum.width = Width();
	layout.maximum.height = Height();
    } else if (layout.dontresize) {
	min = mymin;
	des = mydes;
    } else {
	for (olay = 0; olay < Cvo_NOVERLAYS; ++olay) {
	    if (!havechildren[olay])
		continue;
	    omin[olay].width += 2 * layout.horizontalPad;
	    omin[olay].height += 2 * layout.verticalPad;
	    odes[olay].width += 2 * layout.horizontalPad;
	    odes[olay].height += 2 * layout.verticalPad;

	    if (min.width < omin[olay].width)
		min.width = omin[olay].width;
	    if (min.height < omin[olay].height)
		min.height = omin[olay].height;

	    if (des.width < odes[olay].width)
		des.width = odes[olay].width;
	    if (des.height < odes[olay].height)
		des.height = odes[olay].height;
	}

	//
	// Check against our window's minumum size
	//
	if (min.width < mymin.width)
	    min.width = mymin.width;
	if (min.height < mymin.height)
	    min.height = mymin.height;

	//
	// Special case for top level windows.  If the user has specified
	// a default size, then use it as the default instead of what we
	// compute the default to be.
	//
	if (!parent && defSize.wchars + defSize.wpixel
		    && defSize.hchars + defSize.hpixel) {
	    des = mydes;
	} else {
	    if (des.width < mydes.width)
		des.width = mydes.width;
	    if (des.height < mydes.height)
		des.height = mydes.height;
	}
    }

    if (des.width < min.width || (force & Cvo_FORCE_MINIMUM_WIDTH))
        des.width = min.width;
    if (des.height < min.height || (force & Cvo_FORCE_MINIMUM_HEIGHT))
        des.height = min.height;

    if (layout.maximum.width && des.width > layout.maximum.width) {
        des.width = layout.maximum.width;
        if (min.width > layout.maximum.width)
            min.width = layout.maximum.width;
    }

    if (layout.maximum.height && des.height > layout.maximum.height) {
        des.height = layout.maximum.height;
        if (min.height > layout.maximum.height)
            min.height = layout.maximum.height;
    }

    int rs = layout.ignoreshadow ? 0 : raise;

    if (layout.vertical) {
        min.width += 2*(borderWidth + horizontalPad)+raise;
        min.height += 2*(borderWidth + verticalPad)+rs;
        des.width += 2*(borderWidth + horizontalPad)+raise;
        des.height += 2*(borderWidth + verticalPad)+rs;
    } else {
        min.width += 2*(borderWidth + horizontalPad)+rs;
        min.height += 2*(borderWidth + verticalPad)+raise;
        des.width += 2*(borderWidth + horizontalPad)+rs;
        des.height += 2*(borderWidth + verticalPad)+raise;
    }
    
    //
    // XXX -- This code is suspect...
    //
    obj = Children() ? Children()->Elder() : 0;

    Cvo_LayoutWindow *lw = 0;

    while (obj) {
	if (lw = obj->ToLayoutWindow())
	    break;
	if (obj == Children())
	    obj = 0;
	else
	    obj = obj->Elder();
    }

    if (lw &&
	lw->raise &
	lw->layout.ignoreshadow) {
	if (layout.vertical) {
	    min.height += lw->raise;
	    des.height += lw->raise;
	} else {
	    min.width += lw->raise;
	    des.width += lw->raise;
	}
    }
    // XXX - end of suspect code

    if (layout.maximum.width)
	layout.maximum.width += 2 * (borderWidth + horizontalPad) + rs;
    if (layout.maximum.height)
	layout.maximum.height += 2 * (borderWidth + verticalPad) + rs;

    layout.minimum = min;
    layout.desired = des;

    if (layout.matchWidth) {
	layout.minimum.width = layout.matchWidth->layout.minimum.width;
	layout.desired.width = layout.matchWidth->layout.desired.width;
	layout.maximum.width = layout.matchWidth->layout.maximum.width;
    }

    if (layout.matchHeight) {
	layout.minimum.height = layout.matchHeight->layout.minimum.height;
	layout.desired.height = layout.matchHeight->layout.desired.height;
	layout.maximum.height = layout.matchHeight->layout.maximum.height;
    }
    CVO_RETURN(CheckLayout())
}
