//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: RadioBox.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Toggle.h++>
#include <Cvo/RadioBox.h++>

CONSTRUCTORS_1ARG(Cvo_RadioBox, Cvo_Window, "CvoRadioBox", Cvo_RadioBoxList *)

void
Cvo_RadioBox::_Init(Cvo_RadioBoxList *list)
{   CVO_ENTER
    type = CvoT_RadioBox;

    Cvo_RadioBoxList *rbl = list;
    togcnt = 0;
    currentData = 0;

    while (rbl->label) {
	++togcnt;
	++rbl;
    }
    if (!togcnt)
	CVO_VOID_RETURN

    radio = new Cvo_Radio();
    toggles = new Cvo_Object *[togcnt];

    for (int x = 0; x < togcnt; ++x) {
	char buf[16];

	sprintf(buf, "toggle-%d", x);
	list[x].toggle = toggles[x] = new Cvo_SquareToggleButton(buf, this);
	((Cvo_SquareToggleButton *)toggles[x])->SetDefaultText(list[x].label);
	((Cvo_SquareToggleButton *)toggles[x])->ExpandFrame();
	radio->AddToggle(toggles[x]);
	toggles[x]->Register(CvoButtonDownEvent, &Cvo_RadioBox_ButtonDown,
		     list[x].data);
	toggles[x]->Register(CvoButtonUpEvent, &Cvo_RadioBox_ButtonUp,
		     list[x].data);
    	if (list[x].start_toggled)
	    list[x].toggle->ForceOn();
    }
    CVO_VOID_RETURN
}

Cvo_RadioBox::~Cvo_RadioBox()
{   CVO_ENTER
    delete radio;
    delete [] toggles;
    CVO_DONE
}

void
Cvo_RadioBox_ButtonDown(Cvo_Object *w, XEvent *, void *data)
{   CVO_ENTER
    Cvo_RadioBox *rb = (Cvo_RadioBox *)(w->Parent());

    for (int x = 0; x < rb->togcnt; ++x) {
	if (w == rb->toggles[x]) {
	    Cvo_RadioBoxSelectedEvent rbse;

	    rbse.index = x;
	    rbse.data = data;
	    rb->currentData = data;
	    rb->SendEvent(CvoRadioBoxSelectedEvent, &rbse);
	    CVO_VOID_RETURN
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_RadioBox_ButtonUp(Cvo_Object *w, XEvent *, void *data)
{   CVO_ENTER
    Cvo_RadioBox *rb = (Cvo_RadioBox *)(w->Parent());

    for (int x = 0; x < rb->togcnt; ++x) {
	if (w == rb->toggles[x]) {
	    Cvo_RadioBoxSelectedEvent rbse;

	    rbse.index = x;
	    rbse.data = data;
	    rb->currentData = 0;
	    rb->SendEvent(CvoRadioBoxDeselectedEvent, &rbse);
	    CVO_VOID_RETURN
	}
    }
    CVO_VOID_RETURN
}
