//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: Protocols.cc,v 1.3 1994/09/07 20:46:54 prb Exp $"); }
/*****************************************************************************/
/*  Protocols.cc - 							     */
/*  Date of origin: August 93 						     */
/*                                                                           */
/*  History:                                                                 */
/*     Author       Date    Comments                                         */
/*     ------       ----    --------                                         */
/*     Paul Algren   8-93   Initial implementation 			     */
/*                                                                           */
/*  Portions of this software may still be in development.  The existence of */
/*  the software still in development is not a commitment of actual release  */
/*  or support by Cray Research, Inc.  If it is released, the final form of  */
/*  the product and the time of official release is at the discretion of     */
/*  Cray Research, Inc.                                                      */
/*                                                                           */
/*****************************************************************************/
#include <Cvo/Protocols.h++>
#include <Cvo/convert.h++>

Cvo_ICM_Protocol::Cvo_ICM_Protocol(char* target, Cvo_Object* o)
{
    msg_protocol = None;
    obj = o;
    msg_target = target;

    if (obj) {
	InitProtocol();
	reg = Cvo_Register(obj, ClientMessage, Cvo_ICM_Protocol::Handler, this);
    } 
}

Cvo_ICM_Protocol::~Cvo_ICM_Protocol()
{
    if (reg && obj) {
	delete reg;
    }
}

void
Cvo_ICM_Protocol::SetProtocol(Display* dpy)
{
    if (msg_protocol == None)
	msg_protocol = XInternAtom(dpy, msg_target, False);
}

void
Cvo_ICM_Protocol::InitProtocol()
{
    if (!obj) {return;} 

    SetProtocol(obj->Dpy());

    if (!obj->Object()) {
	obj->CreateAll();
    } 
    Window window = obj->Win();
    XChangeProperty(obj->Dpy(), obj->Win(), MsgProtocol(), XA_WINDOW, 32,
		    PropModeReplace, (unsigned char *)(&window), 1);
}

void
Cvo_ICM_Protocol::Handler(Cvo_Object* obj, XEvent* ev, void* d)
{
    Cvo_ICM_Protocol* proto = (Cvo_ICM_Protocol*) d;
    XClientMessageEvent &ce = ev->xclient;

    //
    // CDD_DROP_TARGET 7.0 matches both atoms instead of passing
    // the protocol type in ce.message_type (UBE).
    // When this happens change the ce.message_type to CddDrop protocols type.
    // If this ever changes remove this code since it does open us up a bit.
    //
    if (ce.message_type == (Atom)Cvo_read32(ce.data.b + 0) &&
        (short)Cvo_read16(ce.data.b+12) == 3) {
	Cvo_CddDrop_Protocol dp;
	dp.SetProtocol(obj->Dpy());
	ce.message_type = dp.MsgProtocol();
    }
    //
    // End kludge
    // 
    
    if (ce.message_type == proto->MsgProtocol()) {
	proto->Process(ev);
	ev->type = 0;
    }
}
    
Atom
Cvo_ICM_Protocol::GetUnusedProperty(Display *dpy, Window to)
{
    char	buffer[64];
    int		cnt, format;
    Atom	property, type;
    BOOL	used;
    unsigned char   *ret_data;
    unsigned long   nitems, left;
    
    /* 
     *	Use the window id to make the name server unique, and the
     *	sp pointer value to make it application unique.
     */
    cnt = 0;
    do	{
	sprintf(buffer,"%s_%d__%d", msg_target, to, cnt++);
	property = XInternAtom(dpy, buffer, False);
	used = True;
	if (XGetWindowProperty(dpy, to, property, 0, 10L, False,
			       AnyPropertyType, &type, &format, &nitems,
			       &left, &ret_data) != Success) {
	    used = False;
	}
	else if (!nitems) {
	    used = False;
	}
    } while (used);
    return(property);
}

Cvo_CddDrop_Protocol::~Cvo_CddDrop_Protocol()
{
    if (data != 0) {
	XFree(_xfree_t data);
	data = 0;
    } 
}

Cvo_IXI_Protocol::~Cvo_IXI_Protocol()
{
    if (data != 0) {
	XFree(_xfree_t data);
	data = 0;
    } 
}

Cvo_SunMvFiles_Protocol::~Cvo_SunMvFiles_Protocol()
{
    if (data != 0) {
	XFree(_xfree_t data);
	data = 0;
    } 
}

Window
Cvo_Drop_Protocol::FindDropTarget(Display* dpy, int dx, int dy)
{
    Window send_to;
    Window parent;
    Window current;
    Window child;

    unsigned long n_left, n_items;
    unsigned char *data;
    int format;
    int rx, ry;
    Atom type;

    SetProtocol(dpy);

    send_to = None;
    parent = current = DefaultRootWindow(dpy);

    x = dx;
    y = dy;

    do {
	XTranslateCoordinates(dpy, parent, current,
			      dx, dy, &rx, &ry, &child);
	n_items = 0;
	XGetWindowProperty(dpy, current, MsgProtocol(), 0L, 1, False,
		  	   XA_WINDOW, &type, &format, &n_items, &n_left, &data);
	if (n_items != 0L) {
	    send_to = *(Window *)data;
	    XFree(_xfree_t data);
	    data = 0;
	}
	dx = rx;
	dy = ry;
	parent = current;
	current = child;
    } while (child != None);
    return(send_to);
}

void
Cvo_CddDrop_Protocol::Process(XEvent* ev)
{
    XClientMessageEvent &ce = ev->xclient;

    Window receiver = ev->xany.window;
    
    Atom property = (Atom)Cvo_read32(ce.data.b + 0);
    sendor = (Window)Cvo_read32(ce.data.b + 4);
    short type = Cvo_read16(ce.data.b+12);
    key = Cvo_read16(ce.data.b+14);
    x = Cvo_read16(ce.data.b + 8);
    y = Cvo_read16(ce.data.b + 10);
    time = Cvo_read32(ce.data.b + 16);

    Atom act_type;
    int act_format;
    unsigned long	left;

    if (property) {
	if (data != 0) {
	    XFree(_xfree_t data);
	    data = 0;
	}
	if (XGetWindowProperty(obj->Dpy(), receiver, property, 0, 1000000L,
			       True, AnyPropertyType, &act_type, &act_format,
	       (unsigned long*)&size, &left, &data) != Success) {
	    fprintf(stderr,"type=%d\n",act_type);
	    return;
	}
    } 
    if (left) {
	fprintf(stderr,"%d bytes of info was lost in the Message", left);
    } 
} 

BOOL
Cvo_CddDrop_Protocol::Send(Display* dpy, Window to)
{
    XEvent  out_report;

    if (to == None) {return (False);} 

    Atom atom = GetUnusedProperty(dpy, to);
    XChangeProperty(dpy, to, atom, 3, 8,
		    PropModeReplace, data, size);
    
    /*--------------------------------------------------------------*
     *	Set the general client message fields.			*
     *--------------------------------------------------------------*/
    
    out_report.type                 = ClientMessage;
    out_report.xany.type            = ClientMessage;
    out_report.xany.send_event      = True;
    out_report.xany.window          = to;
    out_report.xany.display         = dpy;
    
    /*--------------------------------------------------------------*
     *      actual client_message stuff				*
     *--------------------------------------------------------------*/
    
    out_report.xclient.type         = ClientMessage;
    out_report.xclient.message_type = MsgProtocol();
    out_report.xclient.send_event   = True;
    out_report.xclient.window       = to;
    out_report.xclient.display      = dpy;
    out_report.xclient.format 	= 32;
    
    /*
     * Break down the sending atom and sending window into a
     * string of 8 bit byte values. In a world where byte-fiddling
     * is not done, this should be:
     *
     *      out_report.xclient.format = 32;
     *      DATA.l[0] = (long) atom;
     *      DATA.l[1] = (long) sendwin;
     */
    out_report.xclient.format       = 8;

    /*
     *	sending atom
     */
    Cvo_store32(atom,(char *) &(out_report.xclient.data.b[0]));

    /*
     *	sending window
     */
    Cvo_store32(sendor,(char *) &(out_report.xclient.data.b[4]));

    /*
     *	sending drop coordinates in target window.
     */
    Cvo_store16(x,(char*)&(out_report.xclient.data.b[8]));
    Cvo_store16(y,(char*)&(out_report.xclient.data.b[10]));

    /*
     *	type of record being sent.
     */
    Cvo_store16(3,(char*)&(out_report.xclient.data.b[12]));

    /*
     *	this applications unique key 
     */
    if (key > 0) {
	Cvo_store16(key, (char*)&(out_report.xclient.data.b[14]));
    } else	{
	out_report.xclient.data.b[14] = 0;
	out_report.xclient.data.b[15] = 0;
    }

    /*
     * time of event
     */
    Cvo_store32(time, (char*)&(out_report.xclient.data.b[16]));

    /*
     *      send it
     */
    return (XSendEvent(dpy, to, True, (EventMask)0, &out_report));
}

void
Cvo_IXI_Protocol::Process(XEvent* ev)
{
    XClientMessageEvent &ce = ev->xclient;

    Window receiver = ev->xany.window;
    
    time = Cvo_read32(ce.data.b);
    Atom property = (Atom)Cvo_read32(ce.data.b + 16);
    short type = (short)Cvo_read32(ce.data.b + 12);
    x = Cvo_read16(ce.data.b + 4);
    y = Cvo_read16(ce.data.b + 6);

    Atom act_type;
    int act_format;
    unsigned long	left;

    if (property) {
	if (data != 0) {
	    XFree(_xfree_t data);
	    data = 0;
	}
	if (XGetWindowProperty(obj->Dpy(), receiver, property, 0, 1000000L,
			       True, AnyPropertyType, &act_type, &act_format,
	       (unsigned long*)&size, &left, &data) != Success) {
	    fprintf(stderr,"type=%d\n",act_type);
	    return;
	}
    } 
    if (left) {
	fprintf(stderr,"%d bytes of info was lost in the Message", left);
    } 
}

BOOL
Cvo_IXI_Protocol::Send(Display* dpy, Window to)
{
    XEvent  out_report;
    Atom	atom;

    if (to == None) {return (False);} 

    atom = GetUnusedProperty(dpy, to);
    XChangeProperty(dpy, to, atom, 4, 8, PropModeReplace, data, size);
    
    /*--------------------------------------------------------------*
     *	Set the general client message fields.			*
     *--------------------------------------------------------------*/
    
    out_report.type                 = ClientMessage;
    out_report.xany.type            = ClientMessage;
    out_report.xany.send_event      = True;
    out_report.xany.window          = to;
    out_report.xany.display         = dpy;
    
    /*--------------------------------------------------------------*
     *      actual client_message stuff				*
     *--------------------------------------------------------------*/
    
    out_report.xclient.type         = ClientMessage;
    out_report.xclient.message_type = MsgProtocol();
    out_report.xclient.send_event   = True;
    out_report.xclient.window       = to;
    out_report.xclient.display      = dpy;
    out_report.xclient.format 	= 32;

    /*
     *	Set up for an IXI drop client message.
     */
    out_report.xclient.data.l[0] = time;			/* time	*/
    out_report.xclient.data.l[1] = (long) (((x & 0xffff) << 16) |
					   (y & 0xffff));
    out_report.xclient.data.l[2] = 0x00000100;		/* button 1 state */
    out_report.xclient.data.l[3] = (long) XA_STRING;
    out_report.xclient.data.l[4] = (long) atom;

    /*
     *      send it
     */
    return (XSendEvent(dpy, to, True, (EventMask)0, &out_report));
}

void
Cvo_SunMvFiles_Protocol::Process(XEvent* ev)
{
    XClientMessageEvent &ce = ev->xclient;

    Atom property    = (Atom)   ce.data.l[4];
    sendor   = (Window) ce.data.l[3];
    Window receiver = (Window) ce.data.l[3];

    /* 
     *	I got no idea where it was dropped, just set
     *	x and y to -1.
     */
    x = y = (int) -1;

    Atom act_type;
    int act_format;
    unsigned long	left;

    if (property) {
	if (data != 0) {
	    XFree(_xfree_t data);
	    data = 0;
	}
	if (XGetWindowProperty(obj->Dpy(), receiver, property, 0, 1000000L,
			       True, AnyPropertyType, &act_type, &act_format,
	       (unsigned long*)&size, &left, &data) != Success) {
	    fprintf(stderr,"type=%d\n",act_type);
	    return;
	}
    } 
    if (left) {
	fprintf(stderr,"%d bytes of info was lost in the Message", left);
    }
}

BOOL
Cvo_SunMvFiles_Protocol::Send(Display* dpy, Window to)
{
    XEvent  out_report;
    Atom	atom;

    if (to == None) {return (False);} 

    atom = GetUnusedProperty(dpy, to);
    XChangeProperty(dpy, to, atom, 4, 8, PropModeReplace, data, size);
    
    /*--------------------------------------------------------------*
     *	Set the general client message fields.			*
     *--------------------------------------------------------------*/
    
    out_report.type                 = ClientMessage;
    out_report.xany.type            = ClientMessage;
    out_report.xany.send_event      = True;
    out_report.xany.window          = to;
    out_report.xany.display         = dpy;
    
    /*--------------------------------------------------------------*
     *      actual client_message stuff				*
     *--------------------------------------------------------------*/
    
    out_report.xclient.type         = ClientMessage;
    out_report.xclient.message_type = MsgProtocol();
    out_report.xclient.send_event   = True;
    out_report.xclient.window       = to;
    out_report.xclient.display      = dpy;
    out_report.xclient.format 	= 32;

    /*
     *	Set up for an Sun drop client message.
     */
    out_report.xclient.data.l[3] = (long) sendor;
    out_report.xclient.data.l[4] = (long) atom;

    /*
     *      send it
     */
    return (XSendEvent(dpy, to, True, (EventMask)0, &out_report));
}
