//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Picture.cc,v 1.3 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Picture.h++>

CONSTRUCTORS_1ARG(Cvo_Picture, Cvo_Window, "CvoPicture", char *)
CONSTRUCTORS_4ARG(Cvo_Picture, Cvo_Window, "CvoPicture", int, int, int, CARD8 *)
CONSTRUCTORS_6ARG(Cvo_Picture, Cvo_Window, "CvoPicture", int, int, int, int, char **, char **)

void
Cvo_Picture::_Init(char *filename)
{   CVO_ENTER
    image = new Cvo_Image(this, filename);

    if (!image->Loaded()) {
	Cvo_Failure(CvoE_WARN, CvoE_CUTOPEN,
		    "Cannot load file %s as a picture\n", filename);
	CVO_VOID_RETURN
    }
    CVO_VOID_RETURN
}

void
Cvo_Picture::_Init(int w, int h, int dp, CARD8 *dt)
{   CVO_ENTER
    image = new Cvo_Image(this, w, h, dp, dt);
    CVO_VOID_RETURN
}

void
Cvo_Picture::_Init(int w, int h, int n, int cpp, char **colors, char **pixels)
{   CVO_ENTER
    image = new Cvo_Image(this, w, h, n, cpp, colors, pixels);
    CVO_VOID_RETURN
}

void
Cvo_Picture::Exposure(XExposeEvent *ev)
{   CVO_ENTER
    if (!Object())
	CVO_VOID_RETURN

    Cvo_Window::Exposure(ev);

    if (!image->Loaded()) {
	CVO_VOID_RETURN
    }
    if (!image->Width() || !image->Height()) {
	CVO_VOID_RETURN
    }

    int sx = (Width() - image->Width()) / 2;
    int sy = (Height() - image->Height()) / 2;
    int x = 0;
    int y = 0;
    int w = image->Width();
    int h = image->Height();

    if (sx < 0) {
	w = Width();
	sx = 0;
    }

    if (sy < 0) {
	h = Height();
	sy = 0;
    }

    if (ev) {
	if (ev->x < sx) {
	    ev->width -= sx - ev->x;
	    ev->x = sx;
	}

	if (ev->y < sx) {
	    ev->height -= sy - ev->y;
	    ev->y = sy;
	}

	if (ev->x + ev->width > sx + w)
	    ev->width = sx + w - ev->x;

	if (ev->y + ev->height > sy + h)
	    ev->height = sy + h - ev->y;

	x = ev->x - sx;
	y = ev->y - sy;
	w = ev->width;
	h = ev->height;
	sx = ev->x;
	sy = ev->y;

	if (w <= 0 || h <= 0) {
	    CVO_VOID_RETURN
	}
    }

    image->Show(sx, sy, w, h, x, y);
    CVO_VOID_RETURN
}
