//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: PeelOff.cc,v 1.6 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/PeelOff.h++>
#include <Cvo/peel_off.h>

static Cvo_Default def[] = {
    "*CvoPeelOff.Cursor:Top Left Arrow",
    "*CvoPeelOff.Pad:2",
};

CVO_BEGIN_BIND(Cvo_PeelOff)
CVO_DOBIND(Cvo_PeelOff, "Press",	DragBoxInit)
CVO_DOBIND(Cvo_PeelOff, "Drag",		DragBox)
CVO_DOBIND(Cvo_PeelOff, "Release",	DragBoxDone)
CVO_END_BIND(Cvo_PeelOff, Cvo_Window)

static char *trans = "\
    <ButtonPress>: Press()\n\
    <ButtonMotion>: Drag()\n\
    <ButtonRelease>: Release()\n\
";

CONSTRUCTORS_1ARG(Cvo_PeelOff, Cvo_Window, "CvoPeelOff", Cvo_Window *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_PeelOff)

void
Cvo_PeelOff::_Init(Cvo_Window *win)
{
    char *fn;
    image = 0;
    local = True;
    active = False;

    if (fn = GetResource("filename", "Filename")) {
	image = new Cvo_Image(this, fn);
	if (!image->Loaded()) {
	    delete image;
	    image = 0;
	}
    }

    if (!image)
	image = new Cvo_Image(this, peel_off_width, peel_off_height, 1,
				    peel_off_bits);
    FillFrame(False);

    peelwin = win;

    Cvo_Color gray(this, "gray");
    XGCValues xgcv;
    unsigned long mask;

    xgcv.function = GXxor;
    xgcv.line_width = 2;
    xgcv.subwindow_mode = IncludeInferiors;

    mask = GCFunction | GCForeground | GCLineWidth | GCSubwindowMode;

    xgcv.foreground = gray->Pixel();
    if (gray->UsePixmap()) {
        xgcv.stipple = gray->GetPixmap(1);
        mask |= GCStipple|GCFillStyle;
        xgcv.fill_style = FillOpaqueStippled;
    }

    boxGC = XCreateGC(Dpy(), Root(), mask, &xgcv);

    AddTranslations(trans);
    Register(Expose, &Cvo_PeelOff::ExposureHandler);
}

Cvo_PeelOff::~Cvo_PeelOff()
{
    if (local)
	delete image;
    XFreeGC(Dpy(), boxGC);
}

void
Cvo_PeelOff::ExposureHandler(XEvent *, void *)
{
    if (Sunken())
        image->Select();
    else
        image->UnSelect();
    image->Show(0, 0);
}

void
Cvo_PeelOff::DragBoxInit(XEvent *ev, int , char **)
{
    if (active) {
	XDrawRectangle(Dpy(), Root(), boxGC, lx, ly, w, h);
	XUngrabServer(Dpy());
	active = False;

	if (sunken ^= 1) {
	    SelectBackground();
	} else {
	    NormalBackground();
	}
	Redraw();

	return;
    }

    if (ev->type != ButtonPress)
	return;

    XButtonEvent *be = (XButtonEvent *)ev;

    Window child;
    XTranslateCoordinates(peelwin->Dpy(), peelwin->Object(), peelwin->Root(),
			  0, 0, &lx, &ly, &child);
    w = peelwin->XWidth();
    h = peelwin->XHeight();
    bx = be->x_root;
    by = be->y_root;

    if (sunken ^= 1) {
        SelectBackground();
    } else {
        NormalBackground();
    }
    Redraw();

    XGrabServer(Dpy());
    XDrawRectangle(Dpy(), Root(), boxGC, lx, ly, w, h);
    active = True;
}

void
Cvo_PeelOff::DragBox(XEvent *ev, int , char **)
{
    if (!active || ev->type != MotionNotify)
        return;
    XButtonEvent *be = (XButtonEvent *)ev;

    XDrawRectangle(Dpy(), Root(), boxGC, lx, ly, w, h);

    lx += be->x_root - bx;
    ly += be->y_root - by;

    bx = be->x_root;
    by = be->y_root;

    XDrawRectangle(Dpy(), Root(), boxGC, lx, ly, w, h);
}

void
Cvo_PeelOff::DragBoxDone(XEvent *ev, int , char **)
{
    if (!active || ev->type != ButtonRelease)
        return;

    XButtonEvent *be = (XButtonEvent *)ev;

    XDrawRectangle(Dpy(), Root(), boxGC, lx, ly, w, h);
    XUngrabServer(Dpy());

    if (sunken ^= 1) {
	SelectBackground();
    } else {
	NormalBackground();
    }
    Redraw();
    active = False;

    Cvo_PeelOffEvent poe;

    poe.x = lx;
    poe.y = ly;
    poe.peelwin = peelwin;

    SendEvent(CvoPeelOffEvent, &poe);
    peelwin->SendEvent(CvoPeelOffEvent, &poe);
}
