//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Output.cc,v 1.9 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/Output.h++>
#include <ctype.h>
#if defined(I18N) && !defined(_RUNE_MAGIC_1)
#include <wctype.h>
#endif

static Cvo_Default defaults[] = {
    "*CvoOutput*Sunken:True",
    "*CvoOutput*Pad:3",
    "*CvoOutput*FontFamily:Courier",
};

CONSTRUCTORS(Cvo_Output, Cvo_CRT, "CvoOutput")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Output)

void
Cvo_Output::_Init()
{   CVO_ENTER
    type = CvoT_Output;
    buffer = new wchar_t [bufmax = 64];
    bufptr = buffer;
    bufend = buffer;
    offset = buffer;
    accept = 0;
    acceptlen = 0;
    *bufend = 0;
    filter = 0;
    dirty = True;

    defSize.hchars = 1;
    defSize.hpixel = 0;
    maxSize.hchars = 1;
    defSize.hpixel = 0;
    Register(CvoResizeEvent, &Cvo_Output::ResizeEvent);
    CVO_VOID_RETURN
}

Cvo_Output::~Cvo_Output()
{   CVO_ENTER
    delete [] buffer;
    delete [] accept;
    CVO_DONE
}

void
Cvo_Output::_Create()
{   CVO_ENTER
    if (Object())
	CVO_VOID_RETURN
    //
    // Force this thing to only be one line high!
    //
    defSize.hchars = 1;
    defSize.hpixel = 0;
    maxSize.hchars = 1;
    defSize.hpixel = 0;
    Cvo_CRT::_Create();
    CVO_VOID_RETURN
}

void
Cvo_Output::ResizeEvent(XEvent *, void *)
{
    dirty = True;
    Flush(2);
}

char *
Cvo_Output::GetText()
{   CVO_ENTER
    if (!accept)
	accept = new char [acceptlen = bufend - buffer + 1];

    _Cvo_wcstombs(&accept, buffer, &acceptlen);

    // XXX - when the cursor is changed back to a vertical bar, this code
    // can go away.

    char *e = accept;
    while (*e)
	++e;

    if (e > accept && e[-1] == ' ')
	e[-1] = '\0';

    CVO_RETURN(accept)
}

void
Cvo_Output::EraseLine()
{   CVO_ENTER
    bufptr = offset = bufend = buffer;
    *bufend = '\0';
    dirty = True;
    Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_Output::Flush(int r)
{   CVO_ENTER
    if (!Object())
	CVO_VOID_RETURN

    if (dirty) {
	if (bufptr <= offset) {
	    offset = bufptr;
	} else {
	    int bw = StringWidth(bufptr+1);
	    while (offset < bufend && StringWidth(offset) - bw > Width())
		++offset;
	}

	while (offset > buffer && StringWidth(offset-1) <= Width())
	    --offset;

	ClearWindow();
	InsertAt(0, 0, offset);
  	MoveCursor(0, bufptr - offset);
	dirty = False;
    }
    Cvo_CRT::Flush(r);
    CVO_VOID_RETURN
}

void 
Cvo_Output::Enter(char *string)
{   CVO_ENTER
    if (!string)
	CVO_VOID_RETURN
    Cvo_Lock lock;
    static Cvo_CharacterBuffer cb;

    cb.Set(string);
    Enter(cb.wcValue());
    CVO_VOID_RETURN
}

#if	!defined(iswprint)
#define	iswprint(c) isprint(c)
#endif

void
Cvo_Output::MoveCursor(int line, int col)
{
    Cvo_CRT::MoveCursor(line, col);

    bufptr = offset + cursorx;
}

void 
Cvo_Output::Enter(wchar_t *ws)
{   CVO_ENTER
    SelectClear();

    while (*ws) {
	if (iswprint(*ws) && (!filter || (*filter)(this, *ws, bufptr - buffer,
						   filterdata))) {
	    if (bufend + 1 >= buffer + bufmax) {
		wchar_t *nb = new wchar_t[bufmax + 64];
		_memwcpy(nb, buffer, bufmax);
		bufptr += nb - buffer;
		bufend += nb - buffer;
		offset += nb - buffer;
		bufmax += 64;
		delete [] buffer;
		buffer = nb;
	    }
	    if (bufptr < bufend)
		_memwcpy(bufptr+1, bufptr, bufend - bufptr);
	    dirty = True;
	    *bufptr++ = *ws;
	    ++bufend;
	}
	++ws;
    }
    *bufend = 0;
    CVO_VOID_RETURN
}

CARD16
Cvo_Output::CalculateWidth()
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->MWidth() * 8)
}

CARD16
Cvo_Output::CalculateHeight()
{   CVO_ENTER
    CVO_RETURN(TextAttribute()->MHeight())
}
