//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: MenuSession.cc,v 1.5 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Menu.h++>

int Cvo_MenuSession::btncnt = 0;
Cvo_MenuSessionFilter *Cvo_MenuSession::filters = 0;
BOOL Cvo_MenuSession::running = False;

Cvo_MenuSessionFilter::Cvo_MenuSessionFilter()
{
    upfront = 0;
    if (Cvo_MenuSession::filters && Cvo_MenuSession::filters->upfront) {
	Cvo_MenuSessionFilter *f = Cvo_MenuSession::filters;
	while (f->next && f->next->upfront)
	    f = f->next;
    	next = f->next;
	f->next = this;
    } else {
	next = Cvo_MenuSession::filters;
	Cvo_MenuSession::filters = this;
    }
}

Cvo_MenuSessionFilter::~Cvo_MenuSessionFilter()
{
    if (Cvo_MenuSession::filters == this) {
	Cvo_MenuSession::filters = next;
    } else {
	Cvo_MenuSessionFilter *filts = Cvo_MenuSession::filters;

	while (filts && filts->next != this)
		filts = filts->next;
	if (filts)
	    filts->next = next;
    }
}

void
Cvo_MenuSession::Up(int c)
{
    btncnt = c;
    if (!running) {
	running = True;
	Cvo_PushExEventFilter(&Filter, 0, 0);
    }
}

void
Cvo_MenuSession::Down()
{
    Cvo_PopEventFilter();
    running = False;

    while (filters)
	delete filters;
}

void
Cvo_MenuSession::PopTo(Cvo_MenuSessionFilter *filt)
{
    Cvo_MenuSessionFilter *f = filters;
    Cvo_MenuSessionFilter *lf = 0;

    while (f && f->upfront && f != filt) {
	lf = f;
	f = f->next;
    }

    if (lf) {
	while (lf->next && lf->next != filt)
	    delete lf->next;
    } else {
	while (filters != filt)
	    delete filters;
    }
}

BOOL event_filter(Cvo_Object *, XEvent *);

XEvent *
Cvo_MenuSession::Filter(Cvo_Object *win, XEvent *ev, void *)
{
    switch(ev->type) {
    case CvoKeyTextEvent:
	return(0);
    case EnterNotify:
    case LeaveNotify:
    case MapNotify:
	break;
    case KeyPress:
	if (Cvo_DisplayList::AccelCheckFilter(win, ev, win->DisplayList()) == 0) {
	    Down();
	    Cvo_DisplayList::AccelFilter(win, ev, win->DisplayList());
	    return(0);
	}
	if ((btncnt = _cvo_button_count(ev)) == 0)
	    break;
	return(0);
    case KeyRelease:
	return(0);
    case ButtonPress:
	btncnt = _cvo_button_count(ev) + 1;
	if (btncnt == 1)
	    break;
	return(0);
    case ButtonRelease:
	btncnt = _cvo_button_count(ev) - 1;
    	if (btncnt == 0)
	    break;
	return(0);
    case MotionNotify:
	return(0);
    default:
	return(ev);
    }

    Cvo_MenuSessionFilter *filt = filters;

    Cvo_MenuSessionFilter *atend[16];
    int atendi = 0;

    while (filt) {
	switch(filt->Filter(win, ev)) {
        case CvoMenuSessionFilterReturn:
	    break;
	case CvoMenuSessionFilterDeleteMe:
	    delete filt;
	    return(0);
	case CvoMenuSessionFilterProcessed:
	    return(0);
	case CvoMenuSessionFilterFinished: {
	    Cvo_MenuEntry *entry = filt->Entry();
	    Down();
    	    if (entry)
		entry->Call();
	    return(0);
    	  }
        case CvoMenuSessionFilterAgainAtEnd:
	    atend[atendi++] = filt;
	    break;
	}
	filt = filt->next;
    }
    if (atendi) {
	ev->xany.serial = (unsigned long)-1;
	while (atendi-- > 0) {
	    filt = atend[atendi];
	    switch(filt->Filter(win, ev)) {
	    case CvoMenuSessionFilterAgainAtEnd:
	    case CvoMenuSessionFilterReturn:
		break;
	    case CvoMenuSessionFilterDeleteMe:
		delete filt;
		return(0);
	    case CvoMenuSessionFilterProcessed:
		return(0);
	    case CvoMenuSessionFilterFinished: {
		Cvo_MenuEntry *entry = filt->Entry();
		Down();
		if (entry)
		    entry->Call();
		return(0);
	      }
	    }
	}
    }

    switch(ev->type) {
    case ButtonRelease:
	Down();
	return(0);
    case ButtonPress:
    case KeyPress:
    case KeyRelease:
	return(0);
    default:
	return(ev);
    }
}

Cvo_MenuEntry *
Cvo_MenuSessionFilter::Entry()
{
    return(0);
}
