//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: Menu.cc,v 1.12 1995/06/04 07:14:49 prb Exp $"); }
#include <Cvo/Menu.h++>
#include <Cvo/MenuLabel.h++>

static Cvo_Default defs[] = {
    "*CvoMenu.LayoutPad: 0",
    "*CvoMenu.InternalPad: 0",
};

CVO_CREATE_REGISTER_FUNCTIONS(Cvo_Menu)
CONSTRUCTORS(Cvo_Menu, Cvo_Window, "CvoMenu")
CONSTRUCTORS_1ARG(Cvo_Menu, Cvo_Window, "CvoMenu", Cvo_MenuItem *)

Cvo_Menu::Cvo_Menu(char *resname, Cvo_MenuItem *mi)
	   : Cvo_Window(resname, "CvoMenu", Cvo_MAINWINDOW)
{
    if (mi)
	_Init(mi);
    else
	_Init();
}

void
Cvo_Menu::_Init()
{
    VerticalChildren();
    MakePopup();
    items = 0;
    cascadefrom = 0;
    cascade = 0;
    curs = Cvo_Cursor(this, GetResource("menuCursor", "MenuCursor", "Arrow"));

    Register(MapNotify, &Cvo_Menu::MapEvent);
    Register(UnmapNotify, &Cvo_Menu::UnmapEvent);
}

void
Cvo_Menu::_Init(Cvo_MenuItem *mi)
{
    _Init();
    while (mi->resource || mi->flags) {
	new Cvo_MenuEntry(this, mi);
	++mi;
    }
}

void
Cvo_Menu::enter(Cvo_Object *obj, XEvent *, void *vmenu)
{
    Cvo_Menu *m = (Cvo_Menu *)vmenu;
    Cvo_MenuEntry *e = m->items;

    while (e && e->label != obj)
	e = e->next;

    //
    // If we are what the cascade started from, just ignore this
    //
    if (e && m->cascade && m->current == e && e->cascade == m->cascade)
	return;
    //
    // Assure that there are not any cascaded children around.
    //
    if (m->filter)
	m->filter->PopTo();

    obj->ToWindow()->Unflatten();
    obj->ToWindow()->Redraw();

    if (m->current && m->current != e) {
	obj = m->current->label;
	m->current = e;
	leave(obj, 0, vmenu);
    }

    m->current = e;
}

void
Cvo_Menu::leave(Cvo_Object *obj, XEvent *, void *vmenu)
{
    Cvo_Menu *m = (Cvo_Menu *)vmenu;
    Cvo_MenuEntry *e = m->items;

    while (e && e->label != obj)
	e = e->next;

    //
    // If we are what the cascade started from, just ignore this
    //
    if (e && m->cascade && m->current == e && e->cascade == m->cascade)
	return;

    obj->ToWindow()->Flatten();
    obj->ToWindow()->Redraw();

    if (e && m->current == e)
	m->current = 0;
}

void
Cvo_Menu::InsertItem(Cvo_Window *win, int flags)
{
    if (!(flags & CvoM_SEPARATOR))
	win->Flatten();

    if (!(flags & (CvoM_ALWAYSFLAT|CvoM_SEPARATOR))) {
	win->Register(EnterNotify, Cvo_Menu::enter, this);
	win->Register(LeaveNotify, Cvo_Menu::leave, this);
    }
}

#define SHei    HeightOfScreen(DefaultScreenOfDisplay(Dpy()))
#define SWid    WidthOfScreen(DefaultScreenOfDisplay(Dpy()))

void
Cvo_Menu::Start(int cnt)
{
    if (cnt >= 0)
	Cvo_MenuSession::Up(cnt);

    int x, y;
    int t;
    unsigned int m;
    Window w;

    XQueryPointer(Dpy(), Root(), &w, &w, &x, &y, &t, &t, &m); 

    if (x + XWidth() > SWid)
	x = SWid - XWidth();
    if (y + XHeight() > SHei)
	y = SHei - XHeight();

    if (x < 0)
	x = 0;
    if (y < 0)
	y = 0;
	

    ForceMoveWindow(x, y);

    filter = new Cvo_MenuFilter(this);
    Map();
}

void
Cvo_Menu::Start(int cnt, Cvo_Object *from)
{
    if (cnt >= 0)
	Cvo_MenuSession::Up(cnt);

    NewLayout();

    Window child;
    int x, y;
    Cvo_Window *win;

    from->Origin(&x, &y);
    XTranslateCoordinates(from->Dpy(), from->Parent()->Win(),
                          from->Root(), x, y, &x, &y, &child);

    if (win = from->ToWindow()) {
	win->ToXExtCoord(&x, &y);
	y += win->XHeight();
    } else
	y += from->Height();

    if (x + XWidth() > SWid)
	x = SWid - XWidth();
    if (y + XHeight() > SHei) {
	if (win)
	    y -= win->XHeight() + XHeight();
	else
	    y -= from->Height() + XHeight();
    }

    if (x < 0)
	x = 0;
    if (y < 0)
	y = 0;

//  y += from->BorderWidth() + VerticalPad();
    x -= from->BorderWidth();

    ForceMoveWindow(x, y);

    filter = new Cvo_MenuFilter(this);
    Map();
}

void
Cvo_Menu::StartCascade(int cnt, Cvo_Object *from)
{
    if (cnt >= 0)
	Cvo_MenuSession::Up(cnt);

    NewLayout();

    Window child;
    int x, y;
    Cvo_Window *win;

    from->Origin(&x, &y);
    XTranslateCoordinates(from->Dpy(), from->Parent()->Win(),
                          from->Root(), x, y, &x, &y, &child);

    if (win = from->ToWindow()) {
	win->ToXExtCoord(&x, &y);
	x += win->XWidth();
    } else
	x += from->Width();
    x += from->BorderWidth() + HorizontalPad();
    y -= from->BorderWidth();

    if (x + XWidth() > SWid) {
	x -= from->BorderWidth() + HorizontalPad();
	x -= win->XWidth();
	x -= from->BorderWidth() + HorizontalPad();
	x -= XWidth();
    }

    if (y + XHeight() > SHei)
	y = SHei - XHeight();

    if (x < 0)
	x = 0;
    if (y < 0)
	y = 0;

    ForceMoveWindow(x, y);

    filter = new Cvo_MenuFilter(this);
    Map();
}


void
Cvo_Menu::Start(int cnt, int x, int y)
{
    if (cnt >= 0)
	Cvo_MenuSession::Up(cnt);

    NewLayout();

    if (x + XWidth() > SWid)
	x = SWid - XWidth();
    if (y + XHeight() > SHei)
	y = SHei - XHeight();

    if (x < 0)
	x = 0;
    if (y < 0)
	y = 0;
	
    ForceMoveWindow(x, y);

    filter = new Cvo_MenuFilter(this);
    Map();
}

void
Cvo_Menu::MapEvent(XEvent *ev, void *)
{
    if (ev->xmap.event != ev->xmap.window)
	return;

    if (!filter) {
	filter = new Cvo_MenuFilter(this);
    } else if (filter->Last()) {
	int r = GrabPointer(EnterWindowMask|LeaveWindowMask,
			    curs->CursorValue());

        switch (r) {
        case GrabNotViewable:   break;
        case AlreadyGrabbed:    printf("AlreadyGrabbed\n"); break;
        case GrabFrozen:        printf("GrabFrozen\n"); break;
        case 0:                 break;
        default:                printf("Grab failed with %d\n", r); break;
        }    
        GrabKeyboard(); 
    }

    int x, y, cx, cy;

    RaiseWindow();
    FromXCoord(&x, &y);
    Origin(&cx, &cy);
    x -= cx;
    y -= cy;
    Cvo_Object *cw = DiscoverWindow(x, y, 0);
    while (cw && cw->Parent() != this)
        cw = cw->Parent();
    if (cw) {
        cw->Origin(&cx, &cy);
        XCrossingEvent ce;
        ce.type = EnterNotify;
        ce.detail = NotifyNonlinear;
        cw->SendXEvent((XEvent *)&ce);
    }
}

void
Cvo_Menu::UnmapEvent(XEvent *, void *)
{
    if (current)
	leave(current->label, 0, this);
}

Cvo_MenuFilter::Cvo_MenuFilter(Cvo_Menu *m)
{
    menu = m;
    entry = 0;

    if (Last() && menu->Mapped()) {
	int r = menu->GrabPointer(EnterWindowMask|LeaveWindowMask,
				  menu->curs->CursorValue());

	switch (r) {
	case GrabNotViewable:	break;
	case AlreadyGrabbed:	printf("AlreadyGrabbed\n"); break;
	case GrabFrozen:	printf("GrabFrozen\n"); break;
	case 0:			break;
	default:		printf("Grab failed with %d\n", r); break;
	}
	menu->GrabKeyboard();
    }
}

Cvo_MenuFilter::~Cvo_MenuFilter()
{
    menu->Unmap();
    if (menu->cascadefrom)
	menu->cascadefrom->cascade = 0;

    if (Last()) {
	menu->UngrabPointer();
	menu->UngrabKeyboard();
    }
    menu->filter = 0;
}

Cvo_MenuEntry *
Cvo_MenuFilter::Entry()  
{   
    return(entry);
}   

BOOL event_filter(Cvo_Object *, XEvent *);

Cvo_MenuSessionFilterResponse
Cvo_MenuFilter::Select(Cvo_MenuEntry *item)
{
    Cvo_MenuSessionFilterResponse r = item->Select();
    if (r == CvoMenuSessionFilterFinished) {
	entry = item;
    }
    return(r);
}

Cvo_MenuSessionFilterResponse
Cvo_MenuFilter::Filter(Cvo_Object *obj, XEvent *ev)
{
    int x = ev->xbutton.x_root;
    int y = ev->xbutton.y_root;
    menu->ComputeOriginFromRoot(&x, &y);

    Cvo_Object *win = menu->DiscoverWindow(x, y, True);

    switch(ev->type) {
    case KeyPress: {
	XKeyEvent *ke = (XKeyEvent*)ev;
	if (ke->keycode) {
	    Cvo_MenuEntry *items = menu->MenuEntries();
	    while (items) {
		if (items->flags & CvoM_MENU_LABEL) {
		    Cvo_MenuLabel *ml = (Cvo_MenuLabel *)items->label;

		    if (ml->Accelerator() == ke->keycode) {
			return(Select(items));
		    }
		}
		items = items->next;
	    }

	    /*
	     * If we have a cascaded menu then we always ignore keystrokes
	     * as the cascade has dealt with them if it can.
    	     * But, we do not let anyone else get to them either, as
	     * as we don't want to be switching menus while cascaded.
	     */
	    if (menu->cascade)
		return(CvoMenuSessionFilterProcessed);;
	    switch (XKeycodeToKeysym(obj->Dpy(), ke->keycode, 0)) {
    	    case XK_Escape:
		return(CvoMenuSessionFilterFinished);
    	    case XK_Up:
    	    	if (items = menu->Current()) {
    	    	    while ((items = items->prev) &&
			   (items->flags & (CvoM_ALWAYSFLAT|CvoM_SEPARATOR)))
			;
    	    	    if (items) {
			menu->enter(items->label, 0, menu);
			return(CvoMenuSessionFilterProcessed);
		    } else
			menu->leave(menu->Current()->label, 0, menu);
		}
	    	break;
    	    case XK_Down:
    	    	if (items = menu->Current()) {
    	    	    while ((items = items->next) &&
			   (items->flags & (CvoM_ALWAYSFLAT|CvoM_SEPARATOR)))
			;
    	    	    if (items) {
			menu->enter(items->label, 0, menu);
			return(CvoMenuSessionFilterProcessed);
		    }

		} else if (items = menu->MenuEntries()) {
    	    	    while (items && (items->flags & (CvoM_ALWAYSFLAT|CvoM_SEPARATOR)))
			items = items->next;
    	    	    if (items) {
			menu->enter(items->label, 0, menu);
			return(CvoMenuSessionFilterProcessed);
		    }
    	    	}
	    	break;
    	    case XK_Right:
    	    	if ((items = menu->Current())&&(items->flags & CvoM_CASCADE)) {
		    items->Cascade();
		    return(CvoMenuSessionFilterProcessed);
		}
		break;
    	    case XK_Left:
	    	if (menu->cascadefrom)
		    return(CvoMenuSessionFilterDeleteMe);
		break;
	    case XK_KP_Enter:
	    case XK_Return:
    	    	if (items = menu->Current()) {
		    return(Select(items));
		}
		return(CvoMenuSessionFilterFinished);
	    }
	}
	break;
      }
    case ButtonRelease:
	if(win && win->RootObject() == menu->RootObject()) {
	    Cvo_MenuEntry *items = menu->MenuEntries();

    	    if (menu->Current())
	    	return(Select(menu->Current()));
	    while (items) {
		Cvo_Object *obj = win;
		while (obj && obj != items->label)
		    obj = obj->Parent();
		if (obj)
		    return(Select(items));
		items = items->next;
	    }
//
// Adding this back in will basically ignore any button release on
// the edge of a menu.  This might be desirable
//
//	    return(CvoMenuSessionFilterProcessed);
	}
	break;
    }
    return(CvoMenuSessionFilterReturn);
}
