//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: LabelMatrix.cc,v 1.4 1994/09/21 18:18:28 prb Exp $"); }
//
// This code was initially contributed by Paul Algren 11-92
//
#include <string.h>
#include <Cvo/MatrixViewPort.h++>
#include <Cvo/LabelMatrixViewPort.h++>

inline int
max(int x, int y)
{
    return(x > y ? x : y);
}

static Cvo_Default defs[] = {
    "*horizontalLabelWindow.Sunken: True",
    "*verticalLabelWindow.Sunken: True",
};

CONSTRUCTORS(Cvo_LabelMatrixViewPort, Cvo_Window, "CvoLabelMatrixViewPort")

Cvo_LabelMatrixViewPort::LabelFrame::LabelFrame(char *n, Cvo_Object *p)
	: Cvo_Window(n, "CvoLabelFrame", p)
{
    DontLayout();
}

BOOL
Cvo_LabelMatrixViewPort::LabelFrame::SetMapped(BOOL v)
{
    int ret = False;

    if (mapped != v && Object()) {
	if (ret = mapped = v)
	    XMapWindow(Dpy(), Object());
	else
	    XUnmapWindow(Dpy(), Object());
    }
    return(ret);
}

void
Cvo_LabelMatrixViewPort::_Init()
{
    row_width = 0;
    col_height = 0;

    rlw = new LabelFrame("verticalLabelWindow", this);
    rlf = new Cvo_Frame("labelFrame", rlw);

    clw = new LabelFrame("horizontalLabelWindow", this);
    clf = new Cvo_Frame("labelFrame", clw);

    mvp = new Cvo_MatrixViewPort("matrixViewPort", this);
    mvp->ExpandFrame();
    mvp->Register(CvoWindowViewPortMoveEvent, Cvo_LMVP_LabelMoveHandler, this);
}

void Cvo_LabelMatrixViewPort::AddHorizontal()
{
    mvp->AddHorizontal();
}

void Cvo_LabelMatrixViewPort::AddVertical()
{
    mvp->AddVertical();
}

void Cvo_LabelMatrixViewPort::AddLabel(Cvo_Window *but, Cvo_MatrixSlice *slc)
{
    if (slc->Matrix() == mvp->Matrix()) {
	slc->SetLabel(but);
    }
}

void Cvo_LabelMatrixViewPort::StandardLayoutChildren(int force, int olay)
{
    if (olay) {
	return;
    }
    
    int rs = layout.ignoreshadow ? 0 : raise;

    int hsep = mvp->Matrix()->Horz_sep();
    int vsep = mvp->Matrix()->Vert_sep();

    int rwin_w, rwin_h;
    int cwin_w, cwin_h;
    if (row_width > 0) {
	rwin_w = row_width + 2*vsep;
	mvp->Layout()->desired.width = width;
	mvp->Layout()->desired.width -= rwin_w;
	mvp->Layout()->desired.width -= (rlw->HorizontalPad() +
					 rlw->BorderWidth())*2 + rs;
	mvp->Layout()->desired.width -= (rlw->HorizontalPad() +
					 rlw->BorderWidth())*2;
	mvp->Layout()->x = width - mvp->Layout()->desired.width;
	mvp->Layout()->desired.width -= HorizontalPad() + BorderWidth() + rs;
    } else {
	rwin_w = 0;
	mvp->Layout()->desired.width = width - (HorizontalPad() +
						 BorderWidth())*2 + rs;
	mvp->Layout()->x = BorderWidth() + HorizontalPad();
    }
	
    if (col_height > 0) {
	cwin_h = col_height + 2*hsep;
	mvp->Layout()->desired.height = height;
	mvp->Layout()->desired.height -= cwin_h;
	mvp->Layout()->desired.height -= (clw->VerticalPad() +
					  clw->BorderWidth())*2 + rs;
	mvp->Layout()->desired.height -= (clw->VerticalPad() +
					  clw->BorderWidth())*2;
	mvp->Layout()->y = height - mvp->Layout()->desired.height;
	mvp->Layout()->desired.height -= VerticalPad() + BorderWidth() + rs;
    } else {
	cwin_h = 0;
	mvp->Layout()->desired.height = height - (VerticalPad() +
						 BorderWidth())*2 + rs;
	mvp->Layout()->y = BorderWidth() + VerticalPad();
    }

    int mywidth;
    if (mvp->Layout()->maximum.width &&
	mvp->Layout()->desired.width > mvp->Layout()->maximum.width) {
	mywidth = mvp->Layout()->maximum.width;
    } else {
	mywidth = mvp->Layout()->desired.width;
    }

    int myheight;
    if (mvp->Layout()->maximum.height &&
	mvp->Layout()->desired.height > mvp->Layout()->maximum.height) {
	myheight = mvp->Layout()->maximum.height;
    } else {
	myheight = mvp->Layout()->desired.height;
    }

    mvp->LayoutFunction(force|1, 1, mywidth, myheight);

    int rx = 0; int ry = 0;
    int prx = 0; int pry = 0;

    mvp->ClipFrame()->ComputeOriginFromRoot(&rx, &ry);
    ComputeOriginFromRoot(&prx, &pry);

    int mx = 0; int my = 0;
    clw->ToXCoord(&mx, &my);

    my += clw->BorderWidth() + clw->VerticalPad();
    mx = (-rx) - (-prx); 	// match the west edge of the vp

    cwin_w = mvp->ClipFrame()->Width();

    if (cwin_h && cwin_w &&
	(clw->Width() != cwin_w || clw->Height() != cwin_h)) {
	clw->MoveResizeWindow(mx, my, cwin_w, cwin_h, Cvo_LAYOUTTAG);
    }

    if (cwin_h > 0) {
	clf->MoveResizeWindow(0, 0, cwin_w, cwin_h, Cvo_LAYOUTTAG);
	if (clw->SetMapped())
	    clf->Map(1);
    } else {
	clw->SetMapped(False);
    }

    mx = 0; my = 0;
    rlw->ToXCoord(&mx, &my);

    my = (-ry) - (-pry); 	// match the north edge of the vp
    mx += rlw->BorderWidth() + rlw->HorizontalPad();

    rwin_h = mvp->ClipFrame()->Height();

    if (rwin_h && rwin_w &&
	(rlw->Height() != rwin_h || rlw->Width() != rwin_w)) {
	rlw->MoveResizeWindow(mx, my, rwin_w, rwin_h, Cvo_LAYOUTTAG);
    }

    if (rwin_w > 0) {
	rlf->MoveResizeWindow(0, 0, rwin_w, rwin_h, Cvo_LAYOUTTAG);
	if (rlw->SetMapped())
	    rlf->Map(1);
    } else {
	rlw->SetMapped(False);
    }

    Pan_Labels();
}

void
Cvo_LMVP_LabelMoveHandler(Cvo_Object *, XEvent *, void *d)
{
    Cvo_LabelMatrixViewPort *lmvp = (Cvo_LabelMatrixViewPort *) d;
    
    lmvp->Pan_Labels();
}

void
Cvo_LabelMatrixViewPort::Pan_Labels()
{
    int xoffset, yoffset;

    int rs = layout.ignoreshadow ? 0 : raise;

    mvp->Frame()->XOrigin(&xoffset, &yoffset);

    int hsep = mvp->Matrix()->Horz_sep();
    int vsep = mvp->Matrix()->Vert_sep();

    int mx = 0; int my = 0;
    int mw = 0; int mh = 0;

    Cvo_MatrixSlice *slc;
    slc = mvp->Matrix()->Col();
    while (slc) {
	if (slc->Label()) {
	    mx = slc->Org() + xoffset;
	    my = hsep;
	    slc->Label()->ToXCoord(&mx, &my);
	    mw = slc->Des() - (slc->Label()->BorderWidth() +
			       slc->Label()->HorizontalPad()*2 +rs);
	    mh = col_height - (slc->Label()->BorderWidth() +
			       slc->Label()->VerticalPad()*2 + rs);

	    slc->Label()->MoveResizeWindow(mx, my, mw, mh, Cvo_LAYOUTTAG);
	}
	slc = slc->Next();
    }
    slc = mvp->Matrix()->Row();
    while (slc) {
	if (slc->Label()) {
	    mx = vsep;
	    my = slc->Org() + yoffset;
	    slc->Label()->ToXCoord(&mx, &my);
	    mw = row_width - (slc->Label()->BorderWidth() +
			      slc->Label()->HorizontalPad()*2 + rs);
	    mh = slc->Des() - (slc->Label()->BorderWidth() +
			       slc->Label()->VerticalPad()*2 + rs);

	    slc->Label()->MoveResizeWindow(mx, my, mw, mh, Cvo_LAYOUTTAG);
	}
	slc = slc->Next();
    }
}

int
Cvo_LabelMatrixViewPort::StandardComputeLayoutSize(int force)
{
    Cvo_FrameSize mymin, mydes;

    ComputeUserSizes(mymin, mydes);

    layout.minimum.height = 0;
    layout.minimum.width = 0;

    mvp->ComputeLayoutSize(force);
    layout.minimum.height = mvp->Layout()->minimum.height;
    layout.minimum.width = mvp->Layout()->minimum.width;

    row_width=0;
    for (Cvo_MatrixSlice *rowptr = mvp->Matrix()->Row(); rowptr;
	 rowptr = rowptr->Next()) {
	if (rowptr->Label()) {
	    Cvo_LayoutWindow* obj = rowptr->Label()->ToLayoutWindow();
	    if (obj) {
		row_width = max(row_width, obj->Layout()->minimum.width);
	    }
	}
    }

    col_height=0;
    for (Cvo_MatrixSlice *colptr = mvp->Matrix()->Col(); colptr;
	 colptr = colptr->Next()) {
	if (colptr->Label()) {
	    Cvo_LayoutWindow* obj = colptr->Label()->ToLayoutWindow();
	    if (obj) {
		col_height = max(col_height, obj->Layout()->minimum.height);
	    }
	}
    }
    
    int rs = layout.ignoreshadow ? 0 : raise;

    int r_hpad = 0;
    int r_vpad = 0;
    if (rlw) {
	r_vpad = (rlw->BorderWidth() + rlw->VerticalPad());
	r_hpad = (rlw->BorderWidth() + rlw->HorizontalPad());
    }

    int r_hpads = r_hpad * 2 + rs;
    int r_vpads = r_vpad * 2 + rs;

    int c_hpad = 0;
    int c_vpad = 0;
    if (clw) {
	c_vpad = (clw->BorderWidth() + clw->VerticalPad());
	c_hpad = (clw->BorderWidth() + clw->HorizontalPad());
    }

    int c_hpads = c_hpad * 2 + rs;
    int c_vpads = c_vpad * 2 + rs;

    int hsep = mvp->Matrix()->Horz_sep();
    int vsep = mvp->Matrix()->Vert_sep();

    if (col_height) {
	layout.minimum.height += col_height + 2*hsep + c_vpads + c_vpad;
    }
    if (row_width) {
	layout.minimum.width += row_width + 2*vsep + r_hpads + r_hpad;
    }

    layout.minimum.height += ((borderWidth + verticalPad) * 2 + rs)*2;
    layout.minimum.width += ((borderWidth + horizontalPad) * 2 + rs)*2;

    if (layout.minimum.width < mymin.width)
	layout.minimum.width = mymin.width;

    if (layout.minimum.height < mymin.height)
	layout.minimum.height = mymin.height;

    if (mydes.width > layout.minimum.width)
	layout.desired.width = mydes.width;
    else
	layout.desired.width = layout.minimum.width;

    if (mydes.height > layout.minimum.height)
	layout.desired.height = mydes.height;
    else
	layout.desired.height = layout.minimum.height;

    if (layout.maximum.width && layout.maximum.width < layout.minimum.width)
	layout.maximum.width = layout.minimum.width;
    if (layout.maximum.height && layout.maximum.height < layout.minimum.height)
	layout.maximum.height = layout.minimum.height;
    
    return (CheckLayout());
}

