//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: InputViewPort.cc,v 1.12 1995/06/04 07:14:49 prb Exp $"); }

#include <Cvo/InputViewPort.h++>
#include <ctype.h>
#if defined(I18N) && !defined(_RUNE_MAGIC_1)
#include <wctype.h>
#endif  
            
#if     !defined(iswspace)
#define iswspace(c) isspace(c)
#define iswpunct(c) ispunct(c)
#endif

static Cvo_Default defs[] = {
    "*CvoInputViewPort*FontFamily:		Courier",
//  "*CvoInputViewPort*horizontalScrollBar:	False",
    "*CvoInputViewPort.BorderWidth:		0",
};

CVO_INIT_BIND(Cvo_InputViewPort)
CVO_DECL_BIND(Cvo_InputViewPort, _f01, "Insert",    		Insert)
CVO_DECL_BIND(Cvo_InputViewPort, _f02, "InsertLine",		InsertLine)
CVO_DECL_BIND(Cvo_InputViewPort, _f03, "Delete",    		Delete)
CVO_DECL_BIND(Cvo_InputViewPort, _f04, "Forward",   		Forward)
CVO_DECL_BIND(Cvo_InputViewPort, _f05, "Backward",  		Backward)
CVO_DECL_BIND(Cvo_InputViewPort, _f06, "Upward",    		Upward)
CVO_DECL_BIND(Cvo_InputViewPort, _f07, "Downward",  		Downward)
CVO_DECL_BIND(Cvo_InputViewPort, _f08, "Return",    		Return)
CVO_DECL_BIND(Cvo_InputViewPort, _f09, "Home",      		Home)
CVO_DECL_BIND(Cvo_InputViewPort, _f10, "Clear",     		ClearKey)
CVO_DECL_BIND(Cvo_InputViewPort, _f11, "KillLine",  		DeleteLine)
CVO_DECL_BIND(Cvo_InputViewPort, _f12, "insert-selection",	SelectInsert)
CVO_DECL_BIND(Cvo_InputViewPort, _f13, "select-start",		SelectStart)
CVO_DECL_BIND(Cvo_InputViewPort, _f14, "select-extend",		SelectExtend)
CVO_DECL_BIND(Cvo_InputViewPort, _f15, "start-extend",		StartExtend)
CVO_DECL_BIND(Cvo_InputViewPort, _f16, "select-end",		SelectEnd)
CVO_DECL_BIND(Cvo_InputViewPort, _f17, "delete-selection",	SelectKill)
//  { "DeleteLine",		&Cvo_InputViewPort::DeleteLine), },

CVO_START_BIND(Cvo_InputViewPort)
CVO_BIND(_f01)
CVO_BIND(_f02)
CVO_BIND(_f03)
CVO_BIND(_f04)
CVO_BIND(_f05)
CVO_BIND(_f06)
CVO_BIND(_f07)
CVO_BIND(_f08)
CVO_BIND(_f09)
CVO_BIND(_f10)
CVO_BIND(_f11)
CVO_BIND(_f12)
CVO_BIND(_f13)
CVO_BIND(_f14)
CVO_BIND(_f15)
CVO_BIND(_f16)
CVO_BIND(_f17)
CVO_END_BIND(Cvo_InputViewPort, Cvo_TextViewPort)

static char *trans = "\
        <Key>Home: Home() \n\
        <Key>Clear: Clear() \n\
        <Key>Delete: Delete() \n\
    Ctrl<Key>u: KillLine() \n\
        <Key>BackSpace: Delete() \n\
        <Key>Enter: InsertLine() \n\
        <Key>Return: InsertLine() \n\
        <Key>Linefeed: Return() \n\
        <Key>KP_Enter: Return() \n\
    Ctrl<Key>h: Backward() \n\
    Ctrl<Key>j: Downward() \n\
    Ctrl<Key>k: Upward() \n\
    Ctrl<Key>l: Forward() \n\
    Ctrl<Key>m: Return() \n\
        <Key>Left: Backward() \n\
        <Key>Right: Forward() \n\
        <Key>Up: Upward() \n\
        <Key>Down: Downward() \n\
        <Key>: Insert() \n\
        <Btn1Down>:select-start() \n\
        <Btn1Down>(2):select-start(WORD) \n\
        <Btn1Down>(3):select-start(LINE) \n\
        <Btn1Motion>:select-extend() \n\
        <Btn1Up>:select-end(PRIMARY, CUT_BUFFER0) \n\
        <Btn2Up>:insert-selection(PRIMARY, CUT_BUFFER0) \n\
        <Btn3Down>:start-extend() \n\
        <Btn3Motion>:select-extend() \n\
        <Btn3Up>:select-end(PRIMARY, CUT_BUFFER0) \n\
";

CONSTRUCTORS(Cvo_InputViewPort, Cvo_TextViewPort, "CvoInputViewPort")
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_InputViewPort)

void
Cvo_InputViewPort::_Init()
{
    page = &tpage;
    page->SetWindow(text);
    text->NoTranslations();
    if (vertical)
	vertical->SetMaximum(page->NumberLines());

    row = 0;
    col = 0;
    orow = 0;
    ocol = 0;
    ssrow = 0;
    sscol = 0;
    serow = 0;
    secol = 0;

    tpage.AddEntry(0);
    text->MoveCursor(0,0);
    text->ShowCursor();
    text->Outline();
    text->InitializeFocus();

    NeedInputContext();
    AddTranslations(trans);
    Register(CvoFocusInEvent, &Cvo_InputViewPort::FocusInEvent);
    Register(CvoFocusOutEvent, &Cvo_InputViewPort::FocusOutEvent);
    Register(SelectionClear, &Cvo_InputViewPort::SelectClear);
    Cvo_Object::Register(SelectionRequest, &Cvo_Object::SelectRequest);

    sel = 0;
    if (Color()) {
	char *fg = GetResource(_QselectionForeground, _QSelectionForeground);
	char *bg = GetResource(_QselectionBackground, _QSelectionBackground);

	sel = text->NewTextAttribute();
	if (fg)
	    sel->SetForeground(Cvo_Color(text, fg));
	if (bg)
	    sel->SetBackground(Cvo_Color(text, bg));
	else
	    sel->SetBackground(text->CurrentBackground()->Raised());
    } else
	sel = text->TextAttribute()->Reverse();
}

void
Cvo_InputViewPort::MoveCursor(int r, int c)
{
    Preset();
    row = r;
    col = c;
    Update();
}

void
Cvo_InputViewPort::ClearSelection()
{   CVO_ENTER

    if (ssrow < serow) {
	for (int i = ssrow; i <= serow; ++i)
	    tpage.SetAttributes(i, text->TextAttribute());
    } else {
	for (int i = serow; i <= ssrow; ++i)
	    tpage.SetAttributes(i, text->TextAttribute());
    }

    CVO_VOID_RETURN
}   

void
Cvo_InputViewPort::SelectClear(XEvent *e, void *d)
{   CVO_ENTER

    if (ssrow != serow || sscol != secol) {
	Cvo_Object::SelectClear(e, d);
	tpage.DisableDisplay();

	ClearSelection();

	tpage.EnableDisplay();
    }
    ssrow = serow = sscol = secol = 0;
    CVO_VOID_RETURN
}   

void
Cvo_InputViewPort::InsertLine(XEvent *, int, char **)
{
    Preset();
    ClearSelection();

    tpage.GetLine(row, &tbuf);
    tpage.AddEntry(row+1);
    if (tbuf.wcLength() > col) {
	wchar_t *t = tbuf;
	tpage.ReplaceLine(t + col, row+1);
	tpage.DeleteAt(row, col, Cvo_HL_MAX_COLUMN);
    }
    col = 0;
    ++row;
    Update();
}

void
Cvo_InputViewPort::SelectKill(XEvent *ev, int ac, char **av)
{
    if (ssrow == serow && sscol == secol) {
	Delete(ev, ac, av);
	return;
    }
    Preset();

    orow = ocol = -1;
    ClearSelection();
    if (serow < ssrow) {
	int i = serow;
	serow = ssrow;
	ssrow = i;

	i = secol;
	secol = sscol;
	sscol = i;
    }
    if (ssrow == serow) {
	row = ssrow;
	if (sscol < secol) {
	    col = sscol;
	    tpage.DeleteAt(ssrow, sscol, secol - sscol);
	} else {
	    col = secol;
	    tpage.DeleteAt(ssrow, secol, sscol - secol);
	}
    } else {
	row = ssrow;
    	col = sscol;
    	if (sscol == 0) {
	    --ssrow;
	    tpage.DeleteAt(serow, 0, secol);
    	} else {
	    tpage.DeleteAt(ssrow, sscol, Cvo_HL_MAX_COLUMN);
	    tpage.DeleteAt(serow, 0, secol);
	    tpage.GetLine(serow, &tbuf);
    	    tpage.AppendToLine(tbuf.wcValue(), ssrow);
    	    ++serow;
    	}

	for (int i = ssrow + 1; i < serow; ++i)
	    tpage.DeleteEntry(ssrow + 1);

    }

    Update();
    ssrow = serow = sscol = secol = 0;
}

void
Cvo_InputViewPort::AdjustSelection(int &ay, int &ax, int &y, int &x)
{   
    if (linemode) {
        if (ay > y) {
            x = 0;
            ax = Cvo_HL_MAX_COLUMN;
        } else {
            ax = 0;
            x = Cvo_HL_MAX_COLUMN;
        }
    } else if (wordmode) {
        if (ay > y || (ay == y && ax > x)) {
	    int t = y;
    	    y = ay;
    	    ay = t;
    	    t = x;
    	    x = ax;
    	    ax = t;
    	}

    	Cvo_CharacterBuffer cb;
	int gy = -1;
    	int ln;

    	if (ax > 0 && ax < (ln = tpage.Length(ay))) {
	    tpage.GetLine(gy = ay, &cb);
	    wchar_t *text = cb;
	    if (iswspace(text[ax])) {
		while (ax > 0 && iswspace(text[ax-1]))
		    --ax; 
	    } else if (iswpunct(text[ax])) {
		while (ax > 0 && iswpunct(text[ax-1]))
		    --ax; 
	    } else {
		while (ax > 0 && !iswpunct(text[ax-1]) && !iswspace(text[ax-1]))
		    --ax; 
	    }       
    	}
    	if (x >= 0 && x < (ln = tpage.Length(y))) {
    	    if (y != gy)
		tpage.GetLine(y, &cb);
	    wchar_t *text = cb;
	    if (iswspace(text[x])) {
		while (x + 1 < ln && iswspace(text[x+1]))
		    ++x; 
	    } else if (iswpunct(text[x])) {
		while (x + 1 < ln && iswpunct(text[x+1]))
		    ++x; 
	    } else {
		while (x + 1 < ln && !iswpunct(text[x+1])
				  && !iswspace(text[x+1]))
		    ++x;                 
	    }       
	    if (x < ln)
		++x;
    	}
    }   
}   

void
Cvo_InputViewPort::DrawSelection()
{
    int sr = ssrow;
    int sc = sscol;
    int er = serow;
    int ec = secol;

    AdjustSelection(sr, sc, er, ec);

    if (sr == er) {
	if (sc == ec)
	    return;
	if (sc < ec)
	    tpage.SetAttributes(sr, sc, ec - 1, sel);
	else
	    tpage.SetAttributes(sr, ec, sc - 1, sel);
    } else if (sr < er) {
	tpage.SetAttributes(sr, sc, Cvo_HL_MAX_COLUMN, sel);
    	if (ec)
	    tpage.SetAttributes(er, 0, ec - 1, sel);
	for (int i = sr + 1; i < er; ++i)
	    tpage.SetAttributes(i, sel);
    } else {
	tpage.SetAttributes(er, ec, Cvo_HL_MAX_COLUMN, sel);
    	if (sc)
	    tpage.SetAttributes(sr, 0, sc - 1, sel);
	for (int i = er + 1; i < sr; ++i)
	    tpage.SetAttributes(i, sel);
    }
}

void
Cvo_InputViewPort::FocusInEvent(XEvent *, void *)
{
    Cvo_AnyEvent ev;

    text->FakeFocus(True);
    text->SendEvent(CvoFocusInEvent, &ev);
}

void
Cvo_InputViewPort::FocusOutEvent(XEvent *, void *)
{
    Cvo_AnyEvent ev;

    text->FakeFocus(False);
    text->SendEvent(CvoFocusOutEvent, &ev);
}

void
Cvo_InputViewPort::Enter(Cvo_CharacterBuffer &cb) 
{
    Enter((wchar_t *)cb);
}
 
void
Cvo_InputViewPort::Enter(wchar_t *wp)
{
    Preset();
    ClearSelection();
    while (*wp) {
	switch (*wp) {
    	case '\n':
	    ++row;
	    col = 0;
	    break;
    	case '\r':
	    col = 0;
	    break;
	default:
	    if (isprint(*wp)) {
		tpage.InsertAt(row, col);
		tpage.ReplaceAt(row, col++, wp, 1);
	    }
	}
	++wp;
    }
    Update();
}

void
Cvo_InputViewPort::GetText(Cvo_CharacterBuffer *cb)
{
    Cvo_CharacterBuffer lcb;
    wchar_t newline = '\n';

    cb->Truncate(0);

    for (int i = 0; i < tpage.NumberLines(); ++i) {
    	tpage.GetLine(i, &lcb);

    	wchar_t *wt = lcb;
    	int n = lcb.wcLength();

    	while (n > 0 && isspace(wt[n-1]))
	    --n;
    	cb->Append(wt, n);
	cb->Append(&newline, 1);
    }

    wchar_t *wt = *cb;
    int n = cb->wcLength();

    while (n > 0 && isspace(wt[n-1]))
	--n;
    wt[n++] = '\n';
    cb->Truncate(n);
}

void
Cvo_InputViewPort::GetText(char **txt)
{
    GetText(&tbuf);
    *txt = tbuf;
}

void
Cvo_InputViewPort::GetText(wchar_t **txt)
{
    GetText(&tbuf);
    *txt = tbuf;
}

void
Cvo_InputViewPort::Enter(char *cp)
{
    Cvo_CharacterBuffer cb;
    
    cb.Set(cp);
    Enter(cb);
}

void
Cvo_InputViewPort::KillLine(XEvent *, int, char **)
{
    Preset();

    ClearSelection();
    tpage.DeleteAt(row, 0, Cvo_HL_MAX_COLUMN);
    col = 0;

    Update();
}

void
Cvo_InputViewPort::DeleteLine(XEvent *, int, char **)
{
    Preset();

    ClearSelection();
    tpage.DeleteEntry(row);

    Update();
}

void
Cvo_InputViewPort::Delete(XEvent *, int, char **)
{
    Preset();

    ClearSelection();
    if (col > 0 || row == 0) {
	if (col > 0)
	    --col;
	tpage.DeleteAt(row, col);
    } else {
    	col = tpage.Length(row - 1);
	tpage.GetLine(row, &tbuf);
    	tpage.AppendToLine(tbuf.wcValue(), row -1);
    	tpage.DeleteEntry(row);
    	--row;
    }

    Update();
}

void
Cvo_InputViewPort::ClearKey(XEvent *, int, char **)
{
    Preset();
    row = 0;
    col = 0;
    ssrow = serow = 0;
    sscol = secol = 0;
    tpage.ClearLines();
    Update();
}

void
Cvo_InputViewPort::Home(XEvent *, int, char **)
{
    Preset();
    row = 0;
    col = 0;
    Update();
}

void
Cvo_InputViewPort::Backward(XEvent *, int, char **)
{
    Preset();
    if (col)
	--col;
    else if (row) {
	col = tpage.Length(--row);
    }
    Update();
}

void
Cvo_InputViewPort::Forward(XEvent *, int, char **)
{
    Preset();
    ++col;
    Update();
}

void
Cvo_InputViewPort::Upward(XEvent *, int, char **)
{
    Preset();
    if (row)
	--row;
    Update();
}

void
Cvo_InputViewPort::Downward(XEvent *, int, char **)
{
    Preset();
    ++row;
    Update();
}

void
Cvo_InputViewPort::Return(XEvent *, int, char **)
{
    Preset();
    col = 0;
    ++row;
    Update();
}

void
Cvo_InputViewPort::Insert(XEvent *ev, int, char **)
{
    Cvo_KeyTextEvent *kte = (Cvo_KeyTextEvent *)ev;

    if (kte->have_text) {
	Enter(*kte->text);
    }
}

void
Cvo_InputViewPort::SelectInsert(XEvent *, int, char **)
{   
    Cvo_CharacterBuffer cb;
    
    if (GetSelection(&cb)) {
        Enter(cb);
    } 
}   

void
Cvo_InputViewPort::SelectStart(XEvent *ev, int, char **av)
{   
    int x = 0;
    int y = 0;

    BOOL cont;
    
    if (av && !strcasecmp(av[0], "Word")) {
        cont = charmode;
        charmode = linemode = False;
        wordmode = True;
    } else if (av && !strcasecmp(av[0], "Line")) {
        cont = wordmode;
        charmode = wordmode = False;
        linemode = True;
    } else {
        cont = linemode;
        linemode = wordmode = False;
        charmode = True;
    }   

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	text->Origin(&x, &y);
	x = ev->xbutton.x - x;
	y = ev->xbutton.y - y;
    } else if (ev->type == MotionNotify) {
	text->Origin(&x, &y);
	x = ev->xmotion.x - x;
	y = ev->xmotion.y - y;
    }

    text->PixelToCharacter(&y, &x);
    y += FirstLine();
    tpage.DisableDisplay();
    ClearSelection();

    if (cont) {
	serow = y;
	secol = x;
	DrawSelection();
    } else {
	ssrow = serow = y;
	sscol = secol = x;
    }

    tpage.EnableDisplay();
}

void
Cvo_InputViewPort::SelectExtend(XEvent *ev, int, char **)
{   
    int x = 0;
    int y = 0;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	text->Origin(&x, &y);
	x = ev->xbutton.x - x;
	y = ev->xbutton.y - y;
    } else if (ev->type == MotionNotify) {
	text->Origin(&x, &y);
	x = ev->xmotion.x - x;
	y = ev->xmotion.y - y;
    }

    text->PixelToCharacter(&y, &x);
    y += FirstLine();

    tpage.DisableDisplay();
    ClearSelection();
    serow = y;
    secol = x;
    DrawSelection();
    tpage.EnableDisplay();
}

void
Cvo_InputViewPort::StartExtend(XEvent *ev, int, char **)
{   
    int x = 0;
    int y = 0;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	text->Origin(&x, &y);
	x = ev->xbutton.x - x;
	y = ev->xbutton.y - y;
    } else if (ev->type == MotionNotify) {
	text->Origin(&x, &y);
	x = ev->xmotion.x - x;
	y = ev->xmotion.y - y;
    }

    text->PixelToCharacter(&y, &x);
    y += FirstLine();
    tpage.DisableDisplay();
    ClearSelection();
    serow = y;
    secol = x;
    DrawSelection();
    tpage.EnableDisplay();
}

void
Cvo_InputViewPort::SelectEnd(XEvent *ev, int, char **)
{   
    int x = 0;
    int y = 0;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	text->Origin(&x, &y);
	x = ev->xbutton.x - x;
	y = ev->xbutton.y - y;
    } else if (ev->type == MotionNotify) {
	text->Origin(&x, &y);
	x = ev->xmotion.x - x;
	y = ev->xmotion.y - y;
    }

    text->PixelToCharacter(&y, &x);
    y += FirstLine();

    Cvo_CharacterBuffer sb;
    Cvo_CharacterBuffer tb;

    if (ssrow == serow) {
	if (sscol == secol) {
	    MoveCursor(ssrow, sscol);
	    return;
	}
	int x, y;

	if (sscol < secol) {
	    x = sscol;
	    y = secol;
	} else {
	    y = sscol;
	    x = secol;
	}
	tpage.GetLine(ssrow, &tb);
    	if (y > tb.wcLength())
		y = tb.wcLength();
	sb.Set(tb.wcValue() + x, y - x);
	SetSelection(sb);
	return;
    }
    int sr, er;
    int sc, ec;

    if (ssrow < serow) {
	sr = ssrow;
	er = serow;
	sc = sscol;
	ec = secol;
    } else {
	sr = serow;
	er = ssrow;
	sc = secol;
	ec = sscol;
    }

    wchar_t newline = '\n';

    tpage.GetLine(sr, &tb);
    sb.Set(tb.wcValue() + sc, tb.wcLength() - sc);
    sb.Append(&newline, 1);

    if (er >= tpage.NumberLines()) {
	er = tpage.NumberLines();
	ec = 0;
    }
    if (er > sr) {
	for (int i = sr + 1; i < er; ++i) {
	    tpage.GetLine(i, &tb);
	    sb.Append(tb.wcValue(), tb.wcLength());
	    sb.Append(&newline, 1);
	}
	if (ec) {
	    tpage.GetLine(er, &tb);
	    sb.Append(tb.wcValue(), ec);
    	}
    }

    SetSelection(sb);
}

void                
Cvo_InputViewPort::Preset()
{
    orow = row;
    ocol = col;

    text->HideCursor();
    tpage.DisableDisplay();
}

void                
Cvo_InputViewPort::Update()
{
    if (col != ocol || row != orow) {
	if (row >= tpage.NumberLines()) {
    	    tpage.AddEntry(row);
    	}
	if (tpage.Length(row) < col) {
	    tpage.InsertAt(row, col - 1);
    	}
	Cvo_TextViewPort::MoveCursor(row, col);
    }
    tpage.EnableDisplay();
    text->ShowCursor();
    text->Flush(2);
}
