//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: InputOnly.cc,v 1.3 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/InputOnly.h++>

static Cvo_Default defs[] = {
    "*CvoInputOnly.Cursor:",
};

CONSTRUCTORS(Cvo_InputOnly, Cvo_LayoutWindow, "CvoInputOnly")

void
Cvo_InputOnly::_Create()
{   CVO_ENTER
    _cvo_debug(CvoDebug_Create, "Cvo_Create(%s, %s)\n", Name(), Class());

    Window pwin;
    XSetWindowAttributes xat;
    CARD32 xatmask = 0;
    char *xrp;

    if (Object())
	CVO_VOID_RETURN
    Cvo_Lock lock;

    Cvo_LayoutWindow *lp = parent ? parent->ToLayoutWindow() : 0;

    if (parent) {
	if (lp && !lp->Win())
	    lp->Create();
	pwin = parent->Win();
	xat.override_redirect = True;
    } else {
	pwin = DefaultRootWindow(Dpy());
	xat.override_redirect = override ? True : False;
    }

    xatmask = CWOverrideRedirect;

    raise = 0;

    width = layout.desired.width ? layout.desired.width : 1;
    height = layout.desired.height ? layout.desired.height : 1;

    ComputeLocation();
    window = XCreateWindow(Dpy(), pwin,
			   layout.x, layout.y, width, height,
			   borderWidth,
			   (int)CopyFromParent,		// Depth
			   InputOnly,
			   CopyFromParent,		// Visual
			   xatmask, &xat);
    if (!Object()) {
	Cvo_Failure(CvoE_FATAL, CvoE_CANTOPEN,
		    "Cannot create window ``%s(%s)''\n",
		     Name(), Class());
    }
    InsertIntoHashList();

    selectMask |= StructureNotifyMask | SubstructureNotifyMask;

    XSelectInput(Dpy(), Object(), selectMask);
    _PassOnSelectMask(selectMask);		// This should always be a NOP

    if (xrp = GetResource(_Qtranslations, _QTranslations)) {
	Cvo_Translation *t = Cvo_LoadTranslation(xrp, XLATE_OVERRIDE);
	if (translations)
	    translations = Cvo_LoadTranslation(translations, t);
	else
	    translations = t;
    }
    if (xrp = GetResource(_Qcursor, _QCursor)) 
	SetCursor(xrp);
    if (cursor.Empty() && lp)
	SetCursor(lp->GetCursor());
    if (cursor.Empty())
        SetCursor("Diamond Cross");
    Bind();
    CVO_VOID_RETURN
}
