//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Input.cc,v 1.7 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/InputContext.h++>
#include <Cvo/Input.h++>
#include <ctype.h>
#if defined(I18N) && !defined(_RUNE_MAGIC_1)
#include <wctype.h>
#endif

static Cvo_Default defaults[] = {
    "*CvoInput*Sunken:True",
    "*CvoInput*Pad:3",
    "*CvoInput.Cursor:xterm",
    "*CvoInput*FontFamily:Courier",
};

CVO_BEGIN_BIND(Cvo_Input)
CVO_DOBIND(Cvo_Input, "Insert",		  Insert)
CVO_DOBIND(Cvo_Input, "Delete",		  Delete)
CVO_DOBIND(Cvo_Input, "Forward",	  Forward)
CVO_DOBIND(Cvo_Input, "Backward",	  Backward)
CVO_DOBIND(Cvo_Input, "Accept",		  Accept)
CVO_DOBIND(Cvo_Input, "Erase",	  	  EraseText)
CVO_DOBIND(Cvo_Input, "Move", 		  Move)
CVO_DOBIND(Cvo_Input, "insert-selection", InsertSelection)
CVO_END_BIND(Cvo_Input, Cvo_Output)

static char *trans = "\
	<Key>Delete: Delete() \n\
	<Key>BackSpace: Delete() \n\
	<Key>Enter: Accept() \n\
	<Key>Return: Accept() \n\
	<Key>Linefeed: Accept() \n\
	<Key>KP_Enter: Accept() \n\
    Ctrl<Key>j: Accept() \n\
    Ctrl<Key>m: Accept() \n\
	<Key>Left: Backward() \n\
	<Key>Right: Forward() \n\
    Ctrl<Key>u: Erase(Line) \n\
    Ctrl<Key>w: Erase(Word) \n\
    	<Key>Home: Move(Home) \n\
    	<Key>End: Move(End) \n\
	<Key>: Insert() \n\
   ~Ctrl<Btn2Up>:insert-selection(PRIMARY, CUT_BUFFER0) \n\
";

CONSTRUCTORS(Cvo_Input, Cvo_Output, "CvoInput")

void
Cvo_Input::_Init()
{   CVO_ENTER
    type = CvoT_Input;
    ShowCursor();
    NeedInputContext();
    AddTranslations(trans);
    CVO_VOID_RETURN
}

Cvo_Input::~Cvo_Input()
{   CVO_ENTER
    CVO_DONE
}

void
Cvo_Input::Delete(XEvent *, int, char **)
{   CVO_ENTER
    if (bufptr == bufend) {
	if (bufptr == buffer)
	    CVO_VOID_RETURN
	--bufptr;
    } else if (bufptr > buffer) {
	_memwcpy(bufptr - 1, bufptr, bufend - bufptr);
	--bufptr;
    } else {
	_memwcpy(buffer, buffer + 1, (bufend-1) - buffer);
    }
    dirty = True;
    *--bufend = '\0';
    Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_Input::Accept(XEvent *, int, char **)
{   CVO_ENTER
    if (!accept)
	accept = new char [acceptlen = bufend - buffer + 1];

    _Cvo_wcstombs(&accept, buffer, &acceptlen);

    Cvo_InputEnteredEvent iee;

    // XXX - when the cursor is changed back to a vertical bar, this code
    // can go away.

    char *txt = accept;
    while(*txt)
	++txt;
    if (txt > accept && txt[-1] == ' ')
	txt[-1] = '\0';

    iee.text = accept;
    SendEvent(CvoInputEnteredEvent, &iee);
    CVO_VOID_RETURN
}

#if     !defined(iswspace)
#define iswspace(c) isspace(c)
#endif

void
Cvo_Input::EraseText(XEvent *, int, char **av)
{   CVO_ENTER
    if (!av[0] || !strcasecmp(av[0], "Line")) {
	bufptr = offset = bufend = buffer;
	*bufend = '\0';
	dirty = True;
    } else if (!strcasecmp(av[0], "EndOfLine")) {
	bufend = bufptr;
    	*bufend = '\0';
	dirty = True;
    } else if (!strcasecmp(av[0], "Word")) {
	if (bufptr == buffer)
	    CVO_VOID_RETURN
	wchar_t *obp = bufptr;

	if (iswspace(*--bufptr)) {
	    while (bufptr > buffer && iswspace(bufptr[-1]))
		--bufptr;
	} else {
	    while (bufptr > buffer && !iswspace(bufptr[-1]))
		--bufptr;
	}
	if (obp == bufend)
	    bufend = obp;
	else {
	    _memwcpy(bufptr, obp, bufend - obp);
	    bufend -= obp - bufptr;
	}

	dirty = True;
	*bufend = '\0';
    }
    if (dirty)
	Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_Input::Forward(XEvent *, int, char **)
{   CVO_ENTER
    if (bufptr == bufend)
	Enter(" ");
    else {
	dirty = True;
	++bufptr;
    }
    Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_Input::Backward(XEvent *, int, char **)
{   CVO_ENTER
    if (bufptr > buffer) {
	dirty = True;
	--bufptr;
	Flush(2);
    }
    CVO_VOID_RETURN
}

void
Cvo_Input::Move(XEvent *, int, char **av)
{   CVO_ENTER
    if (!av[0] || !strcasecmp(av[0], "home")) {
	if (bufptr != buffer) {
	    bufptr = buffer;
	    dirty = True;
	}
    } else if (!strcasecmp(av[0], "end")) {
	if (bufptr != bufend) {
	    bufptr = bufend;
	    if (bufptr > buffer && bufptr[-1] == ' ')
		--bufptr;
	    dirty = True;
	}
    }

    if (dirty)
	Flush(2);
    CVO_VOID_RETURN
}

void
Cvo_Input::Insert(XEvent *ev, int, char **)
{   CVO_ENTER
    if (ev->type != CvoKeyTextEvent)
	CVO_VOID_RETURN

    Cvo_KeyTextEvent *kte = (Cvo_KeyTextEvent *)ev;

    if (kte->have_text) {
	Enter(kte->text->wcValue());
	Flush(2);
    }
    CVO_VOID_RETURN
}

void
Cvo_Input::InsertSelection(XEvent *, int, char **)
{
    Cvo_CharacterBuffer cb;

    if (GetSelection(&cb)) {
        Enter(cb.wcValue());
	Flush(2);
    }
}

