//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Image.cc,v 1.6 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <Cvo/Pixmap.h++>
#include <Cvo/XImage.h++>
#include <Cvo/Image.h++>
#include <string.h>
#include <stdio.h>
#include <ctype.h>

Cvo_Image *Cvo_Image::root = 0;

Cvo_Image::Cvo_Image(Cvo_Window *_win, char *_filename, char *resource)
{   CVO_ENTER
    Cvo_Lock lock;

    Init(_win);

    char *resfile = _win->GetResource(resource ? resource : "pixmapFile",
							    "PixmapFile");
    if (resfile)
	LoadFile(resfile);
    if (!Loaded() && _filename)
	LoadFile(_filename);
    CVO_VOID_RETURN
}

_Image::~_Image()
{
    delete [] colors;
    if (!usersdata)
	delete [] data.data8;
    delete [] filename;

    _ImageMap *ip = pixmaps;

    while (ip) {
	_ImageMap *nip = ip->next;
	delete ip;
    	ip = nip;
    }
}

Cvo_Image::Cvo_Image(Cvo_Window *_win, int w, int h, int dp, CARD8 *dt)
{   CVO_ENTER
    Cvo_Lock lock;

    Init(_win);
    Cvo_Object *obj = _win->RootObject();

    char *_filename = _win->GetResource("pixmapFile", "PixmapFile");

    if (_filename) {
	LoadFile(_filename);
	if (Loaded())
	    CVO_VOID_RETURN
    }

    Cvo_Image *cvi = next;

    while (cvi) {
	if (!cvi->image || dt != cvi->image->data.data8) {
	    cvi = cvi->next;
	    continue;
	}

	if (obj == cvi->win->RootObject()) {
	    image = cvi->image;
	    image->refcnt++;
	    CVO_VOID_RETURN
	}
	cvi = cvi->next;
    }

    image = new _Image;
    image->refcnt = 1;

    //
    // XXX HACK HACK HACK -- only supports bitmaps depth 1 for now.
    //
    image->width = w;
    image->height = h;
    image->depth = dp;
    image->bpl = (image->width + 7) >> 3;
    image->ncolors = 2;
    image->data.data8 = dt;
    image->xim = Cvo_LoadXImage(win, XYBitmap, 1);
    CVO_VOID_RETURN
}

Cvo_Image::Cvo_Image(Cvo_Window *_win,
		     int w, int h, int ncolors, int cpp,
		     char **colors, char **pixels)
{   CVO_ENTER
    Cvo_Lock lock;

    Init(_win);
    Cvo_Object *obj = _win->RootObject();

    char *_filename = _win->GetResource("pixmapFile", "PixmapFile");

    if (_filename) {
	LoadFile(_filename);
	if (Loaded())
	    CVO_VOID_RETURN
    }

    Cvo_Image *cvi = next;

    while (cvi) {
	if (!cvi->image || (void *)pixels != cvi->image->incore) {
	    cvi = cvi->next;
	    continue;
	}

	if (obj == cvi->win->RootObject()) {
	    image = cvi->image;
	    image->refcnt++;
	    CVO_VOID_RETURN
	}
	cvi = cvi->next;
    }

    image = new _Image;
    image->incore = pixels;
    image->refcnt = 1;

    LoadXPMData(w, h, ncolors, cpp, colors, pixels);
    CVO_VOID_RETURN
}

Cvo_Image::~Cvo_Image()
{   CVO_ENTER
    if (image && image->refcnt-- == 1)
	delete image;
    if (prev)
	prev->next = next;
    if (next)
	next->prev = prev;
    if (root == this)
	root = next;
    CVO_DONE
}

void
Cvo_Image::Init(Cvo_Window *_win)
{
    selected = 0;
    image = 0;
    win = _win;

    if (next = root)
	next->prev = this;
    prev = 0;
    root = this;
}

void
Cvo_Image::LoadFile(char *_filename)
{
    Cvo_Image *cvi = next;
    Cvo_Object *obj = win->RootObject();

    while (cvi) {
	if (!cvi->image || !cvi->image->filename ||
	    strcmp(_filename, cvi->image->filename)) {
		cvi = cvi->next;
		continue;
	}

	if (obj == cvi->win->RootObject()) {
	    image = cvi->image;
	    image->refcnt++;
	    CVO_VOID_RETURN
	}
	cvi = cvi->next;
    }

    image = new _Image;
    image->refcnt = 1;

    LoadXPMFile(_filename);
    if (!image->xim)
	LoadXPM2File(_filename);
    if (!image->xim)
	LoadBMFile(_filename);

    if (image->xim) {
	image->filename = new char[strlen(_filename)+1];
	strcpy(image->filename, _filename);
    } else {
	delete image;
	image = 0;
    }
    CVO_VOID_RETURN
}

void
Cvo_Image::Show(int x, int y, int w, int h, int sx, int sy)
{   CVO_ENTER
    if (!image)
	CVO_VOID_RETURN

    if (sx < 0)
	sx = 0;
    if (sy < 0)
	sy = 0;

    for (_ImageMap *ip = image->pixmaps; ip; ip = ip->next)
    	if (ip->depth == win->Depth() && ip->selected == selected)
	    break;

    if (ip) {
	win->SetForeground(win->Foreground());
	if (!w || w + sx > image->width)
	    w = image->width - sx;
	if (!h || h + sx> image->height)
	    h = image->height - sy;
	if (w < 0 || h < 0)
	    CVO_VOID_RETURN
	win->ToXCoord(&x, &y);
	XCopyArea(win->Dpy(), ip->pixmap, win->Win(), win->Gc(),
		  sx, sy, w, h, x, y);
	CVO_VOID_RETURN
    }

    if (!image->data.data8)
	CVO_VOID_RETURN

    XImage *im = image->xim->Image();

    im->width = image->width;
    im->height = image->height;
    im->data = (char *)image->data.data8;
    im->bytes_per_line = image->bpl;

    if (!w || w + sx > image->width)
	w = image->width - sx;
    if (!h || h + sx> image->height)
	h = image->height - sy;
    if (w < 0 || h < 0)
	CVO_VOID_RETURN

    int z;

    switch(image->depth) {
    case 1:
	if (win->Color()) {
	    win->SetForeground(win->Foreground());
	    if (selected)
		win->SetBackground(win->CurrentBackground()->Select());
	    else
		win->SetBackground(win->CurrentBackground());
	} else {
	    Cvo_Color fg = win->Foreground();
	    Cvo_Color bg = win->CurrentBackground();
	    if (selected) {
		Cvo_Color t = fg;
		fg = bg;
		bg = t;
	    }
	    win->SetForeground(fg->Pixel());
	    if (fg->Pixel() == bg->Pixel()) {
		if (fg->Pixel() == win->White())
		    win->SetBackground(win->Black());
		else
		    win->SetBackground(win->White());
	    } else
		win->SetBackground(bg);
	}
	break;
    case 8:
	if (image->amselected != selected) {
	    image->amselected = selected;
	    CARD8 bg = (CARD8)(image->colors->color->Pixel());
	    CARD8 sl = (CARD8)(image->colors->color->Select()->Pixel());
	    if (!selected) {
		CARD8 t = bg; bg = sl; sl = t;
	    }
	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data8[z] == bg)
		    image->data.data8[z] = sl;
	    }
	}
	break;
    case 16:
	if (image->amselected != selected) {
	    image->amselected = selected;
	    CARD16 bg = (CARD16)(image->colors->color->Pixel());
	    CARD16 sl = (CARD16)(image->colors->color->Select()->Pixel());
	    if (!selected) {
		CARD16 t = bg; bg = sl; sl = t;
	    }
	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data16[z] == bg)
		    image->data.data16[z] = sl;
	    }
	}
	break;
    case 24: case 32:
	if (image->amselected != selected) {
	    image->amselected = selected;
	    CARD32 bg = (CARD32)(image->colors->color->Pixel());
	    CARD32 sl = (CARD32)(image->colors->color->Select()->Pixel());
	    if (!selected) {
		CARD32 t = bg; bg = sl; sl = t;
	    }
	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data32[z] == bg)
		    image->data.data32[z] = sl;
	    }
	}
	break;
    default:
	break;
    }

    win->PutImage(im, sx, sy, x, y, w, h);
    CVO_VOID_RETURN
}

Pixmap
Cvo_Image::GetPixmap(int depth)
{   CVO_ENTER
    if (!image)
	CVO_RETURN(0)

    BOOL ismask = False;

    if (depth == -1)
	depth = image->depth;

    if (depth == -2) {
	depth = 1;
	ismask = True;
    }
	

    //
    // XXX - not right.  I should dither down.
    //
    if (depth < image->depth && !ismask)
	CVO_RETURN(0)

    for (_ImageMap *ip = image->pixmaps; ip; ip = ip->next)
    	if (ip->depth == win->Depth() && ip->selected == selected
				      && ip->mask == ismask)
	    return(ip->pixmap);

    CARD8 *data8 = image->data.data8;
    CARD16 *data16 = image->data.data16;
    CARD32 *data32 = image->data.data32;

    if (!data8 && !data16 && !data32)
	CVO_RETURN(0);

    Cvo_XImage *xi = Cvo_LoadXImage(win, depth > 1 ? ZPixmap : XYBitmap, depth);
    XImage *im = xi->Image();

    im->width = image->width;
    im->height = image->height;

    int bpl = image->bpl;

    if (image->depth != depth)  {
	switch (depth) {
	case 1:
		bpl = (image->width + 7) >> 3;
		data8 = new CARD8[bpl * image->height];
	    	if (ismask)
		    memset(data8, 0, bpl * image->height);
		break;
	case 8:
		bpl = image->width;
		data8 = new CARD8[image->width * image->height];
		break;
	case 16:
		bpl = image->width * 2;
		data16 = new CARD16[image->width * image->height];
		break;
	case 24:
	case 32:
		bpl = image->width * 4;
		data32 = new CARD32[image->width * image->height];
		break;
	default:
		CVO_RETURN(0)
	}
    }

    im->bytes_per_line = bpl;
    im->data = (char *)data8;

    XGCValues gcv;
    unsigned long mask = 0;
    int x, y, z;

    switch(image->depth) {
    case 1:
    	if (ismask) {
	    gcv.foreground = 1;
	    gcv.background = 0;
    	} else if (win->Color()) {
	    gcv.foreground = win->Foreground()->Pixel();
    	    if (selected)
		gcv.background = win->CurrentBackground()->Select()->Pixel();
	    else
		gcv.background = win->CurrentBackground()->Pixel();
	} else {
	    gcv.foreground = win->Foreground()->Pixel();
	    gcv.background = win->CurrentBackground()->Pixel();

    	    if (selected) {
	    	unsigned long t = gcv.foreground;
		gcv.foreground = gcv.background;
	    	gcv.background = t;
    	    }

	    if (gcv.background == gcv.foreground) {
		if (gcv.foreground == win->White())
		    gcv.background = win->Black();
		else
		    gcv.background = win->White();
	    }
	}
	switch (depth) {
	case 1:
	    mask |= GCForeground;
	    mask |= GCBackground;
	    break;
	case 8:
	    for (y = 0; y < image->height; ++y) {
		for (x = 0; x < image->width; ++x) {
		    if (image->data.data8[y*image->bpl+(x>>3)] & (1<<(x&7))) {
			data8[y*image->width+x] = CARD8(gcv.foreground);
		    } else {
			data8[y*image->width+x] = CARD8(gcv.background);
		    }
		}
	    }
	    break;
	case 16:
	    for (y = 0; y < image->height; ++y) {
		for (x = 0; x < image->width; ++x) {
		    if (image->data.data8[y*image->bpl+(x>>3)] & (1 << (x&7)))
			data16[y*image->width+x] = CARD16(gcv.foreground);
		    else
			data16[y*image->width+x] = CARD16(gcv.background);
		}
	    }
	    break;
	case 24:
	case 32:
	    for (y = 0; y < image->height; ++y) {
		for (x = 0; x < image->width; ++x) {
		    if (image->data.data8[y*image->bpl+(x>>3)] & (1 << (x&7)))
			data32[y*image->width+x] = CARD32(gcv.foreground);
		    else
			data32[y*image->width+x] = CARD32(gcv.background);
		}
	    }
	    break;
	}
	break;
    case 8:
	if (image->amselected != selected) {
	    image->amselected = selected;

	    CARD8 bg = (CARD8)(image->colors->color->Pixel());
	    CARD8 sl = (CARD8)(image->colors->color->Select()->Pixel());

    	    if (!selected) {
		CARD8 t = bg; bg = sl; sl = t;
    	    }

	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data8[z] == bg)
		    image->data.data8[z] = sl;
	    }
	}
	switch(depth) {
    	case 1:
    	    {
    	    	CARD8 bg = selected
			 ? (CARD8) image->colors->color->Select()->Pixel()
			 : (CARD8) image->colors->color->Pixel();

		for (z = 0; z < image->width * image->height; ++z) {
		    if (image->data.data8[z] != bg)
			data8[z >> 3] |= 1 << (z & 7);
		}
    	    }
    	    break;
	case 16:
	    for (z = 0; z < image->width * image->height; ++z)
		data16[z] = image->data.data8[z];
	    break;
	case 24:
	case 32:
	    for (z = 0; z < image->width * image->height; ++z)
		data32[z] = image->data.data8[z];
	    break;
	}
	break;
    case 16:
	if (image->amselected != selected) {
	    image->amselected = selected;
	    CARD16 bg = (CARD16)(image->colors->color->Pixel());
	    CARD16 sl = (CARD16)(image->colors->color->Select()->Pixel());

    	    if (!selected) {
		CARD16 t = bg; bg = sl; sl = t;
    	    }

	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data16[z] == bg)
		    image->data.data16[z] = sl;
	    }
	}
	switch(depth) {
	case 1: {
	    CARD16 bg = selected
		      ? (CARD16) image->colors->color->Select()->Pixel()
		      : (CARD16) image->colors->color->Pixel();
	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data16[z] != bg)
		    data8[z >> 3] |= 1 << (z & 7);
	    }
    	    break;
    	  }
	case 24:
	case 32:
	    for (z = 0; z < image->width * image->height; ++z)
		data32[z] = image->data.data16[z];
	    break;
	}
	break;
    case 24: case 32:
	if (image->amselected != selected) {
	    image->amselected = selected;
	    CARD32 bg = (CARD32)(image->colors->color->Pixel());
	    CARD32 sl = (CARD32)(image->colors->color->Select()->Pixel());

    	    if (!selected) {
		CARD32 t = bg; bg = sl; sl = t;
    	    }

	    for (z = 0; z < image->width * image->height; ++z) {
		if (image->data.data32[z] == bg)
		    image->data.data32[z] = sl;
	    }
	}
    	switch (depth) {
    	case 1: {
	    CARD32 bg = selected
		      ? (CARD32) image->colors->color->Select()->Pixel()
		      : (CARD32) image->colors->color->Pixel();
            for (z = 0; z < image->width * image->height; ++z) {
                if (image->data.data32[z] != bg)
                    data8[z >> 3] |= 1 << (z & 7);
            }       
            break;  
    	  }
    	}
	break;
    default:
	break;
    }

    ip = new _ImageMap;
    ip->depth = depth;
    ip->selected = selected;

    if (!win->Object())
	win->Create();

    ip->pixmap = XCreatePixmap(win->Dpy(), win->Object(),
			       image->width, image->height, depth);
    if (ip->pixmap) {
	GC gc = XCreateGC(win->Dpy(), ip->pixmap, mask, &gcv);
	XPutImage(win->Dpy(), ip->pixmap, gc, im, 0, 0, 0, 0,
		  image->width, image->height);
	XFreeGC(win->Dpy(), gc);

    	ip->next = image->pixmaps;
    	image->pixmaps = ip->next;
    } else
	delete ip;
    if (data8 != image->data.data8) {
	switch (depth) {
	case 1:
	case 8:
	    delete [] data8;
	    break;
	case 16:
	    delete [] data16;
	    break;
	case 24:
	case 32:
	    delete [] data32;
	    break;
	}
    }
    xi->Release();

    CVO_RETURN(ip ? ip->pixmap : 0)
}

//
// This definition is taken from X11/Xmu/Drawing.h.
// I can't include that .h file as it will draw in most of Xt,
// which I really do not want at all.
//
extern "C" int XmuReadBitmapDataFromFile(char*, unsigned int*, unsigned int*,
				         unsigned char**, int*, int*);

void
Cvo_Image::LoadBMFile(char *filename)
{   CVO_ENTER
    int x, y;

    if (XmuReadBitmapDataFromFile(filename,
				  &image->width,
				  &image->height,
				  &image->data.data8,
				  &x, &y) != BitmapSuccess)
	CVO_VOID_RETURN
    image->bpl = (image->width + 7) >> 3;
    image->depth = 1;
    image->ncolors = 2;
    image->xim = Cvo_LoadXImage(win, XYBitmap, 1);
    if (image->xim) {
        image->xim->im->width = image->width;
        image->xim->im->height = image->height;
        image->xim->im->data = (char *)image->data.data8;
        image->xim->im->bytes_per_line = image->bpl;
    }
    CVO_VOID_RETURN
}

#include "Image.XPM.h"
#include "Image.XPM2.h"
