//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Image.XPM2.h,v 1.2 1994/08/10 17:59:22 prb Exp $

void
Cvo_Image::LoadXPM2File(char *filename)
{   CVO_ENTER
    char buf[256];
    char *p, *ep;
    int x, y, z;
    int cpp = 1;
    FILE *fp;

    if ((fp = fopen(filename, "r")) == 0) {
	CVO_VOID_RETURN
    }

    if (!fgets(buf, sizeof(buf), fp) ||
	strncmp(buf, "! XPM2", 6) ||
	!fgets(buf, sizeof(buf), fp)) {
	    fclose(fp);
	    CVO_VOID_RETURN
    }

    p = buf;

    image->width = (int)strtol(p, &ep, 0);
    if (p == ep) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    image->height = (int)strtol(p = ep, &ep, 0);
    if (p == ep) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    image->ncolors = (int)strtol(p = ep, &ep, 0);
    if (p == ep) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    cpp = (int)strtol(p = ep, &ep, 0);
    if (p == ep) {
	fclose(fp);
	CVO_VOID_RETURN
    }
    if (cpp < 1)
	cpp = 1;

    int idepth;

    for (idepth = 1, x = 2; image->ncolors > x; x *= 2, idepth++)
	;


    if (idepth > 1 && idepth <= 8)
	idepth = 8;
    if (idepth > 8 && idepth <= 16)
	idepth = 16;
    if (idepth > 16 && idepth <= 24)
	idepth = 24;
    if (idepth > 24 && idepth <= 32)
	idepth = 32;

    if (idepth > win->Depth()) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    if (idepth > 1 && win->Monochrome()) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    image->colors = new _IColor[image->ncolors];

    image->depth = idepth > 1 ? win->Depth() : idepth;

    //
    // This code should be able to handle multi-byte codes as well..
    // But it doesn't.
    //
    for (x = 0; x < image->ncolors; ++x) {
	char *xrp;

	if (!fgets(buf, sizeof(buf), fp) ||
	     buf[1] != ' ' || buf[2] != 'c' || buf[3] != ' ') {
		fclose(fp);
		CVO_VOID_RETURN
	}

	xrp = buf + 4;
	while (*xrp && *xrp != '\n')
		++xrp;
	*xrp = 0;
	xrp = buf+4;
	image->colors[x].rep = buf[0];

	char res[16];
	sprintf(res, "color%d", x);
	XrmQuark q = XrmStringToQuark(res);
	xrp = win->GetResource(q, q, xrp);

	image->colors[x].color = Cvo_Color(win, xrp);
    }

    z = 0;

    switch(image->depth) {
    case 1:
	image->bpl = (image->width + 7) >> 3;
	image->data.data8 = new CARD8[image->bpl * image->height];
	memset(image->data.data8, 0, image->bpl * image->height);
	for (y = 0; y < image->height; ++y) {
	    int c;
	    for (x = 0; x < image->width; ++x) {
		if ((c = getc(fp)) == EOF) {
		    fclose(fp);
		    delete [] image->colors;
		    image->colors = 0;
		    delete [] image->data.data8;
		    image->data.data8 = 0;
		    CVO_VOID_RETURN
		}
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data8;
			image->data.data8 = 0;
			fclose(fp);
			CVO_VOID_RETURN
		    }
		}
		if (z)
		    image->data.data8[x>>3 + y * image->bpl] |= 1 << (x & 7);
	    }
	    while ((c = getc(fp)) != EOF)
		if (c == '\n')
		    break;
	}
	image->xim = Cvo_LoadXImage(win, XYBitmap, 1);
	break;
    case 8:
	image->bpl = image->width;
	image->data.data8 = new CARD8[image->bpl * image->height];
	memset(image->data.data8, 0, image->bpl * image->height);
	for (y = 0; y < image->height; ++y) {
	    int c;
	    for (x = 0; x < image->width; ++x) {
		if ((c = getc(fp)) == EOF) {
		    delete [] image->colors;
		    image->colors = 0;
		    delete [] image->data.data8;
		    image->data.data8 = 0;
		    fclose(fp);
		    CVO_VOID_RETURN
		}
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			fclose(fp);
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data8;
			image->data.data8 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data8[x + y * image->width] =
					(CARD8)image->colors[z].color->Pixel();
	    }
	    while ((c = getc(fp)) != EOF)
		if (c == '\n')
		    break;
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, 8);
	break;
    case 16:
	image->bpl = image->width * 2;
	image->data.data16 = new CARD16[image->width * image->height];
	memset(image->data.data16, 0, image->bpl * image->height);
	for (y = 0; y < image->height; ++y) {
	    int c;
	    for (x = 0; x < image->width; ++x) {
		if ((c = getc(fp)) == EOF) {
		    fclose(fp);
		    delete [] image->colors;
		    image->colors = 0;
		    delete [] image->data.data16;
		    image->data.data16 = 0;
		    CVO_VOID_RETURN
		}
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			fclose(fp);
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data16;
			image->data.data16 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data16[x + y * image->width] =
					(CARD16)image->colors[z].color->Pixel();
	    }
	    while ((c = getc(fp)) != EOF)
		if (c == '\n')
		    break;
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, 16);
	break;
    case 24: case 32:
	image->bpl = image->width * 4;
	image->data.data32 = new CARD32[image->width * image->height];
	memset(image->data.data32, 0, image->bpl * image->height);
	for (y = 0; y < image->height; ++y) {
	    int c;
	    for (x = 0; x < image->width; ++x) {
		if ((c = getc(fp)) == EOF) {
		    fclose(fp);
		    delete [] image->colors;
		    image->colors = 0;
		    delete [] image->data.data32;
		    image->data.data32 = 0;
		    CVO_VOID_RETURN
		}
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			fclose(fp);
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data32;
			image->data.data32 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data32[x + y * image->width] =
					(CARD32)image->colors[z].color->Pixel();
	    }
	    while ((c = getc(fp)) != EOF)
		if (c == '\n')
		    break;
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, 32);
	break;
    }
    if (image->xim) {
	image->xim->im->width = image->width;
	image->xim->im->height = image->height;
	image->xim->im->data = (char *)image->data.data8;
	image->xim->im->bytes_per_line = image->bpl;
    }

    fclose(fp);
    CVO_VOID_RETURN
}
