//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Image.XPM.h,v 1.2 1994/08/10 17:59:22 prb Exp $

static char *
GetDefine(char *string, int &value)
{
    while (isspace(*string))
	++string;
    if (*string++ != '#')
	return(0);
    while (isspace(*string))
	++string;
    if (strncmp(string, "define", 6))
	return(0);
    string += 6;
    if (!isspace(*string))
	return(0);
    while (isspace(*string))
	++string;

    char *result = string;

    while (*string && !isspace(*string))
	++string;
    if (!*string)
	return(0);
    *string++ = '\0';
    while (isspace(*string))
	++string;

    char *e;
    value = int(strtol(string, &e, 0));
    if (e == string)
	return(0);
    return(result);
}

static int
tailcmp(char *s1, char *s2)
{
    int len1 = strlen(s1);
    int len2 = strlen(s2);

    if (len1 < len2)
	return(0);
    return(strcmp(s1 + (len1 - len2), s2) == 0);
}

static char * NextToken(FILE *, char *, int, int * = 0);

static char *
NextToken(FILE *fp, char *buf, int size, int *tlen)
{
    int c;

    do {
	c = getc(fp);
    } while (c != EOF && (isspace(c) || c == '\n'));

    if (c == EOF)
	return(0);

    if (c == '*' || c == '=' ||
	c == '[' || c == ']' ||
	c == '{' || c == '}' ||
	c == ';' || c == ',') {

	return(NextToken(fp, buf, size, tlen));
    }

    char *result = buf;
    if (c == '"') {

	*buf++ = c;
	--size;
	while (size > 1 && (c = getc(fp)) != EOF && c != '"') {
	    *buf++ = c;
	    --size;
	}
	if (c == EOF)
	    return(0);
	*buf = '\0';
	if (tlen)
	    *tlen = buf - result;
	return(result);
    }

    //
    // At this point we should only have identifiers
    //
    if (!isalnum(c) && c != '_')
	return(0);

    do {
	*buf++ = c;
	--size;
    } while ((c = getc(fp)) != EOF && (isalnum(c) || c == '_'));
    if (c == EOF)
	return(0);
    *buf = '\0';
    if (tlen)
	*tlen = buf - result;
    return(result);
}

void
Cvo_Image::LoadXPMFile(char *filename)
{   CVO_ENTER
    char buf[256];
    FILE *fp;
    int cpp;

#define	FORMAT	1
#define	WIDTH	2
#define	HEIGHT	4
#define	NCOLORS	8
#define	CPP	16

    int flags = FORMAT | WIDTH | HEIGHT | NCOLORS | CPP;

    if ((fp = fopen(filename, "r")) == 0) {
	CVO_VOID_RETURN
    }

    while (flags && fgets(buf, sizeof(buf), fp)) {
	char *b = buf;
	while (isspace(*b))
	    ++b;
	if (*b == '\0' || *b == '\n')
	    continue;		// Ignore blank lines 

	int value;
	b = GetDefine(b, value);
	if (!b) {
	    break;
	}
	if (tailcmp(b, "_format")) {
	    if (!(flags & FORMAT) || value != 1)
		break;
	    flags &= ~FORMAT;
	} else if (tailcmp(b, "_width")) {
	    if (!(flags & WIDTH) || value == 0)
		break;
	    image->width = value;
	    flags &= ~WIDTH;
	} else if (tailcmp(b, "_height")) {
	    if (!(flags & HEIGHT) || value == 0)
		break;
	    image->height = value;
	    flags &= ~HEIGHT;
	} else if (tailcmp(b, "_ncolors")) {
	    if (!(flags & NCOLORS) || value == 0)
		break;
	    image->ncolors = value;
	    flags &= ~NCOLORS;
	} else if (tailcmp(b, "_chars_per_pixel")) {
	    if (!(flags & CPP) || value == 0)
		break;
	    cpp = value;
	    flags &= ~CPP;
	} else
	    break;
    }

    if (flags) {
	fclose(fp);
	CVO_VOID_RETURN
    }

    //
    // This will get recomputed, but it is good to check it out here to
    // make sure we don't read a file we can't parse.
    //

    int idepth;
    int x;

    for (idepth = 1, x = 2; image->ncolors > x; x *= 2, idepth++)
        ;


    if (idepth > 1 && idepth <= 8)
        idepth = 8;
    if (idepth > 8 && idepth <= 16)
        idepth = 16;
    if (idepth > 16 && idepth <= 24)
        idepth = 24;
    if (idepth > 24 && idepth <= 32)
        idepth = 32;

    if (idepth > win->Depth()) {
        fclose(fp);
        CVO_VOID_RETURN
    }

    if (idepth > 1 && win->Monochrome()) {
        fclose(fp);
        CVO_VOID_RETURN
    }

    image->colors = new _IColor[image->ncolors];

    image->depth = idepth > 1 ? win->Depth() : idepth;

    int bufsize = image->width * cpp + 4;
    char *buffer = new char [bufsize];

    char *token;

    if (!(token = NextToken(fp, buffer, bufsize)) || strcmp(token, "static")) {
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    if (!(token = NextToken(fp, buffer, bufsize)) || strcmp(token, "char")) {
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    if (!(token = NextToken(fp, buffer, bufsize)) || !tailcmp(token, "_colors")) {
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    int tlen;
    char **colors = new char *[image->ncolors * 2];

    for (x = 0; x < image->ncolors * 2; ++x) {
	token = NextToken(fp, buffer, bufsize, &tlen);

	if (!token || *token != '"' || ((x & 1) == 0 && tlen != cpp + 1)) {
	    while (x-- > 0)
		delete [] colors[x];
	    delete [] colors;
	    delete [] buffer;
	    fclose(fp);
	    CVO_VOID_RETURN
	}
	colors[x] = strdup(token+1);
    }

    if (!(token = NextToken(fp, buffer, bufsize)) || strcmp(token, "static")) {
	while (x-- > 0)
	    delete [] colors[x];
	delete [] colors;
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    if (!(token = NextToken(fp, buffer, bufsize)) || strcmp(token, "char")) {
	while (x-- > 0)
	    delete [] colors[x];
	delete [] colors;
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    if (!(token = NextToken(fp, buffer, bufsize)) || !tailcmp(token, "_pixels")) {
	while (x-- > 0)
	    delete [] colors[x];
	delete [] colors;
	delete [] buffer;
	fclose(fp);
	CVO_VOID_RETURN
    }

    int y;
    char **pixels = new char *[image->height];

    for (y = 0; y < image->height; ++y) {
	token = NextToken(fp, buffer, bufsize, &tlen);

	if (!token || *token != '"' || tlen != cpp * image->width + 1) {
	    while (x-- > 0)
		delete [] colors[x];
	    delete [] colors;
	    while (y-- > 0)
		delete [] pixels[y];
	    delete [] pixels;
	    delete [] buffer;
	    fclose(fp);
	    CVO_VOID_RETURN
	}
	pixels[y] = strdup(token+1);
    }

    fclose(fp);
    delete [] buffer;

    LoadXPMData(image->width, image->height, image->ncolors,
		cpp, colors, pixels);

    while (x-- > 0)
	delete [] colors[x];
    delete [] colors;
    while (y-- > 0)
	delete [] pixels[y];
    delete [] pixels;
    CVO_VOID_RETURN
}

void
Cvo_Image::LoadXPMData(int w, int h, int n, int cpp, char **colors,
						     char **pixels)
{   CVO_ENTER

    if (!w || !h || !n)
	CVO_VOID_RETURN

    image->width = w;
    image->height = h;
    image->ncolors = n;

    int x;
    int y;

    int idepth;

    for (idepth = 1, x = 2; image->ncolors > x; x *= 2, idepth++)
        ;


    if (idepth > 1 && idepth <= 8)
        idepth = 8;
    if (idepth > 8 && idepth <= 16)
        idepth = 16;
    if (idepth > 16 && idepth <= 24)
        idepth = 24;
    if (idepth > 24 && idepth <= 32)
        idepth = 32;

    if (idepth > win->Depth()) {
        CVO_VOID_RETURN
    }

    if (idepth > 1 && win->Monochrome()) {
        CVO_VOID_RETURN
    }

    image->depth = idepth > 1 ? win->Depth() : idepth;

    image->colors = new _IColor[image->ncolors];

    //
    // This code should be able to handle multi-byte codes as well..
    // But it doesn't.
    //
    for (x = 0; x < image->ncolors; ++x) {
	char *xrp = colors[x * 2 + 1];

	image->colors[x].rep = colors[x * 2][0];

	char res[16];
	sprintf(res, "color%d", x);
	XrmQuark q = XrmStringToQuark(res);
	xrp = win->GetResource(q, q, xrp);

	image->colors[x].color = Cvo_Color(win, xrp);
    }

    int z = 0;

    switch(image->depth) {
    case 1:
	image->bpl = (image->width + 7) >> 3;
	image->data.data8 = new CARD8[image->bpl * image->height];
	memset(image->data.data8, 0, image->bpl * image->height);
	for (y = 0; y < image->height; ++y) {
	    for (x = 0; x < image->width; ++x) {
		int c = pixels[y][x * cpp];

		if (pixels[y][x * cpp] != image->colors[0].rep)
		    image->data.data8[(x>>3) + y * image->bpl] |= 1 << (x & 7);
	    }
	}
	image->xim = Cvo_LoadXImage(win, XYBitmap, 1);
	break;
    case 8:
	image->bpl = image->width;
	image->data.data8 = new CARD8[image->width * image->height];
	memset(image->data.data8, 0, image->bpl * image->height);

	for (y = 0; y < image->height; ++y) {
	    for (x = 0; x < image->width; ++x) {
		int c = pixels[y][x * cpp];
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data8;
			image->data.data8 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data8[x + y * image->bpl] =
				    (CARD8)image->colors[z].color->Pixel();
	    }
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, image->depth);
	break;

    case 16:
	image->bpl = image->width * 2;
	image->data.data16 = new CARD16[image->width * image->height];
	memset(image->data.data16, 0, image->bpl * image->height);

	for (y = 0; y < image->height; ++y) {
	    for (x = 0; x < image->width; ++x) {
		int c = pixels[y][x * cpp];
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data16;
			image->data.data16 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data16[x + y * image->width] =
				    (CARD16)image->colors[z].color->Pixel();
	    }
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, 16);
	break;

    case 24: case 32: 
	image->bpl = image->width * 4;
	image->data.data32 = new CARD32[image->width * image->height];
	memset(image->data.data32, 0, image->bpl * image->height);

	for (y = 0; y < image->height; ++y) {
	    for (x = 0; x < image->width; ++x) {
		int c = pixels[y][x * cpp];
		if (c != image->colors[z].rep) {
		    for (z = 0; z < image->ncolors; ++z)
			if (c == image->colors[z].rep)
			    break;
		    if (z >= image->ncolors) {
			delete [] image->colors;
			image->colors = 0;
			delete [] image->data.data32;
			image->data.data32 = 0;
			CVO_VOID_RETURN
		    }
		}
		image->data.data32[x + y * image->width] =
				    (CARD32)image->colors[z].color->Pixel();
	    }
	}
	image->xim = Cvo_LoadXImage(win, ZPixmap, 32);
	break;
    }
    if (image->xim) {
	image->xim->im->width = image->width;
	image->xim->im->height = image->height;
	image->xim->im->data = (char *)image->data.data8;
	image->xim->im->bytes_per_line = image->bpl;
    }
    CVO_VOID_RETURN
}
