//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Font.cc,v 1.10 1994/09/13 19:54:48 prb Exp $"); }
#include <string.h>
#include <Cvo/Window.h++>
#include <Cvo/Pixmap.h++>
#include <stdio.h>

static Cvo_Default defs[] = {
    //
    // These are the default strings to use if the supplied string
    // does not work.
    //
    "?.japanese.cvo_defaultfonts: -sony-*-*-r-normal--16-*-*-*-c-*-*-*,"
    				"-jis-*-*-r-normal--16-*-*-*-c-*-*-*,"
    				"-*-*-*-r-normal--16-*-*-*-c-*-*-*",
    "?.chinese.cvo_defaultfonts: -sony-*-*-r-normal--16-*-*-*-c-*-*-*,"
    				"-*-*-*-r-normal--16-*-*-*-c-*-*-*",
    "?.C.cvo_defaultfonts: -*-*-*-r-normal--*-*-*-*-c-*-*-",
    "?.?.cvo_defaultfonts: -sony-*-*-r-normal--16-*-*-*-c-*-*-*,"
    			  "-jis-*-*-r-normal--16-*-*-*-c-*-*-*,"
    			  "-*-*-*-r-normal--16-*-*-*-c-*-*-*,"
    			  "-*-*-*-r-normal--*-*-*-*-c-*-*-",
    "?.?.cvo_defaultfont: fixed, 9x15, 8x13, 8x16",
};

Cvo_Font::Cvo_Font(Cvo_Object *win)
{   CVO_ENTER
    char *foundry, *family, *weight, *slant, *swidth, *adstyl;
    char *pxlsz, *ptsz, *resx, *resy, *spc, *avgwdth, *rgstry, *encdng;
    static char *fname = 0;
    static int fnamesz = 0;
    char *font;

    if (font = win->GetResource(_QFONT, _QFONT))
	    ;
    else if (family = win->GetResource(_QfontFamily, _QFontFamily)) {
	weight = win->GetResource(_QfontWeight, _QFontWeight, "*");
	pxlsz = win->GetResource(_QfontSize, _QFontSize, "*");
	slant = win->GetResource(_QfontSlant, _QFontSlant, "*");

	if (win->GetResourceTruth(_QfontInfo, _QFontInfo, False)) {
	    foundry = win->GetResource(_QfontFoundry, _QFontFoundry, "*");
	    swidth = win->GetResource(_QfontSpaceWidth, _QFontSpaceWidth, "*");
	    adstyl = win->GetResource(_QfontStyle, _QFontStyle, "*");
	    ptsz = win->GetResource(_QfontPointSize, _QFontPointSize, "*");
	    resx = win->GetResource(_QfontXResolution, _QFontXResolution, "*");
	    resy = win->GetResource(_QfontYResolution, _QFontYResolution, "*");
	    avgwdth = win->GetResource(_QfontWidth, _QFontWidth, "*");
	    rgstry = win->GetResource(_QfontRegistry, _QFontRegistry, "*");
	    encdng = win->GetResource(_QfontEncoding, _QFontEncoding, "*");
	    spc = win->GetResource(_QfontSpacing, _QFontSpacing, "*");
	} else {
	    foundry = "*";
	    swidth = "*";
	    adstyl = "*";
	    ptsz = "*";
	    resx = "*";
	    resy = "*";
	    avgwdth = "*";
	    rgstry = "*";
	    encdng = "*";
	    spc = "*";
	}

	int len = 1 + strlen(foundry) + 1 + strlen(family) + 1 +
		      strlen(weight) + 1 + strlen(slant) + 1 +
		      strlen(swidth) + 1 + strlen(adstyl) + 1 +
		      strlen(pxlsz) + 1 + strlen(ptsz) + 1 +
		      strlen(resx) + 1 + strlen(resy) + 1 +
		      strlen(spc) + 1 + strlen(avgwdth) + 1 +
		      strlen(rgstry) + 1 + strlen(encdng) + 1;
	if (len > fnamesz) {
	    delete [] fname;
	    fname = new char [len];
	}
	sprintf(fname, "-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s",
		foundry, family, weight, slant, swidth, adstyl,
		pxlsz, ptsz, resx, resy, spc, avgwdth, rgstry,
		encdng);
	font = fname;
    } else
	font = win->GetResource(_Qfont, _QFont, win->Parent() ? 0 : "fixed");
    if (!font) {
	//
	// If we don't have a font specified for this window, then
	// start going up the parent tree until we find a window
	// with  font.
	// If we cannot find a font in our upward path (very strange)
	// then we use the first font loaded on this display.
	// If no fonts have been loaded, we must fail.
	//
	Cvo_Object *obj = win->Parent();

	while (obj && !obj->ToWindow())
	    obj = obj->Parent();
	if (obj && obj->ToWindow()) {
	    realfont = obj->ToWindow()->TextAttribute()->Font()->Copy();
	    CVO_VOID_RETURN
	}
	if (win->DisplayList()->Fonts()) {
	    realfont = win->DisplayList()->Fonts()->Copy();
	    CVO_VOID_RETURN
	}
	Cvo_Failure(CvoE_FATAL, CvoE_NOFONT,
		    "Unable to open any fonts for %s\n",
		    win->Name());
    }
    
    _Cvo_Font *fnts = win->DisplayList()->Fonts();
    while (fnts && strcmp(fnts->name, font))
	fnts = fnts->next;
    if (fnts)
	realfont = fnts->Copy();
    else
	realfont = new _Cvo_Font(win->DisplayList(), font);
}

Cvo_Font::Cvo_Font(Cvo_BasicObject *bwin, XrmQuark nq)
{
    char *foundry, *family, *weight, *slant, *swidth, *adstyl;
    char *pxlsz, *ptsz, *resx, *resy, *spc, *avgwdth, *rgstry, *encdng;
    static char *fname = 0;
    static int fnamesz = 0;
    char *font;

    XrmQuark cq = _QFont;

    Cvo_Object *win;

    if (!(win = bwin->ToObject())) {
	Cvo_Failure(CvoE_FATAL, CvoE_NOFONT,
		    "Unable to open any fonts for %s\n",
		    "a basic window");
    }

    family = win->GetResource(_QfontFamily, _QFontFamily, 0, nq, cq);

    if (!family)
	family = win->GetResource(_QfontFamily, _QFontFamily);

    if (!family) {
	Cvo_Object *obj = win;

	while (obj && !obj->ToWindow())
	    obj = obj->Parent();
        if (obj && obj->ToWindow()) {
            realfont = obj->ToWindow()->TextAttribute()->Font()->Copy();
            return;
        }
        if (win->DisplayList()->Fonts()) {
            realfont = win->DisplayList()->Fonts()->Copy();
            return;
        }
	Cvo_Failure(CvoE_FATAL, CvoE_NOFONT,
		    "Unable to open any fonts for %s\n",
		    win->Name());
    }

    foundry = win->GetResource(_QfontFoundry, _QFontFoundry, "*", nq, cq);
    weight = win->GetResource(_QfontWeight, _QFontWeight, "*", nq, cq);
    slant = win->GetResource(_QfontSlant, _QFontSlant, "*", nq, cq);
    swidth = win->GetResource(_QfontSpaceWidth, _QFontSpaceWidth, "*", nq, cq);
    adstyl = win->GetResource(_QfontStyle, _QFontStyle, "*", nq, cq);
    pxlsz = win->GetResource(_QfontSize, _QFontSize, "*", nq, cq);
    ptsz = win->GetResource(_QfontPointSize, _QFontPointSize, "*", nq, cq);
    resx = win->GetResource(_QfontXResolution, _QFontXResolution, "*", nq, cq);
    resy = win->GetResource(_QfontYResolution, _QFontYResolution, "*", nq, cq);
    avgwdth = win->GetResource(_QfontWidth, _QFontWidth, "*", nq, cq);
    rgstry = win->GetResource(_QfontRegistry, _QFontRegistry, "*", nq, cq);
    encdng = win->GetResource(_QfontEncoding, _QFontEncoding, "*", nq, cq);
    spc = win->GetResource(_QfontSpacing, _QFontSpacing, "*", nq, cq);

    int len = 1 + strlen(foundry) + 1 + strlen(family) + 1 +
		  strlen(weight) + 1 + strlen(slant) + 1 +
		  strlen(swidth) + 1 + strlen(adstyl) + 1 +
		  strlen(pxlsz) + 1 + strlen(ptsz) + 1 +
		  strlen(resx) + 1 + strlen(resy) + 1 +
		  strlen(spc) + 1 + strlen(avgwdth) + 1 +
		  strlen(rgstry) + 1 + strlen(encdng) + 1;

    if (len > fnamesz) {
	delete [] fname;
	fname = new char [len];
    }
    sprintf(fname, "-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s-%s",
	    foundry, family, weight, slant, swidth, adstyl,
	    pxlsz, ptsz, resx, resy, spc, avgwdth, rgstry,
	    encdng);
    font = fname;

    realfont = new _Cvo_Font(win->DisplayList(), font);
}

Cvo_Font::Cvo_Font(Cvo_DisplayList *display, char *font)
{   CVO_ENTER
    _Cvo_Font *cwf = display->Fonts();

    while (cwf) {
	if (!strcmp(font, cwf->name)) {
	    realfont = cwf->Copy();
	    return;
	}
	cwf = cwf->next;
    }
    realfont = new _Cvo_Font(display, font);
}

static XFontStruct *
DefaultFont(Cvo_DisplayList *dpy)
{
    char *fn = _Cvo_Base.GetLocaleOption("cvo_defaultfont", 0);
    XFontStruct *fs = 0;

    if (fn)
	while (*fn == ',' || *fn == ' ' || *fn == '\t')
	    ++fn;

    while (!fs && fn && *fn) {
	char *comma;
    	char *p;
	Cvo_CharacterBuffer cb;

    	p = comma = strchr(fn, ',');
    	if (p) {
	    while (p > fn && (p[-1] == ' ' || p[-1] == '\t'))
	    	--p;
	    if (p > fn)
		cb.Set(fn, p - fn);
    	} else {
	    cb.Set(fn);
    	}

	if (fn = comma)
	    while (*fn == ',' || *fn == ' ' || *fn == '\t')
		++fn;
    	if (cb.mbLength()) {
	    fs = XLoadQueryFont(dpy->Dpy(), cb);
    	}
    }
    return(fs);
}

_Cvo_Font::_Cvo_Font(Cvo_DisplayList *dpy, char *_name)
{   CVO_ENTER

// printf("Creating %x\n", this);
    refcnt = 1;
    missing_charsets = 0;
    num_missing_charsets = 0;
    default_string = 0;

    if (!dpy) {
	    Cvo_Failure(CvoE_FATAL,
		       CvoE_NULLDPY,
		       "Null display argument passed to ``%s(%s)''\n",
		       "Cvo_Font::Cvo_Font",
		       _name);
    }
    if (!_name) {
	    Cvo_Failure(CvoE_FATAL,
		       CvoE_NULLFONT,
		       "Null fontname passed to ``%s''\n",
		       "Cvo_Font::Cvo_Font");
    }

    if (!(name = strdup(_name))) {
	    Cvo_Failure(CvoE_FATAL,
		       CvoE_NOMEM,
		       "Out of memory in routine ``%s''\n",
		       "Cvo_Font::Cvo_Font");
    }

    display = dpy;

    //
    // Sort of weird code here.  The idea is to keep the first font
    // loaded at the head of the list.  After that it really doesn't
    // matter
    //
    _Cvo_Font *base;
    if (base = display->Fonts()) {
	if (this->next = base->next)
	    this->next->prev = this;
	base->next = this;
	this->prev = base;
    } else {
	next = 0;
	prev = 0;
	display->Set1stFont(this);
    }

#if	defined(X11R4)
    font = XLoadQueryFont(display->Dpy(), _name);
    if (!font && (font = DefaultFont(display)) == NULL) {
	Cvo_Failure(CvoE_FATAL,
		   CvoE_NULLFONT,
		   "Unable to create fontset `%s''\n",
		   _name);
    }
#else
    font = 0;
    fontset = XCreateFontSet(display->Dpy(),
			     _name,
			     &missing_charsets,
			     &num_missing_charsets,
			     &default_string);

#if	defined(print_fonts)
    char **fonts;
    int nfonts;
    XFontStruct **flist;
    nfonts = XFontsOfFontSet(fontset, &flist, &fonts);
    for (int x = 0; x < nfonts; ++x)
	printf("Font %d: %s\n", x, fonts[x]);
#endif

    if (display->loadingfont && (!fontset || num_missing_charsets)) {
	if (!fontset)
	    num_missing_charsets = 1;	
	else {
	    XFreeFontSet(display->Dpy(), fontset);
	    fontset = 0;
	}
	CVO_VOID_RETURN
    }

    if (!fontset || num_missing_charsets) {
	display->loadingfont = True;

	char *f = _Cvo_Base.GetLocaleOption("cvo_defaultfonts", 0);
	if (f && !strcmp(f, _name))
	    f = 0;
	_Cvo_Font *t = f ? new _Cvo_Font(dpy, f) : 0;

	display->loadingfont = False;

	if (t && t->fontset && !t->num_missing_charsets) {

	    missing_charsets = t->missing_charsets;
	    num_missing_charsets = t->num_missing_charsets;
	    default_string = t->default_string;
	    Mink = t->Mink;
	    Mlogical = t->Mlogical;
	    fontset = t->fontset;
	    if (t->extents == &t->_extents) {
		memcpy(&_extents, &t->_extents, sizeof(_extents));
		extents = &_extents;
	    } else {
		extents = t->extents;
	    }

	    t->font = 0;
	    t->fontset = 0;
	    t->missing_charsets = 0;
	    delete t;

	    CVO_VOID_RETURN
	}
	delete t;
    }

    if (!fontset || num_missing_charsets) {
        if (fontset) {
            XFreeFontSet(display->Dpy(), fontset);
	    fontset = 0;
    	}
	if ((font = XLoadQueryFont(display->Dpy(), _name)) == NULL &&
	    (font = DefaultFont(display)) == NULL) {
		if (num_missing_charsets) {
		    while (num_missing_charsets-- > 0) {
			Cvo_Failure(CvoE_WARN,
				   CvoE_MISSFONT,
				   "Unable to open font %s (%s)\n",
				   *missing_charsets++,
				   _name);
		    }
		}
		Cvo_Failure(CvoE_FATAL,
			   CvoE_NULLFONT,
			   "Unable to create fontset ``%s''\n",
			   _name);
	}
    }

    if (!font && num_missing_charsets) {
	while (num_missing_charsets-- > 1) {
		Cvo_Failure(CvoE_WARN,
			   CvoE_MISSFONT,
			   "Unable to open font %s (%s)\n",
			   *missing_charsets++, _name);
	}
	Cvo_Failure(CvoE_FATAL,
		   CvoE_MISSFONT,
		   "Unable to open font %s (%s)\n",
		   *missing_charsets++, _name);
    }

    extents = XExtentsOfFontSet(fontset);
#endif

    //
    // Calculate the 'M' sizes for the width of the font.  We use
    // this instead of extents->max_{logical,ink}_extent because in
    // a language such as Japanese, the ASCII characters are half the
    // width of the Kanji characters.  If we used max_extent a window
    // for Americans that was 80x24 would become twice as wide for
    // the Japanese and support 160 ASCII characters across!  So, to
    // prevent forcing the Japanese to declare a window 40x24 when they
    // really mean 80x24, we use an "M Space"
    //
    char *str = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    if (font) {
	int dir, asc, des;
	XCharStruct over;

	XTextExtents(font, str, 52, &dir, &asc, &des, &over);
	Mink.x = -over.lbearing;
	Mink.y = -over.ascent;
	Mink.width = over.width;
	Mink.height = over.ascent + over.descent;
	Mlogical = Mink;
	Mlogical.height = font->ascent + font->descent;
	_extents.max_logical_extent.width = font->max_bounds.rbearing -
        		                    font->min_bounds.lbearing;
	_extents.max_logical_extent.height = font->ascent + font->descent;
	_extents.max_logical_extent.y = -font->ascent;
	extents = &_extents;
    }
#if !defined(X11R4)
    else {
	XmbTextExtents(fontset, str, 52, &Mink, &Mlogical);
    }
#endif
    Mink.width /= 52;
    Mlogical.width /= 52;
    CVO_VOID_RETURN
}

_Cvo_Font::~_Cvo_Font()
{   CVO_ENTER

    if (this == display->Fonts()) {
	display->Set1stFont(next);
	if (next)
	    next->prev = 0;
    } else if (prev) {
	if (prev->next = next)
	    next->prev = prev;
    }

    if (font)
	XFreeFont(display->Dpy(), font);
    if (name)
	free(name);
#if !defined(X11R4)
    if (fontset)
	XFreeFontSet(display->Dpy(), fontset);
    if (missing_charsets)
	XFreeStringList(missing_charsets);
#endif
    CVO_DONE
}
