//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: FileView.cc,v 1.5 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/FileView.h++>
#include <Cvo/Pin.h++>
#include <Cvo/Separator.h++>
#include <Cvo/FilePage.h++>
#include <Cvo/TextPage.h++>
#include <Cvo/TextViewPort.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>

CONSTRUCTORS_2ARG(Cvo_FileView, Cvo_Window, "CvoFileView", char *, char *)
CONSTRUCTORS_2ARG(Cvo_FileView, Cvo_Window, "CvoFileView", char *, Cvo_Page *)

void
Cvo_FileView::_Init(char *_title, char *file)
{

    page = new Cvo_FilePage(file);

    if (page->NumberLines() < 0) {
	delete page;
	page = new Cvo_TextPage();

	char buf[256];
	sprintf(buf, "%s: cannot open.", file);
        ((Cvo_TextPage *)page)->AppendText(buf);
    }
    _Init(_title, page);
}

void
Cvo_FileView::_Init(char *_title, Cvo_Page *p)
{
    VerticalChildren();
    Cvo_Frame *frame = new Cvo_Frame("title_frame", this);
    frame->HorizontalChildren();
    pin = new Cvo_Pin("pin", frame);
    pin->ForceOn();
    pin->Register(CvoButtonUpEvent, _Cvo_FileViewDismiss, this);

    title = new Cvo_Label("title", frame, _title);
    title->ExpandFrame();

    new Cvo_Separator(this);

    tvp = new Cvo_TextViewPort("viewer", this, page = p);
    tvp->ExpandFrame();
    tvp->SetMinSize(20, 6);
    tvp->SetDefSize(40, 8);
    tvp->DontJump();
}

Cvo_FileView::~Cvo_FileView()
{
    delete page;
}

void
_Cvo_FileViewDismiss(Cvo_Object *, XEvent *, void *d)
{   CVO_ENTER
    delete (Cvo_FileView *)d;
    CVO_VOID_RETURN
}
