//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: FilePage.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }

#include <Cvo/FilePage.h++>

Cvo_FilePage::Cvo_FilePage(char *file)
{
    if ((fp = fopen(file, "r")) == NULL) {
	nlines = -1;
	maxblock = 0;
	block1 = 0;
	block2 = 0;
	return;
    }
    _Init();
}

Cvo_FilePage::Cvo_FilePage(FILE *file)
{
    fp = file;
    _Init();
}


void
Cvo_FilePage::_Init()
{
    nlines = 0;

    long maxblocks;
    offsets = new off_t[maxblocks = 100];

    char buf[512];
    off_t off;
    int block = -1;
    maxblock = 0;

    while ((off = ftell(fp)), fgets(buf, sizeof(buf), fp)) {
	if (nlines % Cvo_FILEPAGE_BLOCK == 0) {
	    block = nlines / Cvo_FILEPAGE_BLOCK;
	    if (block >= maxblocks) {
		off_t *noffsets = new off_t[block + 100];
		memcpy(noffsets, offsets, int(maxblocks * sizeof(off_t)));
		maxblocks = block + 100;
		delete offsets;
		offsets = noffsets;
	    }
	    offsets[block] = off;
	    if (block && off - offsets[block - 1] > maxblock)
		maxblock = int(off - offsets[block - 1]);
	}
	++nlines;
    }

    if (++block > maxblocks) {
	off_t *noffsets = new off_t[block+1];
	memcpy(noffsets, offsets, int(maxblocks * sizeof(off_t)));
    }
    offsets[block] = off;
    if (block && off - offsets[block - 1] > maxblock)
	maxblock = int(off - offsets[block - 1]);

    block1 = new Cvo_FilePageBlock(maxblock);
    block2 = new Cvo_FilePageBlock(maxblock);
}

void *
Cvo_FilePage::GetLine(CARD i)
{
    if (i >= nlines)
	return(0);

    char *line;

    if ((line = block1->Line(i)) || (line = block2->Line(i)))
	return(line);

    Cvo_FilePageBlock *t = block1;
    block1 = block2;
    block2 = t;

    CARD block = i / Cvo_FILEPAGE_BLOCK;

    block1->Load(fp, block * Cvo_FILEPAGE_BLOCK,
		 offsets[block], offsets[block+1]);

    return(block1->Line(i));
}

void *
Cvo_FilePage::GetLine(CARD i, Cvo_CharacterBuffer *cb)
{
    char *line = (char *)GetLine(i);

    if (line)
	cb->Set(line);
    return(line);
}

Cvo_FilePage::~Cvo_FilePage()
{
    if (fp)
	fclose(fp);
    delete block1;
    delete block2;
}

void
Cvo_FilePageBlock::Load(FILE *fp, CARD line, off_t start, off_t end)
{
    fseek(fp, start, 0);
    int r;
    if ((r = fread(block, 1, int(end - start), fp)) != int(end - start))
	printf("Short Read %d\n", int(end - start) - r);
    fline = line;

    end -= start;
    start = 0;
    lline = 0;
    lines[lline++] = block;

    while (start < end) {
	if (block[start++] == '\n') {
	    block[start-1] = '\0';
	    if (start < end)
		lines[lline++] = &block[start];
	}
    }
    lline += fline;
}

void
Cvo_FilePage::Draw(CARD i, const XRectangle &clip, int x, int y)
{
    if (!win || !win->Object())
	return;
    x = clip.x - x;
    y = clip.y - y;

    XRectangle r = clip;
    win->SetClipRectangles(0, 0, &r, 1, Unsorted);

    win->TextAttribute()->Image(x, y, (char *)GetLine(i));

    win->SetClipMask(None);
}

CARD
Cvo_FilePage::Width(CARD x)
{
    if (!win || x >= nlines)
	return(0);
    return(win->TextAttribute()->StringWidth((char *)GetLine(x)));
}

CARD
Cvo_FilePage::Height(CARD x)
{
    if (!win || x >= nlines)
	return(0);
    return(win->TextAttribute()->MHeight());
}

CARD
Cvo_FilePage::TotalHeight()
{
    if (!win)
	return(0);
    return(nlines * win->TextAttribute()->MHeight());
}
