//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: FileMatch.cc,v 1.3 1994/08/10 17:54:53 prb Exp $"); }
//
// Copyright (c) 1991 The Regents of the University of California.
// All rights reserved.
//
// This code is derived from software contributed to Berkeley by
// Kenneth Almquist.
//
// Converted to C++ for use in the Cray Visual Object library (Cvo)
// By Paul Borman, Cray Research Inc. 1992
//

#include <Cvo/_Machine.h++>
#include <stddef.h>
#include <stdlib.h>
#if	defined(__NEED_MALLOC__)
#include <malloc.h>
#endif
#include <Cvo/util.h++>

#define	CTLESC	'\\'

int
Cvo_FileFilter(char *pattern, char *string)
{   CVO_ENTER
    register char *p, *q;
    register char c;

    p = pattern;
    q = string;
    for (;;) {
	switch (c = *p++) {
	case '\0':
	    goto breakloop;
	case CTLESC:
	    if (*q++ != *p++)
		    CVO_RETURN(0)
	    break;
	case '?':
	    if (*q++ == '\0')
		    CVO_RETURN(0)
	    break;
	case '*':
	    c = *p;
	    if (c != CTLESC && c != '?' && c != '*' && c != '[') {
		while (*q != c) {
		    if (*q == '\0')
			CVO_RETURN(0)
		    q++;
		}
	    }
	    do {
		if (Cvo_FileFilter(p, q))
		    CVO_RETURN(1)
	    } while (*q++ != '\0');
	    CVO_RETURN(0)
	case '[':
	    char *endp;
	    int invert, found;
	    char chr;

	    endp = p;
	    if (*endp == '!')
		endp++;
	    for (;;) {
		if (*endp == '\0')
		    goto dft;		// no matching ]
		if (*endp == CTLESC)
		    endp++;
		if (*++endp == ']')
		    break;
	    }
	    invert = 0;
	    if (*p == '!') {
		invert++;
		p++;
	    }
	    found = 0;
	    chr = *q++;
	    c = *p++;
	    do {
		if (c == CTLESC)
		    c = *p++;
		if (*p == '-' && p[1] != ']') {
		    p++;
		    if (*p == CTLESC)
			p++;
		    if (chr >= c && chr <= *p)
			found = 1;
		    p++;
		} else {
		    if (chr == c)
			found = 1;
		}
	    } while ((c = *p++) != ']');
	    if (found == invert)
		CVO_RETURN(0)
	    break;
	dft:
	default:
	    if (*q++ != c)
		CVO_RETURN(0)
	    break;
	}
    }
breakloop:
    if (*q != '\0')
	CVO_RETURN(0)
    CVO_RETURN(1)
}
