//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Ev.cc,v 1.5 1994/08/10 17:54:53 prb Exp $"); }
//
// This code was initially contributed by Jim Nowicki 10-92
//
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <Cvo/util.h++>
#include <Cvo/Ev.h++>
#if	defined(__NEED_SYSENT__)
#include <sysent.h>
#endif
#include <sys/param.h>
#include <errno.h>

int                     Ev::nbrFds        = 0;    // Number of file descriptors
int                     Ev::eventsChanged = 0;    // Flag for event change
int                     Ev::retryCount    = 0;    // Error retry count
int                     Ev::nbrEvents     = 0;    // Number of pending IO events
int                     Ev::nbrSignals    = 0;    // Nbr active signal handlers
EvVolatile sig_atomic_t Ev::sigPending    = 0;    // Signals pending flag
EvVolatile EvSigQ       Ev::signalQs[EvNumberSignalQueues];
EvSignal               *Ev::signals[NSIG+1];

EvFdMasks              *Ev::masks         = 0;    // Masks of file descriptors
EvFdMasks              *Ev::pendingMasks  = 0;    // Pending IO descriptors
EvIOEvent              *Ev::evList        = 0;    // Current pos. in IO ev. list
EvIOEvent              *Ev::ioEvents      = 0;    // IO Event list
EvTimerEvent           *Ev::timers        = 0;    // Timer event list
EvWorkProcEvent        *Ev::workProcs     = 0;    // Work proc list
void		      (*Ev::flush)()      = 0;	  // Flush function

void
Ev::Unlink(Ev **p)
{   CVO_ENTER
    assert(p != 0);
    if (flags & EV_ACTIVE) {
	while (*p && *p != this)
	    p = &(*p)->next;
	if (*p == this)
	    *p = next;
	flags &= ~EV_ACTIVE;
    } 
    CVO_VOID_RETURN
}

EvIOEvent::EvIOEvent(int f, EvIOCond c, EvIOProc cb, void *userdata)
{   CVO_ENTER
    InitMasks();
    assert(f >= 0 && f < nbrFds);
    fd = f;
    cond = c;
    callback = cb;
    userData = userdata;
    masks->Set(fd, cond);
    Link((Ev **) &ioEvents);
    CVO_VOID_RETURN
}

EvIOEvent::~EvIOEvent()
{   CVO_ENTER
    if (flags & EV_ACTIVE) {
	masks->Clr(fd, cond);
	Unlink((Ev **) &ioEvents);
	eventsChanged = 1;
    }
    CVO_DONE
}

void
EvTimerEvent::BasicSet(const EvTimeVal &tv, EvTimerProc cb, void *ud)
{   CVO_ENTER
    eventTime = tv;
    if (cb)
	callback = cb;
    if (ud)
	userData = ud;

    EvTimerEvent **p = &timers;
    while (*p && (*p)->eventTime <= tv)
	p = (EvTimerEvent **) &(*p)->next;
    next = *p;
    *p = this;
    flags |= EV_ACTIVE;
    CVO_VOID_RETURN
}

void
EvTimerEvent::Set(long interval, EvTimerProc cb, void *ud)
{   CVO_ENTER
    if (flags & EV_ACTIVE) {
       Unlink((Ev **) &timers);
    }
    EvTimeVal tv;
    tv.SetCurrentTime();
    BasicSet(tv + interval, cb, ud);
    CVO_VOID_RETURN
}

void
EvTimerEvent::Set(const EvTimeVal &tv, EvTimerProc cb, void *ud)
{   CVO_ENTER
    if (flags & EV_ACTIVE) {
       Unlink((Ev **) &timers);
    }
    BasicSet(tv, cb, ud);
    CVO_VOID_RETURN
}

EvTimerEvent::EvTimerEvent(const EvTimeVal &tv, EvTimerProc cb, void *ud, int d)
{   CVO_ENTER
    Set(tv, cb, ud);
    if (d) {
	flags |= EV_DODELETE;
    }
    CVO_VOID_RETURN
}

EvTimerEvent::EvTimerEvent(long interval, EvTimerProc cb, void *ud, int del)
{   CVO_ENTER
    EvTimeVal tv;
    tv.SetCurrentTime();
    tv += interval;
    Set(tv, cb, ud);
    if (del) {
	flags |= EV_DODELETE;
    }
    CVO_VOID_RETURN
}

EvWorkProcEvent::EvWorkProcEvent(EvWorkProcProc cb, void *ud, int del)
{   CVO_ENTER
    callback = cb;
    userData = ud;
    Link((Ev **) &workProcs);
    if (del) {
	flags |= EV_DODELETE;
    }
    CVO_VOID_RETURN
}

int
Ev::CheckBadFD()
{   CVO_ENTER
    EvFdMasks m;
    EvTimeVal tv = 0;
    int nbrbad = 0;

    for (int f = 0; f <= nbrFds; f++) {
	if (m.CopyFd(*masks, f)) {
	    if (EvSelect(&m, &tv) < 0 && errno == EBADF) {
		// Found bad file descriptor, remove it
		masks->Clr(f);
		for (EvIOEvent *p = ioEvents; p != NULL; ) {
		    if (p->IsEvent(f)) {
                        p->Unlink((Ev **) &ioEvents);
			p->CallCallback();
			p = ioEvents;          //    Start over in list.
		    } else
			p = p->Next();
		}
		nbrbad++;
	    }
	    m.Clr(f);
	}
    }
    CVO_RETURN(nbrbad)
}

void
Ev::ProcessEvents(int control)
{   CVO_ENTER
    EvTimeVal tv_next;
    InitMasks();
    do {
	assert(ioEvents != NULL || timers != NULL || workProcs != NULL ||
	       nbrSignals != 0 || control != EV_LOOP);
	if (flush)
	    (*flush)();
	if (sigPending) {
	    DispatchSignalHandlers();
	    continue;
	}
	EvTimeVal *tvptr = NULL;
	if (timers) {
	    tv_next.SetCurrentTime();
	    if (tv_next >= timers->Time()) {
		EvTimerEvent *thistime = timers;
		int del = timers->flags & EV_DODELETE;
		thistime->Unlink((Ev **) &timers);
		thistime->CallCallback();
		if (del && (thistime->flags & EV_ACTIVE) == 0)
		    delete thistime;
		continue;
	    }
	    tv_next = timers->Time() - tv_next;
	    tvptr = &tv_next;
	}
	if (control == EV_POLL || workProcs) {
	    tv_next = 0;
	    tvptr = &tv_next;
	}
	*pendingMasks = *masks;
	nbrEvents = EvSelect(pendingMasks, tvptr);
	if (nbrEvents < 0) {
	    // Select failed, see why.
	    switch (errno) {
	    case EBADF:
		if (CheckBadFD()) {
		    *pendingMasks = *masks;
		    if ((nbrEvents = EvSelect(pendingMasks, tvptr)) >= 0) {
			break;
		    }
		    if (errno == EINTR) {
			continue;
		    }
		}
		// FALLTHRU
	    default:
		if (++retryCount >= EV_RETRY_MAX) {
		    perror("EvSelect");
		    abort();            // Program is braindead, pull the plug
		}
		// FALLTHRU
	    case EINTR:
		continue;
	    }
	}
	eventsChanged = retryCount = 0;
	if (nbrEvents > 0) {
	    evList = ioEvents;
	    while (nbrEvents > 0 && evList != NULL && !sigPending) {
		if (evList->IsEvent(pendingMasks)) {
		    pendingMasks->Clr(evList->Fd(), evList->Cond());
		    EvIOEvent *ev = evList;
		    evList = evList->Next();
		    nbrEvents--;
		    ev->CallCallback();
		    if (eventsChanged) {   // Rescan entire list?
			eventsChanged = 0;
			evList = ioEvents;
		    }
		} else
		    evList = evList->Next();
	    }
	} else if (workProcs) {
	    EvWorkProcEvent *wp = workProcs;
	    int del = wp->flags & EV_DODELETE;
	    wp->Unlink((Ev **) &workProcs);
	    if (!wp->CallCallback()) {
		wp->Link((Ev **) &workProcs);
	    } else if (del) {
		delete wp;
	    }
	}
    } while (control == EV_LOOP);
    CVO_VOID_RETURN
}
