//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Color.cc,v 1.5 1994/08/23 13:50:37 prb Exp $"); }
#include <Cvo/Window.h++>
#include <string.h>
#if defined(__NEED_STRINGS__)
#include <strings.h>
#endif

#define	char CARD8
#include "pat/g0.h"	// WHITE
#include "pat/g1.h"
#include "pat/g2.h"
#include "pat/g3.h"
#include "pat/g4.h"
#include "pat/g5.h"
#include "pat/g6.h"
#include "pat/g7.h"
#include "pat/g8.h"
#include "pat/g9.h"
#include "pat/g10.h"
#include "pat/g11.h"
#include "pat/g12.h"
#include "pat/g13.h"
#include "pat/g14.h"
#include "pat/g15.h"
#include "pat/g16.h"	// BLACK
#include "pat/p0.h"	// horizontal
#include "pat/p1.h"	// vertical
#include "pat/p2.h"	// forward
#include "pat/p3.h"	// backward
#include "pat/p4.h"	// HORIZONTAL
#include "pat/p5.h"	// VERTICAL
#include "pat/p6.h"	// FORWARD
#include "pat/p7.h"	// BACKWARD
#undef	char

#define	NPatterns	24

static CARD8 *gmaps[] = {
    g16_bits,		// BLACK
    g15_bits,
    g14_bits,
    g13_bits,
    g12_bits,
    g11_bits,
    g10_bits,
    g9_bits,
    g8_bits,
    g7_bits,
    g6_bits,
    g5_bits,
    g4_bits,
    g3_bits,
    g2_bits,
    g1_bits,
    g0_bits,		// WHITE
    p0_bits,
    p1_bits,
    p2_bits,
    p3_bits,
    p4_bits,
    p5_bits,
    p6_bits,
    p7_bits,
};

typedef struct {
    double    red;
    double    green;
    double    blue;
} _Cvo_RGB;

typedef struct {
    double    hue;
    double    lit;
    double    sat;
} _Cvo_HLS;

static void Cvo_convertColor(XColor *back,
                             XColor *upper,
                             XColor *lower,
                             XColor *select,
                             XColor *raised);
_Cvo_Color *_Cvo_Color::freelist = 0;

static _Cvo_HLS _Cvo_rgb2hls(_Cvo_RGB &rgb);
static _Cvo_RGB _Cvo_hls2rgb(_Cvo_HLS &hls);

#define	_U1		((CARD32)-1)
#define	_US1		((CARD16)-1)

Cvo_Color::Cvo_Color(Cvo_BasicObject *win, char *name, int back)
{   CVO_ENTER
    //
    // Always operate on the highest level window
    //
    win = win->RootObject();

    long black = win->Black();
    long white = win->White();

    XColor c;

    c.pixel = _U1;

    if (win->Monochrome()) {
	_Cvo_MonoColorDatabase *mc;
        if (!strcasecmp(name, "white"))
	    mc = _Cvo_FindMonoColor(16);
        else if (!strcasecmp(name, "black"))
	    mc = _Cvo_FindMonoColor(0);
	else
	    mc = _Cvo_FindMonoColor(name, back);

	color = Cvo_Color(win, mc->level, back, mc)->Copy();
	CVO_VOID_RETURN
    }

    Cvo_Quark qname = name;

    _Cvo_Color *cwc = win->DisplayList()->colors;

    while (cwc) {
	if (win == cwc->window && cwc->name == qname)
	    break;
        cwc = cwc->next;
    }

    if (cwc) {
	color = cwc->Copy();
        CVO_VOID_RETURN
    }

    cwc = win->DisplayList()->colors;

    XParseColor(win->Dpy(), win->Cmap(), name, &c);
    c.pixel = _U1;

    while (cwc) {
        if (c.pixel != _U1) {
            if (win == cwc->window && cwc->color.pixel == c.pixel
				   && !cwc->usepixmap)
                break;
        } else {
            if (win == cwc->window && cwc->color.red == c.red &&
		        	      cwc->color.green == c.green &&
		        	      cwc->color.blue == c.blue &&
		        	      !cwc->usepixmap)
		break;
        }
        cwc = cwc->next;
    }

    if (cwc) {
	color = cwc->Copy();
        CVO_VOID_RETURN
    }

    if (c.pixel == _U1 &&
        !XAllocColor(win->Dpy(), win->Cmap(), &c)) {
        cwc = win->DisplayList()->colors;
        while (cwc) {
            if (win == cwc->window &&
                cwc->pixel == (back ? white : black))
                break;
            cwc = cwc->next;
        }
        if (cwc) {
	    color = cwc->Copy();
            CVO_VOID_RETURN
        }
        c.pixel = back ? white : black;
        c.red = c.blue = c.green = back ? _US1 : 0;
    }

    color = new _Cvo_Color(win->DisplayList()->colors);

    color->name = qname;
    color->window = win;
    color->color = c;
    color->pixel = c.pixel;
    if (c.pixel == black || c.pixel == white)
	++color->refcnt;
    CVO_VOID_RETURN
}

Cvo_Color::Cvo_Color(Cvo_BasicObject *win, XColor &c, int back)
{   CVO_ENTER
    //
    // Always operate on the highest level window
    //
    win = win->RootObject();

    long black = win->Black();
    long white = win->White();

    _Cvo_Color *cwc = win->DisplayList()->colors;

    while (cwc) {
        if (c.pixel != _U1) {
            if (win == cwc->window && cwc->color.pixel == c.pixel
				   && !cwc->usepixmap)
                break;
        } else {
            if (win == cwc->window &&
		cwc->color.red == c.red &&
                cwc->color.green == c.green &&
                cwc->color.blue == c.blue &&
		!cwc->usepixmap)
            break;
        }
        cwc = cwc->next;
    }

    if (cwc) {
        color = cwc->Copy();
        CVO_VOID_RETURN
    }

    if (c.pixel == _U1 &&
        !XAllocColor(win->Dpy(), win->Cmap(), &c)) {
        cwc = win->DisplayList()->colors;
        while (cwc) {
            if (win == cwc->window && cwc->pixel == (back ? white : black))
                break;
            cwc = cwc->next;
        }
        if (cwc) {
            color = cwc->Copy();
            CVO_VOID_RETURN
        }
        c.pixel = back ? white : black;
        c.red = c.blue = c.green = back ? _US1 : 0;
    }

    color = new _Cvo_Color(win->DisplayList()->colors);

    color->window = win;
    color->color = c;
    color->pixel = c.pixel;
    if (c.pixel == black || c.pixel == white)
	++color->refcnt;
    CVO_VOID_RETURN
}

Cvo_Color::Cvo_Color(Cvo_BasicObject *win, double hue, double lit, double sat, int back)
{   CVO_ENTER
    _Cvo_RGB rgb;
    _Cvo_HLS hls;

    while (hue < 0)
	hue += 360.0;
    while (hue > 360)
	hue -= 360.0;
    if (lit > 1.0)
	lit = 1.0;
    if (lit < 0)
	lit = 0;
    if (sat > 1.0)
	sat = 1.0;
    if (sat < 0)
	sat = 0;

    hls.hue = hue;
    hls.lit = lit;
    hls.sat = sat;
    rgb = _Cvo_hls2rgb(hls);

    XColor c;
    c.red = (CARD16)(rgb.red * 65535.0);
    c.green = (CARD16)(rgb.green * 65535.0);
    c.blue = (CARD16)(rgb.blue * 65535.0);
    c.pixel = _U1;
    c.flags = DoRed|DoGreen|DoBlue;

    color = Cvo_Color(win, c, back)->Copy();
    CVO_VOID_RETURN
}

Cvo_Color::Cvo_Color(Cvo_BasicObject *win, int level, int, _Cvo_MonoColorDatabase *mc)
{   CVO_ENTER
    //
    // Always operate on the highest level window
    //
    win = win->RootObject();

    long black = win->Black();
    long white = win->White();

    if (level < 0)
	level = 0;	// Black
    else if (level > NPatterns)
	level = 16;	// White

    _Cvo_Color *cwc = win->DisplayList()->colors;

    while (cwc) {
        //
        // We could compare win->Dpy() == window->Dpy() here if
        // we want, that would give one color pool per display.
        // But I am not sure that is correct on displays that support
        // multiple visual depths
        //
	if (win == cwc->window && cwc->monochrome && cwc->level == level)
	    break;

        cwc = cwc->next;
    }

    if (cwc) {
        color = cwc->Copy();
	CVO_VOID_RETURN
    }

    color = new _Cvo_Color(win->DisplayList()->colors);

    int dp = DisplayPlanes(win->Dpy(), win->XScreen());

    if (level != 0 && level != 16) {
	color->pixmap = XCreatePixmapFromBitmapData(win->Dpy(),
						  win->Root(),
						  (char *)gmaps[level],
						  4, 4,
						  black, white, dp);
	if (win->Depth() == 1)
	    color->pixmap1 = color->pixmap;
	else {
	    color->pixmap1 = XCreatePixmapFromBitmapData(win->Dpy(),
						       win->Root(),
						       (char *)gmaps[level],
						       4, 4,
						       black, white, 1);
	}
    }
    color->window = win;

    if (!mc || !(mc->upper || mc->lower || mc->select))
	mc = _Cvo_FindMonoColor(level);

    color->color.red = mc->upper;
    color->color.green = mc->lower;
    color->color.blue = mc->select;

    if (level == 0) {
	color->pixel = black;
    } else if (level == 16) {
	color->pixel = white;
    } else {
	color->pixel = black;
	color->usepixmap = True;
    }

    color->monochrome = True;
    color->level = level;
    color->color.pixel = _U1;
    color->color.flags = DoRed|DoGreen|DoBlue;

    if (color->pixel == black || color->pixel == white)
	++color->refcnt;

    CVO_VOID_RETURN
}

_Cvo_Color::_Cvo_Color(_Cvo_Color *&root)
{   CVO_ENTER
    next = root;
    root = this;
    name = 0;

    window = 0;
    usepixmap = False;
    monochrome = False;
    level = 0;
    pixmap = 0;
    pixmap1 = 0;
    pixel = _U1;

    refcnt = 1;
    CVO_VOID_RETURN
}

_Cvo_Color::~_Cvo_Color()
{   CVO_ENTER
    _Cvo_Color *&root = window->DisplayList()->colors;

    if (this == root)
        root = next;
    else if (root) {
        _Cvo_Color *c = root;
        while (c->next && c->next != this)
            c = c->next;
        if (c->next == this)
            c->next = next;
    }
    next = this;

    if (usepixmap) {
	XFreePixmap(window->Dpy(), pixmap);
	if (pixmap1 != pixmap)
	    XFreePixmap(window->Dpy(), pixmap1);
    } else if (pixel != _U1 && pixel != window->White()
			    && pixel != window->Black()) {
	unsigned long p = pixel;	// if CARD32 is not unsigned long
	XFreeColors(window->Dpy(), window->Cmap(), &p, 1, 0);
    }
    CVO_DONE
}

Cvo_Color &
_Cvo_Color::MakeUpper()
{   CVO_ENTER

    if (monochrome) {
	upper = Cvo_Color(window, color.red, CvoC_BACKGROUND);
    } else {
	XColor c;

	Cvo_convertColor(&color, &c, 0, 0, 0);
	upper = Cvo_Color(window, c, CvoC_BACKGROUND);
    }
    CVO_RETURN(upper)
}

Cvo_Color &
_Cvo_Color::MakeLower()
{   CVO_ENTER

    if (monochrome) {
	lower = Cvo_Color(window, color.green, CvoC_BACKGROUND);
    } else {
	XColor c;

	Cvo_convertColor(&color, 0, &c, 0, 0);
	lower = Cvo_Color(window, c, CvoC_BACKGROUND);
    }
    CVO_RETURN(lower)
}

Cvo_Color &
_Cvo_Color::MakeSelect()
{   CVO_ENTER

    if (monochrome) {
	select = Cvo_Color(window, color.blue, CvoC_BACKGROUND);
    } else {
	XColor c;

	Cvo_convertColor(&color, 0, 0, &c, 0);
	select = Cvo_Color(window, c, CvoC_BACKGROUND);
    }
    select->raised = Cvo_Color(this);
    CVO_RETURN(select)
}

Cvo_Color &
_Cvo_Color::MakeRaised()
{   CVO_ENTER

    if (monochrome) {
	raised = Cvo_Color(window, color.blue, CvoC_BACKGROUND);
    } else {
	XColor c;

	Cvo_convertColor(&color, 0, 0, 0, &c);
	raised = Cvo_Color(window, c, CvoC_BACKGROUND);
    }
    raised->select = Cvo_Color(this);
    CVO_RETURN(raised)
}

double
_Cvo_Color::Hue() const
{
    if (monochrome)
	return(0.0);

    _Cvo_RGB rgb;
    _Cvo_HLS hls;

    rgb.red = (double)color.red/65535.0;
    rgb.green = (double)color.green/65535.0;
    rgb.blue = (double)color.blue/65535.0;

    hls = _Cvo_rgb2hls(rgb);
    return(hls.hue);
}

double
_Cvo_Color::Lightness() const
{
    if (monochrome)
	return(NPatterns / double(level));

    _Cvo_RGB rgb;
    _Cvo_HLS hls;

    rgb.red = (double)color.red/65535.0;
    rgb.green = (double)color.green/65535.0;
    rgb.blue = (double)color.blue/65535.0;

    hls = _Cvo_rgb2hls(rgb);
    return(hls.lit);
}

double
_Cvo_Color::Saturation() const
{
    if (monochrome)
	return(0.0);

    _Cvo_RGB rgb;
    _Cvo_HLS hls;

    rgb.red = (double)color.red/65535.0;
    rgb.green = (double)color.green/65535.0;
    rgb.blue = (double)color.blue/65535.0;

    hls = _Cvo_rgb2hls(rgb);
    return(hls.sat);
}

//
// Cvo_convertColor
//      Calculate the upper and lower chamfered edges given a background
//      color.
//
//      back    Points to a XColor structure containing the background RGB
//              values
//      upper   Points to a XColor structure where the upper (lighter)
//              chamfered color is placed.
//      lower   Points to a XColor structure where the lower (darker)
//              chamfered color is placed.
//      select  Points to a XColor structure where the select (a little darker)
//              color is placed.
//      raised  Points to a XColor structure where the raised (a little lighter)
//              color is placed.
//
//      Note that the colors are not allocated, only the XColor structures
//      are filled in.
//
static void
Cvo_convertColor(XColor *back, XColor *upper, XColor *lower, XColor *select, XColor *raised)
{   CVO_ENTER
    _Cvo_RGB rgb;
    _Cvo_HLS hls1;
    _Cvo_HLS hls2;
    _Cvo_HLS hls3;
    _Cvo_HLS hls4;
    
    rgb.red = (double)back->red/65535.0;
    rgb.green = (double)back->green/65535.0;
    rgb.blue = (double)back->blue/65535.0;

    hls1 = _Cvo_rgb2hls(rgb);
    hls2 = hls1;
    hls3 = hls1;
    hls4 = hls1;

    if (hls1.lit > .925) {
        hls1.lit *= 0.90;
        hls2.lit *= 0.75;
        hls1.sat *= 0.25;
        hls2.sat *= 0.25;
        hls3.sat *= 0.25;
    } else if (hls1.lit < 0.0) {
        hls1.lit = 0.50;
        hls2.lit = 0.33;
    } else if (hls1.lit < 0.40) {
        hls1.lit = (hls1.lit/0.40) * .2 + .5;
        hls2.lit = 0.33;
    } else {
        hls1.lit = ((hls1.lit-0.40)/0.50) * .15 + .80;
        hls2.lit *= .75;
    }

    if (hls3.lit > 0.925 * 0.85)
	if ((hls4.sat /= 0.25) > 1.0)
	    hls4.sat = 1.0;
    if ((hls4.lit /= 0.85) > 1.0)
        hls4.lit = 1.0;

    hls3.lit *= 0.85;


    if (upper) {
        rgb = _Cvo_hls2rgb(hls1);    // Upper Color

        upper->red = (CARD16)(rgb.red * 65535.0);
        upper->green = (CARD16)(rgb.green * 65535.0);
        upper->blue = (CARD16)(rgb.blue * 65535.0);
        upper->pixel = _U1;
        upper->flags = DoRed|DoGreen|DoBlue;
    }

    if (lower) {
        rgb = _Cvo_hls2rgb(hls2);    // Lower Color

        lower->red = (CARD16)(rgb.red * 65535.0);
        lower->green = (CARD16)(rgb.green * 65535.0);
        lower->blue = (CARD16)(rgb.blue * 65535.0);
        lower->pixel = _U1;
        lower->flags = DoRed|DoGreen|DoBlue;
    }

    if (select) {
        rgb = _Cvo_hls2rgb(hls3);    // Select Color

        select->red = (CARD16)(rgb.red * 65535.0);
        select->green = (CARD16)(rgb.green * 65535.0);
        select->blue = (CARD16)(rgb.blue * 65535.0);
        select->pixel = _U1;
        select->flags = DoRed|DoGreen|DoBlue;
    }

    if (raised) {
        rgb = _Cvo_hls2rgb(hls3);    // Select Color

        raised->red = (CARD16)(rgb.red * 65535.0);
        raised->green = (CARD16)(rgb.green * 65535.0);
        raised->blue = (CARD16)(rgb.blue * 65535.0);
        raised->pixel = _U1;
        raised->flags = DoRed|DoGreen|DoBlue;
    }
    CVO_VOID_RETURN
}

static _Cvo_HLS
_Cvo_rgb2hls(_Cvo_RGB &rgb)
{   CVO_ENTER
    double max = rgb.red;
    double min = rgb.red;
    double rc, gc, bc;

    _Cvo_HLS hls;

    if (rgb.green > max)
        max = rgb.green;

    if (rgb.blue > max)
        max = rgb.blue;

    if (rgb.green < min)
        min = rgb.green;

    if (rgb.blue < min)
        min = rgb.blue;

    hls.lit = (max + min) / 2.0;
    if (max == min) {
        hls.sat = 0;
        hls.hue = 0;
    } else {
        if (hls.lit < 0.5)
            hls.sat = (max - min)/(max + min);
        else
            hls.sat = (max - min)/(2.0 - max - min);
        rc = (max - rgb.red)/(max - min);
        gc = (max - rgb.green)/(max - min);
        bc = (max - rgb.blue)/(max - min);

        if (rgb.red == max)
            hls.hue = bc - gc;
        else if (rgb.green == max)
            hls.hue = 2.0 + rc - bc;
        else
            hls.hue = 4.0 + gc - rc;
        hls.hue *= 60.0;
        if (hls.hue < 0.0)
            hls.hue += 360.0;
    }
    CVO_RETURN(hls)
}

static double
value(double n1, double n2, double hue)
{   CVO_ENTER
    if (hue > 360.0)
        hue -= 360.0;
    else if (hue < 0.0)
        hue += 360.0;
    if (hue < 60.0)
        CVO_RETURN(n1 + (n2 - n1) * hue / 60.0)
    if (hue < 180.0)
        CVO_RETURN(n2)
    if (hue < 240)
        CVO_RETURN(n1 + (n2 - n1) * (240.0 - hue) / 60)
    CVO_RETURN(n1)
}

static _Cvo_RGB
_Cvo_hls2rgb(_Cvo_HLS &hls)
{   CVO_ENTER
    _Cvo_RGB rgb;
    double m1, m2;

    if (hls.lit < 0.5)
        m2 = hls.lit * (1 + hls.sat);
    else
        m2 = hls.lit + hls.sat - hls.lit * hls.sat;

    m1 = 2 * hls.lit - m2;

    if (hls.sat == 0) {
        rgb.red = hls.lit;
        rgb.green = hls.lit;
        rgb.blue = hls.lit;
    } else {
        rgb.red = value(m1, m2, hls.hue + 120.0);
        rgb.green = value(m1, m2, hls.hue);
        rgb.blue = value(m1, m2, hls.hue - 120.0);
    }
    CVO_RETURN(rgb)
}
