//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: ButtonMenu.cc,v 1.12 1994/09/21 18:18:28 prb Exp $"); }
#include <Cvo/ButtonMenu.h++>
#include <string.h>
#include <stdio.h>

CONSTRUCTORS_1ARG(Cvo_ButtonMenu, Cvo_MenuLabel, "CvoButtonMenu", Cvo_MenuItem *)
CONSTRUCTORS_2ARG(Cvo_ButtonMenu, Cvo_MenuLabel, "CvoButtonMenu", Cvo_MenuItem *, Cvo_MenuBar *)
CVO_CREATE_REGISTER_FUNCTIONS(Cvo_ButtonMenu)

CVO_BEGIN_BIND(Cvo_ButtonMenu)
CVO_DOBIND(Cvo_ButtonMenu, "Press",   Down)
CVO_DOBIND(Cvo_ButtonMenu, "Release", Up)  
CVO_END_BIND(Cvo_ButtonMenu, Cvo_MenuLabel)

static char *trans = "\
    <ButtonPress>: Press()\n\
    <ButtonRelease>: Release()\n\
";

static Cvo_Default def[] = {
        "*CvoButtonMenu.Cursor:Top Left Arrow",
        "*CvoButtonMenu.Pad:2",
        "*CvoButtonMenu.BorderWidth:0",
        "*CvoButtonMenu.FontWeight:Bold",
};

static void voidhandler(Cvo_Object *, XEvent *, void *) { ; }

void
Cvo_ButtonMenu::CallMe(Cvo_Object *obj, XEvent *ev, void *vb)
{
    Cvo_ButtonMenu* cbm = (Cvo_ButtonMenu*)vb;
    if ((! cbm->Mapped()) || (cbm->Root() != obj->Root()))
	    return;

    ((Cvo_ButtonMenu *)vb)->Start(ev, 0);
}

void
Cvo_ButtonMenu::_Init(Cvo_MenuItem *mi, Cvo_MenuBar *mb)
{   CVO_ENTER
    type = CvoT_ButtonMenu;

    Compact(True);
    cnt = 0;
    waitcnt = 0;
    flat = 1;
    menu = 0;
    bar = mb;
    Flatten();

    menuitems = mi;

    AddTranslations(trans);
    Register(CvoButtonDownEvent, &Cvo_ButtonMenu::Start);

    //
    // XXX - this only really needs to be registered for when a menu
    // is actually up, but we have to get all of them on the menu bar.
    // might want to fix this in the future.
    //
    Register(EnterNotify, voidhandler);
    Register(LeaveNotify, voidhandler);

    char *s = Name();
    char *nm = new char [ strlen(s) + 6 ];
    sprintf(nm, "%s-menu", s);

    menu = new Cvo_Menu(nm, Dpy(), menuitems);
    menu->Owner(bar);

    delete [] nm;
    menu->Register(CvoDestroyedEvent,
	           Cvo_ButtonMenu::Destroyed, this)->AddDependent(this);
    menu->Register(CvoUnmapRequestEvent,
	           Cvo_ButtonMenu::Destroyed, this)->AddDependent(this);

    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::Accelerate()
{
    if (accel) {
	KeyCode k;
	CARD st;
	if (Cvo_ParseAccelerator(this, "Alt-F", k, st) == False &&
	    Cvo_ParseAccelerator(this, "Meta-F", k, st) == False &&
	    Cvo_ParseAccelerator(this, "Super-F", k, st) == False &&
	    Cvo_ParseAccelerator(this, "Hyper-F", k, st) == False &&
	    Cvo_ParseAccelerator(this, "CTRL-F", k, st) == False) {
		//
		// No good modifiers were found...
		//
		return;
    	}

	DisplayList()->AddAccelerator(this, accel, st, Cvo_ButtonMenu::CallMe, this);
    }
}

void
Cvo_ButtonMenu::_Create()
{   CVO_ENTER
    if (Object())
        CVO_VOID_RETURN

    SetDefaultText(Name());
    Cvo_MenuLabel::_Create();
    SetWindowBorder(Background());
    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::Start(XEvent *ev, void *)
{   CVO_ENTER

    Unflatten();
    _drawChamfer();

    if (!menu->Object()) {
	menu->SetWindowBackground(Background());
	menu->SetWindowForeground(Foreground());
    }

    //
    // We know the win field is not set when being called from
    // the Cvo_MenuBarFilter::Filter function.
    // If we are called from there we should not set up the filters
    // as they have already been set up.
    //
    if (ev->xany.window && bar) {
	(new Cvo_MenuBarFilter(this, bar))->MoveUpFront();
    }
    if (ev->xany.display) {
	(new Cvo_ButtonMenuFilter)->MoveUpFront();
    }

    if (ev->type == ButtonPress) {
	menu->Start(_cvo_button_count(ev) + 1, this);
    } else
	menu->Start(0, this);
    ForceRelease();		// We lost the button up in the menu...
    CVO_VOID_RETURN
}

Cvo_MenuSessionFilterResponse
Cvo_ButtonMenuFilter::Filter(Cvo_Object *, XEvent *ev)
{
    switch (ev->type) {
    case LeaveNotify: {
	XCrossingEvent *xce = (XCrossingEvent *)ev;
	if (xce->mode != NotifyNormal)
	    return(CvoMenuSessionFilterReturn);
	return(CvoMenuSessionFilterDeleteMe);
      }
    case EnterNotify: {
	XCrossingEvent *xce = (XCrossingEvent *)ev;
	if (xce->mode != NotifyNormal)
	    return(CvoMenuSessionFilterReturn);
	return(CvoMenuSessionFilterDeleteMe);
      }
    case ButtonRelease:
	return(CvoMenuSessionFilterDeleteMe);
    default:
	return(CvoMenuSessionFilterReturn);
    }
}

Cvo_MenuBarFilter::Cvo_MenuBarFilter(Cvo_ButtonMenu *m, Cvo_MenuBar *b)
{
    menu = m;
    bar = b;
}

Cvo_MenuSessionFilterResponse
Cvo_MenuBarFilter::Filter(Cvo_Object *win, XEvent *ev)
{
    XEvent *sev;
    XButtonEvent xbe;
    XKeyEvent xke;
    Cvo_ButtonMenu *bm;

    memset(&xbe, 0, sizeof(xbe));

    switch (ev->type) {
    case KeyPress: {
    	Cvo_MenuBarEntries *mbe = bar->Menus();

    	while (mbe && mbe->button != menu)
	    mbe = mbe->next;

    	if (!mbe)
	    return(CvoMenuSessionFilterReturn);

	XKeyEvent *ke = (XKeyEvent*)ev;

	xke.type = KeyPress;
    	xke.state = ke->state;
    	sev = (XEvent *)&xke;

	switch (XKeycodeToKeysym(win->Dpy(), ke->keycode, 0)) {
    	case XK_Left:
	    if (ev->xany.serial != (unsigned long)-1)
		return(CvoMenuSessionFilterAgainAtEnd);
    	    if (mbe->prev) {
		bm = mbe->prev->button;
		goto switch_menu;
	    }
    	    break;
    	case XK_Right:
	    if (ev->xany.serial != (unsigned long)-1)
		return(CvoMenuSessionFilterAgainAtEnd);
    	    if (mbe->next) {
		bm = mbe->next->button;
		goto switch_menu;
	    }
    	    break;
	}
	return(CvoMenuSessionFilterReturn);
      }
    case EnterNotify: {
	XCrossingEvent *xce = (XCrossingEvent *)ev;

	if (!win || win == menu
		 || win->Type() != CvoT_ButtonMenu
		 || !(xce->state & ButtonMask))
	    return(CvoMenuSessionFilterReturn);

	bm = (Cvo_ButtonMenu *)win;

	if (bm->Bar() != bar)
	    return(CvoMenuSessionFilterReturn);

	//
	// Fill in enough parameters for Start() above
	//
	xbe.type = ButtonPress;
    	xbe.state = xce->state;
    	sev = (XEvent *)&xbe;
    	goto switch_menu;
      }
    case ButtonPress: {
	int x = ev->xbutton.x_root;
	int y = ev->xbutton.y_root;

	menu->ComputeOriginFromRoot(&x, &y);
	win = menu->DiscoverWindow(x, y, True);

	if (!win || win == menu || win->Type() != CvoT_ButtonMenu)
	    return(CvoMenuSessionFilterReturn);

        bm = (Cvo_ButtonMenu *)win;
        
        if (bm->Bar() != bar)
            return(CvoMenuSessionFilterReturn);

    	sev = ev;
    	goto switch_menu;
      }
    switch_menu: {
    	if (menu == bm) {
	    return(CvoMenuSessionFilterProcessed);
    	}
        // 
        // Okay, we have entered a button menu while a mouse button is
        // pressed and it is on our menu bar.
        // Pop all the filters up to us,
        // Tear down the old menu and bring us up.
        //
        while (next)
            delete next;
        menu->Menu()->Unmap();
        menu = bm;
        
	Window w = sev->xbutton.window;
    	sev->xbutton.window = 0;
        menu->Start(sev, 0);
    	sev->xbutton.window = w;
        return(CvoMenuSessionFilterProcessed);
      }
    default:
	return(CvoMenuSessionFilterReturn);
    }
}

void
Cvo_ButtonMenu::Destroyed(Cvo_Object *, XEvent *, void *w)
{   CVO_ENTER
    Cvo_ButtonMenu *bm = (Cvo_ButtonMenu *)w;

    bm->Flatten();
    bm->_clearChamfer();
    bm->Flush();

    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::ForceDown()
{
    if (!cnt) {
	XEvent ev;
	ev.type = 0;
	Down(&ev, 0, 0);
    }
}

void
Cvo_ButtonMenu::ForceUp(BOOL useit)
{
    if (cnt) {
	XEvent ev;
	if (!useit) {
	    ev.xbutton.button = 0;
	    ev.xbutton.state = 0;
	    ev.xbutton.y =
	    ev.xbutton.x = -(BorderWidth() - 1);
	    ev.type = ButtonPress;
	    FromXCoord(&ev.xbutton.x, &ev.xbutton.y);
	} else {
	    ev.type = 0;
	}
	Up(&ev, 0, 0);
    }
}

void
Cvo_ButtonMenu::LocalDown(XEvent *ev, int, char **)
{   CVO_ENTER
    Cvo_ButtonEvent bev;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	bev.button = ev->xbutton.button;
	bev.state = ev->xbutton.state;
    } else {
	bev.button = 0;
	bev.state = 0;
    }

    if (!flat) {
	if (sunken ^= 1) {
	    SelectBackground();
	} else {
	    NormalBackground();
	}
	Redraw();
    }

    bev.value = 0;
    SendEvent(CvoButtonDownEvent, &bev);
    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::LocalUp(XEvent *ev, int, char **)
{   CVO_ENTER
    int b = 0;
    int x = 0;
    int y = 0;
    int bw = BorderWidth();
    unsigned int s = 0;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	x = ev->xbutton.x;
	y = ev->xbutton.y;
	b = ev->xbutton.button;
	s = ev->xbutton.state;
	ToXCoord(&x, &y);
    }

    if (!flat) {
	if (sunken ^= 1) {
	    SelectBackground();
	} else {
	    NormalBackground();
	}
	Redraw();
    }

    if (x >= -bw && y >= -bw && x <= XWidth() + bw && y <= XHeight() + bw) {
	Cvo_ButtonEvent bev;
	bev.value = 0;
	bev.button = b;
	bev.state = s;
	SendEvent(CvoButtonUpEvent, &bev);
    }
    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::Down(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    if (!Sensitive())
	CVO_VOID_RETURN

    if (ev->type == ButtonPress) {
	if (cnt == 0) {
	    cnt = _cvo_button_count(ev) + 1;
	    LocalDown(ev, ac, av);
    	} else
	    cnt = _cvo_button_count(ev) + 1;
    } else {
	if (cnt < 0)
	    cnt = 0;
	if (cnt++ == 0)
	    LocalDown(ev, ac, av);
    }
    CVO_VOID_RETURN
}

void
Cvo_ButtonMenu::Up(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    if (!Sensitive())
	CVO_VOID_RETURN

    if (cnt > 0 && ev->type == ButtonRelease)
	cnt = _cvo_button_count(ev);
    if (--cnt <= 0) {
	if (cnt < 0)
	    cnt = 0;
	else {
	    LocalUp(ev, ac, av);
	}
    }
    CVO_VOID_RETURN
}
