//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: BasicObject.cc,v 1.5 1994/09/07 20:46:54 prb Exp $"); }
#include <Cvo/Window.h++>
#include <memory.h>
#include <string.h>
#if	!defined(X11R4)
#include <X11/Xlocale.h>
#endif

Cvo_BasicObject *Cvo_BasicObject::base = 0;
Cvo_DisplayList *Cvo_BasicObject::defdpy = 0;
Cvo_BasicObject *Cvo_BasicObject::freelist = 0;
int Cvo_BasicObject::_serial = 0;

FILE *_printoptimize = 0;

Cvo_BasicObject::Cvo_BasicObject(Cvo_BasicObject *parent)
{   CVO_ENTER
    display = parent->display;
    _Init();
    CVO_VOID_RETURN
}

Cvo_BasicObject::Cvo_BasicObject(Display *_display)
{   CVO_ENTER
    if (!_display) {
	if (!defdpy && !Cvo_OpenDefaultDisplay()) {
	    Cvo_Failure(CvoE_FATAL,
		   CvoE_CANTOPEN,
		   "Cannot open display ``%s''\n",
		   XDisplayName(_Cvo_Base.DisplayName));
	}
	display = defdpy;
    } else
	display = defdpy->FindDisplayList(_display);
    _Init();
    CVO_VOID_RETURN
}

Cvo_BasicObject &
Cvo_BasicObject::operator =(Cvo_BasicObject &)
{   CVO_ENTER
    Cvo_Failure(CvoE_ABORT, CvoE_COPYCLASS,
		"Copy constructor called on Cvo Object\n");
    CVO_RETURN(*this)
}

Cvo_BasicObject::Cvo_BasicObject(Cvo_BasicObject &)
{   CVO_ENTER
    Cvo_Failure(CvoE_ABORT, CvoE_COPYCLASS,
		"Copy constructor called on Cvo Object\n");
    CVO_VOID_RETURN
}

void
Cvo_BasicObject::_Init()
{   CVO_ENTER
    cvo_level = _CVO_BASIC_OBJECT;

    if (magic != Cvo_MAGIC)
        Cvo_Failure(CvoE_ABORT, CvoE_STATICLASS,
                    "Cvo Object appears to be an automatic\n");
    magic = Cvo_MAGIC;        // Indicate we have been allocated
    window = 0;
    width = 0;
    height = 0;
    mapped = 0;
    incopy = 0;
    exposed = 0;
    configured = 0;
    flattened = 0;
    sunken = 0;
    unsensitive = 0;
    etched = 0;
    frame = 0;
    oldconfigured = 0;
    positioned = 0;
    dontmap = 0;
    override = 0;
    ispixmap = 0;
    dokeytext = False;
    amlayingout = False;
    inputonly = False;
    sentmoved = False;
    sentresize = False;
    selectregistered = False;
    selectnotify = False;
    locksize = False;
    notranslations = False;
    reverse = False;
    hidemoat = False;

    type = CvoT_BasicObject;

    if (!base) {
        prev = (Cvo_BasicObject *)0;
        next = (Cvo_BasicObject *)0;
        base = this;
    } else {
        next = base;
        prev = 0;
        base->prev = this;
        base = this;
    }
    serial = ++_serial;

    if ((depth  = DisplayPlanes(Dpy(), XScreen())) <= 1)
        monochrome = 1;
    else
        monochrome = 0;
    CVO_VOID_RETURN
}

Cvo_BasicObject::~Cvo_BasicObject()
{   CVO_ENTER
    Cvo_Lock lock;

    if (magic != Cvo_MAGIC)
	CVO_VOID_RETURN

    if (type) {
	if (base == this) {
	    base = next;
	} else {
	    prev->next = next;
	    if (next)
		next->prev = prev;
	}

	type = 0;
    }
    CVO_DONE
}

Cvo_BasicObject *
Cvo_BasicObject::RootObject()
{
    Cvo_Object *obj;

    if (obj = ToObject()) {
	while (obj->Parent())
	    obj = obj->Parent();
	return(obj);
    }
    return(this);
}

void *
Cvo_BasicObject::operator new(size_t sz)
{   CVO_ENTER
    Cvo_BasicObject *w = freelist;

    while (w && w->size != sz) {
        w = w->next;
    }

    //
    // If we found something of the correct size, remove it from the
    // free list, otherwise allocate an object.
    //
    if (w) {
        if (w->prev)
            w->prev->next = w->next;
        else
            freelist = w->next;

        if (w->next)
            w->next->prev = w->prev;
    } else {
        if (_printoptimize) {
            static int x = 0;
            fprintf(_printoptimize, "Cvo_OptimizeObjectCreation ___obj%d = %d;\n", x++, sz);
            fflush(_printoptimize);
        }
        w = (Cvo_Object *)new char[sz];
        if (!w) {
            fprintf(stderr, "Cvo general memory allocation failure.\n");
            exit(1);
        }
    }

    memset((char *)w, 0, sz);
    w->size = sz;
    w->magic = Cvo_MAGIC;        // Indicate we have been allocated
    CVO_RETURN((void *)w)
}

size_t Cvo_OptimizeObjectCreation::total = 0;
int Cvo_OptimizeObjectCreation::count = 0;
int Cvo_OptimizeObjectCreation::maxcnt = 256;
size_t Cvo_OptimizeObjectCreation::blocks[256];

Cvo_OptimizeObjectCreation::Cvo_OptimizeObjectCreation(int sz)
{   CVO_ENTER
    total += (sz + 7) & ~7;
    blocks[count++] = sz;
    if (count == maxcnt)
	CreateBlocks();
    CVO_VOID_RETURN
}

void 
Cvo_OptimizeObjectCreation::CreateBlocks()
{   CVO_ENTER
    if (!total || !count)
	CVO_VOID_RETURN
    char *tmp = new char [total];

    while (count-- > 0) {
	Cvo_Object *w = (Cvo_Object *)tmp;
	tmp += (blocks[count] + 7) & ~7;
	w->size = blocks[count];
	w->prev = 0;
	w->magic = 0;
	w->next = Cvo_Object::freelist;
	if (Cvo_Object::freelist)
	    Cvo_Object::freelist->prev = w;
	Cvo_Object::freelist = w;
    }
    total = 0;
    count = 0;
    CVO_VOID_RETURN
}

void
Cvo_BasicObject::operator delete(void *p)
{   CVO_ENTER
    Cvo_BasicObject *w = (Cvo_BasicObject *)p;

    if (w->magic == Cvo_MAGIC) {
	w->next = freelist;
	w->prev = 0;
	w->magic = 0;			// Indicate we are not allocated
	w->serial = 0;			// Also nuke the serial number
	if (freelist)
	    freelist->prev = w;
	freelist = w;
    }
    CVO_VOID_RETURN
}

void
Cvo_InitializeLocale(char *lang)
{   CVO_ENTER

    static int onetime = 0;
    if (onetime++)
	CVO_VOID_RETURN

    if (!lang)
	lang = "";

#if    !defined(X11R4)
    char *locale;

    if (!(locale = setlocale(LC_ALL, lang))) {
	locale = *lang ? lang : getenv("LANG");
        Cvo_Failure(locale ? CvoE_WARN : CvoE_FATAL,
                CvoE_LOCALE,
                "Cannot set locale to %s\n",
			locale ? locale : "default-locale");
	setlocale(LC_ALL, "C");
	_Cvo_Base.Locale = "C";
    } else {
	locale = *lang ? lang : getenv("LANG");
	_Cvo_Base.Locale = (locale && *locale) ? locale : "C";
    }

    int CanSupportLocale = True;

    if (!XSupportsLocale()) {
	setlocale(LC_ALL, "C");
        if (XSupportsLocale()) {
	    Cvo_Failure(CvoE_WARN,
		    CvoE_UNSLOCALE,
		    "Locale %s not supported by X\n", _Cvo_Base.Locale);
	} else
	    CanSupportLocale = False;
	_Cvo_Base.Locale = "C";
//	Cvo_Failure(CvoE_FATAL,
//		CvoE_UNSLOCALE,
//		    "Default locale not supported by X!\n", _Cvo_Base.Locale);
    }
    if (CanSupportLocale && !XSetLocaleModifiers("")) {
        Cvo_Failure(CvoE_WARN,
                CvoE_LOCALEMOD,
                "Cannot set locale modifiers for %s\n", _Cvo_Base.Locale);
	setlocale(LC_ALL, "C");
	_Cvo_Base.Locale = "C";
    }
#else
    _Cvo_Base.Locale = "C";
#endif
    CVO_VOID_RETURN
}

BOOL
Cvo_OpenDefaultDisplay()
{   CVO_ENTER
    //
    // The very first window created should go through
    // this creation path, as the others assume a display
    // has already been set.  If we dectect that the application
    // did not call Cvo_Parse, then we fake a call to it so that
    // the program will at least be initialized.
    //
    if (!_Cvo_Base.ProgramName) {
        int argc = 1;
        static char *_argv[] = {
            "cvo",
            0,
        };
        char **argv = _argv;

        Cvo_Parse(&argc, &argv);
    }
    Display *newdpy = XOpenDisplay(_Cvo_Base.DisplayName);
    if (!newdpy)
	return(False);

    Cvo_BasicObject::defdpy = _Cvo_Base.AddDisplay(newdpy);

#if    !defined(X11R4)
    // XXX - shouldn't this be done for all displays, and not just
    //	     the default display?
    XIM im;

    if (im = XOpenIM(newdpy, NULL, _Cvo_Base.InstanceName,
				   _Cvo_Base.ClassName)) {
	XIMStyles *styles;

	static XIMStyle supported_styles[] = {
	    XIMPreeditArea|XIMStatusArea,
	    XIMPreeditNothing|XIMStatusNothing,
	    XIMPreeditNone|XIMStatusNone,
	    0,
	};

	XIMStyle style = sizeof(supported_styles)/sizeof(XIMStyle) - 1;

	XGetIMValues(im, XNQueryInputStyle, &styles, NULL);

	for (unsigned short i = 0; i < styles->count_styles; ++i) {
	    for (int j = 0; supported_styles[j]; ++j)
		if (styles->supported_styles[i] == supported_styles[j]) {
		    if (j < style)
			style = j;
		    break;
		}
	}

	XFree(_xfree_t styles);

	if (!supported_styles[style]) {
	    if (strcmp(_Cvo_Base.Locale, "C"))
		Cvo_Failure(CvoE_WARN,
			CvoE_UNSUPIMS,
			"Cannot support any of the input method styles for %s\n",
			_Cvo_Base.Locale);
	    XCloseIM(im);
	    im = 0;
	}
	Cvo_BasicObject::defdpy->SetInputMethod(im);
	Cvo_BasicObject::defdpy->SetInputStyle(supported_styles[style]);
    } else if (strcmp(_Cvo_Base.Locale, "C")) {
	//
	// Only warn the user if they are not in the C locale
	//
	Cvo_Failure(CvoE_WARN,
		    CvoE_UNSUPIM,
		    "Cannot open an input method for %s\n",
		    _Cvo_Base.Locale);
    }

    //
    // Initialize the X Input method here...
    //
#endif
    for (char *p = _Cvo_Base.Locale; *p; ++p)
	if (*p == '.')
	    *p = '_';
    _Cvo_Base.QLocale = XrmStringToQuark(_Cvo_Base.Locale);
    return(True);
}

//
// Force defaults to be loaded.
//
void ____load_defaults() {
    extern int ____load_18n_defaults;
    ____load_18n_defaults = 1;
}
