//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: BasicButton.cc,v 1.8 1994/09/21 18:18:28 prb Exp $"); }
#include <stdio.h>
#include <Cvo/BasicButton.h++>
#include <string.h>

static Cvo_Default def[] = {
    "*CvoBasicButton.Cursor:Top Left Arrow",
    "*CvoBasicButton.Pad:2",
};

static char *trans = "\
    <ButtonPress>: Press()\n\
    <ButtonRelease>: Release()\n\
";


CONSTRUCTORS(Cvo_BasicButton, Cvo_Window, "CvoBasicButton")

CVO_BEGIN_BIND(Cvo_BasicButton)
CVO_DOBIND(Cvo_BasicButton, "Press",   Down)
CVO_DOBIND(Cvo_BasicButton, "Release", Up)
CVO_END_BIND(Cvo_BasicButton, Cvo_Window)

void
Cvo_BasicButton::_Init()
{
    type = CvoT_BasicButton;
    flat = 0;
    cnt = 0;
    leftjustify = 0;
    rightjustify = 0;

    AddTranslations(trans);
}

void
Cvo_BasicButton::ForceDown()
{
    if (!cnt) {
	XEvent ev;
	ev.type = 0;
	Down(&ev, 0, 0);
    }
}

void
Cvo_BasicButton::ForceUp(BOOL useit)
{
    if (cnt) {
	XEvent ev;
	if (!useit) {
	    ev.xbutton.button = 0;
	    ev.xbutton.state = 0;
	    ev.xbutton.y =
	    ev.xbutton.x = -(BorderWidth() - 1);
	    ev.type = ButtonPress;
	    FromXCoord(&ev.xbutton.x, &ev.xbutton.y);
	} else {
	    ev.type = 0;
	}
	Up(&ev, 0, 0);
    }
}

void
Cvo_BasicButton::LocalDown(XEvent *ev, int, char **)
{   CVO_ENTER
    Cvo_ButtonEvent bev;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	bev.button = ev->xbutton.button;
	bev.state = ev->xbutton.state;
    } else {
	bev.button = 0;
	bev.state = 0;
    }

    if (!flat) {
	if (sunken ^= 1) {
	    SelectBackground();
	} else {
	    NormalBackground();
	}
	Redraw();
    }

    bev.value = 0;
    SendEvent(CvoButtonDownEvent, &bev);
    CVO_VOID_RETURN
}

void
Cvo_BasicButton::LocalUp(XEvent *ev, int, char **)
{   CVO_ENTER
    int b = 0;
    int x = 0;
    int y = 0;
    int bw = BorderWidth();
    unsigned int s = 0;

    if (ev->type == ButtonPress || ev->type == ButtonRelease) {
	x = ev->xbutton.x;
	y = ev->xbutton.y;
	b = ev->xbutton.button;
	s = ev->xbutton.state;
	ToXCoord(&x, &y);
    }

    if (!flat) {
	if (sunken ^= 1) {
	    SelectBackground();
	} else {
	    NormalBackground();
	}
	Redraw();
    }

    if (x >= -bw && y >= -bw && x <= XWidth() + bw && y <= XHeight() + bw) {
	Cvo_ButtonEvent bev;
	bev.value = 0;
	bev.button = b;
	bev.state = s;
	SendEvent(CvoButtonUpEvent, &bev);
    }
    CVO_VOID_RETURN
}

void
Cvo_BasicButton::Down(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    if (!Sensitive())
	CVO_VOID_RETURN

    if (ev->type == ButtonPress) {
	if (cnt == 0) {
	    cnt = _cvo_button_count(ev) + 1;
	    LocalDown(ev, ac, av);
    	} else
	    cnt = _cvo_button_count(ev) + 1;
    } else {
	if (cnt < 0)
	    cnt = 0;
	if (cnt++ == 0)
	    LocalDown(ev, ac, av);
    }
    CVO_VOID_RETURN
}

void
Cvo_BasicButton::Up(XEvent *ev, int ac, char **av)
{   CVO_ENTER
    if (!Sensitive())
	CVO_VOID_RETURN

    if (cnt > 0 && ev->type == ButtonRelease)
	cnt = _cvo_button_count(ev);
    if (--cnt <= 0) {
	if (cnt < 0)
	    cnt = 0;
	else {
	    LocalUp(ev, ac, av);
	}
    }
    CVO_VOID_RETURN
}

void
Cvo_BasicButton::Flash()
{
    if (sunken ^= 1)
	SelectBackground();
    else
	NormalBackground();
    Redraw();

    if (sunken ^= 1)
	SelectBackground();
    else
	NormalBackground();
    Redraw();
}
