//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RSCID() { void("$Id: Arrows.cc,v 1.2 1994/08/10 17:54:53 prb Exp $"); }
#include <Cvo/Window.h++>
#include <math.h>

void
Cvo_Window::DrawArrow(int dir, int x, int y, int w, int h)
{   CVO_ENTER
    switch (dir) {
    case Cvo_NORTH:	DrawUpArrow(x,y,w,h); break;
    case Cvo_SOUTH:	DrawDownArrow(x,y,w,h); break;
    case Cvo_EAST:	DrawRightArrow(x,y,w,h); break;
    case Cvo_WEST:	DrawLeftArrow(x,y,w,h); break;
    }
}

void
Cvo_Window::DrawUpArrow(int x, int y, int w, int h)
{   CVO_ENTER
    XPoint p[8];
    int amt;

    if (h == -1)
    	h = w;
    if (Monochrome()) {
        ToXCoord(&x, &y);

        p[0].x = x + (w / 2);
        p[0].y = y;

        p[1].x = x + (w / 2) + 1;
        p[1].y = y;
        p[2].x = x + w;
        p[2].y = y + h;
        p[3].x = x;
        p[3].y = y + h;
        SetForeground(foreground);
        XFillPolygon(Dpy(), Object(), gc, p+(w&1), 3+((w&1)^1), Convex, CoordModeOrigin);
        CVO_VOID_RETURN
    }

    amt = (w + 3) / 5;
    if ((h + 3) / 5 < amt)
    	amt = (h + 3) / 5;
    if (chamfer && chamfer < amt)
    	amt = chamfer;

    double t = double(w) / double(h);
    double ts = t * t;
    int ud = int(double(amt) * sqrt(4.0/ts + 1.0) + 0.5);
    int sd = int(double(amt) * (ts / 2.0 + sqrt(1.0 + ts)) + 0.5);

    Cvo_Lock lock;

    ToXCoord(&x, &y);

    p[0].x = x + (w / 2);
    p[0].y = y;

    p[1].x = x + (w / 2) + 1;
    p[1].y = y;

    p[2].x = p[1].x;
    p[2].y = y + ud;

    p[3].x = x + sd;
    p[3].y = y + h - amt;

    p[4].x = x - 1;
    p[4].y = y + h;


    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);
    p[0].x = x + w / 2 + 2;
    p[2].y += 1;
    p[3].x = x + w - sd + 1;
    p[4].x = x + w;
    p[4].y = y + h;

    SetForeground(background->Lower());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);

    p[1].x = x-1;
    p[1].y = y + h;
    p[2].x = x + sd;
    p[2].y = p[3].y;
    XFillPolygon(Dpy(), Object(), gc, p+1, 4, Convex, CoordModeOrigin);
    CVO_VOID_RETURN
}

void
Cvo_Window::DrawDownArrow(int x, int y, int w, int h)
{   CVO_ENTER
    XPoint p[8];
    int amt;
    if (h == -1)
    	h = w;

    if (Monochrome()) {
	ToXCoord(&x, &y);

	p[0].x = x + (w / 2);
	p[0].y = y + h;

	p[1].x = x + (w / 2) + 1;
	p[1].y = y + h;
	p[2].x = x + w;
	p[2].y = y;
	p[3].x = x;
	p[3].y = y;
	SetForeground(foreground);
	XFillPolygon(Dpy(), Object(), gc, p+(w&1), 3+((w&1)^1), Convex, CoordModeOrigin);
	CVO_VOID_RETURN         
    }

    amt = (w + 3) / 5;
    if ((h + 3) / 5 < amt)
    	amt = (h + 3) / 5;
    if (chamfer && chamfer < amt)
    	amt = chamfer;

    double t = double(w) / double(h);
    double ts = t * t;
    int ud = int(double(amt) * sqrt(4.0/ts + 1.0) + 0.5);
    int sd = int(double(amt) * (ts / 2.0 + sqrt(1.0 + ts)) + 0.5);

    Cvo_Lock lock;

    ToXCoord(&x, &y);

    p[0].x = x + (w / 2) - 1;
    p[0].y = y + h;

    p[1].x = x + (w / 2);
    p[1].y = y + h;

    p[2].x = p[1].x;
    p[2].y = y + h - ud + 1;

    p[3].x = x + sd - 1;
    p[3].y = y + amt;

    p[4].x = x - 1;
    p[4].y = y;


    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);
    p[0].x = x + w / 2 + 1;
    p[3].x = x + w - sd + 1;
    p[4].x = x + w;
    p[4].y = y;

    SetForeground(background->Lower());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);

    p[1].x = x-1;
    p[1].y = y;
    p[2].x = x + sd;
    p[2].y = p[3].y;
    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+1, 4, Convex, CoordModeOrigin);
    CVO_VOID_RETURN
}

void
Cvo_Window::DrawLeftArrow(int x, int y, int w, int h)
{   CVO_ENTER
    XPoint p[8];
    int amt;

    if (h == -1)
    	h = w;

    if (Monochrome()) {
        ToXCoord(&x, &y);

	p[0].y = y + (h / 2) - 1;
	p[0].x = x;

	p[1].y = y + (h / 2);
	p[1].x = x;

	p[2].y = y + h;
	p[2].x = x + w;

	p[3].y = y;
	p[3].x = x + w;

        SetForeground(foreground);
        XFillPolygon(Dpy(), Object(), gc, p+(w&1), 3+((w&1)^1), Convex, CoordModeOrigin);
        CVO_VOID_RETURN    
    }

    amt = (w + 3) / 5;
    if ((h + 3) / 5 < amt)
    	amt = (h + 3) / 5;
    if (chamfer && chamfer < amt)
    	amt = chamfer;

    double t = double(h) / double(w);
    double ts = t * t;
    int ud = int(double(amt) * sqrt(4.0/ts + 1.0) + 0.5);
    int sd = int(double(amt) * (ts / 2.0 + sqrt(1.0 + ts)) + 0.5);

    Cvo_Lock lock;

    ToXCoord(&x, &y);

    p[0].y = y + (h / 2) - 1;
    p[0].x = x;

    p[1].y = y + (h / 2);
    p[1].x = x;

    p[2].y = p[1].y;
    p[2].x = x + ud;

    p[3].y = y + sd - 1;
    p[3].x = x + w - amt;

    p[4].y = y - 1;
    p[4].x = x + w;


    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);
    p[0].y = y + h / 2 + 1;
    p[2].x += 2;
    p[3].y = y + h - sd + 1;
    p[4].y = y + h;
    p[4].x = x + w;

    SetForeground(background->Lower());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);

    p[1].y = y-1;
    p[1].x = x + w;
    p[2].y = y + sd - 1;
    p[2].x = p[3].x;
    XFillPolygon(Dpy(), Object(), gc, p+1, 4, Convex, CoordModeOrigin);
    CVO_VOID_RETURN
}

void
Cvo_Window::DrawRightArrow(int x, int y, int w, int h)
{   CVO_ENTER
    XPoint p[8];
    int amt;

    if (h == -1)
    	h = w;

    if (Monochrome()) {
        ToXCoord(&x, &y);

        p[0].y = y + (h / 2) - 1;
        p[0].x = x + w;

        p[1].y = y + (h / 2);
        p[1].x = x + w;

        p[2].y = y + h;
        p[2].x = x;

        p[3].y = y;
        p[3].x = x;

        SetForeground(foreground);
        XFillPolygon(Dpy(), Object(), gc, p+(w&1), 3+((w&1)^1), Convex, CoordModeOrigin);
        CVO_VOID_RETURN    
    }

    amt = (w + 3) / 5;
    if ((h + 3) / 5 < amt)
    	amt = (h + 3) / 5;
    if (chamfer && chamfer < amt)
    	amt = chamfer;

    double t = double(h) / double(w);
    double ts = t * t;
    int ud = int(double(amt) * sqrt(4.0/ts + 1.0) + 0.5);
    int sd = int(double(amt) * (ts / 2.0 + sqrt(1.0 + ts)) + 0.5);

    Cvo_Lock lock;

    ToXCoord(&x, &y);

    p[0].y = y + (h / 2) - 1;
    p[0].x = x + w;

    p[1].y = y + (h / 2);
    p[1].x = x + w;

    p[2].y = p[1].y;
    p[2].x = x + w - ud;

    p[3].y = y + sd - 1;
    p[3].x = x + amt;

    p[4].y = y - 1;
    p[4].x = x;


    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);
    p[0].y = y + h / 2 + 1;
    p[3].y = y + h - sd + 1;
    p[4].y = y + h;
    p[4].x = x;

    SetForeground(background->Lower());
    XFillPolygon(Dpy(), Object(), gc, p+(w&1), 4+((w&1)^1), Convex, CoordModeOrigin);

    p[1].y = y-1;
    p[1].x = x;
    p[2].y = y + sd - 1;
    p[2].x = p[3].x;
    SetForeground(background->Upper());
    XFillPolygon(Dpy(), Object(), gc, p+1, 4, Convex, CoordModeOrigin);
    CVO_VOID_RETURN
}
