//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
static void USMID() { void("%Z%%M%	%I%	%G% %U%"); }
static void RCSID() { void("$Id: Accelerator.cc,v 1.14 1994/08/23 13:51:40 prb Exp $"); }
#include <Cvo/Object.h++>

XEvent *
Cvo_DisplayList::AccelFilter(Cvo_Object *obj, XEvent *ev, void *vd)
{
    if (ev->type != KeyPress)
	return(ev);

    Cvo_DisplayList *disp = (Cvo_DisplayList *)vd;

    Cvo_Accelerator *a = disp->accelerators;

    while (a) {
    	if (a->Check(obj, ev))
	    return(0);
	a = a->Next();
    }
    return(ev);
}

XEvent *
Cvo_DisplayList::AccelCheckFilter(Cvo_Object *obj, XEvent *ev, void *vd)
{
    if (ev->type != KeyPress)
	return(ev);

    Cvo_DisplayList *disp = (Cvo_DisplayList *)vd;

    Cvo_Accelerator *a = disp->accelerators;

    while (a) {
    	if (a->CheckOnly(obj, ev))
	    return(0);
	a = a->Next();
    }
    return(ev);
}

void
Cvo_DisplayList::DeleteAccel(Cvo_Object *obj, XEvent *, void *a)
{
    Cvo_Accelerator *ac = (Cvo_Accelerator *)a;

    ac->Unlink((Cvo_RootedList **)&(obj->DisplayList()->accelerators));
    delete ac;
}

Cvo_Accelerator *
Cvo_DisplayList::AddAccelerator(Cvo_Object *obj, KeyCode k, CARD s, 
			 void (*f)(Cvo_Object *, XEvent *, void *), void *d)
{
    if (!accelerators) {
	main->_AddSelectMask(KeyPressMask);
	Cvo_PushEventFilter(Cvo_DisplayList::AccelFilter, this);
    }

    Cvo_Accelerator *a = new Cvo_Accelerator(&accelerators, k, s, f, d);
    if (obj && a)
	obj->Register(CvoDestroyedEvent, &Cvo_DisplayList::DeleteAccel, a);
    return(a);
}

Cvo_Accelerator *
Cvo_DisplayList::AddAccelerator(Cvo_Object *obj, KeyCode k,
			void (*f)(Cvo_Object *, XEvent *, void *), void *d)
{
    if (!accelerators) {
	main->_AddSelectMask(KeyPressMask);
	Cvo_PushEventFilter(&Cvo_DisplayList::AccelFilter, this);
    }

    Cvo_Accelerator *a = new Cvo_Accelerator(&accelerators, k, f, d);
    if(obj && a)
	obj->Register(CvoDestroyedEvent, &Cvo_DisplayList::DeleteAccel, a);
    return(a);
}

Cvo_Accelerator::Cvo_Accelerator(Cvo_Accelerator **r, KeyCode k, CARD s,
			void (*f)(Cvo_Object *, XEvent *, void *), void *d)
               : Cvo_RootedList((Cvo_RootedList **)r)
{
    _Init(k, s, f, d);
}

Cvo_Accelerator::Cvo_Accelerator(Cvo_Accelerator **r, KeyCode k,
			void (*f)(Cvo_Object *, XEvent *, void *), void *d)
               : Cvo_RootedList((Cvo_RootedList **)r)
{
    _Init(k, 0, f, d);
}

void
Cvo_Accelerator::_Init(KeyCode k, CARD s,
	    	       void (*f)(Cvo_Object *, XEvent *, void *), void *d)
{
    key = k;
    state = s;
    data = d;
    func = f;
}

BOOL
Cvo_Accelerator::Check(Cvo_Object *obj, XEvent *ev)
{
    if (ev->xkey.state != state || ev->xkey.keycode != key)
	return(False);
    if (func)
	(*func)(obj, ev, data);
    return(True);
}

BOOL
Cvo_Accelerator::CheckOnly(Cvo_Object *, XEvent *ev)
{
    if (ev->xkey.state != state || ev->xkey.keycode != key)
	return(False);
    return(True);
}

BOOL
Cvo_ParseAccelerator(Cvo_Object *o, wchar_t *string, KeyCode &key, CARD &state)
{
    Cvo_CharacterBuffer cb = string;
    return(Cvo_ParseAccelerator(o, (char *)cb, key, state));
}

inline
issep(int c)
{
    return (c == '+' || c == '-' || c == '/' || c == ' ' || c == '\t');
}

void
Cvo_DisplayList::FillModMask()
{
    delete [] modifiermap;
    max_keypermod = 0;
    modifiermap = 0;

    XModifierKeymap *xmm = XGetModifierMapping(Dpy());
    if (xmm) {
    	max_keypermod = xmm->max_keypermod;
    	modifiermap = new KeySym[(Mod5MapIndex+1) * max_keypermod];
    	KeySym *ks = modifiermap;
    	KeyCode *kc = xmm->modifiermap;
    	for (int x = 0; x <= Mod5MapIndex * max_keypermod; ++x)
    	    *ks++ = XKeycodeToKeysym(Dpy(), *kc++, 0);
    	XFree(_xfree_t xmm->modifiermap);
	XFree(_xfree_t xmm);
    }
}

CARD
Cvo_DisplayList::GetModMask(KeySym k1, KeySym k2)
{
    CARD mask = 0;

    if (!modifiermap)
	FillModMask();
    if (!modifiermap)
	return(mask);

    KeySym *ks = modifiermap;

    for (int m = 0; m <= Mod5MapIndex; ++m) {
	for (int k = 0; k < max_keypermod; ++k) {
	    if (k1 != NoSymbol && k1 == *ks || k2 != NoSymbol && k2 == *ks) {
		switch(m) {
		case ShiftMapIndex:	mask |= ShiftMask;	break;
		case LockMapIndex:	mask |= LockMask;	break;
		case ControlMapIndex:	mask |= ControlMask;	break;
		case Mod1MapIndex:	mask |= Mod1Mask;	break;
		case Mod2MapIndex:	mask |= Mod2Mask;	break;
		case Mod3MapIndex:	mask |= Mod3Mask;	break;
		case Mod4MapIndex:	mask |= Mod4Mask;	break;
		case Mod5MapIndex:	mask |= Mod5Mask;	break;
		default:		break;
		}
    	    }
	    ++ks;
	}
    }
    return(mask);
}

CARD
Cvo_DisplayList::GetModMask(KeyCode kc)
{
    return(GetModMask(XKeycodeToKeysym(Dpy(), kc, 0), NoSymbol));
}

#define	COMPAR(e, s, p) \
	((sizeof(p) - 1) == (e - s) && strncasecmp(s, p, sizeof(p) - 1) == 0)

BOOL
Cvo_ParseAccelerator(Cvo_Object *o, char *string, KeyCode &key, CARD &state)
{
    char *end;

    while (*string && (*string == ' ' || *string == '\t'))
	++string;

    if (*string == '<') {
    	for (end = ++string; *end && *end != '>'; ++end)
		;
    } else {
    	for (end = string + 1; *end; ++end)
		;
    }

    while (end > string && issep(end[-1]))
	--end;

    while (end > string && issep(*string))
	++string;

    //
    // Okay, from here on we are looking for a list of modifiers followed
    // by a single keysym. The modifiers are seperated from the keysym
    // by '-' '+' ' ' or '/'.
    //

    char *wend = string;
    KeySym ks;

    state = 0;
    ks = NoSymbol;

    while (string < end) {
	while (wend < end && !issep(*wend))
	    ++wend;
    	if (COMPAR(wend, string, "shift"))
	    state |= ShiftMask;
    	else if (COMPAR(wend, string, "lock") || COMPAR(wend, string, "caps"))
	    state |= LockMask;
    	else if (COMPAR(wend, string, "ctrl"))
	    state |= ControlMask;
    	else if (COMPAR(wend, string, "mod1"))
	    state |= Mod1Mask;
    	else if (COMPAR(wend, string, "mod2"))
	    state |= Mod2Mask;
    	else if (COMPAR(wend, string, "mod3"))
	    state |= Mod3Mask;
    	else if (COMPAR(wend, string, "mod4"))
	    state |= Mod4Mask;
    	else if (COMPAR(wend, string, "mod5"))
	    state |= Mod5Mask;
    	else if (COMPAR(wend, string, "button1"))
	    state |= Button1Mask;
    	else if (COMPAR(wend, string, "button2"))
	    state |= Button2Mask;
    	else if (COMPAR(wend, string, "button3"))
	    state |= Button3Mask;
    	else if (COMPAR(wend, string, "button4"))
	    state |= Button4Mask;
    	else if (COMPAR(wend, string, "button5"))
	    state |= Button5Mask;
    	else if (COMPAR(wend, string, "meta"))
	    state |= o->DisplayList()->GetModMask(XK_Meta_L, XK_Meta_R);
    	else if (COMPAR(wend, string, "alt"))
	    state |= o->DisplayList()->GetModMask(XK_Alt_L, XK_Alt_R);
    	else if (COMPAR(wend, string, "super"))
	    state |= o->DisplayList()->GetModMask(XK_Super_L, XK_Super_R);
    	else if (COMPAR(wend, string, "hyper"))
	    state |= o->DisplayList()->GetModMask(XK_Hyper_L, XK_Hyper_R);
    	else {
	    Cvo_CharacterBuffer cb(string, wend - string);
	    if ((ks = XStringToKeysym((char *)cb)) == NoSymbol) {
		fprintf(stderr, "Unknown keysym: %.*s\n", wend - string, string);
		return(False);
    	    }
    	}
    	while (wend < end && issep(*wend))
	    ++wend;
    	string = wend;
    }

    if (ks == NoSymbol || (key = XKeysymToKeycode(o->Dpy(), ks)) == 0)
	return(False);
    return(True);
}
