//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: Iwin.h++,v 1.12 1994/09/07 21:08:23 prb Exp $
//
#if     !defined(_Cvo_Iwin_)
#define _Cvo_Iwin_

#include <Cvo/Window.h++>
#include <Cvo/RootedList.h++>
#include <Cvo/Image.h++>
#include <Cvo/Pixmap.h++>
#include <string.h>

#define	Cvo_IwinTooBig	-9999

class Cvo_Iwin;
class Cvo_ViewPort;

class Cvo_IwinItem : public Cvo_RootedList {
    friend Cvo_Iwin;

    int			orientation:8;
    BOOL		highlighed:1;
    BOOL		displayed:1;
    BOOL		selected:1;

    Cvo_Image		*primary;
    Cvo_Image		*secondary;
    Pixmap		mask;

    CARD16		namewidth;
    CARD16		nameheight;
private:
    Cvo_IwinItem	**root;
    char		*tag;
    void		*client_data;
    INT16		x;
    INT16		y;
    CARD32		location;

    Cvo_IwinItem(Cvo_IwinItem **, char *, void * = 0, int = Cvo_VERTICAL);
public:
    ~Cvo_IwinItem();
    char *Tag()				{ return(tag); 			}
    void *Data()			{ return(client_data);		}
    void SetData(void *d)		{ client_data = d;		}
    void SetTag(char *tg);

    int	X()				{ return(x);			}
    int	Y()				{ return(y);			}
    int	W()				{ return(primary->Width());	}
    int	H()				{ return(primary->Height());	}
    void SetX(int dx)			{ x = dx;			}
    void SetY(int dy)			{ y = dy;			}
    void SetLocation(CARD32 v)		{ location = v;			}
    int NX();
    int NY();
    int	NW()				{ return(namewidth);		}
    int	NH()				{ return(nameheight);		}
    int	FW();
    int	FH();

    Cvo_IwinItem *Next()		{ return((Cvo_IwinItem *)next); }
    Cvo_IwinItem *Prev()		{ return((Cvo_IwinItem *)prev); }

    void Select()			{ if (!selected) displayed = False;
					  selected = True; }
    void Unselect()			{ if (selected) displayed = False;
					  selected = False; }

    int	IntersectP(int, int, int, int);
    int	IntersectN(int, int, int, int);
    int	IntersectP(int x, int y)	{ return(IntersectP(x,y,x,y)); }
    int	IntersectN(int x, int y)	{ return(IntersectN(x,y,x,y)); }
    int	IntersectP(XRectangle *);
    int	IntersectN(XRectangle *);

    BOOL Collide(Cvo_IwinItem &other);

    static int Sort(Cvo_RootedList *, Cvo_RootedList *);
    static int Prepend(Cvo_RootedList *, Cvo_RootedList *);
};

inline int
Cvo_IwinItem::IntersectP(XRectangle *r)
{
    return(IntersectP(r->x, r->y, r->x + r->width, r->y + r->height));
}

inline int
Cvo_IwinItem::IntersectN(XRectangle *r)
{
    return(IntersectN(r->x, r->y, r->x + r->width, r->y + r->height));
}

inline int
Cvo_IwinItem::NX()
{
    if (orientation == Cvo_VERTICAL)
	return(X() + (W() - NW()) / 2);
    else
	return(X() + W());
}

inline int
Cvo_IwinItem::NY()
{
    if (orientation == Cvo_VERTICAL)
	return(Y() + H());
    else
	return(Y() + (H() - NH()) / 2);
}

inline int
Cvo_IwinItem::FW()
{
    if (orientation == Cvo_VERTICAL)
	return(NW() > W() ? NW() : W());
    else
	return(NW() + 5 + W());
}

inline int
Cvo_IwinItem::FH()
{
    if (orientation == Cvo_VERTICAL)
	return(NH() + H());
    else
	return(H());
}

class Cvo_Iwin : public Cvo_Window {
private: 
    Cvo_Pixmap		*pixmap;
    XPoint		next;
    XPoint		offset;
    XPoint		origin;

    unsigned		iwidth;		// Default icon width (with name)
    unsigned		iheight;	// Default icon height (with name)

    unsigned		useStagger:1;

    BOOL		output:1;	// are we writing to the screen
    BOOL		dirty:1;
    BOOL		realdirty:1;
    BOOL		dirtypix:1;

    BOOL		pretty:1;	// True if the window is pretty
    BOOL		cute:1;		// True if we were the last to place

    BOOL		moving:1;	// True if we are moving icons
    BOOL		haveMoved:1;
    BOOL		autoPlace:1;
    BOOL		allowIntraMv:1;
    BOOL		needResize:1;

    int			nwidth;		// Used when needResize is set
    int			nheight;

    Cvo_IwinItem	**movingIcons;
    int			moveCount;
    XPoint		*offsets;
    XRectangle		*rects;

    Cvo_IwinItem	*items;		// List of all items
    int			selected;	// number of icons selected
    Cvo_IwinItem	**selectedItems;
    GC			boxGC;

    Cvo_ViewPort	*viewPort;
protected:
    void _Create();
    void Bind(); 
    void RecaluclatePixmap();
    CVO_DEFINE_REGISTER_FUNCTIONS(Cvo_Iwin)
    void DoResize();
    void DoResizeEvent(XEvent *, void *);
    void RecalcSize();
    void Redisplay();
    void DisplayIcon(Cvo_IwinItem *,int);
    int	FontHeight();
    void SetLocation(Cvo_IwinItem *, int, int);

    static void ScrollEvent(Cvo_Object *, XEvent *, void *);
private: 
    void _Init(Cvo_ViewPort *);
    inline void getgrid(Cvo_IwinItem *, int &, int &);
public:
    CONSTRUCDECL_1ARG(Cvo_Iwin, Cvo_ViewPort * = 0) 
    GC BoxGC()				{ return(boxGC);		}

    Cvo_IwinItem * AddIcon(char *, int x, int y,
		 Cvo_Image *, Cvo_Image * = NULL,
		 Pixmap = NULL, void * = NULL, int = Cvo_VERTICAL);

    Cvo_IwinItem * AddIcon(char *t, Cvo_Image *p, Cvo_Image *s = NULL,
                 Pixmap m = NULL, void *d = NULL, int o = Cvo_VERTICAL)
    	{ return(AddIcon(t, Cvo_IwinTooBig, Cvo_IwinTooBig, p, s, m, d, o)); }
    Cvo_IwinItem * AddIcon(char *t, Cvo_Image *p, 
                 Pixmap m, void *d = NULL, int o = Cvo_VERTICAL)
    	{ return(AddIcon(t, Cvo_IwinTooBig, Cvo_IwinTooBig, p, 0, m, d, o)); }

    void Organize();
    void ReOrganize();
    void Organize(Cvo_IwinItem *);


    BOOL DisableOutput()	{ BOOL o = output; output = False; return(o); }
    void EnableOutput(BOOL o)
#if defined(__IRIX_IS_BRAINDEAD__)
				;
#else
				{ if (output = o) {
				    if (needResize) DoResize();
				    else if (dirty) Redisplay(); } }
#endif

    void AllowIntraPaneMv(BOOL o=True)	{ allowIntraMv = o; }
    void AllowAutoPlace(BOOL o=True)	{ autoPlace = o; }

    int Selected()			{ return(selected);		}
    void SelectAll();
    void UnselectAll();
    void EvalSelected();
    void SelectInBox(int, int, int, int);
    void SelectByTag(char *tag);
    void BuildSelectionList();
    void ScrollTo(int, int);

    void SelectionBox(XEvent *);
    Cvo_IwinItem **SelectedInWindow(int *);

    void SelectIcons(XEvent *, int, char **);
    void ExecuteIcons(XEvent *, int, char **);
    void InitMove(int, int);
    void MoveIcons(XEvent *, int, char **);
    void EndMove();
    void DropIcons(XEvent *, int, char **);
    void Process(XEvent *, int, char **);

    Cvo_IwinItem *LocateIcon(int dx,int dy); // locate icon from <x,y>
    void DrawRectangles(Window win, GC gc, XRectangle *rects, int nrects);

    void Reset();   		// Delete all Icons
    void Exposure(XExposeEvent *ev = NULL);
    void Flush(int = 0);
    Cvo_IwinItem *Items()		{ return(items); }
    CARD16 CalculateWidth();
    CARD16 CalculateHeight();

    int PHeight()		{ return(pixmap ? pixmap->Height() : 0); }
    int PWidth()		{ return(pixmap ? pixmap->Width() : 0); }
};

inline void
Cvo_Iwin::SetLocation(Cvo_IwinItem *item, int x, int y)
{
    item->SetX(x);
    item->SetY(y);

    x = ((x - offset.x + iwidth / 2) / iwidth) + 0x7fff;
    y = ((y - offset.y - iheight / 2) / iheight) + 0x7fff;

    x &= 0xffff;
    y &= 0xffff;

    item->SetLocation((y << 16) | x);
}

#define CvoIwinPrimaryEvent	(Cvo_IwinEventType + InternalEvent0)
#define CvoIwinSecondaryEvent	(Cvo_IwinEventType + InternalEvent1)
#define CvoIwinDropEvent	(Cvo_IwinEventType + InternalEvent2)

struct Cvo_IwinEvent : Cvo_AnyEvent {
    Cvo_IwinItem	*item;		// item
    void		*client_data;	// user specified data
};

struct Cvo_IwinDropEvent : Cvo_AnyEvent {
    Cvo_IwinItem	**selections;	// items selected.
    short		count;		// number of items selected.
    int			refx;
    int			refy;
    int			offx;
    int			offy;
    Time		time;		// time that the event occurred.
};

typedef Cvo_IwinEvent Cvo_IwinPrimaryEvent;
typedef Cvo_IwinEvent Cvo_IwinSecondaryEvent;

#endif
