//
// Copyright 1994, Cray Research, Inc.
//                 
// Permission to use, copy, modify and distribute this software and
// its accompanying documentation (the "Software") is granted without
// fee, provided that the above copyright notice and this permission
// notice appear in all copies of the Software and all supporting
// documentation, and the name of Cray Research, Inc. not be used in
// advertising or publicity pertaining to distribution of the 
// Software without the prior specific, written permission of Cray
// Research, Inc.  The Software is a proprietary product of Cray
// Research, Inc., and all rights not specifically granted by this
// license shall remain in Cray Research, Inc.  No charge may be made
// for the use or distribution of the Software.  The Software may be
// distributed as a part of a different product for which a fee is
// charged, if (i) that product contains or provides substantial
// functionality that is additional to, or different from, the
// functionality of the Software, and (ii) no separate, special or
// direct charge is made for the Software.
//         
// THE SOFTWARE IS MADE AVAILABLE "AS IS", AND ALL EXPRESS AND
// IMPLIED WARRANTIES, INCLUDING THE IMPLIED WARRANTIES OF FITNESS
// FOR A PARTICULAR PURPOSE, MERCHANTABILITY, AND FREEDOM FROM
// VIOLATION OF THIRD PARTY INTELLECTUAL PROPERTY RIGHTS, ARE HEREBY
// DISCLAIMED AND EXCLUDED BY CRAY RESEARCH, INC.  CRAY RESEARCH,
// INC. WILL NOT BE LIABLE IN ANY EVENT FOR ANY CONSEQUENTIAL,
// SPECIAL, INCIDENTAL, OR INDIRECT DAMAGES ARISING OUT OF OR IN
// CONNECTION WITH THE PERFORMANCE OF THE SOFTWARE OR ITS USE BY ANY
// PERSON, OR ANY FAILURE OR NEGLIGENCE ON THE PART OF CRAY RESEARCH,
// INC., EXCEPT FOR THE GROSS NEGLIGENCE OR WILLFUL MISCONDUCT OF
// CRAY RESEARCH.
// 
// This License Agreement shall be governed by, and interpreted and
// construed in accordance with, the laws of the State of Minnesota,
// without reference to its provisions on the conflicts of laws, and
// excluding the United Nations Convention of the International Sale
// of Goods.
//
//	USMID %Z%%M%	%I%	%G% %U%
//	$Id: GenericList.h++,v 1.3 1994/09/08 19:43:08 prb Exp $
//
#if	!defined(_Cvo_GenericList_)
#define	_Cvo_GenericList_

#if	!defined(_Cvo_ViewPort_)
#include <Cvo/ViewPort.h++>
#endif

#if	!defined(_Cvo_Page_)
#include <Cvo/Page.h++>
#endif
#if	!defined(_Cvo_List_)
#include <Cvo/List.h++>
#endif

class Cvo_GenericList : public Cvo_ViewPort {
public:
    Cvo_Page	*page;
protected:
    int		current;		// Current item selected
    int		firstline;		// first line displayed
    int		lastline;		// last line displayed
    int		lines;			// last number of lines we knew about
    CARD	xoffset;
    BOOL	jumptoend:1;		// 1 -> jump to end on page change
    BOOL	lookAtScreenOnly:1;
    BOOL	drawingscreen:1;
    BOOL	partialLine:1;
    BOOL	radiostyle:1;
    BOOL	reselect:1;
    void _Init(Cvo_Page *);
    void _Init()			{ _Init(0); }
    void Bind();
    void EvaluateWidth(int = 0);

    friend void Cvo_GenericList_ScrollHorizontal(Cvo_Object *, XEvent *, void *);
    friend void Cvo_GenericList_ScrollVertical(Cvo_Object *, XEvent *, void *);
    friend void Cvo_GenericList_PageChanged(Cvo_Object *, XEvent *, void *);
    friend void Cvo_GenericList_Resize(Cvo_Object *, XEvent *, void *);
    friend void Cvo_GenericList_MapRequest(Cvo_Object *, XEvent *, void *);
public:
    CONSTRUCDECL_1ARG(Cvo_GenericList, Cvo_Page *)
    void	_Create();
    void	Jump(BOOL v = True)	{ jumptoend = v; }
    int		FirstLine()		{ return(firstline);	}
    int		LastLine()		{ return(lastline);	}
    void	OnlyEvaluateScreen(BOOL v = True)
					{ lookAtScreenOnly = v; }
    Cvo_Page	*Page()			{ return(page); }

    void ClearSelected();
    void NewPage(Cvo_Page *);
    void UseRadioStyle(BOOL v = True)	{ radiostyle = v; }
    void AllowReselect(BOOL v = True)   { reselect = v; }
    void Select(int line, int count = 0, int button = 0);
    int Current()			{ return(current); }

    virtual void Down(XEvent *, int, char **);
    virtual void Up(XEvent *, int, char **);
};
#endif
