#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include <Cvo/Application.h++>
#include <Cvo/TextPage.h++>
#include <Cvo/TextViewPort.h++>

Cvo_TextPage	*page;
void external_input_handler(EvIOEvent *, void *);

static Cvo_Default defs[] = {
    "*output*CRT.FontFamily:Courier",
    "*JumpScroll:False",
};

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);
    int fd = 0;
    char *title = "Output";
    if (argv[1]) {
	if ((fd = open(argv[1], 0)) < 0) {
	    perror(argv[1]);
	    exit(1);
	}
	title = argv[1];
    }

    Cvo_Application *app = new Cvo_Application("example", Cvo_MAINWINDOW);
    Cvo_Window *slab = new Cvo_Window("slab", app);
    slab->ExpandFrame();		// Allow slab to resize with window
    slab->VerticalChildren();		// Layout children windows vertically

    page = new Cvo_TextPage();
    page->SetAbsoluteMax(0);

    new Cvo_Label("title", slab, title);
    Cvo_TextViewPort *output = new Cvo_TextViewPort("output", slab, page);
    output->FillFrame();
    output->ExpandFrame();
    output->SetMinSize(20, 1);	
    output->SetDefSize(80, 24);	
    output->DontJump();

    new EvInputEvent(fd, external_input_handler);
    app->MainLoop();
}

void
external_input_handler(EvIOEvent *ei, void *)
{
    static char linebuf[256];
    static int current = 0;

    char buf[256];
    int r = read(ei->Fd(), buf, sizeof(buf)-1);
    if (r <= 0) {
	delete ei;
	if (current) {
	    linebuf[current] = 0;
	    page->AppendText(linebuf);
	}
	return;
    }
    ei->Disable();
    for (int i = 0; i < r; ++i) {
	if (buf[i] == '\n') {
	    linebuf[current] = 0;
	    current = 0;
	    page->AppendText(linebuf);
	} else {
	    linebuf[current++] = buf[i];
	    if (current == sizeof(linebuf) - 1) {
		linebuf[current] = 0;
		current = 0;
		page->AppendText(linebuf);
	    }
	}
    }
    ei->Enable();
}
