#include "Radio.h++"
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

RadioInfo radio;

main(int ac, char **av)
{
    int debug;

    extern char *optarg;

    int i;
    int sender = 0;
    int client = -1;
    char *audio = 0;
    int channel = 0;
    int holdopen = 0;

    while ((i = getopt(ac, av, "CSs:x:da:c:t:hT:p:")) != EOF) {
	switch (i) {
	case 'p':
	    radio.SetPort(strtol(optarg, 0, 0));
	    break;
	case 'T': {
	    int tts = strtotype(optarg);
	    if (tts < 0) {
		fprintf(stderr, "%s: invalid packet type\n", optarg);
		exit(1);
	    }
	    radio.SetSendType(tts);
	    break;
	  }
	case 't':
	    radio.SetThreshold(strtol(optarg, 0, 0));
	    break;
	case 'c':
	    channel = atoi(optarg);
	    radio.SetSendChannel(channel);
	    break;
	case 'd':
	    radio.SetDebug();
	    radio.PrintDebug();
	    debug = 1;
	    break;
	case 's':
	    radio.SetSource(optarg);
	    break;
	case 'x':
	    radio.Exclude(optarg);
	    break;

	case 'h': holdopen = 1;				break;
	case 'a': client = 1;	audio = optarg;		break;
	case 'C': client = 1;				break;
	case 'S': sender = 1;				break;
	default:
	    fprintf(stderr, "Usage: %s [-S] [-C] [-s source] [-x skipif ...] [-a audio_device] [-h] [-t threshhold] [-c channel]\n");
	    exit(1);
	}
    }

    radio.Bind();

    if (!sender) {
	client = 1;
	if (!audio)
	    audio = "/dev/audio";
    }

    if (client) {
	if (audio && (client = open(audio, 1)) < 0) {
	    perror("audio");
	    exit(1);
	}
	if (holdopen) {
	    audio = 0;
	} else if (audio) {
	    close(client);
	    client = 1;
	}
    }

    for (;;) {
	if (radio.ReadPacket() < 0)
	    break;
	if (sender)
	    radio.BroadcastPacket();

	if (client >= 0 && (!channel || channel == radio.Channel())) {
	    int ofd = client;

	    if (audio && radio.Type() == RADIO_SUN_ULAW
		      && (ofd = open(audio, 1)) < 0) {
		continue;
	    }
	    radio.WriteData(ofd);
	    if (audio && radio.Type() == RADIO_SUN_ULAW)
		close(ofd);
	}
    }
}
