/*************************************************************
 *                                                           *
 *                     file: msf.h                           *
 *                                                           *
 *************************************************************/

/*
 * Copyright (C) 1988, 1989 Sun Microsystems, Inc.
 */

/* @(#)msf.h 1.2 90/08/15 Copyr 1989, 1990 Sun Microsystem. */

/* 
 * This file contains the typedefs of msf data structure 
 */
#include <stdio.h>

class Msf {
	int	min;
	int	sec;
	int	frame;
public:
	Msf();
	Msf(int m, int s, int f = 0);
	Msf(int f);
	Msf(Msf &m)		{ min = m.min; sec = m.sec; frame = m.frame; }
	friend Msf operator + (Msf &, Msf &);
	friend Msf operator - (Msf &, Msf &);
	Msf &operator = (Msf &);
	Msf &operator += (Msf &);
	Msf &operator -= (Msf &);
	int operator == (Msf &);
	int operator < (Msf &);
	int operator > (Msf &);
	int Frame()	{ return(frame); }
	int Minute()	{ return(min); }
	int Second()	{ return(sec); }
	int Frames()	{ return((min * 60 + sec) * 75 + frame); }
	void SetFrames(int f);
	void Set(int m, int s, int f = 0) { min = m; sec = s; frame = f; }
	void Print()	{ printf("%02d:%02d.%02d", min, sec, frame); }
};
