#include <Cvo/Application.h++>
#include <Cvo/Slab.h++>
#include <Cvo/Label.h++>
#include <Cvo/Separator.h++>
#include <Cvo/ScrollBar.h++>
#include <Cvo/Frame.h++>
#include <Cvo/TextPage.h++>
#include <Cvo/TextViewPort.h++>
#include <Cvo/RadioBox.h++>
#include <Cvo/Input.h++>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sun/audioio.h>
#include "Radio.h++"
#include <AsyncIO.h>
#include "cdrom.h"

Cvo_TextPage *page;

void ChangeVolume(Cvo_Object *, XEvent *, void *);
void ChangeGain(Cvo_Object *, XEvent *, void *);
void ChangeMonitor(Cvo_Object *, XEvent *, void *);
void ChangeStations(Cvo_Object *, XEvent *, void *);
void SendTextMessage(Cvo_Object *, XEvent *, void *);
void RepeatMode(Cvo_Object *, XEvent *, void *);
void OpenDisk(Cvo_Object *, XEvent *, void *);
void EjectDisk(Cvo_Object *, XEvent *, void *);
void Play(Cvo_Object *, XEvent *, void *);
void Stop(Cvo_Object *, XEvent *, void *);
void ExitHandler(Cvo_Object *, XEvent *, void *);
void RadioHandler(EvIOEvent *, void *);
void PeriodicScan(EvTimerEvent *, void *);
void SendMessage(char *, int);

void StartAudioDevice(int);
void StartAudioDaemon(int);
void AsyncHandler(void *);

int afd;
int station_manager = 0;
int repeat = 0;
int playing = 0;
int CurrentVolume();
void SetVolume(int);
int CurrentGain();
void SetGain(int);
int CurrentMonitor();
void SetMonitor(int);

int two = 2;
int three = 3;
int four = 4;

int current_channel = 0;

Cvo_Default defs[] = {
    "*Color*RadioBox.Chamfer: 0",
    "*Mono*RadioBox.Chamfer: 0",
    "*Color*RadioBox.BorderWidth: 0",
    "*Mono*RadioBox.BorderWidth: 0",
    "*info*FontFamily: Courier",
};

Cvo_RadioBoxList channels[] = {
    { "Channel 2",	&two, },
    { "Channel 3",	&three, },
    { "Channel 4",	&four, },
    { 0, },
};

RadioInfo radio;
CD_ROM *cdrom = 0;

int	todaemon[2] = { -1, -1, };
int	fromdaemon[2] = { -1, -1, };
int	toserver[2] = { -1, -1, };
int	daemonpid = 0;
int	serverpid = 0;

Cvo_SquareToggleButton *playbutton;

main(int ac, char **av)
{
    if (getenv("STATION_MANAGER")) {
	station_manager = 1;
	cdrom = new CD_ROM;
    }

    Cvo_Parse(&ac, &av);

    afd = open("/dev/audioctl", 2);

    if (afd < 0) {
	perror("/dev/audioctl");
	exit(1);
    }

    Cvo_Application *app = new Cvo_Application("radio", Cvo_MAINWINDOW);
    app->Register(CvoExitEvent, ExitHandler);
    Cvo_Slab *slab = new Cvo_Slab("slab", app);

    slab->ExpandFrame();
    slab->VerticalChildren();

    new Cvo_Label("title", slab, "Paul's Cvo Radio Station");
    new Cvo_Separator("sep", slab);
    Cvo_RadioBox *selector = new Cvo_RadioBox("channels", slab, channels);
    new Cvo_Separator("sep", slab);

    Cvo_Frame *f = new Cvo_Frame("frame", slab);
    f->HorizontalChildren();
    Cvo_Label *L = new Cvo_Label("volume-label", f, "Volume: ");
    L->LeftJustify();
    Cvo_ScrollBar *volume = new Cvo_ScrollBar("volume", f, Cvo_HORIZONTAL);
    volume->FillFrame();
    volume->ExpandFrame();
    volume->SetValues(AUDIO_MIN_GAIN, AUDIO_MAX_GAIN, CurrentVolume(), 0);
    volumen->Register(CvoScrollBarEvent, ChangeVolume);

    if (station_manager) {
	f = new Cvo_Frame("frame", slab);
	f->HorizontalChildren();
	Cvo_Label *LL = new Cvo_Label("gain-label", f, "Gain:");
	LL->MatchWidth(L);
	LL->SetGravity(Cvo_WEST);
	LL->LeftJustify();
	Cvo_ScrollBar *gain = new Cvo_ScrollBar("gain", f, Cvo_HORIZONTAL);
	gain->FillFrame();
	gain->ExpandFrame();
	gain->SetValues(AUDIO_MIN_GAIN, AUDIO_MAX_GAIN, CurrentGain(), 0);
	gain->Register(CvoScrollBarEvent, ChangeGain);

	f = new Cvo_Frame("frame", slab);
	f->HorizontalChildren();
	LL = new Cvo_Label("monitor-label", f, "Monitor:");
	LL->SetGravity(Cvo_WEST);
	LL->LeftJustify();
	LL->MatchWidth(L);
	Cvo_ScrollBar *mon = new Cvo_ScrollBar("monitor", f, Cvo_HORIZONTAL);
	mon->FillFrame();
	mon->ExpandFrame();
	mon->SetValues(AUDIO_MIN_GAIN, AUDIO_MAX_GAIN, CurrentMonitor(), 0);
	mon->Register(CvoScrollBarEvent, ChangeMonitor);

	new Cvo_Separator("sep", slab);
	f = new Cvo_Frame("frame", slab);
	f->HorizontalChildren();

	playbutton = new Cvo_SquareToggleButton("play", f, "Play");
	playbutton->SetMinSize(12, 0);
	playbutton->Register(CvoButtonDownEvent, Play);
	playbutton->Register(CvoButtonUpEvent, Stop);

	Cvo_SquareToggleButton *sq = new Cvo_SquareToggleButton("repeat", f,
								"Repeat");
	sq->SetMinSize(12, 0);
	sq->Register(CvoButtonDownEvent, RepeatMode, (void *)-1);
	sq->Register(CvoButtonUpEvent, RepeatMode, (void *)0);
	sq = new Cvo_SquareToggleButton("disk", f, "Open Disk");
	sq->SetMinSize(12, 0);
	sq->Register(CvoButtonDownEvent, OpenDisk);
	sq->Register(CvoButtonUpEvent, EjectDisk);
    }

    new Cvo_Separator("sep", slab);
    new Cvo_Label("info-title", slab, "Radio Station Information");
    page = new Cvo_TextPage();
    Cvo_TextViewPort *output = new Cvo_TextViewPort("info", slab, page);
    output->FillFrame();
    output->ExpandFrame();
    output->SetMinSize(32,2);
    output->SetDefSize(32,6);
    output->Jump();

    if (station_manager) {
	Cvo_Input *input = new Cvo_Input("input", slab);
	input->FillFrame();
	input->Register(CvoInputEnteredEvent, SendTextMessage);
	new EvTimerEvent(5000, PeriodicScan);
    }

    selector->Register(CvoRadioBoxSelectedEvent, ChangeStations);

    Cvo_MainLoop(app);
}

void
SendTextMessage(Cvo_Object *obj, XEvent *ev, void *)
{
    Cvo_Input *input = (Cvo_Input *)obj;
    Cvo_InputEnteredEvent *iee = (Cvo_InputEnteredEvent *)ev;
    SendMessage(iee->text, strlen(iee->text));
    input->SetText();
}

void
SendMessage(char *buf, int len)
{
    if (toserver[1] >= 0) {
	write(toserver[1], "m", 1);
	write(toserver[1], buf, len);
	write(toserver[1], "", 1);
    }
}

void
ChangeVolume(Cvo_Object *, XEvent *ev, void *)
{
    Cvo_ScrollBarEvent *sbe = (Cvo_ScrollBarEvent *)ev;
    SetVolume(sbe->value);
}

void
ChangeGain(Cvo_Object *, XEvent *ev, void *)
{
    Cvo_ScrollBarEvent *sbe = (Cvo_ScrollBarEvent *)ev;
    SetGain(sbe->value);
}

void
ChangeMonitor(Cvo_Object *, XEvent *ev, void *)
{
    Cvo_ScrollBarEvent *sbe = (Cvo_ScrollBarEvent *)ev;
    SetMonitor(sbe->value);
}

void
ChangeStations(Cvo_Object *obj, XEvent *ev, void *)
{
    Cvo_RadioBoxSelectedEvent *se = (Cvo_RadioBoxSelectedEvent *)ev;
    Cvo_RadioBox *selector = (Cvo_RadioBox *)obj;

    static int first_time = 1;

    current_channel = *(int *)se->data;
    if (first_time) {
	radio.Bind();
	if (station_manager)
	    StartAudioDevice(ConnectionNumber(obj->Dpy()));
	StartAudioDaemon(ConnectionNumber(obj->Dpy()));
	new EvInputEvent(fromdaemon[0], RadioHandler);
	selector->RequireSelection();
	first_time = 0;
    } else if (todaemon[1]) {
	char buf[16];
	sprintf(buf, "c%d;", current_channel);
	write(todaemon[1], buf, strlen(buf));
    }
}

void
StartAudioDevice(int fd)
{
    if (pipe(toserver) < 0) {
	perror("pipe");	
	exit(1);
    }

    switch (serverpid = fork()) {
    case -1:
	perror("fork");
	exit(1);
    case 0:
	radio.SetSource("-");
	close(fd);
	close(toserver[1]);
	break;
    default:
	radio.SetSource(0);
	close(toserver[0]);
	return;
    }
    _RegisterIO(toserver[0], AsyncHandler, toserver, 0);

    close(0);
    if (open("/dev/audio", 0) != 0) {
	perror("/dev/audio");
	exit(1);
    }
    for (;;) {
	if (radio.ReadPacket() < 0)
	    break;
	radio.BroadcastPacket();
    }
}

void
StartAudioDaemon(int fd)
{
    if (pipe(todaemon) < 0 || pipe(fromdaemon) < 0) {
	perror("pipe");	
	exit(1);
    }

    switch (daemonpid = fork()) {
    case -1:
	perror("fork");
	exit(1);
    case 0:
	close(fd);
	close(todaemon[1]);
	close(fromdaemon[0]);
	break;
    default:
	close(todaemon[0]);
	close(fromdaemon[1]);
	return;
    }
    _RegisterIO(todaemon[0], AsyncHandler, todaemon, 0);
    for (;;) {
        if (radio.ReadPacket() < 0) {
	    perror("ReadPacket");
            exit(0);
	}

	switch (radio.Type()) {
	case RADIO_TEXT:
	    write(fromdaemon[1], radio.Data(), radio.Length());
	    break;
	case RADIO_SUN_ULAW:
	    if (radio.Channel() == current_channel) {
		static int fd = -1;
		if (fd < 0)
		    fd = open("/dev/audio", 1);
		if (fd >= 0) {
		    radio.WriteData(fd);
		    close(fd);
		    fd = -1;
		} else {
		    perror("/dev/audio");
		    exit(1);
		}
	    }
	    break;
	}
    }
}

void
AsyncHandler(void *from)
{

    char buf[1024];
    int r = read(*(int *)from, buf, sizeof(buf));
    if (r <= 0) {
	printf("Only read %d bytes\n", r);
	exit(0);
    }

    char *b = buf;

    static int state = 0;

    while (r-- > 0) {
	switch (state) {
	case 0:
	    switch (*b) {
	    case 'c':
		state = 'c';
		break;
	    case 'm':
		state = 'm';
		break;
	    default:
		break;
	    }
	    break;
	case 'c': {
	    static int ch = 0;
	    if (*b >= 0 && *b <= '9')
		ch = ch * 10 + *b - '0';
	    else if (*b == ';') {
		if (ch)
		    current_channel = ch;
		ch = 0;
		state = 0;
	    }
	    break;
	  }
	case 'm': {
	    static char mbuf[1024];
	    static char *mptr = mbuf;
	    if ((*mptr++ = *b) == '\0') {
		radio.SetChannel(RADIO_LISTING_CHANNEL);
		radio.SetType(RADIO_TEXT);
		radio.SendMessage(mbuf, mptr - mbuf);
		mptr = mbuf;
		state = 0;
	    }
	    break;
	  }
	}
	++b;
    }
}

void
RadioHandler(EvIOEvent *, void *)
{
    char buf[1024];
    int r = read(fromdaemon[0], buf, sizeof(buf));
    page->AppendText(buf, r);
}

static lasttrack = -1;

void
PeriodicScan(EvTimerEvent *, void *)
{
    int track;

    if (cdrom->Playing(&track)) {
	char buf[64];
	if (track != lasttrack) {
	    lasttrack = track;
	    Msf msf = cdrom->TrackTime(track);
	    sprintf(buf, "Now playing track %2d [%2d:%2d]",
		    track, msf.Minute(), msf.Second());
	    SendMessage(buf, strlen(buf));
	}
    } else {
	if (playing && repeat)
	    cdrom->PlayTrack(cdrom->FirstTrack(), cdrom->LastTrack());
    }
    if (playing = cdrom->Playing(&track))
	playbutton->ForceOn();
    else
	playbutton->ForceOff();
    new EvTimerEvent(5000, PeriodicScan);
}


void
ExitHandler(Cvo_Object *, XEvent *, void *)
{
    if (daemonpid > 1)
	kill(daemonpid, 9);
    if (serverpid > 1)
	kill(serverpid, 9);
}

void
RepeatMode(Cvo_Object *, XEvent *, void *mode)
{
    repeat = mode ? True : False;
}

void
OpenDisk(Cvo_Object *obj, XEvent *, void *)
{
    Cvo_SquareToggleButton *sq = (Cvo_SquareToggleButton *)obj;

    cdrom->Open();
    if (cdrom->Ejected())
	sq->ForceOff();
    else
	sq->SetText("Eject Disk");
}

void
EjectDisk(Cvo_Object *obj, XEvent *, void *)
{
    Cvo_SquareToggleButton *sq = (Cvo_SquareToggleButton *)obj;
    cdrom->Eject();
    sq->SetText("Open Disk");
    playing = 0;
    playbutton->ForceOff();
}

void
Play(Cvo_Object *, XEvent *, void *)
{
    int track;

    if (cdrom->Playing(&track)) {
	playing = True;
	return;
    }
    cdrom->PlayTrack(cdrom->FirstTrack(), cdrom->LastTrack());

    if (playing = cdrom->Playing(&lasttrack)) {
	playing = True;
	Msf msf = cdrom->TrackTime(track);
	char buf[64];
	sprintf(buf, "Now playing track %2d [%2d:%2d]",
		track, msf.Minute(), msf.Second());
	SendMessage(buf, strlen(buf));
    } else
	playbutton->ForceOff();
}

void
Stop(Cvo_Object *, XEvent *, void *)
{
    cdrom->Stop();
    playing = False;
}

int
CurrentVolume()
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);

    return(ai.play.gain);
}

void
SetVolume(int v)
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);
    if (v < AUDIO_MIN_GAIN)
	v = AUDIO_MIN_GAIN;
    if (v > AUDIO_MAX_GAIN)
	v = AUDIO_MAX_GAIN;
    ai.play.gain = v;
    ioctl(afd, AUDIO_SETINFO, &ai);
}

int
CurrentGain()
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);

    return(ai.record.gain);
}

void
SetGain(int v)
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);
    if (v < AUDIO_MIN_GAIN)
	v = AUDIO_MIN_GAIN;
    if (v > AUDIO_MAX_GAIN)
	v = AUDIO_MAX_GAIN;
    ai.record.gain = v;
    ioctl(afd, AUDIO_SETINFO, &ai);
}

int
CurrentMonitor()
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);

    return(ai.monitor_gain);
}

void
SetMonitor(int v)
{
    audio_info ai;
    ioctl(afd, AUDIO_GETINFO, &ai);
    if (v < AUDIO_MIN_GAIN)
	v = AUDIO_MIN_GAIN;
    if (v > AUDIO_MAX_GAIN)
	v = AUDIO_MAX_GAIN;
    ai.monitor_gain = v;
    ioctl(afd, AUDIO_SETINFO, &ai);
}
