#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <net/if.h>

#define	RADIO_SUN_ULAW		0x01
#define	RADIO_TEXT		0x02

#define	RADIO_LISTING_CHANNEL	0x01
#define	RADIO_AUDIO_CHANNEL	0x02

#define	DEFAULT_AUDIO_CHANNEL	RADIO_AUDIO_CHANNEL

#define	MAX_INTERFACES	16

struct datapacket {
    struct {
	unsigned char	type;
	unsigned char	channel;
	unsigned char	pad[6];
    } header;
    unsigned char	data[1024];
};

class Interface {
    char			name[IFNAMSIZ];
    sockaddr_in			sin;
    in_addr			netmask;
public:
    Interface(char *);
    void SetFamily(short f)	{ sin.sin_family = f;}
    void SetPort(u_short p)	{ sin.sin_port = p;}
    void SetAddress(sockaddr &);
    void SetNetMask(sockaddr &);
    int Send(int, void *, int);
    int Match(in_addr &);
    operator char *()		{ return(inet_ntoa(sin.sin_addr)); }
    char *Name()		{ return(name); }
};

class RadioInfo {
    int			s;
    Interface		*interfaces[MAX_INTERFACES];
    int			icnt;
    Interface		*source;
    int			sourcefd;
    short		port;
    sockaddr_in		recv;
    datapacket		dp;
    int			plen;
    char		sendtype;
    char		sendchannel;
    long		noise;
    int			debug;
    void		(*eprint)(char *);
    void		(*dprint)(char *);
    char		printbuf[256];
    void		perror(char *);
public:
    RadioInfo();
    void SetPort(u_short p);
    void SetPort(long p)	{ SetPort(u_short(p)); }
    void SetSource(char *);
    void Exclude(char *);
    void Bind();
    void SetSendType(long t)	{ sendtype = char(t); }
    void SetSendChannel(long c)	{ sendchannel = char(c); }
    void SetDebug()		{ debug = 1; }
    void SetThreshold(long t)	{ noise = t; }
    int ReadPacket();
    int PollPacket();
    void BroadcastPacket();
    void WriteData(int fd);
    void PrintDebug();
    int	Channel()		{ return(dp.header.channel); }
    int	Type()			{ return(dp.header.type); }
    void SetChannel(int c)	{ dp.header.channel = c; }
    void SetType(int t)		{ dp.header.type = t; }
    int ReadFD()		{ return(sourcefd >= 0 ? sourcefd : s); }
    void SetErrorHandler(void (*e)(char *))	{ eprint = e; }
    void SetDebugHandler(void (*d)(char *))	{ dprint = d; }
    char *Data()			{ return((char *)dp.data); }
    int Length()			{ return(plen); }
    void SendMessage(void *, int);
};

void _ErrorPrint(char *);
void _DebugPrint(char *);
char *typetostr(int);
int strtotype(char *);
int strtochannel(char *type);

inline void
Interface::SetAddress(sockaddr &a)
{
    sin.sin_addr = ((struct sockaddr_in *)&a)->sin_addr;
}

inline void
Interface::SetNetMask(sockaddr &a)
{
    netmask = ((struct sockaddr_in *)&a)->sin_addr;
}

inline int
Interface::Match(in_addr &a)
{
    return((a.s_addr & netmask.s_addr) == sin.sin_addr.s_addr);
}
