#include <Cvo/Object.h++>

char *str1 = NULL;
char *str2 = "default string value";
INT num1 = 0;
INT num2 = 42;
BOOL bool1 = False;
BOOL bool2 = True;

Cvo_StringOption  s1("-str1",  "*str1",  "String defaults to NULL",	&str1);
Cvo_StringOption  s2("-str2",  "*str2",  "String defaults to !NULL",	&str2);

Cvo_NumericOption n1("-num1",  "*num1",  "Numeric defaults to 0",	&num1);
Cvo_NumericOption n2("-num2",  "*num2",  "Numeric defaults to 42",	&num2);

Cvo_BooleanOption b1("-bool1", "*bool1", "Boolean defaults False",	&bool1);
Cvo_BooleanOption b2("+bool1", "*bool1", 0, 				&bool1);

Cvo_BooleanOption b3("+bool2", "*bool2", "Boolean defaults True",	&bool2);
Cvo_BooleanOption b4("-bool2", "*bool2", 0,				&bool2);

main(int ac, char **av)
{
    Cvo_Parse(&ac, &av);

    printf("str1: %s\n", str1 ? str1 : "<NULL>");
    printf("str2: %s\n", str2 ? str2 : "<NULL>");

    printf("num1: %d\n", num1);
    printf("num2: %d\n", num2);

    printf("bool1: %s\n", bool1 ? "True" : "False");
    printf("bool2: %s\n", bool2 ? "True" : "False");
}
