#include <Cvo/Inform.h++>
#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/TextPage.h++>
#include <Cvo/TextViewPort.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Label.h++>

void doinform(Cvo_Object *, XEvent *, void *);

Cvo_Application *app;
Cvo_TextPage output;

main()
{
    app = new Cvo_Application("inform-example");
    Cvo_Window *slab = new Cvo_Window(app);
    slab->VerticalChildren();

    Cvo_Button *button = new Cvo_Button("doinform", slab, "Do Inform");
    button->Register(CvoButtonUpEvent, doinform);

    new Cvo_Separator(slab);

    new Cvo_Label("output-label", slab, "User Output");

    Cvo_TextViewPort *tvp = new Cvo_TextViewPort("output", slab, &output);
    tvp->ExpandFrame();
    tvp->SetMinSize(40,5);

    app->MainLoop();
}

void
doinform(Cvo_Object *, XEvent *, void *)
{
    output.AppendText("Start inform\n");
    Cvo_Inform("inform", app, "This is an inform box.\n"
			      "All you can do is press the buttons.\n");
    output.AppendText("Done with inform\n");
}
