#include <Cvo/Application.h++>
#include <Cvo/RadioBox.h++>

void radioHandler(Cvo_Object *, XEvent *, void *);

Cvo_RadioBoxList radiolist[] =
{
	"First",		"first",
	"Second",		"second",
	"Third",		"third",
	NULL,			NULL
};

int
main (int argc, char *argv[])
{
    Cvo_Parse (&argc, &argv);

    Cvo_Application *app = new Cvo_Application("test");

	Cvo_RadioBox *rad = new Cvo_RadioBox("radio",Cvo_MAINWINDOW,radiolist);
	rad->VerticalChildren();

	rad->Register(CvoRadioBoxSelectedEvent,radioHandler);
	rad->Register(CvoRadioBoxDeselectedEvent,radioHandler);

    Cvo_MainLoop (rad);
}

void
radioHandler(Cvo_Object *, XEvent *e, void *)
{
	Cvo_RadioBoxSelectedEvent *ev = (Cvo_RadioBoxSelectedEvent*)e;

	switch (ev->type) {
	case CvoRadioBoxSelectedEvent:
		printf("%s selected.  Index number %d\n",ev->data,ev->index);
		break;
	case CvoRadioBoxDeselectedEvent:
		printf("%s deselected.  Index number %d\n",ev->data,ev->index);
		break;
	}

	fflush(stdout);
}
