#include <Cvo/Application.h++>
#include <Cvo/Window.h++>
#include <Cvo/Button.h++>
#include <Cvo/ImageButton.h++>
#include <Cvo/Pin.h++>
#include <Cvo/Frame.h++>
#include <stdio.h>

void buttonhandler (Cvo_Object *, XEvent *, void *);

main (int argc, char *argv[])
{
    Cvo_Parse (&argc, &argv);

    Cvo_Application *app = new Cvo_Application ("appl");

    Cvo_Window *window = new Cvo_Window ("window", app);
    window->ExpandFrame ();
	window->VerticalChildren();

	Cvo_Pin *pinButton = new Cvo_Pin ("pin", window);
	pinButton->ExpandFrame();

    Cvo_Button *button = new Cvo_Button ("button", window, "button");
	button->ExpandFrame ();
	button->FillFrame (False);

    Cvo_ImageButton *imageButton = new Cvo_ImageButton ("button2", window,
		"/home/sumac5/ahern/cvo_examples/button.xpm");
	imageButton->ExpandFrame ();

    pinButton->Register (CvoButtonUpEvent, buttonhandler, "pin up");
    pinButton->Register (CvoButtonDownEvent, buttonhandler, "pin down");
    button->Register (CvoButtonUpEvent, buttonhandler, "plain button");
    imageButton->Register (CvoButtonUpEvent, buttonhandler, "image");

    Cvo_MainLoop (app);
}

void buttonhandler (Cvo_Object *, XEvent *, void *data)
{
	printf("Button: %s\n",(char*)data);
	fflush(stdout);
}
