#include <Cvo/Application.h++>
#include <Cvo/Toggle.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Label.h++>
#include <Cvo/Radio.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Window.h++>

static Cvo_Default def[] = {
    "*win1.tag1.label: Group One",
    "*win1.frame1.label1.label: Label One",
    "*win1.frame1.button1.Label.label: Button One",
    "*win2.tag2.label: Group Two",
    "*win2.frame2.label2.label: Label Two",
    "*win2.frame2.button2.Label.label: Button Two"
};

void main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("exampleApp");

    Cvo_Window *win1 = new Cvo_Window("win1", app);
    new Cvo_Separator(app);
    Cvo_Window *win2 = new Cvo_Window("win2", app);

    win1->HorizontalChildren();
    win2->HorizontalChildren();

    Cvo_Label *tag1 = new Cvo_Label("tag1", win1, "NR");
    Cvo_Frame *frame1 = new Cvo_Frame("frame1", win1);

    Cvo_Label *tag2 = new Cvo_Label("tag2", win2, "NR");
    Cvo_Frame *frame2 = new Cvo_Frame("frame2", win2);

    frame1->VerticalChildren();
    frame2->VerticalChildren();

    Cvo_ChamferedLabel *label1 = new Cvo_ChamferedLabel("label1", frame1, "NR");
    Cvo_SquareToggleButton *button1 = new Cvo_SquareToggleButton("button1", frame1, "NR");

    Cvo_ChamferedLabel *label2 = new Cvo_ChamferedLabel("label2", frame2, "NR");
    Cvo_SquareToggleButton *button2 = new Cvo_SquareToggleButton("button2", frame2, "NR");

    // This Cvo_Radio object will manage the two buttons, such
    // that only one at a time is toggled on.

    Cvo_Radio *radio = new Cvo_Radio();
    Cvo_RadioList *r1 = radio->AddToggle(button1, "Button One");
    Cvo_RadioList *r2 = radio->AddToggle(button2, "Button Two");

    app->MainLoop();
}
