#include <Cvo/Application.h++>
#include <Cvo/Buffer.h++>
#include <Cvo/Button.h++>
#include <Cvo/ButtonMenu.h++>
#include <Cvo/Menu.h++>
#include <Cvo/MenuBar.h++>
#include <Cvo/MenuLabel.h++>
#include <Cvo/Separator.h++>
#include <Cvo/Window.h++>

#define CASC_TOGGLE1	100
#define CASC_TOGGLE2	101
#define MENU1_TOGGLE1	102
#define MENU1_TOGGLE2	103

#define DEL_ENTRIES	200
#define ADD_ENTRIES	201

Cvo_Default def[] = {
    "*menu-button.label: Press Me",
    "*button-menu.label: Button Menu",
    "*menubar-test.menubar1-item1: _Item One",
    "*menubar-test.showLogo: false",

    "*CvoMenu*menu1-label.label: Sample Menu",
    "*CvoMenu*menu1-item1.label: _Cascade Item",
    "*CvoMenu*menu1-item2.label: _Toggle Item + <CTRL-T>",
    "*CvoMenu*menu1-item3.label: _Regular Item",
    "*CvoMenu*menu1-item4.label: _Another Toggle + <CTRL-A>",
    "*CvoMenu*menu1-item5.label: _Delete Menu Entries + <CTRL-D>",
    "*CvoMenu*menu1-item6.label: Add _Menu Item",
    "*CvoMenu*menu1-button.label: Button on the fly",
    "*CvoMenu*menu1-newitem1.label: New _Item + <CTRL-N>",
    "*CvoMenu*menu1-newitem2.label: Another New Item",
    "*CvoMenu*menu1-newitem3.label: Yet Another New Item",
    "*CvoMenu*menu1-newitem4.label: And Another",

    "*CvoMenu*casc-label.label: Cascade Menu",
    "*CvoMenu*casc-item1.label: _Toggle Me",
    "*CvoMenu*casc-item2.label: _Flattened",
    "*CvoMenu*casc-item3.label: Toggle _Me Too",
    "*CvoMenu*casc-item4.label: _Press Me Cascade"
};

void ButtonHandler(Cvo_Object *, XEvent *, void *);
void MenuHandler(Cvo_Object *, XEvent *, void *);
void MenuToggle(Cvo_Object *, XEvent *, void *);

Cvo_MenuItem casc[] = {
    { "casc-label", NULL, NULL, CvoM_ALWAYSFLAT },
    { "casc-item1", MenuToggle, (void *) CASC_TOGGLE1, CvoM_TOGGLE },
    { "casc-item2", MenuHandler, NULL, 0 },
    { "casc-item3", MenuToggle, (void *) CASC_TOGGLE2, CvoM_TOGGLE },
    { "casc-item4", MenuHandler, NULL, 0 },
    NULL
};

Cvo_MenuItem menu1[] = {
    { "menu1-label", NULL, NULL, CvoM_ALWAYSFLAT },
    { "menu1-item1", MenuHandler, (void *) casc, CvoM_CASCADE },
    { "menu1-item2", MenuToggle, (void *) MENU1_TOGGLE1, CvoM_TOGGLE },
    { "menu1-item3", MenuHandler, NULL, 0 },
    { "menu1-item4", MenuToggle, (void *) MENU1_TOGGLE2, CvoM_TOGGLE },
    { "menu1-item5", MenuHandler, (void *) DEL_ENTRIES, CvoM_SEPARATOR },
    { "menu1-item6", MenuHandler, (void *) ADD_ENTRIES, 0},
    { CvoM_SaveAs, NULL, NULL , 0 },
    NULL
};

Cvo_MenuBarList menubar1[] = {
    { "menubar1-item1", menu1 },
    NULL
};

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("app");

    Cvo_Button *but = new Cvo_Button("menu-button", app, "NR");
    but->Register(CvoButtonUpEvent, ButtonHandler);

    Cvo_ButtonMenu *bm = new Cvo_ButtonMenu("button-menu", app, menu1);
    Cvo_MenuBar *mb = new Cvo_MenuBar("menubar-test", app, menubar1);


    app->MainLoop();
}

void MenuHandlerTwo(Cvo_Object *, XEvent *ev, void *data);

void ButtonHandler(Cvo_Object *obj, XEvent *, void *)
{
    static Cvo_Menu *menu = NULL;
    static Cvo_Button *mbut;
    static Cvo_MenuEntry *e;

    if (menu == NULL) {
        menu = new Cvo_Menu("app-menu", Cvo_MAINWINDOW, menu1);
        mbut = new Cvo_Button("menu1-button", menu, "NR");
        e = new Cvo_MenuEntry(menu, mbut);

        menu->Register(CvoNewMenuItemEvent, MenuHandler);
        menu->Register(CvoDelMenuItemEvent, MenuHandler);
        menu->Register(CvoMenuEvent, MenuHandlerTwo);
    }

    menu->Map();
    menu->StartCascade(1, (Cvo_Button *) obj);
}

void MenuHandlerTwo(Cvo_Object *, XEvent *ev, void *data)
{
    fprintf(stderr, "MenuHandlerTwo(): got CvoMenuEvent\n");
}

void MenuHandler(Cvo_Object *, XEvent *ev, void *data)
{
    Cvo_MenuEvent *mev = (Cvo_MenuEvent *) ev;
    Cvo_NewMenuItemEvent *nev = (Cvo_NewMenuItemEvent *) ev;
    Cvo_MenuLabel *label;
    Cvo_MenuItem *newitem;

    char s[50];
    static int count = 1;
    int type, p = 0;

    switch(ev->type) {
	case CvoMenuEvent:
	    fprintf(stderr, "CvoMenuEvent generated\n");
	    type = (int) data;

	    switch(type) {
		case DEL_ENTRIES:
		    delete mev->menu->MenuEntries();
		    break;
		case ADD_ENTRIES:
		    sprintf(s, "menu1-newitem%d", count++);
                    newitem = new Cvo_MenuItem();
		    // newitem->resource = new char[strlen(s)];
		    newitem->resource = s;
		    newitem->func = MenuHandler;
		    newitem->data = NULL;
		    newitem->flags = 0;
		    new Cvo_MenuEntry(mev->menu, newitem);
		    break;
	    }
	    break;
	case CvoMenuCascadeEvent:
	    fprintf(stderr, "CvoMenuCascadeEvent generated\n");
	    break;
	case CvoNewMenuItemEvent:
	    fprintf(stderr, "CvoNewMenuItemEvent generated\n");
	    p = 1;
	case CvoDelMenuItemEvent:
	    if (!p) fprintf(stderr, "CvoDelMenuItemEvent generated\n");

	    label = (Cvo_MenuLabel *) nev->item->label;
	    if (label->Type() == CvoT_Label) {
	      Cvo_CharacterBuffer cb;
	      static foo = 0;
	      label->GetText(cb);
	      label->Compact(foo^=1);
	      fprintf(stderr, "  Entry: \"%s\"\n", cb.mbValue());
	    }
	    break;
    }
}

void MenuToggle(Cvo_Object *, XEvent *ev, void *data)
{
    Cvo_MenuEvent *mev = (Cvo_MenuEvent *) ev;
    int tog = (int) data;

    switch(tog) {
	case CASC_TOGGLE1:
	    break;
	case CASC_TOGGLE2:
	    break;
	case MENU1_TOGGLE1:
	    break;
	case MENU1_TOGGLE2:
	    break;
    }
}
