#include <Cvo/Application.h++>
#include <Cvo/Button.h++>
#include <Cvo/Confirm.h++>

Cvo_Default def[] = {
    "*pressme.label: Press Me",

    "*confirm-test.cancel: Not OK"
    "*confirm-test.label: Confirm Me",
    "*confirm-test.confirm: OK",
};

void ConfirmDialog(Cvo_Object *, XEvent *, void *);

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);	// Parse the command line.

    Cvo_Application *app = new Cvo_Application("exampleApp");

    Cvo_Button *b1 = new Cvo_Button("pressme", app, "NR");
    Cvo_Register(b1, CvoButtonUpEvent, ConfirmDialog);

    app->MainLoop();
}

void ConfirmDialog(Cvo_Object *obj, XEvent *, void *)
{
    Cvo_Application *app = (Cvo_Application *) obj->Parent();

    Cvo_Confirm("confirm-test", app, "NR");
}
