#include <Cvo/Application.h++>
#include <Cvo/Label.h++>
#include <Cvo/Tree.h++>
#include <Cvo/TreeViewPort.h++>

#define LABCNT 		8

static Cvo_Default def[] = {
    "*CvoTree.gravity: North",
    "*CvoTree.label0.label: Label One",
    "*CvoTree.label1.label: Label Two",
    "*CvoTree.label2.label: Label Three",
    "*CvoTree.label3.label: Label Four",
    "*CvoTree.label4.label: Label Five",
    "*CvoTree.label5.label: Label Six",
    "*CvoTree.label6.label: Label Seven",
    "*CvoTree.label7.label: Label Eight",
};

main(int argc, char **argv)
{
    int i = 0;
    char s[30];
    Cvo_Label *labs[LABCNT];

    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("foo");
    app->SetMinPixelSize(100, 100);

    Cvo_TreeViewPort *vp = new Cvo_TreeViewPort("vp", app);
    vp->ExpandFrame();
    vp->AddVertical();
    vp->AddHorizontal();

    Cvo_Tree *tree = vp->Tree();

    for(;i<LABCNT;i++) {
	sprintf(s, "label%d", i);
	labs[i] = new Cvo_Label(s, tree, "NR");
    }

    Cvo_TreeNode *rootnode = new Cvo_TreeNode(labs[0], tree);

    for(i=1;i<LABCNT;i++) {
        new Cvo_TreeNode(labs[i], rootnode);
    }

    app->MainLoop();
}
