#include <Cvo/Application.h++>
#include <Cvo/Frame.h++>
#include <Cvo/Matrix.h++>
#include <Cvo/MatrixViewPort.h++>
#include <Cvo/Output.h++>
#include <Cvo/PinUp.h++>
#include <Cvo/Window.h++>
#include <Cvo/WindowViewPort.h++>

static Cvo_Default def[] = {
    "*matrixVP*viewPortFrame.horizontalSpace: 5",
};

main(int argc, char **argv)
{
    Cvo_Parse(&argc, &argv);

    Cvo_Application *app = new Cvo_Application("app");
    app->SetMaxPixelSize(300, 300);

    Cvo_Frame *frame = new Cvo_Frame(app);
    frame->HorizontalChildren();

    Cvo_MatrixViewPort *mvp = new Cvo_MatrixViewPort("matrixVP", frame);
    mvp->ExpandFrame();
    mvp->AddVertical();
    mvp->AddHorizontal();

    Cvo_WindowViewPortPanner *panner = new Cvo_WindowViewPortPanner("panner", frame, mvp);
    panner->SetMinPixelSize(100, 100);

    Cvo_Matrix *matrix = mvp->Matrix();
    Cvo_Output *out1 = new Cvo_Output("out1", matrix);
    Cvo_Output *out2 = new Cvo_Output("out2", matrix);
    Cvo_Window *win = new Cvo_Window("win", matrix);
    win->SetMinPixelSize(300, 300);

    matrix->AddCell(out1, 1, 1);
    matrix->AddCell(out2, 2, 2);
    matrix->AddCell(win, 3, 3);

    Cvo_WindowViewPort *wvp = new Cvo_WindowViewPort("windowVP", app);
    wvp->ExpandFrame();
    wvp->AddVertical();
    wvp->AddHorizontal();

    Cvo_PinUp *pinup = new Cvo_PinUp("pinup", wvp->Frame());
    pinup->SetMinPixelSize(300, 300);

    app->MainLoop();
}
